/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.managedblockchain.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Network configuration properties.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Network implements SdkPojo, Serializable, ToCopyableBuilder<Network.Builder, Network> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(Network::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(Network::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(Network::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> FRAMEWORK_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Framework").getter(getter(Network::frameworkAsString)).setter(setter(Builder::framework))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Framework").build()).build();

    private static final SdkField<String> FRAMEWORK_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FrameworkVersion").getter(getter(Network::frameworkVersion)).setter(setter(Builder::frameworkVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FrameworkVersion").build()).build();

    private static final SdkField<NetworkFrameworkAttributes> FRAMEWORK_ATTRIBUTES_FIELD = SdkField
            .<NetworkFrameworkAttributes> builder(MarshallingType.SDK_POJO).memberName("FrameworkAttributes")
            .getter(getter(Network::frameworkAttributes)).setter(setter(Builder::frameworkAttributes))
            .constructor(NetworkFrameworkAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FrameworkAttributes").build())
            .build();

    private static final SdkField<String> VPC_ENDPOINT_SERVICE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VpcEndpointServiceName").getter(getter(Network::vpcEndpointServiceName))
            .setter(setter(Builder::vpcEndpointServiceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcEndpointServiceName").build())
            .build();

    private static final SdkField<VotingPolicy> VOTING_POLICY_FIELD = SdkField.<VotingPolicy> builder(MarshallingType.SDK_POJO)
            .memberName("VotingPolicy").getter(getter(Network::votingPolicy)).setter(setter(Builder::votingPolicy))
            .constructor(VotingPolicy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VotingPolicy").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(Network::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationDate")
            .getter(getter(Network::creationDate))
            .setter(setter(Builder::creationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(Network::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(Network::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD,
            DESCRIPTION_FIELD, FRAMEWORK_FIELD, FRAMEWORK_VERSION_FIELD, FRAMEWORK_ATTRIBUTES_FIELD,
            VPC_ENDPOINT_SERVICE_NAME_FIELD, VOTING_POLICY_FIELD, STATUS_FIELD, CREATION_DATE_FIELD, TAGS_FIELD, ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String name;

    private final String description;

    private final String framework;

    private final String frameworkVersion;

    private final NetworkFrameworkAttributes frameworkAttributes;

    private final String vpcEndpointServiceName;

    private final VotingPolicy votingPolicy;

    private final String status;

    private final Instant creationDate;

    private final Map<String, String> tags;

    private final String arn;

    private Network(BuilderImpl builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.description = builder.description;
        this.framework = builder.framework;
        this.frameworkVersion = builder.frameworkVersion;
        this.frameworkAttributes = builder.frameworkAttributes;
        this.vpcEndpointServiceName = builder.vpcEndpointServiceName;
        this.votingPolicy = builder.votingPolicy;
        this.status = builder.status;
        this.creationDate = builder.creationDate;
        this.tags = builder.tags;
        this.arn = builder.arn;
    }

    /**
     * <p>
     * The unique identifier of the network.
     * </p>
     * 
     * @return The unique identifier of the network.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The name of the network.
     * </p>
     * 
     * @return The name of the network.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Attributes of the blockchain framework for the network.
     * </p>
     * 
     * @return Attributes of the blockchain framework for the network.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The blockchain framework that the network uses.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #framework} will
     * return {@link Framework#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #frameworkAsString}.
     * </p>
     * 
     * @return The blockchain framework that the network uses.
     * @see Framework
     */
    public final Framework framework() {
        return Framework.fromValue(framework);
    }

    /**
     * <p>
     * The blockchain framework that the network uses.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #framework} will
     * return {@link Framework#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #frameworkAsString}.
     * </p>
     * 
     * @return The blockchain framework that the network uses.
     * @see Framework
     */
    public final String frameworkAsString() {
        return framework;
    }

    /**
     * <p>
     * The version of the blockchain framework that the network uses.
     * </p>
     * 
     * @return The version of the blockchain framework that the network uses.
     */
    public final String frameworkVersion() {
        return frameworkVersion;
    }

    /**
     * <p>
     * Attributes of the blockchain framework that the network uses.
     * </p>
     * 
     * @return Attributes of the blockchain framework that the network uses.
     */
    public final NetworkFrameworkAttributes frameworkAttributes() {
        return frameworkAttributes;
    }

    /**
     * <p>
     * The VPC endpoint service name of the VPC endpoint service of the network. Members use the VPC endpoint service
     * name to create a VPC endpoint to access network resources.
     * </p>
     * 
     * @return The VPC endpoint service name of the VPC endpoint service of the network. Members use the VPC endpoint
     *         service name to create a VPC endpoint to access network resources.
     */
    public final String vpcEndpointServiceName() {
        return vpcEndpointServiceName;
    }

    /**
     * <p>
     * The voting rules for the network to decide if a proposal is accepted.
     * </p>
     * 
     * @return The voting rules for the network to decide if a proposal is accepted.
     */
    public final VotingPolicy votingPolicy() {
        return votingPolicy;
    }

    /**
     * <p>
     * The current status of the network.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link NetworkStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the network.
     * @see NetworkStatus
     */
    public final NetworkStatus status() {
        return NetworkStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the network.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link NetworkStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the network.
     * @see NetworkStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The date and time that the network was created.
     * </p>
     * 
     * @return The date and time that the network was created.
     */
    public final Instant creationDate() {
        return creationDate;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Tags assigned to the network. Each tag consists of a key and optional value.
     * </p>
     * <p>
     * For more information about tags, see <a
     * href="https://docs.aws.amazon.com/managed-blockchain/latest/ethereum-dev/tagging-resources.html">Tagging
     * Resources</a> in the <i>Amazon Managed Blockchain Ethereum Developer Guide</i>, or <a
     * href="https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html"
     * >Tagging Resources</a> in the <i>Amazon Managed Blockchain Hyperledger Fabric Developer Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Tags assigned to the network. Each tag consists of a key and optional value.</p>
     *         <p>
     *         For more information about tags, see <a
     *         href="https://docs.aws.amazon.com/managed-blockchain/latest/ethereum-dev/tagging-resources.html">Tagging
     *         Resources</a> in the <i>Amazon Managed Blockchain Ethereum Developer Guide</i>, or <a href=
     *         "https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html"
     *         >Tagging Resources</a> in the <i>Amazon Managed Blockchain Hyperledger Fabric Developer Guide</i>.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the network. For more information about ARNs and their format, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names
     * (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the network. For more information about ARNs and their format, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names
     *         (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.
     */
    public final String arn() {
        return arn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(frameworkAsString());
        hashCode = 31 * hashCode + Objects.hashCode(frameworkVersion());
        hashCode = 31 * hashCode + Objects.hashCode(frameworkAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(vpcEndpointServiceName());
        hashCode = 31 * hashCode + Objects.hashCode(votingPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Network)) {
            return false;
        }
        Network other = (Network) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description())
                && Objects.equals(frameworkAsString(), other.frameworkAsString())
                && Objects.equals(frameworkVersion(), other.frameworkVersion())
                && Objects.equals(frameworkAttributes(), other.frameworkAttributes())
                && Objects.equals(vpcEndpointServiceName(), other.vpcEndpointServiceName())
                && Objects.equals(votingPolicy(), other.votingPolicy())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(creationDate(), other.creationDate()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(arn(), other.arn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Network").add("Id", id()).add("Name", name()).add("Description", description())
                .add("Framework", frameworkAsString()).add("FrameworkVersion", frameworkVersion())
                .add("FrameworkAttributes", frameworkAttributes()).add("VpcEndpointServiceName", vpcEndpointServiceName())
                .add("VotingPolicy", votingPolicy()).add("Status", statusAsString()).add("CreationDate", creationDate())
                .add("Tags", hasTags() ? tags() : null).add("Arn", arn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Framework":
            return Optional.ofNullable(clazz.cast(frameworkAsString()));
        case "FrameworkVersion":
            return Optional.ofNullable(clazz.cast(frameworkVersion()));
        case "FrameworkAttributes":
            return Optional.ofNullable(clazz.cast(frameworkAttributes()));
        case "VpcEndpointServiceName":
            return Optional.ofNullable(clazz.cast(vpcEndpointServiceName()));
        case "VotingPolicy":
            return Optional.ofNullable(clazz.cast(votingPolicy()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "CreationDate":
            return Optional.ofNullable(clazz.cast(creationDate()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Network, T> g) {
        return obj -> g.apply((Network) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Network> {
        /**
         * <p>
         * The unique identifier of the network.
         * </p>
         * 
         * @param id
         *        The unique identifier of the network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The name of the network.
         * </p>
         * 
         * @param name
         *        The name of the network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Attributes of the blockchain framework for the network.
         * </p>
         * 
         * @param description
         *        Attributes of the blockchain framework for the network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The blockchain framework that the network uses.
         * </p>
         * 
         * @param framework
         *        The blockchain framework that the network uses.
         * @see Framework
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Framework
         */
        Builder framework(String framework);

        /**
         * <p>
         * The blockchain framework that the network uses.
         * </p>
         * 
         * @param framework
         *        The blockchain framework that the network uses.
         * @see Framework
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Framework
         */
        Builder framework(Framework framework);

        /**
         * <p>
         * The version of the blockchain framework that the network uses.
         * </p>
         * 
         * @param frameworkVersion
         *        The version of the blockchain framework that the network uses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder frameworkVersion(String frameworkVersion);

        /**
         * <p>
         * Attributes of the blockchain framework that the network uses.
         * </p>
         * 
         * @param frameworkAttributes
         *        Attributes of the blockchain framework that the network uses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder frameworkAttributes(NetworkFrameworkAttributes frameworkAttributes);

        /**
         * <p>
         * Attributes of the blockchain framework that the network uses.
         * </p>
         * This is a convenience method that creates an instance of the {@link NetworkFrameworkAttributes.Builder}
         * avoiding the need to create one manually via {@link NetworkFrameworkAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NetworkFrameworkAttributes.Builder#build()} is called immediately
         * and its result is passed to {@link #frameworkAttributes(NetworkFrameworkAttributes)}.
         * 
         * @param frameworkAttributes
         *        a consumer that will call methods on {@link NetworkFrameworkAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #frameworkAttributes(NetworkFrameworkAttributes)
         */
        default Builder frameworkAttributes(Consumer<NetworkFrameworkAttributes.Builder> frameworkAttributes) {
            return frameworkAttributes(NetworkFrameworkAttributes.builder().applyMutation(frameworkAttributes).build());
        }

        /**
         * <p>
         * The VPC endpoint service name of the VPC endpoint service of the network. Members use the VPC endpoint
         * service name to create a VPC endpoint to access network resources.
         * </p>
         * 
         * @param vpcEndpointServiceName
         *        The VPC endpoint service name of the VPC endpoint service of the network. Members use the VPC endpoint
         *        service name to create a VPC endpoint to access network resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcEndpointServiceName(String vpcEndpointServiceName);

        /**
         * <p>
         * The voting rules for the network to decide if a proposal is accepted.
         * </p>
         * 
         * @param votingPolicy
         *        The voting rules for the network to decide if a proposal is accepted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder votingPolicy(VotingPolicy votingPolicy);

        /**
         * <p>
         * The voting rules for the network to decide if a proposal is accepted.
         * </p>
         * This is a convenience method that creates an instance of the {@link VotingPolicy.Builder} avoiding the need
         * to create one manually via {@link VotingPolicy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VotingPolicy.Builder#build()} is called immediately and its
         * result is passed to {@link #votingPolicy(VotingPolicy)}.
         * 
         * @param votingPolicy
         *        a consumer that will call methods on {@link VotingPolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #votingPolicy(VotingPolicy)
         */
        default Builder votingPolicy(Consumer<VotingPolicy.Builder> votingPolicy) {
            return votingPolicy(VotingPolicy.builder().applyMutation(votingPolicy).build());
        }

        /**
         * <p>
         * The current status of the network.
         * </p>
         * 
         * @param status
         *        The current status of the network.
         * @see NetworkStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NetworkStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the network.
         * </p>
         * 
         * @param status
         *        The current status of the network.
         * @see NetworkStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NetworkStatus
         */
        Builder status(NetworkStatus status);

        /**
         * <p>
         * The date and time that the network was created.
         * </p>
         * 
         * @param creationDate
         *        The date and time that the network was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(Instant creationDate);

        /**
         * <p>
         * Tags assigned to the network. Each tag consists of a key and optional value.
         * </p>
         * <p>
         * For more information about tags, see <a
         * href="https://docs.aws.amazon.com/managed-blockchain/latest/ethereum-dev/tagging-resources.html">Tagging
         * Resources</a> in the <i>Amazon Managed Blockchain Ethereum Developer Guide</i>, or <a
         * href="https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html"
         * >Tagging Resources</a> in the <i>Amazon Managed Blockchain Hyperledger Fabric Developer Guide</i>.
         * </p>
         * 
         * @param tags
         *        Tags assigned to the network. Each tag consists of a key and optional value.</p>
         *        <p>
         *        For more information about tags, see <a
         *        href="https://docs.aws.amazon.com/managed-blockchain/latest/ethereum-dev/tagging-resources.html"
         *        >Tagging Resources</a> in the <i>Amazon Managed Blockchain Ethereum Developer Guide</i>, or <a href=
         *        "https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html"
         *        >Tagging Resources</a> in the <i>Amazon Managed Blockchain Hyperledger Fabric Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the network. For more information about ARNs and their format, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names
         * (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the network. For more information about ARNs and their format, see
         *        <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource
         *        Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String name;

        private String description;

        private String framework;

        private String frameworkVersion;

        private NetworkFrameworkAttributes frameworkAttributes;

        private String vpcEndpointServiceName;

        private VotingPolicy votingPolicy;

        private String status;

        private Instant creationDate;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String arn;

        private BuilderImpl() {
        }

        private BuilderImpl(Network model) {
            id(model.id);
            name(model.name);
            description(model.description);
            framework(model.framework);
            frameworkVersion(model.frameworkVersion);
            frameworkAttributes(model.frameworkAttributes);
            vpcEndpointServiceName(model.vpcEndpointServiceName);
            votingPolicy(model.votingPolicy);
            status(model.status);
            creationDate(model.creationDate);
            tags(model.tags);
            arn(model.arn);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getFramework() {
            return framework;
        }

        public final void setFramework(String framework) {
            this.framework = framework;
        }

        @Override
        public final Builder framework(String framework) {
            this.framework = framework;
            return this;
        }

        @Override
        public final Builder framework(Framework framework) {
            this.framework(framework == null ? null : framework.toString());
            return this;
        }

        public final String getFrameworkVersion() {
            return frameworkVersion;
        }

        public final void setFrameworkVersion(String frameworkVersion) {
            this.frameworkVersion = frameworkVersion;
        }

        @Override
        public final Builder frameworkVersion(String frameworkVersion) {
            this.frameworkVersion = frameworkVersion;
            return this;
        }

        public final NetworkFrameworkAttributes.Builder getFrameworkAttributes() {
            return frameworkAttributes != null ? frameworkAttributes.toBuilder() : null;
        }

        public final void setFrameworkAttributes(NetworkFrameworkAttributes.BuilderImpl frameworkAttributes) {
            this.frameworkAttributes = frameworkAttributes != null ? frameworkAttributes.build() : null;
        }

        @Override
        public final Builder frameworkAttributes(NetworkFrameworkAttributes frameworkAttributes) {
            this.frameworkAttributes = frameworkAttributes;
            return this;
        }

        public final String getVpcEndpointServiceName() {
            return vpcEndpointServiceName;
        }

        public final void setVpcEndpointServiceName(String vpcEndpointServiceName) {
            this.vpcEndpointServiceName = vpcEndpointServiceName;
        }

        @Override
        public final Builder vpcEndpointServiceName(String vpcEndpointServiceName) {
            this.vpcEndpointServiceName = vpcEndpointServiceName;
            return this;
        }

        public final VotingPolicy.Builder getVotingPolicy() {
            return votingPolicy != null ? votingPolicy.toBuilder() : null;
        }

        public final void setVotingPolicy(VotingPolicy.BuilderImpl votingPolicy) {
            this.votingPolicy = votingPolicy != null ? votingPolicy.build() : null;
        }

        @Override
        public final Builder votingPolicy(VotingPolicy votingPolicy) {
            this.votingPolicy = votingPolicy;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(NetworkStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCreationDate() {
            return creationDate;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = OutputTagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = OutputTagMapCopier.copy(tags);
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        @Override
        public Network build() {
            return new Network(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
