/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.managedblockchainquery.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetAssetContractResponse extends ManagedBlockchainQueryResponse implements
        ToCopyableBuilder<GetAssetContractResponse.Builder, GetAssetContractResponse> {
    private static final SdkField<ContractIdentifier> CONTRACT_IDENTIFIER_FIELD = SdkField
            .<ContractIdentifier> builder(MarshallingType.SDK_POJO).memberName("contractIdentifier")
            .getter(getter(GetAssetContractResponse::contractIdentifier)).setter(setter(Builder::contractIdentifier))
            .constructor(ContractIdentifier::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contractIdentifier").build())
            .build();

    private static final SdkField<String> TOKEN_STANDARD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("tokenStandard").getter(getter(GetAssetContractResponse::tokenStandardAsString))
            .setter(setter(Builder::tokenStandard))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tokenStandard").build()).build();

    private static final SdkField<String> DEPLOYER_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("deployerAddress").getter(getter(GetAssetContractResponse::deployerAddress))
            .setter(setter(Builder::deployerAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deployerAddress").build()).build();

    private static final SdkField<ContractMetadata> METADATA_FIELD = SdkField
            .<ContractMetadata> builder(MarshallingType.SDK_POJO).memberName("metadata")
            .getter(getter(GetAssetContractResponse::metadata)).setter(setter(Builder::metadata))
            .constructor(ContractMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadata").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTRACT_IDENTIFIER_FIELD,
            TOKEN_STANDARD_FIELD, DEPLOYER_ADDRESS_FIELD, METADATA_FIELD));

    private final ContractIdentifier contractIdentifier;

    private final String tokenStandard;

    private final String deployerAddress;

    private final ContractMetadata metadata;

    private GetAssetContractResponse(BuilderImpl builder) {
        super(builder);
        this.contractIdentifier = builder.contractIdentifier;
        this.tokenStandard = builder.tokenStandard;
        this.deployerAddress = builder.deployerAddress;
        this.metadata = builder.metadata;
    }

    /**
     * <p>
     * Contains the blockchain address and network information about the contract.
     * </p>
     * 
     * @return Contains the blockchain address and network information about the contract.
     */
    public final ContractIdentifier contractIdentifier() {
        return contractIdentifier;
    }

    /**
     * <p>
     * The token standard of the contract requested.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #tokenStandard}
     * will return {@link QueryTokenStandard#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #tokenStandardAsString}.
     * </p>
     * 
     * @return The token standard of the contract requested.
     * @see QueryTokenStandard
     */
    public final QueryTokenStandard tokenStandard() {
        return QueryTokenStandard.fromValue(tokenStandard);
    }

    /**
     * <p>
     * The token standard of the contract requested.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #tokenStandard}
     * will return {@link QueryTokenStandard#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #tokenStandardAsString}.
     * </p>
     * 
     * @return The token standard of the contract requested.
     * @see QueryTokenStandard
     */
    public final String tokenStandardAsString() {
        return tokenStandard;
    }

    /**
     * <p>
     * The address of the deployer of contract.
     * </p>
     * 
     * @return The address of the deployer of contract.
     */
    public final String deployerAddress() {
        return deployerAddress;
    }

    /**
     * Returns the value of the Metadata property for this object.
     * 
     * @return The value of the Metadata property for this object.
     */
    public final ContractMetadata metadata() {
        return metadata;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(contractIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(tokenStandardAsString());
        hashCode = 31 * hashCode + Objects.hashCode(deployerAddress());
        hashCode = 31 * hashCode + Objects.hashCode(metadata());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAssetContractResponse)) {
            return false;
        }
        GetAssetContractResponse other = (GetAssetContractResponse) obj;
        return Objects.equals(contractIdentifier(), other.contractIdentifier())
                && Objects.equals(tokenStandardAsString(), other.tokenStandardAsString())
                && Objects.equals(deployerAddress(), other.deployerAddress()) && Objects.equals(metadata(), other.metadata());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetAssetContractResponse").add("ContractIdentifier", contractIdentifier())
                .add("TokenStandard", tokenStandardAsString()).add("DeployerAddress", deployerAddress())
                .add("Metadata", metadata()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "contractIdentifier":
            return Optional.ofNullable(clazz.cast(contractIdentifier()));
        case "tokenStandard":
            return Optional.ofNullable(clazz.cast(tokenStandardAsString()));
        case "deployerAddress":
            return Optional.ofNullable(clazz.cast(deployerAddress()));
        case "metadata":
            return Optional.ofNullable(clazz.cast(metadata()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetAssetContractResponse, T> g) {
        return obj -> g.apply((GetAssetContractResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ManagedBlockchainQueryResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetAssetContractResponse> {
        /**
         * <p>
         * Contains the blockchain address and network information about the contract.
         * </p>
         * 
         * @param contractIdentifier
         *        Contains the blockchain address and network information about the contract.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contractIdentifier(ContractIdentifier contractIdentifier);

        /**
         * <p>
         * Contains the blockchain address and network information about the contract.
         * </p>
         * This is a convenience method that creates an instance of the {@link ContractIdentifier.Builder} avoiding the
         * need to create one manually via {@link ContractIdentifier#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ContractIdentifier.Builder#build()} is called immediately and its
         * result is passed to {@link #contractIdentifier(ContractIdentifier)}.
         * 
         * @param contractIdentifier
         *        a consumer that will call methods on {@link ContractIdentifier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #contractIdentifier(ContractIdentifier)
         */
        default Builder contractIdentifier(Consumer<ContractIdentifier.Builder> contractIdentifier) {
            return contractIdentifier(ContractIdentifier.builder().applyMutation(contractIdentifier).build());
        }

        /**
         * <p>
         * The token standard of the contract requested.
         * </p>
         * 
         * @param tokenStandard
         *        The token standard of the contract requested.
         * @see QueryTokenStandard
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QueryTokenStandard
         */
        Builder tokenStandard(String tokenStandard);

        /**
         * <p>
         * The token standard of the contract requested.
         * </p>
         * 
         * @param tokenStandard
         *        The token standard of the contract requested.
         * @see QueryTokenStandard
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QueryTokenStandard
         */
        Builder tokenStandard(QueryTokenStandard tokenStandard);

        /**
         * <p>
         * The address of the deployer of contract.
         * </p>
         * 
         * @param deployerAddress
         *        The address of the deployer of contract.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deployerAddress(String deployerAddress);

        /**
         * Sets the value of the Metadata property for this object.
         *
         * @param metadata
         *        The new value for the Metadata property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadata(ContractMetadata metadata);

        /**
         * Sets the value of the Metadata property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ContractMetadata.Builder} avoiding the
         * need to create one manually via {@link ContractMetadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ContractMetadata.Builder#build()} is called immediately and its
         * result is passed to {@link #metadata(ContractMetadata)}.
         * 
         * @param metadata
         *        a consumer that will call methods on {@link ContractMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metadata(ContractMetadata)
         */
        default Builder metadata(Consumer<ContractMetadata.Builder> metadata) {
            return metadata(ContractMetadata.builder().applyMutation(metadata).build());
        }
    }

    static final class BuilderImpl extends ManagedBlockchainQueryResponse.BuilderImpl implements Builder {
        private ContractIdentifier contractIdentifier;

        private String tokenStandard;

        private String deployerAddress;

        private ContractMetadata metadata;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAssetContractResponse model) {
            super(model);
            contractIdentifier(model.contractIdentifier);
            tokenStandard(model.tokenStandard);
            deployerAddress(model.deployerAddress);
            metadata(model.metadata);
        }

        public final ContractIdentifier.Builder getContractIdentifier() {
            return contractIdentifier != null ? contractIdentifier.toBuilder() : null;
        }

        public final void setContractIdentifier(ContractIdentifier.BuilderImpl contractIdentifier) {
            this.contractIdentifier = contractIdentifier != null ? contractIdentifier.build() : null;
        }

        @Override
        public final Builder contractIdentifier(ContractIdentifier contractIdentifier) {
            this.contractIdentifier = contractIdentifier;
            return this;
        }

        public final String getTokenStandard() {
            return tokenStandard;
        }

        public final void setTokenStandard(String tokenStandard) {
            this.tokenStandard = tokenStandard;
        }

        @Override
        public final Builder tokenStandard(String tokenStandard) {
            this.tokenStandard = tokenStandard;
            return this;
        }

        @Override
        public final Builder tokenStandard(QueryTokenStandard tokenStandard) {
            this.tokenStandard(tokenStandard == null ? null : tokenStandard.toString());
            return this;
        }

        public final String getDeployerAddress() {
            return deployerAddress;
        }

        public final void setDeployerAddress(String deployerAddress) {
            this.deployerAddress = deployerAddress;
        }

        @Override
        public final Builder deployerAddress(String deployerAddress) {
            this.deployerAddress = deployerAddress;
            return this;
        }

        public final ContractMetadata.Builder getMetadata() {
            return metadata != null ? metadata.toBuilder() : null;
        }

        public final void setMetadata(ContractMetadata.BuilderImpl metadata) {
            this.metadata = metadata != null ? metadata.build() : null;
        }

        @Override
        public final Builder metadata(ContractMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        @Override
        public GetAssetContractResponse build() {
            return new GetAssetContractResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
