/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.managedblockchainquery.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The container for determining how the list transaction result will be sorted.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListTransactionsSort implements SdkPojo, Serializable,
        ToCopyableBuilder<ListTransactionsSort.Builder, ListTransactionsSort> {
    private static final SdkField<String> SORT_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("sortBy")
            .getter(getter(ListTransactionsSort::sortByAsString)).setter(setter(Builder::sortBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sortBy").build()).build();

    private static final SdkField<String> SORT_ORDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sortOrder").getter(getter(ListTransactionsSort::sortOrderAsString)).setter(setter(Builder::sortOrder))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sortOrder").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SORT_BY_FIELD,
            SORT_ORDER_FIELD));

    private static final long serialVersionUID = 1L;

    private final String sortBy;

    private final String sortOrder;

    private ListTransactionsSort(BuilderImpl builder) {
        this.sortBy = builder.sortBy;
        this.sortOrder = builder.sortOrder;
    }

    /**
     * <p>
     * Defaults to the value <code>TRANSACTION_TIMESTAMP</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortBy} will
     * return {@link ListTransactionsSortBy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #sortByAsString}.
     * </p>
     * 
     * @return Defaults to the value <code>TRANSACTION_TIMESTAMP</code>.
     * @see ListTransactionsSortBy
     */
    public final ListTransactionsSortBy sortBy() {
        return ListTransactionsSortBy.fromValue(sortBy);
    }

    /**
     * <p>
     * Defaults to the value <code>TRANSACTION_TIMESTAMP</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortBy} will
     * return {@link ListTransactionsSortBy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #sortByAsString}.
     * </p>
     * 
     * @return Defaults to the value <code>TRANSACTION_TIMESTAMP</code>.
     * @see ListTransactionsSortBy
     */
    public final String sortByAsString() {
        return sortBy;
    }

    /**
     * <p>
     * The container for the <i>sort order</i> for <code>ListTransactions</code>. The <code>SortOrder</code> field only
     * accepts the values <code>ASCENDING</code> and <code>DESCENDING</code>. Not providing <code>SortOrder</code> will
     * default to <code>ASCENDING</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link SortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return The container for the <i>sort order</i> for <code>ListTransactions</code>. The <code>SortOrder</code>
     *         field only accepts the values <code>ASCENDING</code> and <code>DESCENDING</code>. Not providing
     *         <code>SortOrder</code> will default to <code>ASCENDING</code>.
     * @see SortOrder
     */
    public final SortOrder sortOrder() {
        return SortOrder.fromValue(sortOrder);
    }

    /**
     * <p>
     * The container for the <i>sort order</i> for <code>ListTransactions</code>. The <code>SortOrder</code> field only
     * accepts the values <code>ASCENDING</code> and <code>DESCENDING</code>. Not providing <code>SortOrder</code> will
     * default to <code>ASCENDING</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link SortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return The container for the <i>sort order</i> for <code>ListTransactions</code>. The <code>SortOrder</code>
     *         field only accepts the values <code>ASCENDING</code> and <code>DESCENDING</code>. Not providing
     *         <code>SortOrder</code> will default to <code>ASCENDING</code>.
     * @see SortOrder
     */
    public final String sortOrderAsString() {
        return sortOrder;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sortByAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sortOrderAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTransactionsSort)) {
            return false;
        }
        ListTransactionsSort other = (ListTransactionsSort) obj;
        return Objects.equals(sortByAsString(), other.sortByAsString())
                && Objects.equals(sortOrderAsString(), other.sortOrderAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListTransactionsSort").add("SortBy", sortByAsString()).add("SortOrder", sortOrderAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "sortBy":
            return Optional.ofNullable(clazz.cast(sortByAsString()));
        case "sortOrder":
            return Optional.ofNullable(clazz.cast(sortOrderAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTransactionsSort, T> g) {
        return obj -> g.apply((ListTransactionsSort) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ListTransactionsSort> {
        /**
         * <p>
         * Defaults to the value <code>TRANSACTION_TIMESTAMP</code>.
         * </p>
         * 
         * @param sortBy
         *        Defaults to the value <code>TRANSACTION_TIMESTAMP</code>.
         * @see ListTransactionsSortBy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ListTransactionsSortBy
         */
        Builder sortBy(String sortBy);

        /**
         * <p>
         * Defaults to the value <code>TRANSACTION_TIMESTAMP</code>.
         * </p>
         * 
         * @param sortBy
         *        Defaults to the value <code>TRANSACTION_TIMESTAMP</code>.
         * @see ListTransactionsSortBy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ListTransactionsSortBy
         */
        Builder sortBy(ListTransactionsSortBy sortBy);

        /**
         * <p>
         * The container for the <i>sort order</i> for <code>ListTransactions</code>. The <code>SortOrder</code> field
         * only accepts the values <code>ASCENDING</code> and <code>DESCENDING</code>. Not providing
         * <code>SortOrder</code> will default to <code>ASCENDING</code>.
         * </p>
         * 
         * @param sortOrder
         *        The container for the <i>sort order</i> for <code>ListTransactions</code>. The <code>SortOrder</code>
         *        field only accepts the values <code>ASCENDING</code> and <code>DESCENDING</code>. Not providing
         *        <code>SortOrder</code> will default to <code>ASCENDING</code>.
         * @see SortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortOrder
         */
        Builder sortOrder(String sortOrder);

        /**
         * <p>
         * The container for the <i>sort order</i> for <code>ListTransactions</code>. The <code>SortOrder</code> field
         * only accepts the values <code>ASCENDING</code> and <code>DESCENDING</code>. Not providing
         * <code>SortOrder</code> will default to <code>ASCENDING</code>.
         * </p>
         * 
         * @param sortOrder
         *        The container for the <i>sort order</i> for <code>ListTransactions</code>. The <code>SortOrder</code>
         *        field only accepts the values <code>ASCENDING</code> and <code>DESCENDING</code>. Not providing
         *        <code>SortOrder</code> will default to <code>ASCENDING</code>.
         * @see SortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortOrder
         */
        Builder sortOrder(SortOrder sortOrder);
    }

    static final class BuilderImpl implements Builder {
        private String sortBy;

        private String sortOrder;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTransactionsSort model) {
            sortBy(model.sortBy);
            sortOrder(model.sortOrder);
        }

        public final String getSortBy() {
            return sortBy;
        }

        public final void setSortBy(String sortBy) {
            this.sortBy = sortBy;
        }

        @Override
        public final Builder sortBy(String sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        @Override
        public final Builder sortBy(ListTransactionsSortBy sortBy) {
            this.sortBy(sortBy == null ? null : sortBy.toString());
            return this;
        }

        public final String getSortOrder() {
            return sortOrder;
        }

        public final void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        @Override
        public final Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public final Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder(sortOrder == null ? null : sortOrder.toString());
            return this;
        }

        @Override
        public ListTransactionsSort build() {
            return new ListTransactionsSort(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
