/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.managedblockchainquery.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAssetContractsRequest extends ManagedBlockchainQueryRequest implements
        ToCopyableBuilder<ListAssetContractsRequest.Builder, ListAssetContractsRequest> {
    private static final SdkField<ContractFilter> CONTRACT_FILTER_FIELD = SdkField
            .<ContractFilter> builder(MarshallingType.SDK_POJO).memberName("contractFilter")
            .getter(getter(ListAssetContractsRequest::contractFilter)).setter(setter(Builder::contractFilter))
            .constructor(ContractFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contractFilter").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListAssetContractsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListAssetContractsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTRACT_FILTER_FIELD,
            NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private final ContractFilter contractFilter;

    private final String nextToken;

    private final Integer maxResults;

    private ListAssetContractsRequest(BuilderImpl builder) {
        super(builder);
        this.contractFilter = builder.contractFilter;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * Contains the filter parameter for the request.
     * </p>
     * 
     * @return Contains the filter parameter for the request.
     */
    public final ContractFilter contractFilter() {
        return contractFilter;
    }

    /**
     * <p>
     * The pagination token that indicates the next set of results to retrieve.
     * </p>
     * 
     * @return The pagination token that indicates the next set of results to retrieve.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of contracts to list.
     * </p>
     * 
     * @return The maximum number of contracts to list.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(contractFilter());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAssetContractsRequest)) {
            return false;
        }
        ListAssetContractsRequest other = (ListAssetContractsRequest) obj;
        return Objects.equals(contractFilter(), other.contractFilter()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListAssetContractsRequest").add("ContractFilter", contractFilter())
                .add("NextToken", nextToken()).add("MaxResults", maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "contractFilter":
            return Optional.ofNullable(clazz.cast(contractFilter()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAssetContractsRequest, T> g) {
        return obj -> g.apply((ListAssetContractsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ManagedBlockchainQueryRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListAssetContractsRequest> {
        /**
         * <p>
         * Contains the filter parameter for the request.
         * </p>
         * 
         * @param contractFilter
         *        Contains the filter parameter for the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contractFilter(ContractFilter contractFilter);

        /**
         * <p>
         * Contains the filter parameter for the request.
         * </p>
         * This is a convenience method that creates an instance of the {@link ContractFilter.Builder} avoiding the need
         * to create one manually via {@link ContractFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ContractFilter.Builder#build()} is called immediately and its
         * result is passed to {@link #contractFilter(ContractFilter)}.
         * 
         * @param contractFilter
         *        a consumer that will call methods on {@link ContractFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #contractFilter(ContractFilter)
         */
        default Builder contractFilter(Consumer<ContractFilter.Builder> contractFilter) {
            return contractFilter(ContractFilter.builder().applyMutation(contractFilter).build());
        }

        /**
         * <p>
         * The pagination token that indicates the next set of results to retrieve.
         * </p>
         * 
         * @param nextToken
         *        The pagination token that indicates the next set of results to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of contracts to list.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of contracts to list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ManagedBlockchainQueryRequest.BuilderImpl implements Builder {
        private ContractFilter contractFilter;

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAssetContractsRequest model) {
            super(model);
            contractFilter(model.contractFilter);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final ContractFilter.Builder getContractFilter() {
            return contractFilter != null ? contractFilter.toBuilder() : null;
        }

        public final void setContractFilter(ContractFilter.BuilderImpl contractFilter) {
            this.contractFilter = contractFilter != null ? contractFilter.build() : null;
        }

        @Override
        public final Builder contractFilter(ContractFilter contractFilter) {
            this.contractFilter = contractFilter;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListAssetContractsRequest build() {
            return new ListAssetContractsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
