/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.marketplaceagreement.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetAgreementTermsResponse extends MarketplaceAgreementResponse implements
        ToCopyableBuilder<GetAgreementTermsResponse.Builder, GetAgreementTermsResponse> {
    private static final SdkField<List<AcceptedTerm>> ACCEPTED_TERMS_FIELD = SdkField
            .<List<AcceptedTerm>> builder(MarshallingType.LIST)
            .memberName("acceptedTerms")
            .getter(getter(GetAgreementTermsResponse::acceptedTerms))
            .setter(setter(Builder::acceptedTerms))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("acceptedTerms").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AcceptedTerm> builder(MarshallingType.SDK_POJO)
                                            .constructor(AcceptedTerm::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(GetAgreementTermsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCEPTED_TERMS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<AcceptedTerm> acceptedTerms;

    private final String nextToken;

    private GetAgreementTermsResponse(BuilderImpl builder) {
        super(builder);
        this.acceptedTerms = builder.acceptedTerms;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the AcceptedTerms property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAcceptedTerms() {
        return acceptedTerms != null && !(acceptedTerms instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A subset of terms proposed by the proposer that have been accepted by the acceptor as part of the agreement
     * creation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAcceptedTerms} method.
     * </p>
     * 
     * @return A subset of terms proposed by the proposer that have been accepted by the acceptor as part of the
     *         agreement creation.
     */
    public final List<AcceptedTerm> acceptedTerms() {
        return acceptedTerms;
    }

    /**
     * <p>
     * A token to specify where to start pagination
     * </p>
     * 
     * @return A token to specify where to start pagination
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAcceptedTerms() ? acceptedTerms() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAgreementTermsResponse)) {
            return false;
        }
        GetAgreementTermsResponse other = (GetAgreementTermsResponse) obj;
        return hasAcceptedTerms() == other.hasAcceptedTerms() && Objects.equals(acceptedTerms(), other.acceptedTerms())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetAgreementTermsResponse").add("AcceptedTerms", hasAcceptedTerms() ? acceptedTerms() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "acceptedTerms":
            return Optional.ofNullable(clazz.cast(acceptedTerms()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetAgreementTermsResponse, T> g) {
        return obj -> g.apply((GetAgreementTermsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MarketplaceAgreementResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetAgreementTermsResponse> {
        /**
         * <p>
         * A subset of terms proposed by the proposer that have been accepted by the acceptor as part of the agreement
         * creation.
         * </p>
         * 
         * @param acceptedTerms
         *        A subset of terms proposed by the proposer that have been accepted by the acceptor as part of the
         *        agreement creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acceptedTerms(Collection<AcceptedTerm> acceptedTerms);

        /**
         * <p>
         * A subset of terms proposed by the proposer that have been accepted by the acceptor as part of the agreement
         * creation.
         * </p>
         * 
         * @param acceptedTerms
         *        A subset of terms proposed by the proposer that have been accepted by the acceptor as part of the
         *        agreement creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acceptedTerms(AcceptedTerm... acceptedTerms);

        /**
         * <p>
         * A subset of terms proposed by the proposer that have been accepted by the acceptor as part of the agreement
         * creation.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.marketplaceagreement.model.AcceptedTerm.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.marketplaceagreement.model.AcceptedTerm#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.marketplaceagreement.model.AcceptedTerm.Builder#build()} is called
         * immediately and its result is passed to {@link #acceptedTerms(List<AcceptedTerm>)}.
         * 
         * @param acceptedTerms
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.marketplaceagreement.model.AcceptedTerm.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #acceptedTerms(java.util.Collection<AcceptedTerm>)
         */
        Builder acceptedTerms(Consumer<AcceptedTerm.Builder>... acceptedTerms);

        /**
         * <p>
         * A token to specify where to start pagination
         * </p>
         * 
         * @param nextToken
         *        A token to specify where to start pagination
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends MarketplaceAgreementResponse.BuilderImpl implements Builder {
        private List<AcceptedTerm> acceptedTerms = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAgreementTermsResponse model) {
            super(model);
            acceptedTerms(model.acceptedTerms);
            nextToken(model.nextToken);
        }

        public final List<AcceptedTerm.Builder> getAcceptedTerms() {
            List<AcceptedTerm.Builder> result = AcceptedTermListCopier.copyToBuilder(this.acceptedTerms);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAcceptedTerms(Collection<AcceptedTerm.BuilderImpl> acceptedTerms) {
            this.acceptedTerms = AcceptedTermListCopier.copyFromBuilder(acceptedTerms);
        }

        @Override
        public final Builder acceptedTerms(Collection<AcceptedTerm> acceptedTerms) {
            this.acceptedTerms = AcceptedTermListCopier.copy(acceptedTerms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder acceptedTerms(AcceptedTerm... acceptedTerms) {
            acceptedTerms(Arrays.asList(acceptedTerms));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder acceptedTerms(Consumer<AcceptedTerm.Builder>... acceptedTerms) {
            acceptedTerms(Stream.of(acceptedTerms).map(c -> AcceptedTerm.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetAgreementTermsResponse build() {
            return new GetAgreementTermsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
