/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.marketplaceagreement.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines the list of text agreements proposed to the acceptors. An example is the end user license agreement (EULA).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LegalTerm implements SdkPojo, Serializable, ToCopyableBuilder<LegalTerm.Builder, LegalTerm> {
    private static final SdkField<List<DocumentItem>> DOCUMENTS_FIELD = SdkField
            .<List<DocumentItem>> builder(MarshallingType.LIST)
            .memberName("documents")
            .getter(getter(LegalTerm::documents))
            .setter(setter(Builder::documents))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("documents").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DocumentItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(DocumentItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(LegalTerm::type)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOCUMENTS_FIELD, TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<DocumentItem> documents;

    private final String type;

    private LegalTerm(BuilderImpl builder) {
        this.documents = builder.documents;
        this.type = builder.type;
    }

    /**
     * For responses, this returns true if the service returned a value for the Documents property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasDocuments() {
        return documents != null && !(documents instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of references to legal resources proposed to the buyers. An example is the EULA.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDocuments} method.
     * </p>
     * 
     * @return List of references to legal resources proposed to the buyers. An example is the EULA.
     */
    public final List<DocumentItem> documents() {
        return documents;
    }

    /**
     * <p>
     * Category of the term being updated.
     * </p>
     * 
     * @return Category of the term being updated.
     */
    public final String type() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasDocuments() ? documents() : null);
        hashCode = 31 * hashCode + Objects.hashCode(type());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LegalTerm)) {
            return false;
        }
        LegalTerm other = (LegalTerm) obj;
        return hasDocuments() == other.hasDocuments() && Objects.equals(documents(), other.documents())
                && Objects.equals(type(), other.type());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LegalTerm").add("Documents", hasDocuments() ? documents() : null).add("Type", type()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "documents":
            return Optional.ofNullable(clazz.cast(documents()));
        case "type":
            return Optional.ofNullable(clazz.cast(type()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LegalTerm, T> g) {
        return obj -> g.apply((LegalTerm) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LegalTerm> {
        /**
         * <p>
         * List of references to legal resources proposed to the buyers. An example is the EULA.
         * </p>
         * 
         * @param documents
         *        List of references to legal resources proposed to the buyers. An example is the EULA.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documents(Collection<DocumentItem> documents);

        /**
         * <p>
         * List of references to legal resources proposed to the buyers. An example is the EULA.
         * </p>
         * 
         * @param documents
         *        List of references to legal resources proposed to the buyers. An example is the EULA.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documents(DocumentItem... documents);

        /**
         * <p>
         * List of references to legal resources proposed to the buyers. An example is the EULA.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.marketplaceagreement.model.DocumentItem.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.marketplaceagreement.model.DocumentItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.marketplaceagreement.model.DocumentItem.Builder#build()} is called
         * immediately and its result is passed to {@link #documents(List<DocumentItem>)}.
         * 
         * @param documents
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.marketplaceagreement.model.DocumentItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #documents(java.util.Collection<DocumentItem>)
         */
        Builder documents(Consumer<DocumentItem.Builder>... documents);

        /**
         * <p>
         * Category of the term being updated.
         * </p>
         * 
         * @param type
         *        Category of the term being updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);
    }

    static final class BuilderImpl implements Builder {
        private List<DocumentItem> documents = DefaultSdkAutoConstructList.getInstance();

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(LegalTerm model) {
            documents(model.documents);
            type(model.type);
        }

        public final List<DocumentItem.Builder> getDocuments() {
            List<DocumentItem.Builder> result = DocumentListCopier.copyToBuilder(this.documents);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDocuments(Collection<DocumentItem.BuilderImpl> documents) {
            this.documents = DocumentListCopier.copyFromBuilder(documents);
        }

        @Override
        public final Builder documents(Collection<DocumentItem> documents) {
            this.documents = DocumentListCopier.copy(documents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documents(DocumentItem... documents) {
            documents(Arrays.asList(documents));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documents(Consumer<DocumentItem.Builder>... documents) {
            documents(Stream.of(documents).map(c -> DocumentItem.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public LegalTerm build() {
            return new LegalTerm(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
