/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.marketplacecatalog.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListEntitiesRequest extends MarketplaceCatalogRequest implements
        ToCopyableBuilder<ListEntitiesRequest.Builder, ListEntitiesRequest> {
    private static final SdkField<String> CATALOG_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Catalog")
            .getter(getter(ListEntitiesRequest::catalog)).setter(setter(Builder::catalog))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Catalog").build()).build();

    private static final SdkField<String> ENTITY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EntityType").getter(getter(ListEntitiesRequest::entityType)).setter(setter(Builder::entityType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntityType").build()).build();

    private static final SdkField<List<Filter>> FILTER_LIST_FIELD = SdkField
            .<List<Filter>> builder(MarshallingType.LIST)
            .memberName("FilterList")
            .getter(getter(ListEntitiesRequest::filterList))
            .setter(setter(Builder::filterList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Filter> builder(MarshallingType.SDK_POJO)
                                            .constructor(Filter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Sort> SORT_FIELD = SdkField.<Sort> builder(MarshallingType.SDK_POJO).memberName("Sort")
            .getter(getter(ListEntitiesRequest::sort)).setter(setter(Builder::sort)).constructor(Sort::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sort").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListEntitiesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListEntitiesRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_FIELD,
            ENTITY_TYPE_FIELD, FILTER_LIST_FIELD, SORT_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private final String catalog;

    private final String entityType;

    private final List<Filter> filterList;

    private final Sort sort;

    private final String nextToken;

    private final Integer maxResults;

    private ListEntitiesRequest(BuilderImpl builder) {
        super(builder);
        this.catalog = builder.catalog;
        this.entityType = builder.entityType;
        this.filterList = builder.filterList;
        this.sort = builder.sort;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * The catalog related to the request. Fixed value: <code>AWSMarketplace</code>
     * </p>
     * 
     * @return The catalog related to the request. Fixed value: <code>AWSMarketplace</code>
     */
    public final String catalog() {
        return catalog;
    }

    /**
     * <p>
     * The type of entities to retrieve.
     * </p>
     * 
     * @return The type of entities to retrieve.
     */
    public final String entityType() {
        return entityType;
    }

    /**
     * For responses, this returns true if the service returned a value for the FilterList property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFilterList() {
        return filterList != null && !(filterList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of filter objects. Each filter object contains two attributes, <code>filterName</code> and
     * <code>filterValues</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilterList} method.
     * </p>
     * 
     * @return An array of filter objects. Each filter object contains two attributes, <code>filterName</code> and
     *         <code>filterValues</code>.
     */
    public final List<Filter> filterList() {
        return filterList;
    }

    /**
     * <p>
     * An object that contains two attributes, <code>SortBy</code> and <code>SortOrder</code>.
     * </p>
     * 
     * @return An object that contains two attributes, <code>SortBy</code> and <code>SortOrder</code>.
     */
    public final Sort sort() {
        return sort;
    }

    /**
     * <p>
     * The value of the next token, if it exists. Null if there are no more results.
     * </p>
     * 
     * @return The value of the next token, if it exists. Null if there are no more results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * Specifies the upper limit of the elements on a single page. If a value isn't provided, the default value is 20.
     * </p>
     * 
     * @return Specifies the upper limit of the elements on a single page. If a value isn't provided, the default value
     *         is 20.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(catalog());
        hashCode = 31 * hashCode + Objects.hashCode(entityType());
        hashCode = 31 * hashCode + Objects.hashCode(hasFilterList() ? filterList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(sort());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEntitiesRequest)) {
            return false;
        }
        ListEntitiesRequest other = (ListEntitiesRequest) obj;
        return Objects.equals(catalog(), other.catalog()) && Objects.equals(entityType(), other.entityType())
                && hasFilterList() == other.hasFilterList() && Objects.equals(filterList(), other.filterList())
                && Objects.equals(sort(), other.sort()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListEntitiesRequest").add("Catalog", catalog()).add("EntityType", entityType())
                .add("FilterList", hasFilterList() ? filterList() : null).add("Sort", sort()).add("NextToken", nextToken())
                .add("MaxResults", maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Catalog":
            return Optional.ofNullable(clazz.cast(catalog()));
        case "EntityType":
            return Optional.ofNullable(clazz.cast(entityType()));
        case "FilterList":
            return Optional.ofNullable(clazz.cast(filterList()));
        case "Sort":
            return Optional.ofNullable(clazz.cast(sort()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListEntitiesRequest, T> g) {
        return obj -> g.apply((ListEntitiesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MarketplaceCatalogRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListEntitiesRequest> {
        /**
         * <p>
         * The catalog related to the request. Fixed value: <code>AWSMarketplace</code>
         * </p>
         * 
         * @param catalog
         *        The catalog related to the request. Fixed value: <code>AWSMarketplace</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder catalog(String catalog);

        /**
         * <p>
         * The type of entities to retrieve.
         * </p>
         * 
         * @param entityType
         *        The type of entities to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityType(String entityType);

        /**
         * <p>
         * An array of filter objects. Each filter object contains two attributes, <code>filterName</code> and
         * <code>filterValues</code>.
         * </p>
         * 
         * @param filterList
         *        An array of filter objects. Each filter object contains two attributes, <code>filterName</code> and
         *        <code>filterValues</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterList(Collection<Filter> filterList);

        /**
         * <p>
         * An array of filter objects. Each filter object contains two attributes, <code>filterName</code> and
         * <code>filterValues</code>.
         * </p>
         * 
         * @param filterList
         *        An array of filter objects. Each filter object contains two attributes, <code>filterName</code> and
         *        <code>filterValues</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterList(Filter... filterList);

        /**
         * <p>
         * An array of filter objects. Each filter object contains two attributes, <code>filterName</code> and
         * <code>filterValues</code>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.marketplacecatalog.model.Filter.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.marketplacecatalog.model.Filter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.marketplacecatalog.model.Filter.Builder#build()} is called immediately
         * and its result is passed to {@link #filterList(List<Filter>)}.
         * 
         * @param filterList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.marketplacecatalog.model.Filter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filterList(java.util.Collection<Filter>)
         */
        Builder filterList(Consumer<Filter.Builder>... filterList);

        /**
         * <p>
         * An object that contains two attributes, <code>SortBy</code> and <code>SortOrder</code>.
         * </p>
         * 
         * @param sort
         *        An object that contains two attributes, <code>SortBy</code> and <code>SortOrder</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sort(Sort sort);

        /**
         * <p>
         * An object that contains two attributes, <code>SortBy</code> and <code>SortOrder</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link Sort.Builder} avoiding the need to create
         * one manually via {@link Sort#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Sort.Builder#build()} is called immediately and its result is
         * passed to {@link #sort(Sort)}.
         * 
         * @param sort
         *        a consumer that will call methods on {@link Sort.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sort(Sort)
         */
        default Builder sort(Consumer<Sort.Builder> sort) {
            return sort(Sort.builder().applyMutation(sort).build());
        }

        /**
         * <p>
         * The value of the next token, if it exists. Null if there are no more results.
         * </p>
         * 
         * @param nextToken
         *        The value of the next token, if it exists. Null if there are no more results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Specifies the upper limit of the elements on a single page. If a value isn't provided, the default value is
         * 20.
         * </p>
         * 
         * @param maxResults
         *        Specifies the upper limit of the elements on a single page. If a value isn't provided, the default
         *        value is 20.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MarketplaceCatalogRequest.BuilderImpl implements Builder {
        private String catalog;

        private String entityType;

        private List<Filter> filterList = DefaultSdkAutoConstructList.getInstance();

        private Sort sort;

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListEntitiesRequest model) {
            super(model);
            catalog(model.catalog);
            entityType(model.entityType);
            filterList(model.filterList);
            sort(model.sort);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final String getCatalog() {
            return catalog;
        }

        public final void setCatalog(String catalog) {
            this.catalog = catalog;
        }

        @Override
        public final Builder catalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        public final String getEntityType() {
            return entityType;
        }

        public final void setEntityType(String entityType) {
            this.entityType = entityType;
        }

        @Override
        public final Builder entityType(String entityType) {
            this.entityType = entityType;
            return this;
        }

        public final List<Filter.Builder> getFilterList() {
            List<Filter.Builder> result = FilterListCopier.copyToBuilder(this.filterList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilterList(Collection<Filter.BuilderImpl> filterList) {
            this.filterList = FilterListCopier.copyFromBuilder(filterList);
        }

        @Override
        public final Builder filterList(Collection<Filter> filterList) {
            this.filterList = FilterListCopier.copy(filterList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filterList(Filter... filterList) {
            filterList(Arrays.asList(filterList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filterList(Consumer<Filter.Builder>... filterList) {
            filterList(Stream.of(filterList).map(c -> Filter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Sort.Builder getSort() {
            return sort != null ? sort.toBuilder() : null;
        }

        public final void setSort(Sort.BuilderImpl sort) {
            this.sort = sort != null ? sort.build() : null;
        }

        @Override
        public final Builder sort(Sort sort) {
            this.sort = sort;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListEntitiesRequest build() {
            return new ListEntitiesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
