/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.marketplacecatalog.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Object containing all the filter fields for container products. Client can add a maximum of 8 filters in a single
 * <code>ListEntities</code> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ContainerProductFilters implements SdkPojo, Serializable,
        ToCopyableBuilder<ContainerProductFilters.Builder, ContainerProductFilters> {
    private static final SdkField<ContainerProductEntityIdFilter> ENTITY_ID_FIELD = SdkField
            .<ContainerProductEntityIdFilter> builder(MarshallingType.SDK_POJO).memberName("EntityId")
            .getter(getter(ContainerProductFilters::entityId)).setter(setter(Builder::entityId))
            .constructor(ContainerProductEntityIdFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntityId").build()).build();

    private static final SdkField<ContainerProductLastModifiedDateFilter> LAST_MODIFIED_DATE_FIELD = SdkField
            .<ContainerProductLastModifiedDateFilter> builder(MarshallingType.SDK_POJO).memberName("LastModifiedDate")
            .getter(getter(ContainerProductFilters::lastModifiedDate)).setter(setter(Builder::lastModifiedDate))
            .constructor(ContainerProductLastModifiedDateFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedDate").build()).build();

    private static final SdkField<ContainerProductTitleFilter> PRODUCT_TITLE_FIELD = SdkField
            .<ContainerProductTitleFilter> builder(MarshallingType.SDK_POJO).memberName("ProductTitle")
            .getter(getter(ContainerProductFilters::productTitle)).setter(setter(Builder::productTitle))
            .constructor(ContainerProductTitleFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductTitle").build()).build();

    private static final SdkField<ContainerProductVisibilityFilter> VISIBILITY_FIELD = SdkField
            .<ContainerProductVisibilityFilter> builder(MarshallingType.SDK_POJO).memberName("Visibility")
            .getter(getter(ContainerProductFilters::visibility)).setter(setter(Builder::visibility))
            .constructor(ContainerProductVisibilityFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Visibility").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTITY_ID_FIELD,
            LAST_MODIFIED_DATE_FIELD, PRODUCT_TITLE_FIELD, VISIBILITY_FIELD));

    private static final long serialVersionUID = 1L;

    private final ContainerProductEntityIdFilter entityId;

    private final ContainerProductLastModifiedDateFilter lastModifiedDate;

    private final ContainerProductTitleFilter productTitle;

    private final ContainerProductVisibilityFilter visibility;

    private ContainerProductFilters(BuilderImpl builder) {
        this.entityId = builder.entityId;
        this.lastModifiedDate = builder.lastModifiedDate;
        this.productTitle = builder.productTitle;
        this.visibility = builder.visibility;
    }

    /**
     * <p>
     * Unique identifier for the container product.
     * </p>
     * 
     * @return Unique identifier for the container product.
     */
    public final ContainerProductEntityIdFilter entityId() {
        return entityId;
    }

    /**
     * <p>
     * The last date on which the container product was modified.
     * </p>
     * 
     * @return The last date on which the container product was modified.
     */
    public final ContainerProductLastModifiedDateFilter lastModifiedDate() {
        return lastModifiedDate;
    }

    /**
     * <p>
     * The title of the container product.
     * </p>
     * 
     * @return The title of the container product.
     */
    public final ContainerProductTitleFilter productTitle() {
        return productTitle;
    }

    /**
     * <p>
     * The visibility of the container product.
     * </p>
     * 
     * @return The visibility of the container product.
     */
    public final ContainerProductVisibilityFilter visibility() {
        return visibility;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(entityId());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(productTitle());
        hashCode = 31 * hashCode + Objects.hashCode(visibility());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContainerProductFilters)) {
            return false;
        }
        ContainerProductFilters other = (ContainerProductFilters) obj;
        return Objects.equals(entityId(), other.entityId()) && Objects.equals(lastModifiedDate(), other.lastModifiedDate())
                && Objects.equals(productTitle(), other.productTitle()) && Objects.equals(visibility(), other.visibility());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ContainerProductFilters").add("EntityId", entityId())
                .add("LastModifiedDate", lastModifiedDate()).add("ProductTitle", productTitle()).add("Visibility", visibility())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EntityId":
            return Optional.ofNullable(clazz.cast(entityId()));
        case "LastModifiedDate":
            return Optional.ofNullable(clazz.cast(lastModifiedDate()));
        case "ProductTitle":
            return Optional.ofNullable(clazz.cast(productTitle()));
        case "Visibility":
            return Optional.ofNullable(clazz.cast(visibility()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ContainerProductFilters, T> g) {
        return obj -> g.apply((ContainerProductFilters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ContainerProductFilters> {
        /**
         * <p>
         * Unique identifier for the container product.
         * </p>
         * 
         * @param entityId
         *        Unique identifier for the container product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityId(ContainerProductEntityIdFilter entityId);

        /**
         * <p>
         * Unique identifier for the container product.
         * </p>
         * This is a convenience method that creates an instance of the {@link ContainerProductEntityIdFilter.Builder}
         * avoiding the need to create one manually via {@link ContainerProductEntityIdFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ContainerProductEntityIdFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #entityId(ContainerProductEntityIdFilter)}.
         * 
         * @param entityId
         *        a consumer that will call methods on {@link ContainerProductEntityIdFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #entityId(ContainerProductEntityIdFilter)
         */
        default Builder entityId(Consumer<ContainerProductEntityIdFilter.Builder> entityId) {
            return entityId(ContainerProductEntityIdFilter.builder().applyMutation(entityId).build());
        }

        /**
         * <p>
         * The last date on which the container product was modified.
         * </p>
         * 
         * @param lastModifiedDate
         *        The last date on which the container product was modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedDate(ContainerProductLastModifiedDateFilter lastModifiedDate);

        /**
         * <p>
         * The last date on which the container product was modified.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ContainerProductLastModifiedDateFilter.Builder} avoiding the need to create one manually via
         * {@link ContainerProductLastModifiedDateFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ContainerProductLastModifiedDateFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #lastModifiedDate(ContainerProductLastModifiedDateFilter)}.
         * 
         * @param lastModifiedDate
         *        a consumer that will call methods on {@link ContainerProductLastModifiedDateFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lastModifiedDate(ContainerProductLastModifiedDateFilter)
         */
        default Builder lastModifiedDate(Consumer<ContainerProductLastModifiedDateFilter.Builder> lastModifiedDate) {
            return lastModifiedDate(ContainerProductLastModifiedDateFilter.builder().applyMutation(lastModifiedDate).build());
        }

        /**
         * <p>
         * The title of the container product.
         * </p>
         * 
         * @param productTitle
         *        The title of the container product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productTitle(ContainerProductTitleFilter productTitle);

        /**
         * <p>
         * The title of the container product.
         * </p>
         * This is a convenience method that creates an instance of the {@link ContainerProductTitleFilter.Builder}
         * avoiding the need to create one manually via {@link ContainerProductTitleFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ContainerProductTitleFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #productTitle(ContainerProductTitleFilter)}.
         * 
         * @param productTitle
         *        a consumer that will call methods on {@link ContainerProductTitleFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #productTitle(ContainerProductTitleFilter)
         */
        default Builder productTitle(Consumer<ContainerProductTitleFilter.Builder> productTitle) {
            return productTitle(ContainerProductTitleFilter.builder().applyMutation(productTitle).build());
        }

        /**
         * <p>
         * The visibility of the container product.
         * </p>
         * 
         * @param visibility
         *        The visibility of the container product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder visibility(ContainerProductVisibilityFilter visibility);

        /**
         * <p>
         * The visibility of the container product.
         * </p>
         * This is a convenience method that creates an instance of the {@link ContainerProductVisibilityFilter.Builder}
         * avoiding the need to create one manually via {@link ContainerProductVisibilityFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ContainerProductVisibilityFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #visibility(ContainerProductVisibilityFilter)}.
         * 
         * @param visibility
         *        a consumer that will call methods on {@link ContainerProductVisibilityFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #visibility(ContainerProductVisibilityFilter)
         */
        default Builder visibility(Consumer<ContainerProductVisibilityFilter.Builder> visibility) {
            return visibility(ContainerProductVisibilityFilter.builder().applyMutation(visibility).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ContainerProductEntityIdFilter entityId;

        private ContainerProductLastModifiedDateFilter lastModifiedDate;

        private ContainerProductTitleFilter productTitle;

        private ContainerProductVisibilityFilter visibility;

        private BuilderImpl() {
        }

        private BuilderImpl(ContainerProductFilters model) {
            entityId(model.entityId);
            lastModifiedDate(model.lastModifiedDate);
            productTitle(model.productTitle);
            visibility(model.visibility);
        }

        public final ContainerProductEntityIdFilter.Builder getEntityId() {
            return entityId != null ? entityId.toBuilder() : null;
        }

        public final void setEntityId(ContainerProductEntityIdFilter.BuilderImpl entityId) {
            this.entityId = entityId != null ? entityId.build() : null;
        }

        @Override
        public final Builder entityId(ContainerProductEntityIdFilter entityId) {
            this.entityId = entityId;
            return this;
        }

        public final ContainerProductLastModifiedDateFilter.Builder getLastModifiedDate() {
            return lastModifiedDate != null ? lastModifiedDate.toBuilder() : null;
        }

        public final void setLastModifiedDate(ContainerProductLastModifiedDateFilter.BuilderImpl lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate != null ? lastModifiedDate.build() : null;
        }

        @Override
        public final Builder lastModifiedDate(ContainerProductLastModifiedDateFilter lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final ContainerProductTitleFilter.Builder getProductTitle() {
            return productTitle != null ? productTitle.toBuilder() : null;
        }

        public final void setProductTitle(ContainerProductTitleFilter.BuilderImpl productTitle) {
            this.productTitle = productTitle != null ? productTitle.build() : null;
        }

        @Override
        public final Builder productTitle(ContainerProductTitleFilter productTitle) {
            this.productTitle = productTitle;
            return this;
        }

        public final ContainerProductVisibilityFilter.Builder getVisibility() {
            return visibility != null ? visibility.toBuilder() : null;
        }

        public final void setVisibility(ContainerProductVisibilityFilter.BuilderImpl visibility) {
            this.visibility = visibility != null ? visibility.build() : null;
        }

        @Override
        public final Builder visibility(ContainerProductVisibilityFilter visibility) {
            this.visibility = visibility;
            return this;
        }

        @Override
        public ContainerProductFilters build() {
            return new ContainerProductFilters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
