/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.marketplacecatalog.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Object that allows filtering based on the last modified date of container products.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ContainerProductLastModifiedDateFilter implements SdkPojo, Serializable,
        ToCopyableBuilder<ContainerProductLastModifiedDateFilter.Builder, ContainerProductLastModifiedDateFilter> {
    private static final SdkField<ContainerProductLastModifiedDateFilterDateRange> DATE_RANGE_FIELD = SdkField
            .<ContainerProductLastModifiedDateFilterDateRange> builder(MarshallingType.SDK_POJO).memberName("DateRange")
            .getter(getter(ContainerProductLastModifiedDateFilter::dateRange)).setter(setter(Builder::dateRange))
            .constructor(ContainerProductLastModifiedDateFilterDateRange::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DateRange").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATE_RANGE_FIELD));

    private static final long serialVersionUID = 1L;

    private final ContainerProductLastModifiedDateFilterDateRange dateRange;

    private ContainerProductLastModifiedDateFilter(BuilderImpl builder) {
        this.dateRange = builder.dateRange;
    }

    /**
     * <p>
     * Dates between which the container product was last modified.
     * </p>
     * 
     * @return Dates between which the container product was last modified.
     */
    public final ContainerProductLastModifiedDateFilterDateRange dateRange() {
        return dateRange;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dateRange());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContainerProductLastModifiedDateFilter)) {
            return false;
        }
        ContainerProductLastModifiedDateFilter other = (ContainerProductLastModifiedDateFilter) obj;
        return Objects.equals(dateRange(), other.dateRange());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ContainerProductLastModifiedDateFilter").add("DateRange", dateRange()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DateRange":
            return Optional.ofNullable(clazz.cast(dateRange()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ContainerProductLastModifiedDateFilter, T> g) {
        return obj -> g.apply((ContainerProductLastModifiedDateFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ContainerProductLastModifiedDateFilter> {
        /**
         * <p>
         * Dates between which the container product was last modified.
         * </p>
         * 
         * @param dateRange
         *        Dates between which the container product was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dateRange(ContainerProductLastModifiedDateFilterDateRange dateRange);

        /**
         * <p>
         * Dates between which the container product was last modified.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ContainerProductLastModifiedDateFilterDateRange.Builder} avoiding the need to create one manually via
         * {@link ContainerProductLastModifiedDateFilterDateRange#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ContainerProductLastModifiedDateFilterDateRange.Builder#build()}
         * is called immediately and its result is passed to
         * {@link #dateRange(ContainerProductLastModifiedDateFilterDateRange)}.
         * 
         * @param dateRange
         *        a consumer that will call methods on {@link ContainerProductLastModifiedDateFilterDateRange.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dateRange(ContainerProductLastModifiedDateFilterDateRange)
         */
        default Builder dateRange(Consumer<ContainerProductLastModifiedDateFilterDateRange.Builder> dateRange) {
            return dateRange(ContainerProductLastModifiedDateFilterDateRange.builder().applyMutation(dateRange).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ContainerProductLastModifiedDateFilterDateRange dateRange;

        private BuilderImpl() {
        }

        private BuilderImpl(ContainerProductLastModifiedDateFilter model) {
            dateRange(model.dateRange);
        }

        public final ContainerProductLastModifiedDateFilterDateRange.Builder getDateRange() {
            return dateRange != null ? dateRange.toBuilder() : null;
        }

        public final void setDateRange(ContainerProductLastModifiedDateFilterDateRange.BuilderImpl dateRange) {
            this.dateRange = dateRange != null ? dateRange.build() : null;
        }

        @Override
        public final Builder dateRange(ContainerProductLastModifiedDateFilterDateRange dateRange) {
            this.dateRange = dateRange;
            return this;
        }

        @Override
        public ContainerProductLastModifiedDateFilter build() {
            return new ContainerProductLastModifiedDateFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
