/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.marketplacecatalog.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Object containing all the filter fields for data products. Client can add a maximum of 8 filters in a single
 * <code>ListEntities</code> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataProductFilters implements SdkPojo, Serializable,
        ToCopyableBuilder<DataProductFilters.Builder, DataProductFilters> {
    private static final SdkField<DataProductEntityIdFilter> ENTITY_ID_FIELD = SdkField
            .<DataProductEntityIdFilter> builder(MarshallingType.SDK_POJO).memberName("EntityId")
            .getter(getter(DataProductFilters::entityId)).setter(setter(Builder::entityId))
            .constructor(DataProductEntityIdFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntityId").build()).build();

    private static final SdkField<DataProductTitleFilter> PRODUCT_TITLE_FIELD = SdkField
            .<DataProductTitleFilter> builder(MarshallingType.SDK_POJO).memberName("ProductTitle")
            .getter(getter(DataProductFilters::productTitle)).setter(setter(Builder::productTitle))
            .constructor(DataProductTitleFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductTitle").build()).build();

    private static final SdkField<DataProductVisibilityFilter> VISIBILITY_FIELD = SdkField
            .<DataProductVisibilityFilter> builder(MarshallingType.SDK_POJO).memberName("Visibility")
            .getter(getter(DataProductFilters::visibility)).setter(setter(Builder::visibility))
            .constructor(DataProductVisibilityFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Visibility").build()).build();

    private static final SdkField<DataProductLastModifiedDateFilter> LAST_MODIFIED_DATE_FIELD = SdkField
            .<DataProductLastModifiedDateFilter> builder(MarshallingType.SDK_POJO).memberName("LastModifiedDate")
            .getter(getter(DataProductFilters::lastModifiedDate)).setter(setter(Builder::lastModifiedDate))
            .constructor(DataProductLastModifiedDateFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedDate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTITY_ID_FIELD,
            PRODUCT_TITLE_FIELD, VISIBILITY_FIELD, LAST_MODIFIED_DATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final DataProductEntityIdFilter entityId;

    private final DataProductTitleFilter productTitle;

    private final DataProductVisibilityFilter visibility;

    private final DataProductLastModifiedDateFilter lastModifiedDate;

    private DataProductFilters(BuilderImpl builder) {
        this.entityId = builder.entityId;
        this.productTitle = builder.productTitle;
        this.visibility = builder.visibility;
        this.lastModifiedDate = builder.lastModifiedDate;
    }

    /**
     * <p>
     * Unique identifier for the data product.
     * </p>
     * 
     * @return Unique identifier for the data product.
     */
    public final DataProductEntityIdFilter entityId() {
        return entityId;
    }

    /**
     * <p>
     * The title of the data product.
     * </p>
     * 
     * @return The title of the data product.
     */
    public final DataProductTitleFilter productTitle() {
        return productTitle;
    }

    /**
     * <p>
     * The visibility of the data product.
     * </p>
     * 
     * @return The visibility of the data product.
     */
    public final DataProductVisibilityFilter visibility() {
        return visibility;
    }

    /**
     * <p>
     * The last date on which the data product was modified.
     * </p>
     * 
     * @return The last date on which the data product was modified.
     */
    public final DataProductLastModifiedDateFilter lastModifiedDate() {
        return lastModifiedDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(entityId());
        hashCode = 31 * hashCode + Objects.hashCode(productTitle());
        hashCode = 31 * hashCode + Objects.hashCode(visibility());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedDate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataProductFilters)) {
            return false;
        }
        DataProductFilters other = (DataProductFilters) obj;
        return Objects.equals(entityId(), other.entityId()) && Objects.equals(productTitle(), other.productTitle())
                && Objects.equals(visibility(), other.visibility())
                && Objects.equals(lastModifiedDate(), other.lastModifiedDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataProductFilters").add("EntityId", entityId()).add("ProductTitle", productTitle())
                .add("Visibility", visibility()).add("LastModifiedDate", lastModifiedDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EntityId":
            return Optional.ofNullable(clazz.cast(entityId()));
        case "ProductTitle":
            return Optional.ofNullable(clazz.cast(productTitle()));
        case "Visibility":
            return Optional.ofNullable(clazz.cast(visibility()));
        case "LastModifiedDate":
            return Optional.ofNullable(clazz.cast(lastModifiedDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataProductFilters, T> g) {
        return obj -> g.apply((DataProductFilters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataProductFilters> {
        /**
         * <p>
         * Unique identifier for the data product.
         * </p>
         * 
         * @param entityId
         *        Unique identifier for the data product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityId(DataProductEntityIdFilter entityId);

        /**
         * <p>
         * Unique identifier for the data product.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataProductEntityIdFilter.Builder}
         * avoiding the need to create one manually via {@link DataProductEntityIdFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataProductEntityIdFilter.Builder#build()} is called immediately
         * and its result is passed to {@link #entityId(DataProductEntityIdFilter)}.
         * 
         * @param entityId
         *        a consumer that will call methods on {@link DataProductEntityIdFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #entityId(DataProductEntityIdFilter)
         */
        default Builder entityId(Consumer<DataProductEntityIdFilter.Builder> entityId) {
            return entityId(DataProductEntityIdFilter.builder().applyMutation(entityId).build());
        }

        /**
         * <p>
         * The title of the data product.
         * </p>
         * 
         * @param productTitle
         *        The title of the data product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productTitle(DataProductTitleFilter productTitle);

        /**
         * <p>
         * The title of the data product.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataProductTitleFilter.Builder} avoiding
         * the need to create one manually via {@link DataProductTitleFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataProductTitleFilter.Builder#build()} is called immediately and
         * its result is passed to {@link #productTitle(DataProductTitleFilter)}.
         * 
         * @param productTitle
         *        a consumer that will call methods on {@link DataProductTitleFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #productTitle(DataProductTitleFilter)
         */
        default Builder productTitle(Consumer<DataProductTitleFilter.Builder> productTitle) {
            return productTitle(DataProductTitleFilter.builder().applyMutation(productTitle).build());
        }

        /**
         * <p>
         * The visibility of the data product.
         * </p>
         * 
         * @param visibility
         *        The visibility of the data product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder visibility(DataProductVisibilityFilter visibility);

        /**
         * <p>
         * The visibility of the data product.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataProductVisibilityFilter.Builder}
         * avoiding the need to create one manually via {@link DataProductVisibilityFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataProductVisibilityFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #visibility(DataProductVisibilityFilter)}.
         * 
         * @param visibility
         *        a consumer that will call methods on {@link DataProductVisibilityFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #visibility(DataProductVisibilityFilter)
         */
        default Builder visibility(Consumer<DataProductVisibilityFilter.Builder> visibility) {
            return visibility(DataProductVisibilityFilter.builder().applyMutation(visibility).build());
        }

        /**
         * <p>
         * The last date on which the data product was modified.
         * </p>
         * 
         * @param lastModifiedDate
         *        The last date on which the data product was modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedDate(DataProductLastModifiedDateFilter lastModifiedDate);

        /**
         * <p>
         * The last date on which the data product was modified.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link DataProductLastModifiedDateFilter.Builder} avoiding the need to create one manually via
         * {@link DataProductLastModifiedDateFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataProductLastModifiedDateFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #lastModifiedDate(DataProductLastModifiedDateFilter)}.
         * 
         * @param lastModifiedDate
         *        a consumer that will call methods on {@link DataProductLastModifiedDateFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lastModifiedDate(DataProductLastModifiedDateFilter)
         */
        default Builder lastModifiedDate(Consumer<DataProductLastModifiedDateFilter.Builder> lastModifiedDate) {
            return lastModifiedDate(DataProductLastModifiedDateFilter.builder().applyMutation(lastModifiedDate).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private DataProductEntityIdFilter entityId;

        private DataProductTitleFilter productTitle;

        private DataProductVisibilityFilter visibility;

        private DataProductLastModifiedDateFilter lastModifiedDate;

        private BuilderImpl() {
        }

        private BuilderImpl(DataProductFilters model) {
            entityId(model.entityId);
            productTitle(model.productTitle);
            visibility(model.visibility);
            lastModifiedDate(model.lastModifiedDate);
        }

        public final DataProductEntityIdFilter.Builder getEntityId() {
            return entityId != null ? entityId.toBuilder() : null;
        }

        public final void setEntityId(DataProductEntityIdFilter.BuilderImpl entityId) {
            this.entityId = entityId != null ? entityId.build() : null;
        }

        @Override
        public final Builder entityId(DataProductEntityIdFilter entityId) {
            this.entityId = entityId;
            return this;
        }

        public final DataProductTitleFilter.Builder getProductTitle() {
            return productTitle != null ? productTitle.toBuilder() : null;
        }

        public final void setProductTitle(DataProductTitleFilter.BuilderImpl productTitle) {
            this.productTitle = productTitle != null ? productTitle.build() : null;
        }

        @Override
        public final Builder productTitle(DataProductTitleFilter productTitle) {
            this.productTitle = productTitle;
            return this;
        }

        public final DataProductVisibilityFilter.Builder getVisibility() {
            return visibility != null ? visibility.toBuilder() : null;
        }

        public final void setVisibility(DataProductVisibilityFilter.BuilderImpl visibility) {
            this.visibility = visibility != null ? visibility.build() : null;
        }

        @Override
        public final Builder visibility(DataProductVisibilityFilter visibility) {
            this.visibility = visibility;
            return this;
        }

        public final DataProductLastModifiedDateFilter.Builder getLastModifiedDate() {
            return lastModifiedDate != null ? lastModifiedDate.toBuilder() : null;
        }

        public final void setLastModifiedDate(DataProductLastModifiedDateFilter.BuilderImpl lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate != null ? lastModifiedDate.build() : null;
        }

        @Override
        public final Builder lastModifiedDate(DataProductLastModifiedDateFilter lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        @Override
        public DataProductFilters build() {
            return new DataProductFilters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
