/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.marketplacecatalog.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This object is a container for common summary information about the entity. The summary doesn't contain the whole
 * entity structure, but it does contain information common across all entities.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EntitySummary implements SdkPojo, Serializable, ToCopyableBuilder<EntitySummary.Builder, EntitySummary> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(EntitySummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> ENTITY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EntityType").getter(getter(EntitySummary::entityType)).setter(setter(Builder::entityType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntityType").build()).build();

    private static final SdkField<String> ENTITY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EntityId").getter(getter(EntitySummary::entityId)).setter(setter(Builder::entityId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntityId").build()).build();

    private static final SdkField<String> ENTITY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EntityArn").getter(getter(EntitySummary::entityArn)).setter(setter(Builder::entityArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntityArn").build()).build();

    private static final SdkField<String> LAST_MODIFIED_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LastModifiedDate").getter(getter(EntitySummary::lastModifiedDate))
            .setter(setter(Builder::lastModifiedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedDate").build()).build();

    private static final SdkField<String> VISIBILITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Visibility").getter(getter(EntitySummary::visibility)).setter(setter(Builder::visibility))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Visibility").build()).build();

    private static final SdkField<AmiProductSummary> AMI_PRODUCT_SUMMARY_FIELD = SdkField
            .<AmiProductSummary> builder(MarshallingType.SDK_POJO).memberName("AmiProductSummary")
            .getter(getter(EntitySummary::amiProductSummary)).setter(setter(Builder::amiProductSummary))
            .constructor(AmiProductSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AmiProductSummary").build()).build();

    private static final SdkField<ContainerProductSummary> CONTAINER_PRODUCT_SUMMARY_FIELD = SdkField
            .<ContainerProductSummary> builder(MarshallingType.SDK_POJO).memberName("ContainerProductSummary")
            .getter(getter(EntitySummary::containerProductSummary)).setter(setter(Builder::containerProductSummary))
            .constructor(ContainerProductSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContainerProductSummary").build())
            .build();

    private static final SdkField<DataProductSummary> DATA_PRODUCT_SUMMARY_FIELD = SdkField
            .<DataProductSummary> builder(MarshallingType.SDK_POJO).memberName("DataProductSummary")
            .getter(getter(EntitySummary::dataProductSummary)).setter(setter(Builder::dataProductSummary))
            .constructor(DataProductSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataProductSummary").build())
            .build();

    private static final SdkField<SaaSProductSummary> SAA_S_PRODUCT_SUMMARY_FIELD = SdkField
            .<SaaSProductSummary> builder(MarshallingType.SDK_POJO).memberName("SaaSProductSummary")
            .getter(getter(EntitySummary::saaSProductSummary)).setter(setter(Builder::saaSProductSummary))
            .constructor(SaaSProductSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SaaSProductSummary").build())
            .build();

    private static final SdkField<OfferSummary> OFFER_SUMMARY_FIELD = SdkField.<OfferSummary> builder(MarshallingType.SDK_POJO)
            .memberName("OfferSummary").getter(getter(EntitySummary::offerSummary)).setter(setter(Builder::offerSummary))
            .constructor(OfferSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OfferSummary").build()).build();

    private static final SdkField<ResaleAuthorizationSummary> RESALE_AUTHORIZATION_SUMMARY_FIELD = SdkField
            .<ResaleAuthorizationSummary> builder(MarshallingType.SDK_POJO)
            .memberName("ResaleAuthorizationSummary")
            .getter(getter(EntitySummary::resaleAuthorizationSummary))
            .setter(setter(Builder::resaleAuthorizationSummary))
            .constructor(ResaleAuthorizationSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResaleAuthorizationSummary").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ENTITY_TYPE_FIELD,
            ENTITY_ID_FIELD, ENTITY_ARN_FIELD, LAST_MODIFIED_DATE_FIELD, VISIBILITY_FIELD, AMI_PRODUCT_SUMMARY_FIELD,
            CONTAINER_PRODUCT_SUMMARY_FIELD, DATA_PRODUCT_SUMMARY_FIELD, SAA_S_PRODUCT_SUMMARY_FIELD, OFFER_SUMMARY_FIELD,
            RESALE_AUTHORIZATION_SUMMARY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String entityType;

    private final String entityId;

    private final String entityArn;

    private final String lastModifiedDate;

    private final String visibility;

    private final AmiProductSummary amiProductSummary;

    private final ContainerProductSummary containerProductSummary;

    private final DataProductSummary dataProductSummary;

    private final SaaSProductSummary saaSProductSummary;

    private final OfferSummary offerSummary;

    private final ResaleAuthorizationSummary resaleAuthorizationSummary;

    private EntitySummary(BuilderImpl builder) {
        this.name = builder.name;
        this.entityType = builder.entityType;
        this.entityId = builder.entityId;
        this.entityArn = builder.entityArn;
        this.lastModifiedDate = builder.lastModifiedDate;
        this.visibility = builder.visibility;
        this.amiProductSummary = builder.amiProductSummary;
        this.containerProductSummary = builder.containerProductSummary;
        this.dataProductSummary = builder.dataProductSummary;
        this.saaSProductSummary = builder.saaSProductSummary;
        this.offerSummary = builder.offerSummary;
        this.resaleAuthorizationSummary = builder.resaleAuthorizationSummary;
    }

    /**
     * <p>
     * The name for the entity. This value is not unique. It is defined by the seller.
     * </p>
     * 
     * @return The name for the entity. This value is not unique. It is defined by the seller.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The type of the entity.
     * </p>
     * 
     * @return The type of the entity.
     */
    public final String entityType() {
        return entityType;
    }

    /**
     * <p>
     * The unique identifier for the entity.
     * </p>
     * 
     * @return The unique identifier for the entity.
     */
    public final String entityId() {
        return entityId;
    }

    /**
     * <p>
     * The ARN associated with the unique identifier for the entity.
     * </p>
     * 
     * @return The ARN associated with the unique identifier for the entity.
     */
    public final String entityArn() {
        return entityArn;
    }

    /**
     * <p>
     * The last time the entity was published, using ISO 8601 format (2018-02-27T13:45:22Z).
     * </p>
     * 
     * @return The last time the entity was published, using ISO 8601 format (2018-02-27T13:45:22Z).
     */
    public final String lastModifiedDate() {
        return lastModifiedDate;
    }

    /**
     * <p>
     * The visibility status of the entity to buyers. This value can be <code>Public</code> (everyone can view the
     * entity), <code>Limited</code> (the entity is visible to limited accounts only), or <code>Restricted</code> (the
     * entity was published and then unpublished and only existing buyers can view it).
     * </p>
     * 
     * @return The visibility status of the entity to buyers. This value can be <code>Public</code> (everyone can view
     *         the entity), <code>Limited</code> (the entity is visible to limited accounts only), or
     *         <code>Restricted</code> (the entity was published and then unpublished and only existing buyers can view
     *         it).
     */
    public final String visibility() {
        return visibility;
    }

    /**
     * <p>
     * An object that contains summary information about the AMI product.
     * </p>
     * 
     * @return An object that contains summary information about the AMI product.
     */
    public final AmiProductSummary amiProductSummary() {
        return amiProductSummary;
    }

    /**
     * <p>
     * An object that contains summary information about the container product.
     * </p>
     * 
     * @return An object that contains summary information about the container product.
     */
    public final ContainerProductSummary containerProductSummary() {
        return containerProductSummary;
    }

    /**
     * <p>
     * An object that contains summary information about the data product.
     * </p>
     * 
     * @return An object that contains summary information about the data product.
     */
    public final DataProductSummary dataProductSummary() {
        return dataProductSummary;
    }

    /**
     * <p>
     * An object that contains summary information about the SaaS product.
     * </p>
     * 
     * @return An object that contains summary information about the SaaS product.
     */
    public final SaaSProductSummary saaSProductSummary() {
        return saaSProductSummary;
    }

    /**
     * <p>
     * An object that contains summary information about the offer.
     * </p>
     * 
     * @return An object that contains summary information about the offer.
     */
    public final OfferSummary offerSummary() {
        return offerSummary;
    }

    /**
     * <p>
     * An object that contains summary information about the Resale Authorization.
     * </p>
     * 
     * @return An object that contains summary information about the Resale Authorization.
     */
    public final ResaleAuthorizationSummary resaleAuthorizationSummary() {
        return resaleAuthorizationSummary;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(entityType());
        hashCode = 31 * hashCode + Objects.hashCode(entityId());
        hashCode = 31 * hashCode + Objects.hashCode(entityArn());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(visibility());
        hashCode = 31 * hashCode + Objects.hashCode(amiProductSummary());
        hashCode = 31 * hashCode + Objects.hashCode(containerProductSummary());
        hashCode = 31 * hashCode + Objects.hashCode(dataProductSummary());
        hashCode = 31 * hashCode + Objects.hashCode(saaSProductSummary());
        hashCode = 31 * hashCode + Objects.hashCode(offerSummary());
        hashCode = 31 * hashCode + Objects.hashCode(resaleAuthorizationSummary());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EntitySummary)) {
            return false;
        }
        EntitySummary other = (EntitySummary) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(entityType(), other.entityType())
                && Objects.equals(entityId(), other.entityId()) && Objects.equals(entityArn(), other.entityArn())
                && Objects.equals(lastModifiedDate(), other.lastModifiedDate())
                && Objects.equals(visibility(), other.visibility())
                && Objects.equals(amiProductSummary(), other.amiProductSummary())
                && Objects.equals(containerProductSummary(), other.containerProductSummary())
                && Objects.equals(dataProductSummary(), other.dataProductSummary())
                && Objects.equals(saaSProductSummary(), other.saaSProductSummary())
                && Objects.equals(offerSummary(), other.offerSummary())
                && Objects.equals(resaleAuthorizationSummary(), other.resaleAuthorizationSummary());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EntitySummary").add("Name", name()).add("EntityType", entityType()).add("EntityId", entityId())
                .add("EntityArn", entityArn()).add("LastModifiedDate", lastModifiedDate()).add("Visibility", visibility())
                .add("AmiProductSummary", amiProductSummary()).add("ContainerProductSummary", containerProductSummary())
                .add("DataProductSummary", dataProductSummary()).add("SaaSProductSummary", saaSProductSummary())
                .add("OfferSummary", offerSummary()).add("ResaleAuthorizationSummary", resaleAuthorizationSummary()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "EntityType":
            return Optional.ofNullable(clazz.cast(entityType()));
        case "EntityId":
            return Optional.ofNullable(clazz.cast(entityId()));
        case "EntityArn":
            return Optional.ofNullable(clazz.cast(entityArn()));
        case "LastModifiedDate":
            return Optional.ofNullable(clazz.cast(lastModifiedDate()));
        case "Visibility":
            return Optional.ofNullable(clazz.cast(visibility()));
        case "AmiProductSummary":
            return Optional.ofNullable(clazz.cast(amiProductSummary()));
        case "ContainerProductSummary":
            return Optional.ofNullable(clazz.cast(containerProductSummary()));
        case "DataProductSummary":
            return Optional.ofNullable(clazz.cast(dataProductSummary()));
        case "SaaSProductSummary":
            return Optional.ofNullable(clazz.cast(saaSProductSummary()));
        case "OfferSummary":
            return Optional.ofNullable(clazz.cast(offerSummary()));
        case "ResaleAuthorizationSummary":
            return Optional.ofNullable(clazz.cast(resaleAuthorizationSummary()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EntitySummary, T> g) {
        return obj -> g.apply((EntitySummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EntitySummary> {
        /**
         * <p>
         * The name for the entity. This value is not unique. It is defined by the seller.
         * </p>
         * 
         * @param name
         *        The name for the entity. This value is not unique. It is defined by the seller.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The type of the entity.
         * </p>
         * 
         * @param entityType
         *        The type of the entity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityType(String entityType);

        /**
         * <p>
         * The unique identifier for the entity.
         * </p>
         * 
         * @param entityId
         *        The unique identifier for the entity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityId(String entityId);

        /**
         * <p>
         * The ARN associated with the unique identifier for the entity.
         * </p>
         * 
         * @param entityArn
         *        The ARN associated with the unique identifier for the entity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityArn(String entityArn);

        /**
         * <p>
         * The last time the entity was published, using ISO 8601 format (2018-02-27T13:45:22Z).
         * </p>
         * 
         * @param lastModifiedDate
         *        The last time the entity was published, using ISO 8601 format (2018-02-27T13:45:22Z).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedDate(String lastModifiedDate);

        /**
         * <p>
         * The visibility status of the entity to buyers. This value can be <code>Public</code> (everyone can view the
         * entity), <code>Limited</code> (the entity is visible to limited accounts only), or <code>Restricted</code>
         * (the entity was published and then unpublished and only existing buyers can view it).
         * </p>
         * 
         * @param visibility
         *        The visibility status of the entity to buyers. This value can be <code>Public</code> (everyone can
         *        view the entity), <code>Limited</code> (the entity is visible to limited accounts only), or
         *        <code>Restricted</code> (the entity was published and then unpublished and only existing buyers can
         *        view it).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder visibility(String visibility);

        /**
         * <p>
         * An object that contains summary information about the AMI product.
         * </p>
         * 
         * @param amiProductSummary
         *        An object that contains summary information about the AMI product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amiProductSummary(AmiProductSummary amiProductSummary);

        /**
         * <p>
         * An object that contains summary information about the AMI product.
         * </p>
         * This is a convenience method that creates an instance of the {@link AmiProductSummary.Builder} avoiding the
         * need to create one manually via {@link AmiProductSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AmiProductSummary.Builder#build()} is called immediately and its
         * result is passed to {@link #amiProductSummary(AmiProductSummary)}.
         * 
         * @param amiProductSummary
         *        a consumer that will call methods on {@link AmiProductSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #amiProductSummary(AmiProductSummary)
         */
        default Builder amiProductSummary(Consumer<AmiProductSummary.Builder> amiProductSummary) {
            return amiProductSummary(AmiProductSummary.builder().applyMutation(amiProductSummary).build());
        }

        /**
         * <p>
         * An object that contains summary information about the container product.
         * </p>
         * 
         * @param containerProductSummary
         *        An object that contains summary information about the container product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containerProductSummary(ContainerProductSummary containerProductSummary);

        /**
         * <p>
         * An object that contains summary information about the container product.
         * </p>
         * This is a convenience method that creates an instance of the {@link ContainerProductSummary.Builder} avoiding
         * the need to create one manually via {@link ContainerProductSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ContainerProductSummary.Builder#build()} is called immediately
         * and its result is passed to {@link #containerProductSummary(ContainerProductSummary)}.
         * 
         * @param containerProductSummary
         *        a consumer that will call methods on {@link ContainerProductSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #containerProductSummary(ContainerProductSummary)
         */
        default Builder containerProductSummary(Consumer<ContainerProductSummary.Builder> containerProductSummary) {
            return containerProductSummary(ContainerProductSummary.builder().applyMutation(containerProductSummary).build());
        }

        /**
         * <p>
         * An object that contains summary information about the data product.
         * </p>
         * 
         * @param dataProductSummary
         *        An object that contains summary information about the data product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataProductSummary(DataProductSummary dataProductSummary);

        /**
         * <p>
         * An object that contains summary information about the data product.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataProductSummary.Builder} avoiding the
         * need to create one manually via {@link DataProductSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataProductSummary.Builder#build()} is called immediately and its
         * result is passed to {@link #dataProductSummary(DataProductSummary)}.
         * 
         * @param dataProductSummary
         *        a consumer that will call methods on {@link DataProductSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataProductSummary(DataProductSummary)
         */
        default Builder dataProductSummary(Consumer<DataProductSummary.Builder> dataProductSummary) {
            return dataProductSummary(DataProductSummary.builder().applyMutation(dataProductSummary).build());
        }

        /**
         * <p>
         * An object that contains summary information about the SaaS product.
         * </p>
         * 
         * @param saaSProductSummary
         *        An object that contains summary information about the SaaS product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder saaSProductSummary(SaaSProductSummary saaSProductSummary);

        /**
         * <p>
         * An object that contains summary information about the SaaS product.
         * </p>
         * This is a convenience method that creates an instance of the {@link SaaSProductSummary.Builder} avoiding the
         * need to create one manually via {@link SaaSProductSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SaaSProductSummary.Builder#build()} is called immediately and its
         * result is passed to {@link #saaSProductSummary(SaaSProductSummary)}.
         * 
         * @param saaSProductSummary
         *        a consumer that will call methods on {@link SaaSProductSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #saaSProductSummary(SaaSProductSummary)
         */
        default Builder saaSProductSummary(Consumer<SaaSProductSummary.Builder> saaSProductSummary) {
            return saaSProductSummary(SaaSProductSummary.builder().applyMutation(saaSProductSummary).build());
        }

        /**
         * <p>
         * An object that contains summary information about the offer.
         * </p>
         * 
         * @param offerSummary
         *        An object that contains summary information about the offer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder offerSummary(OfferSummary offerSummary);

        /**
         * <p>
         * An object that contains summary information about the offer.
         * </p>
         * This is a convenience method that creates an instance of the {@link OfferSummary.Builder} avoiding the need
         * to create one manually via {@link OfferSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OfferSummary.Builder#build()} is called immediately and its
         * result is passed to {@link #offerSummary(OfferSummary)}.
         * 
         * @param offerSummary
         *        a consumer that will call methods on {@link OfferSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #offerSummary(OfferSummary)
         */
        default Builder offerSummary(Consumer<OfferSummary.Builder> offerSummary) {
            return offerSummary(OfferSummary.builder().applyMutation(offerSummary).build());
        }

        /**
         * <p>
         * An object that contains summary information about the Resale Authorization.
         * </p>
         * 
         * @param resaleAuthorizationSummary
         *        An object that contains summary information about the Resale Authorization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resaleAuthorizationSummary(ResaleAuthorizationSummary resaleAuthorizationSummary);

        /**
         * <p>
         * An object that contains summary information about the Resale Authorization.
         * </p>
         * This is a convenience method that creates an instance of the {@link ResaleAuthorizationSummary.Builder}
         * avoiding the need to create one manually via {@link ResaleAuthorizationSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResaleAuthorizationSummary.Builder#build()} is called immediately
         * and its result is passed to {@link #resaleAuthorizationSummary(ResaleAuthorizationSummary)}.
         * 
         * @param resaleAuthorizationSummary
         *        a consumer that will call methods on {@link ResaleAuthorizationSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resaleAuthorizationSummary(ResaleAuthorizationSummary)
         */
        default Builder resaleAuthorizationSummary(Consumer<ResaleAuthorizationSummary.Builder> resaleAuthorizationSummary) {
            return resaleAuthorizationSummary(ResaleAuthorizationSummary.builder().applyMutation(resaleAuthorizationSummary)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String entityType;

        private String entityId;

        private String entityArn;

        private String lastModifiedDate;

        private String visibility;

        private AmiProductSummary amiProductSummary;

        private ContainerProductSummary containerProductSummary;

        private DataProductSummary dataProductSummary;

        private SaaSProductSummary saaSProductSummary;

        private OfferSummary offerSummary;

        private ResaleAuthorizationSummary resaleAuthorizationSummary;

        private BuilderImpl() {
        }

        private BuilderImpl(EntitySummary model) {
            name(model.name);
            entityType(model.entityType);
            entityId(model.entityId);
            entityArn(model.entityArn);
            lastModifiedDate(model.lastModifiedDate);
            visibility(model.visibility);
            amiProductSummary(model.amiProductSummary);
            containerProductSummary(model.containerProductSummary);
            dataProductSummary(model.dataProductSummary);
            saaSProductSummary(model.saaSProductSummary);
            offerSummary(model.offerSummary);
            resaleAuthorizationSummary(model.resaleAuthorizationSummary);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getEntityType() {
            return entityType;
        }

        public final void setEntityType(String entityType) {
            this.entityType = entityType;
        }

        @Override
        public final Builder entityType(String entityType) {
            this.entityType = entityType;
            return this;
        }

        public final String getEntityId() {
            return entityId;
        }

        public final void setEntityId(String entityId) {
            this.entityId = entityId;
        }

        @Override
        public final Builder entityId(String entityId) {
            this.entityId = entityId;
            return this;
        }

        public final String getEntityArn() {
            return entityArn;
        }

        public final void setEntityArn(String entityArn) {
            this.entityArn = entityArn;
        }

        @Override
        public final Builder entityArn(String entityArn) {
            this.entityArn = entityArn;
            return this;
        }

        public final String getLastModifiedDate() {
            return lastModifiedDate;
        }

        public final void setLastModifiedDate(String lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(String lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final String getVisibility() {
            return visibility;
        }

        public final void setVisibility(String visibility) {
            this.visibility = visibility;
        }

        @Override
        public final Builder visibility(String visibility) {
            this.visibility = visibility;
            return this;
        }

        public final AmiProductSummary.Builder getAmiProductSummary() {
            return amiProductSummary != null ? amiProductSummary.toBuilder() : null;
        }

        public final void setAmiProductSummary(AmiProductSummary.BuilderImpl amiProductSummary) {
            this.amiProductSummary = amiProductSummary != null ? amiProductSummary.build() : null;
        }

        @Override
        public final Builder amiProductSummary(AmiProductSummary amiProductSummary) {
            this.amiProductSummary = amiProductSummary;
            return this;
        }

        public final ContainerProductSummary.Builder getContainerProductSummary() {
            return containerProductSummary != null ? containerProductSummary.toBuilder() : null;
        }

        public final void setContainerProductSummary(ContainerProductSummary.BuilderImpl containerProductSummary) {
            this.containerProductSummary = containerProductSummary != null ? containerProductSummary.build() : null;
        }

        @Override
        public final Builder containerProductSummary(ContainerProductSummary containerProductSummary) {
            this.containerProductSummary = containerProductSummary;
            return this;
        }

        public final DataProductSummary.Builder getDataProductSummary() {
            return dataProductSummary != null ? dataProductSummary.toBuilder() : null;
        }

        public final void setDataProductSummary(DataProductSummary.BuilderImpl dataProductSummary) {
            this.dataProductSummary = dataProductSummary != null ? dataProductSummary.build() : null;
        }

        @Override
        public final Builder dataProductSummary(DataProductSummary dataProductSummary) {
            this.dataProductSummary = dataProductSummary;
            return this;
        }

        public final SaaSProductSummary.Builder getSaaSProductSummary() {
            return saaSProductSummary != null ? saaSProductSummary.toBuilder() : null;
        }

        public final void setSaaSProductSummary(SaaSProductSummary.BuilderImpl saaSProductSummary) {
            this.saaSProductSummary = saaSProductSummary != null ? saaSProductSummary.build() : null;
        }

        @Override
        public final Builder saaSProductSummary(SaaSProductSummary saaSProductSummary) {
            this.saaSProductSummary = saaSProductSummary;
            return this;
        }

        public final OfferSummary.Builder getOfferSummary() {
            return offerSummary != null ? offerSummary.toBuilder() : null;
        }

        public final void setOfferSummary(OfferSummary.BuilderImpl offerSummary) {
            this.offerSummary = offerSummary != null ? offerSummary.build() : null;
        }

        @Override
        public final Builder offerSummary(OfferSummary offerSummary) {
            this.offerSummary = offerSummary;
            return this;
        }

        public final ResaleAuthorizationSummary.Builder getResaleAuthorizationSummary() {
            return resaleAuthorizationSummary != null ? resaleAuthorizationSummary.toBuilder() : null;
        }

        public final void setResaleAuthorizationSummary(ResaleAuthorizationSummary.BuilderImpl resaleAuthorizationSummary) {
            this.resaleAuthorizationSummary = resaleAuthorizationSummary != null ? resaleAuthorizationSummary.build() : null;
        }

        @Override
        public final Builder resaleAuthorizationSummary(ResaleAuthorizationSummary resaleAuthorizationSummary) {
            this.resaleAuthorizationSummary = resaleAuthorizationSummary;
            return this;
        }

        @Override
        public EntitySummary build() {
            return new EntitySummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
