/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.marketplacecatalog.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Allows filtering on the <code>BuyerAccounts</code> of an offer.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OfferBuyerAccountsFilter implements SdkPojo, Serializable,
        ToCopyableBuilder<OfferBuyerAccountsFilter.Builder, OfferBuyerAccountsFilter> {
    private static final SdkField<String> WILD_CARD_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WildCardValue").getter(getter(OfferBuyerAccountsFilter::wildCardValue))
            .setter(setter(Builder::wildCardValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WildCardValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WILD_CARD_VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String wildCardValue;

    private OfferBuyerAccountsFilter(BuilderImpl builder) {
        this.wildCardValue = builder.wildCardValue;
    }

    /**
     * <p>
     * Allows filtering on the <code>BuyerAccounts</code> of an offer with wild card input.
     * </p>
     * 
     * @return Allows filtering on the <code>BuyerAccounts</code> of an offer with wild card input.
     */
    public final String wildCardValue() {
        return wildCardValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(wildCardValue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OfferBuyerAccountsFilter)) {
            return false;
        }
        OfferBuyerAccountsFilter other = (OfferBuyerAccountsFilter) obj;
        return Objects.equals(wildCardValue(), other.wildCardValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OfferBuyerAccountsFilter").add("WildCardValue", wildCardValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WildCardValue":
            return Optional.ofNullable(clazz.cast(wildCardValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OfferBuyerAccountsFilter, T> g) {
        return obj -> g.apply((OfferBuyerAccountsFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OfferBuyerAccountsFilter> {
        /**
         * <p>
         * Allows filtering on the <code>BuyerAccounts</code> of an offer with wild card input.
         * </p>
         * 
         * @param wildCardValue
         *        Allows filtering on the <code>BuyerAccounts</code> of an offer with wild card input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder wildCardValue(String wildCardValue);
    }

    static final class BuilderImpl implements Builder {
        private String wildCardValue;

        private BuilderImpl() {
        }

        private BuilderImpl(OfferBuyerAccountsFilter model) {
            wildCardValue(model.wildCardValue);
        }

        public final String getWildCardValue() {
            return wildCardValue;
        }

        public final void setWildCardValue(String wildCardValue) {
            this.wildCardValue = wildCardValue;
        }

        @Override
        public final Builder wildCardValue(String wildCardValue) {
            this.wildCardValue = wildCardValue;
            return this;
        }

        @Override
        public OfferBuyerAccountsFilter build() {
            return new OfferBuyerAccountsFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
