/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.marketplacecatalog.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A filter for offers entity.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OfferFilters implements SdkPojo, Serializable, ToCopyableBuilder<OfferFilters.Builder, OfferFilters> {
    private static final SdkField<OfferEntityIdFilter> ENTITY_ID_FIELD = SdkField
            .<OfferEntityIdFilter> builder(MarshallingType.SDK_POJO).memberName("EntityId")
            .getter(getter(OfferFilters::entityId)).setter(setter(Builder::entityId)).constructor(OfferEntityIdFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntityId").build()).build();

    private static final SdkField<OfferNameFilter> NAME_FIELD = SdkField.<OfferNameFilter> builder(MarshallingType.SDK_POJO)
            .memberName("Name").getter(getter(OfferFilters::name)).setter(setter(Builder::name))
            .constructor(OfferNameFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<OfferProductIdFilter> PRODUCT_ID_FIELD = SdkField
            .<OfferProductIdFilter> builder(MarshallingType.SDK_POJO).memberName("ProductId")
            .getter(getter(OfferFilters::productId)).setter(setter(Builder::productId))
            .constructor(OfferProductIdFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductId").build()).build();

    private static final SdkField<OfferReleaseDateFilter> RELEASE_DATE_FIELD = SdkField
            .<OfferReleaseDateFilter> builder(MarshallingType.SDK_POJO).memberName("ReleaseDate")
            .getter(getter(OfferFilters::releaseDate)).setter(setter(Builder::releaseDate))
            .constructor(OfferReleaseDateFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReleaseDate").build()).build();

    private static final SdkField<OfferAvailabilityEndDateFilter> AVAILABILITY_END_DATE_FIELD = SdkField
            .<OfferAvailabilityEndDateFilter> builder(MarshallingType.SDK_POJO).memberName("AvailabilityEndDate")
            .getter(getter(OfferFilters::availabilityEndDate)).setter(setter(Builder::availabilityEndDate))
            .constructor(OfferAvailabilityEndDateFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityEndDate").build())
            .build();

    private static final SdkField<OfferBuyerAccountsFilter> BUYER_ACCOUNTS_FIELD = SdkField
            .<OfferBuyerAccountsFilter> builder(MarshallingType.SDK_POJO).memberName("BuyerAccounts")
            .getter(getter(OfferFilters::buyerAccounts)).setter(setter(Builder::buyerAccounts))
            .constructor(OfferBuyerAccountsFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BuyerAccounts").build()).build();

    private static final SdkField<OfferStateFilter> STATE_FIELD = SdkField.<OfferStateFilter> builder(MarshallingType.SDK_POJO)
            .memberName("State").getter(getter(OfferFilters::state)).setter(setter(Builder::state))
            .constructor(OfferStateFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<OfferTargetingFilter> TARGETING_FIELD = SdkField
            .<OfferTargetingFilter> builder(MarshallingType.SDK_POJO).memberName("Targeting")
            .getter(getter(OfferFilters::targeting)).setter(setter(Builder::targeting))
            .constructor(OfferTargetingFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Targeting").build()).build();

    private static final SdkField<OfferLastModifiedDateFilter> LAST_MODIFIED_DATE_FIELD = SdkField
            .<OfferLastModifiedDateFilter> builder(MarshallingType.SDK_POJO).memberName("LastModifiedDate")
            .getter(getter(OfferFilters::lastModifiedDate)).setter(setter(Builder::lastModifiedDate))
            .constructor(OfferLastModifiedDateFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedDate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTITY_ID_FIELD, NAME_FIELD,
            PRODUCT_ID_FIELD, RELEASE_DATE_FIELD, AVAILABILITY_END_DATE_FIELD, BUYER_ACCOUNTS_FIELD, STATE_FIELD,
            TARGETING_FIELD, LAST_MODIFIED_DATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final OfferEntityIdFilter entityId;

    private final OfferNameFilter name;

    private final OfferProductIdFilter productId;

    private final OfferReleaseDateFilter releaseDate;

    private final OfferAvailabilityEndDateFilter availabilityEndDate;

    private final OfferBuyerAccountsFilter buyerAccounts;

    private final OfferStateFilter state;

    private final OfferTargetingFilter targeting;

    private final OfferLastModifiedDateFilter lastModifiedDate;

    private OfferFilters(BuilderImpl builder) {
        this.entityId = builder.entityId;
        this.name = builder.name;
        this.productId = builder.productId;
        this.releaseDate = builder.releaseDate;
        this.availabilityEndDate = builder.availabilityEndDate;
        this.buyerAccounts = builder.buyerAccounts;
        this.state = builder.state;
        this.targeting = builder.targeting;
        this.lastModifiedDate = builder.lastModifiedDate;
    }

    /**
     * <p>
     * Allows filtering on <code>EntityId</code> of an offer.
     * </p>
     * 
     * @return Allows filtering on <code>EntityId</code> of an offer.
     */
    public final OfferEntityIdFilter entityId() {
        return entityId;
    }

    /**
     * <p>
     * Allows filtering on the <code>Name</code> of an offer.
     * </p>
     * 
     * @return Allows filtering on the <code>Name</code> of an offer.
     */
    public final OfferNameFilter name() {
        return name;
    }

    /**
     * <p>
     * Allows filtering on the <code>ProductId</code> of an offer.
     * </p>
     * 
     * @return Allows filtering on the <code>ProductId</code> of an offer.
     */
    public final OfferProductIdFilter productId() {
        return productId;
    }

    /**
     * <p>
     * Allows filtering on the <code>ReleaseDate</code> of an offer.
     * </p>
     * 
     * @return Allows filtering on the <code>ReleaseDate</code> of an offer.
     */
    public final OfferReleaseDateFilter releaseDate() {
        return releaseDate;
    }

    /**
     * <p>
     * Allows filtering on the <code>AvailabilityEndDate</code> of an offer.
     * </p>
     * 
     * @return Allows filtering on the <code>AvailabilityEndDate</code> of an offer.
     */
    public final OfferAvailabilityEndDateFilter availabilityEndDate() {
        return availabilityEndDate;
    }

    /**
     * <p>
     * Allows filtering on the <code>BuyerAccounts</code> of an offer.
     * </p>
     * 
     * @return Allows filtering on the <code>BuyerAccounts</code> of an offer.
     */
    public final OfferBuyerAccountsFilter buyerAccounts() {
        return buyerAccounts;
    }

    /**
     * <p>
     * Allows filtering on the <code>State</code> of an offer.
     * </p>
     * 
     * @return Allows filtering on the <code>State</code> of an offer.
     */
    public final OfferStateFilter state() {
        return state;
    }

    /**
     * <p>
     * Allows filtering on the <code>Targeting</code> of an offer.
     * </p>
     * 
     * @return Allows filtering on the <code>Targeting</code> of an offer.
     */
    public final OfferTargetingFilter targeting() {
        return targeting;
    }

    /**
     * <p>
     * Allows filtering on the <code>LastModifiedDate</code> of an offer.
     * </p>
     * 
     * @return Allows filtering on the <code>LastModifiedDate</code> of an offer.
     */
    public final OfferLastModifiedDateFilter lastModifiedDate() {
        return lastModifiedDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(entityId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(productId());
        hashCode = 31 * hashCode + Objects.hashCode(releaseDate());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityEndDate());
        hashCode = 31 * hashCode + Objects.hashCode(buyerAccounts());
        hashCode = 31 * hashCode + Objects.hashCode(state());
        hashCode = 31 * hashCode + Objects.hashCode(targeting());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedDate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OfferFilters)) {
            return false;
        }
        OfferFilters other = (OfferFilters) obj;
        return Objects.equals(entityId(), other.entityId()) && Objects.equals(name(), other.name())
                && Objects.equals(productId(), other.productId()) && Objects.equals(releaseDate(), other.releaseDate())
                && Objects.equals(availabilityEndDate(), other.availabilityEndDate())
                && Objects.equals(buyerAccounts(), other.buyerAccounts()) && Objects.equals(state(), other.state())
                && Objects.equals(targeting(), other.targeting()) && Objects.equals(lastModifiedDate(), other.lastModifiedDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OfferFilters").add("EntityId", entityId()).add("Name", name()).add("ProductId", productId())
                .add("ReleaseDate", releaseDate()).add("AvailabilityEndDate", availabilityEndDate())
                .add("BuyerAccounts", buyerAccounts()).add("State", state()).add("Targeting", targeting())
                .add("LastModifiedDate", lastModifiedDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EntityId":
            return Optional.ofNullable(clazz.cast(entityId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "ProductId":
            return Optional.ofNullable(clazz.cast(productId()));
        case "ReleaseDate":
            return Optional.ofNullable(clazz.cast(releaseDate()));
        case "AvailabilityEndDate":
            return Optional.ofNullable(clazz.cast(availabilityEndDate()));
        case "BuyerAccounts":
            return Optional.ofNullable(clazz.cast(buyerAccounts()));
        case "State":
            return Optional.ofNullable(clazz.cast(state()));
        case "Targeting":
            return Optional.ofNullable(clazz.cast(targeting()));
        case "LastModifiedDate":
            return Optional.ofNullable(clazz.cast(lastModifiedDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OfferFilters, T> g) {
        return obj -> g.apply((OfferFilters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OfferFilters> {
        /**
         * <p>
         * Allows filtering on <code>EntityId</code> of an offer.
         * </p>
         * 
         * @param entityId
         *        Allows filtering on <code>EntityId</code> of an offer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityId(OfferEntityIdFilter entityId);

        /**
         * <p>
         * Allows filtering on <code>EntityId</code> of an offer.
         * </p>
         * This is a convenience method that creates an instance of the {@link OfferEntityIdFilter.Builder} avoiding the
         * need to create one manually via {@link OfferEntityIdFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OfferEntityIdFilter.Builder#build()} is called immediately and
         * its result is passed to {@link #entityId(OfferEntityIdFilter)}.
         * 
         * @param entityId
         *        a consumer that will call methods on {@link OfferEntityIdFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #entityId(OfferEntityIdFilter)
         */
        default Builder entityId(Consumer<OfferEntityIdFilter.Builder> entityId) {
            return entityId(OfferEntityIdFilter.builder().applyMutation(entityId).build());
        }

        /**
         * <p>
         * Allows filtering on the <code>Name</code> of an offer.
         * </p>
         * 
         * @param name
         *        Allows filtering on the <code>Name</code> of an offer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(OfferNameFilter name);

        /**
         * <p>
         * Allows filtering on the <code>Name</code> of an offer.
         * </p>
         * This is a convenience method that creates an instance of the {@link OfferNameFilter.Builder} avoiding the
         * need to create one manually via {@link OfferNameFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OfferNameFilter.Builder#build()} is called immediately and its
         * result is passed to {@link #name(OfferNameFilter)}.
         * 
         * @param name
         *        a consumer that will call methods on {@link OfferNameFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #name(OfferNameFilter)
         */
        default Builder name(Consumer<OfferNameFilter.Builder> name) {
            return name(OfferNameFilter.builder().applyMutation(name).build());
        }

        /**
         * <p>
         * Allows filtering on the <code>ProductId</code> of an offer.
         * </p>
         * 
         * @param productId
         *        Allows filtering on the <code>ProductId</code> of an offer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productId(OfferProductIdFilter productId);

        /**
         * <p>
         * Allows filtering on the <code>ProductId</code> of an offer.
         * </p>
         * This is a convenience method that creates an instance of the {@link OfferProductIdFilter.Builder} avoiding
         * the need to create one manually via {@link OfferProductIdFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OfferProductIdFilter.Builder#build()} is called immediately and
         * its result is passed to {@link #productId(OfferProductIdFilter)}.
         * 
         * @param productId
         *        a consumer that will call methods on {@link OfferProductIdFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #productId(OfferProductIdFilter)
         */
        default Builder productId(Consumer<OfferProductIdFilter.Builder> productId) {
            return productId(OfferProductIdFilter.builder().applyMutation(productId).build());
        }

        /**
         * <p>
         * Allows filtering on the <code>ReleaseDate</code> of an offer.
         * </p>
         * 
         * @param releaseDate
         *        Allows filtering on the <code>ReleaseDate</code> of an offer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder releaseDate(OfferReleaseDateFilter releaseDate);

        /**
         * <p>
         * Allows filtering on the <code>ReleaseDate</code> of an offer.
         * </p>
         * This is a convenience method that creates an instance of the {@link OfferReleaseDateFilter.Builder} avoiding
         * the need to create one manually via {@link OfferReleaseDateFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OfferReleaseDateFilter.Builder#build()} is called immediately and
         * its result is passed to {@link #releaseDate(OfferReleaseDateFilter)}.
         * 
         * @param releaseDate
         *        a consumer that will call methods on {@link OfferReleaseDateFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #releaseDate(OfferReleaseDateFilter)
         */
        default Builder releaseDate(Consumer<OfferReleaseDateFilter.Builder> releaseDate) {
            return releaseDate(OfferReleaseDateFilter.builder().applyMutation(releaseDate).build());
        }

        /**
         * <p>
         * Allows filtering on the <code>AvailabilityEndDate</code> of an offer.
         * </p>
         * 
         * @param availabilityEndDate
         *        Allows filtering on the <code>AvailabilityEndDate</code> of an offer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityEndDate(OfferAvailabilityEndDateFilter availabilityEndDate);

        /**
         * <p>
         * Allows filtering on the <code>AvailabilityEndDate</code> of an offer.
         * </p>
         * This is a convenience method that creates an instance of the {@link OfferAvailabilityEndDateFilter.Builder}
         * avoiding the need to create one manually via {@link OfferAvailabilityEndDateFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OfferAvailabilityEndDateFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #availabilityEndDate(OfferAvailabilityEndDateFilter)}.
         * 
         * @param availabilityEndDate
         *        a consumer that will call methods on {@link OfferAvailabilityEndDateFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #availabilityEndDate(OfferAvailabilityEndDateFilter)
         */
        default Builder availabilityEndDate(Consumer<OfferAvailabilityEndDateFilter.Builder> availabilityEndDate) {
            return availabilityEndDate(OfferAvailabilityEndDateFilter.builder().applyMutation(availabilityEndDate).build());
        }

        /**
         * <p>
         * Allows filtering on the <code>BuyerAccounts</code> of an offer.
         * </p>
         * 
         * @param buyerAccounts
         *        Allows filtering on the <code>BuyerAccounts</code> of an offer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder buyerAccounts(OfferBuyerAccountsFilter buyerAccounts);

        /**
         * <p>
         * Allows filtering on the <code>BuyerAccounts</code> of an offer.
         * </p>
         * This is a convenience method that creates an instance of the {@link OfferBuyerAccountsFilter.Builder}
         * avoiding the need to create one manually via {@link OfferBuyerAccountsFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OfferBuyerAccountsFilter.Builder#build()} is called immediately
         * and its result is passed to {@link #buyerAccounts(OfferBuyerAccountsFilter)}.
         * 
         * @param buyerAccounts
         *        a consumer that will call methods on {@link OfferBuyerAccountsFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #buyerAccounts(OfferBuyerAccountsFilter)
         */
        default Builder buyerAccounts(Consumer<OfferBuyerAccountsFilter.Builder> buyerAccounts) {
            return buyerAccounts(OfferBuyerAccountsFilter.builder().applyMutation(buyerAccounts).build());
        }

        /**
         * <p>
         * Allows filtering on the <code>State</code> of an offer.
         * </p>
         * 
         * @param state
         *        Allows filtering on the <code>State</code> of an offer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder state(OfferStateFilter state);

        /**
         * <p>
         * Allows filtering on the <code>State</code> of an offer.
         * </p>
         * This is a convenience method that creates an instance of the {@link OfferStateFilter.Builder} avoiding the
         * need to create one manually via {@link OfferStateFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OfferStateFilter.Builder#build()} is called immediately and its
         * result is passed to {@link #state(OfferStateFilter)}.
         * 
         * @param state
         *        a consumer that will call methods on {@link OfferStateFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #state(OfferStateFilter)
         */
        default Builder state(Consumer<OfferStateFilter.Builder> state) {
            return state(OfferStateFilter.builder().applyMutation(state).build());
        }

        /**
         * <p>
         * Allows filtering on the <code>Targeting</code> of an offer.
         * </p>
         * 
         * @param targeting
         *        Allows filtering on the <code>Targeting</code> of an offer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targeting(OfferTargetingFilter targeting);

        /**
         * <p>
         * Allows filtering on the <code>Targeting</code> of an offer.
         * </p>
         * This is a convenience method that creates an instance of the {@link OfferTargetingFilter.Builder} avoiding
         * the need to create one manually via {@link OfferTargetingFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OfferTargetingFilter.Builder#build()} is called immediately and
         * its result is passed to {@link #targeting(OfferTargetingFilter)}.
         * 
         * @param targeting
         *        a consumer that will call methods on {@link OfferTargetingFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targeting(OfferTargetingFilter)
         */
        default Builder targeting(Consumer<OfferTargetingFilter.Builder> targeting) {
            return targeting(OfferTargetingFilter.builder().applyMutation(targeting).build());
        }

        /**
         * <p>
         * Allows filtering on the <code>LastModifiedDate</code> of an offer.
         * </p>
         * 
         * @param lastModifiedDate
         *        Allows filtering on the <code>LastModifiedDate</code> of an offer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedDate(OfferLastModifiedDateFilter lastModifiedDate);

        /**
         * <p>
         * Allows filtering on the <code>LastModifiedDate</code> of an offer.
         * </p>
         * This is a convenience method that creates an instance of the {@link OfferLastModifiedDateFilter.Builder}
         * avoiding the need to create one manually via {@link OfferLastModifiedDateFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OfferLastModifiedDateFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #lastModifiedDate(OfferLastModifiedDateFilter)}.
         * 
         * @param lastModifiedDate
         *        a consumer that will call methods on {@link OfferLastModifiedDateFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lastModifiedDate(OfferLastModifiedDateFilter)
         */
        default Builder lastModifiedDate(Consumer<OfferLastModifiedDateFilter.Builder> lastModifiedDate) {
            return lastModifiedDate(OfferLastModifiedDateFilter.builder().applyMutation(lastModifiedDate).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private OfferEntityIdFilter entityId;

        private OfferNameFilter name;

        private OfferProductIdFilter productId;

        private OfferReleaseDateFilter releaseDate;

        private OfferAvailabilityEndDateFilter availabilityEndDate;

        private OfferBuyerAccountsFilter buyerAccounts;

        private OfferStateFilter state;

        private OfferTargetingFilter targeting;

        private OfferLastModifiedDateFilter lastModifiedDate;

        private BuilderImpl() {
        }

        private BuilderImpl(OfferFilters model) {
            entityId(model.entityId);
            name(model.name);
            productId(model.productId);
            releaseDate(model.releaseDate);
            availabilityEndDate(model.availabilityEndDate);
            buyerAccounts(model.buyerAccounts);
            state(model.state);
            targeting(model.targeting);
            lastModifiedDate(model.lastModifiedDate);
        }

        public final OfferEntityIdFilter.Builder getEntityId() {
            return entityId != null ? entityId.toBuilder() : null;
        }

        public final void setEntityId(OfferEntityIdFilter.BuilderImpl entityId) {
            this.entityId = entityId != null ? entityId.build() : null;
        }

        @Override
        public final Builder entityId(OfferEntityIdFilter entityId) {
            this.entityId = entityId;
            return this;
        }

        public final OfferNameFilter.Builder getName() {
            return name != null ? name.toBuilder() : null;
        }

        public final void setName(OfferNameFilter.BuilderImpl name) {
            this.name = name != null ? name.build() : null;
        }

        @Override
        public final Builder name(OfferNameFilter name) {
            this.name = name;
            return this;
        }

        public final OfferProductIdFilter.Builder getProductId() {
            return productId != null ? productId.toBuilder() : null;
        }

        public final void setProductId(OfferProductIdFilter.BuilderImpl productId) {
            this.productId = productId != null ? productId.build() : null;
        }

        @Override
        public final Builder productId(OfferProductIdFilter productId) {
            this.productId = productId;
            return this;
        }

        public final OfferReleaseDateFilter.Builder getReleaseDate() {
            return releaseDate != null ? releaseDate.toBuilder() : null;
        }

        public final void setReleaseDate(OfferReleaseDateFilter.BuilderImpl releaseDate) {
            this.releaseDate = releaseDate != null ? releaseDate.build() : null;
        }

        @Override
        public final Builder releaseDate(OfferReleaseDateFilter releaseDate) {
            this.releaseDate = releaseDate;
            return this;
        }

        public final OfferAvailabilityEndDateFilter.Builder getAvailabilityEndDate() {
            return availabilityEndDate != null ? availabilityEndDate.toBuilder() : null;
        }

        public final void setAvailabilityEndDate(OfferAvailabilityEndDateFilter.BuilderImpl availabilityEndDate) {
            this.availabilityEndDate = availabilityEndDate != null ? availabilityEndDate.build() : null;
        }

        @Override
        public final Builder availabilityEndDate(OfferAvailabilityEndDateFilter availabilityEndDate) {
            this.availabilityEndDate = availabilityEndDate;
            return this;
        }

        public final OfferBuyerAccountsFilter.Builder getBuyerAccounts() {
            return buyerAccounts != null ? buyerAccounts.toBuilder() : null;
        }

        public final void setBuyerAccounts(OfferBuyerAccountsFilter.BuilderImpl buyerAccounts) {
            this.buyerAccounts = buyerAccounts != null ? buyerAccounts.build() : null;
        }

        @Override
        public final Builder buyerAccounts(OfferBuyerAccountsFilter buyerAccounts) {
            this.buyerAccounts = buyerAccounts;
            return this;
        }

        public final OfferStateFilter.Builder getState() {
            return state != null ? state.toBuilder() : null;
        }

        public final void setState(OfferStateFilter.BuilderImpl state) {
            this.state = state != null ? state.build() : null;
        }

        @Override
        public final Builder state(OfferStateFilter state) {
            this.state = state;
            return this;
        }

        public final OfferTargetingFilter.Builder getTargeting() {
            return targeting != null ? targeting.toBuilder() : null;
        }

        public final void setTargeting(OfferTargetingFilter.BuilderImpl targeting) {
            this.targeting = targeting != null ? targeting.build() : null;
        }

        @Override
        public final Builder targeting(OfferTargetingFilter targeting) {
            this.targeting = targeting;
            return this;
        }

        public final OfferLastModifiedDateFilter.Builder getLastModifiedDate() {
            return lastModifiedDate != null ? lastModifiedDate.toBuilder() : null;
        }

        public final void setLastModifiedDate(OfferLastModifiedDateFilter.BuilderImpl lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate != null ? lastModifiedDate.build() : null;
        }

        @Override
        public final Builder lastModifiedDate(OfferLastModifiedDateFilter lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        @Override
        public OfferFilters build() {
            return new OfferFilters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
