/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.marketplacecatalog.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summarized information about an offer.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OfferSummary implements SdkPojo, Serializable, ToCopyableBuilder<OfferSummary.Builder, OfferSummary> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(OfferSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> PRODUCT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProductId").getter(getter(OfferSummary::productId)).setter(setter(Builder::productId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductId").build()).build();

    private static final SdkField<String> RELEASE_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReleaseDate").getter(getter(OfferSummary::releaseDate)).setter(setter(Builder::releaseDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReleaseDate").build()).build();

    private static final SdkField<String> AVAILABILITY_END_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AvailabilityEndDate").getter(getter(OfferSummary::availabilityEndDate))
            .setter(setter(Builder::availabilityEndDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityEndDate").build())
            .build();

    private static final SdkField<List<String>> BUYER_ACCOUNTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("BuyerAccounts")
            .getter(getter(OfferSummary::buyerAccounts))
            .setter(setter(Builder::buyerAccounts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BuyerAccounts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(OfferSummary::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<List<String>> TARGETING_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Targeting")
            .getter(getter(OfferSummary::targetingAsStrings))
            .setter(setter(Builder::targetingWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Targeting").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, PRODUCT_ID_FIELD,
            RELEASE_DATE_FIELD, AVAILABILITY_END_DATE_FIELD, BUYER_ACCOUNTS_FIELD, STATE_FIELD, TARGETING_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String productId;

    private final String releaseDate;

    private final String availabilityEndDate;

    private final List<String> buyerAccounts;

    private final String state;

    private final List<String> targeting;

    private OfferSummary(BuilderImpl builder) {
        this.name = builder.name;
        this.productId = builder.productId;
        this.releaseDate = builder.releaseDate;
        this.availabilityEndDate = builder.availabilityEndDate;
        this.buyerAccounts = builder.buyerAccounts;
        this.state = builder.state;
        this.targeting = builder.targeting;
    }

    /**
     * <p>
     * The name of the offer.
     * </p>
     * 
     * @return The name of the offer.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The product ID of the offer.
     * </p>
     * 
     * @return The product ID of the offer.
     */
    public final String productId() {
        return productId;
    }

    /**
     * <p>
     * The release date of the offer.
     * </p>
     * 
     * @return The release date of the offer.
     */
    public final String releaseDate() {
        return releaseDate;
    }

    /**
     * <p>
     * The availability end date of the offer.
     * </p>
     * 
     * @return The availability end date of the offer.
     */
    public final String availabilityEndDate() {
        return availabilityEndDate;
    }

    /**
     * For responses, this returns true if the service returned a value for the BuyerAccounts property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasBuyerAccounts() {
        return buyerAccounts != null && !(buyerAccounts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The buyer accounts in the offer.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBuyerAccounts} method.
     * </p>
     * 
     * @return The buyer accounts in the offer.
     */
    public final List<String> buyerAccounts() {
        return buyerAccounts;
    }

    /**
     * <p>
     * The status of the offer.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link OfferStateString#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The status of the offer.
     * @see OfferStateString
     */
    public final OfferStateString state() {
        return OfferStateString.fromValue(state);
    }

    /**
     * <p>
     * The status of the offer.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link OfferStateString#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The status of the offer.
     * @see OfferStateString
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The targeting in the offer.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTargeting} method.
     * </p>
     * 
     * @return The targeting in the offer.
     */
    public final List<OfferTargetingString> targeting() {
        return OfferTargetingListCopier.copyStringToEnum(targeting);
    }

    /**
     * For responses, this returns true if the service returned a value for the Targeting property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasTargeting() {
        return targeting != null && !(targeting instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The targeting in the offer.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTargeting} method.
     * </p>
     * 
     * @return The targeting in the offer.
     */
    public final List<String> targetingAsStrings() {
        return targeting;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(productId());
        hashCode = 31 * hashCode + Objects.hashCode(releaseDate());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityEndDate());
        hashCode = 31 * hashCode + Objects.hashCode(hasBuyerAccounts() ? buyerAccounts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTargeting() ? targetingAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OfferSummary)) {
            return false;
        }
        OfferSummary other = (OfferSummary) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(productId(), other.productId())
                && Objects.equals(releaseDate(), other.releaseDate())
                && Objects.equals(availabilityEndDate(), other.availabilityEndDate())
                && hasBuyerAccounts() == other.hasBuyerAccounts() && Objects.equals(buyerAccounts(), other.buyerAccounts())
                && Objects.equals(stateAsString(), other.stateAsString()) && hasTargeting() == other.hasTargeting()
                && Objects.equals(targetingAsStrings(), other.targetingAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OfferSummary").add("Name", name()).add("ProductId", productId())
                .add("ReleaseDate", releaseDate()).add("AvailabilityEndDate", availabilityEndDate())
                .add("BuyerAccounts", hasBuyerAccounts() ? buyerAccounts() : null).add("State", stateAsString())
                .add("Targeting", hasTargeting() ? targetingAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "ProductId":
            return Optional.ofNullable(clazz.cast(productId()));
        case "ReleaseDate":
            return Optional.ofNullable(clazz.cast(releaseDate()));
        case "AvailabilityEndDate":
            return Optional.ofNullable(clazz.cast(availabilityEndDate()));
        case "BuyerAccounts":
            return Optional.ofNullable(clazz.cast(buyerAccounts()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "Targeting":
            return Optional.ofNullable(clazz.cast(targetingAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OfferSummary, T> g) {
        return obj -> g.apply((OfferSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OfferSummary> {
        /**
         * <p>
         * The name of the offer.
         * </p>
         * 
         * @param name
         *        The name of the offer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The product ID of the offer.
         * </p>
         * 
         * @param productId
         *        The product ID of the offer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productId(String productId);

        /**
         * <p>
         * The release date of the offer.
         * </p>
         * 
         * @param releaseDate
         *        The release date of the offer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder releaseDate(String releaseDate);

        /**
         * <p>
         * The availability end date of the offer.
         * </p>
         * 
         * @param availabilityEndDate
         *        The availability end date of the offer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityEndDate(String availabilityEndDate);

        /**
         * <p>
         * The buyer accounts in the offer.
         * </p>
         * 
         * @param buyerAccounts
         *        The buyer accounts in the offer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder buyerAccounts(Collection<String> buyerAccounts);

        /**
         * <p>
         * The buyer accounts in the offer.
         * </p>
         * 
         * @param buyerAccounts
         *        The buyer accounts in the offer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder buyerAccounts(String... buyerAccounts);

        /**
         * <p>
         * The status of the offer.
         * </p>
         * 
         * @param state
         *        The status of the offer.
         * @see OfferStateString
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OfferStateString
         */
        Builder state(String state);

        /**
         * <p>
         * The status of the offer.
         * </p>
         * 
         * @param state
         *        The status of the offer.
         * @see OfferStateString
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OfferStateString
         */
        Builder state(OfferStateString state);

        /**
         * <p>
         * The targeting in the offer.
         * </p>
         * 
         * @param targeting
         *        The targeting in the offer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetingWithStrings(Collection<String> targeting);

        /**
         * <p>
         * The targeting in the offer.
         * </p>
         * 
         * @param targeting
         *        The targeting in the offer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetingWithStrings(String... targeting);

        /**
         * <p>
         * The targeting in the offer.
         * </p>
         * 
         * @param targeting
         *        The targeting in the offer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targeting(Collection<OfferTargetingString> targeting);

        /**
         * <p>
         * The targeting in the offer.
         * </p>
         * 
         * @param targeting
         *        The targeting in the offer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targeting(OfferTargetingString... targeting);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String productId;

        private String releaseDate;

        private String availabilityEndDate;

        private List<String> buyerAccounts = DefaultSdkAutoConstructList.getInstance();

        private String state;

        private List<String> targeting = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(OfferSummary model) {
            name(model.name);
            productId(model.productId);
            releaseDate(model.releaseDate);
            availabilityEndDate(model.availabilityEndDate);
            buyerAccounts(model.buyerAccounts);
            state(model.state);
            targetingWithStrings(model.targeting);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getProductId() {
            return productId;
        }

        public final void setProductId(String productId) {
            this.productId = productId;
        }

        @Override
        public final Builder productId(String productId) {
            this.productId = productId;
            return this;
        }

        public final String getReleaseDate() {
            return releaseDate;
        }

        public final void setReleaseDate(String releaseDate) {
            this.releaseDate = releaseDate;
        }

        @Override
        public final Builder releaseDate(String releaseDate) {
            this.releaseDate = releaseDate;
            return this;
        }

        public final String getAvailabilityEndDate() {
            return availabilityEndDate;
        }

        public final void setAvailabilityEndDate(String availabilityEndDate) {
            this.availabilityEndDate = availabilityEndDate;
        }

        @Override
        public final Builder availabilityEndDate(String availabilityEndDate) {
            this.availabilityEndDate = availabilityEndDate;
            return this;
        }

        public final Collection<String> getBuyerAccounts() {
            if (buyerAccounts instanceof SdkAutoConstructList) {
                return null;
            }
            return buyerAccounts;
        }

        public final void setBuyerAccounts(Collection<String> buyerAccounts) {
            this.buyerAccounts = OfferBuyerAccountsListCopier.copy(buyerAccounts);
        }

        @Override
        public final Builder buyerAccounts(Collection<String> buyerAccounts) {
            this.buyerAccounts = OfferBuyerAccountsListCopier.copy(buyerAccounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder buyerAccounts(String... buyerAccounts) {
            buyerAccounts(Arrays.asList(buyerAccounts));
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(OfferStateString state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final Collection<String> getTargeting() {
            if (targeting instanceof SdkAutoConstructList) {
                return null;
            }
            return targeting;
        }

        public final void setTargeting(Collection<String> targeting) {
            this.targeting = OfferTargetingListCopier.copy(targeting);
        }

        @Override
        public final Builder targetingWithStrings(Collection<String> targeting) {
            this.targeting = OfferTargetingListCopier.copy(targeting);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetingWithStrings(String... targeting) {
            targetingWithStrings(Arrays.asList(targeting));
            return this;
        }

        @Override
        public final Builder targeting(Collection<OfferTargetingString> targeting) {
            this.targeting = OfferTargetingListCopier.copyEnumToString(targeting);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targeting(OfferTargetingString... targeting) {
            targeting(Arrays.asList(targeting));
            return this;
        }

        @Override
        public OfferSummary build() {
            return new OfferSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
