/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.marketplacecatalog.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A filter for ResaleAuthorization entity.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResaleAuthorizationFilters implements SdkPojo, Serializable,
        ToCopyableBuilder<ResaleAuthorizationFilters.Builder, ResaleAuthorizationFilters> {
    private static final SdkField<ResaleAuthorizationEntityIdFilter> ENTITY_ID_FIELD = SdkField
            .<ResaleAuthorizationEntityIdFilter> builder(MarshallingType.SDK_POJO).memberName("EntityId")
            .getter(getter(ResaleAuthorizationFilters::entityId)).setter(setter(Builder::entityId))
            .constructor(ResaleAuthorizationEntityIdFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntityId").build()).build();

    private static final SdkField<ResaleAuthorizationNameFilter> NAME_FIELD = SdkField
            .<ResaleAuthorizationNameFilter> builder(MarshallingType.SDK_POJO).memberName("Name")
            .getter(getter(ResaleAuthorizationFilters::name)).setter(setter(Builder::name))
            .constructor(ResaleAuthorizationNameFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<ResaleAuthorizationProductIdFilter> PRODUCT_ID_FIELD = SdkField
            .<ResaleAuthorizationProductIdFilter> builder(MarshallingType.SDK_POJO).memberName("ProductId")
            .getter(getter(ResaleAuthorizationFilters::productId)).setter(setter(Builder::productId))
            .constructor(ResaleAuthorizationProductIdFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductId").build()).build();

    private static final SdkField<ResaleAuthorizationCreatedDateFilter> CREATED_DATE_FIELD = SdkField
            .<ResaleAuthorizationCreatedDateFilter> builder(MarshallingType.SDK_POJO).memberName("CreatedDate")
            .getter(getter(ResaleAuthorizationFilters::createdDate)).setter(setter(Builder::createdDate))
            .constructor(ResaleAuthorizationCreatedDateFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedDate").build()).build();

    private static final SdkField<ResaleAuthorizationAvailabilityEndDateFilter> AVAILABILITY_END_DATE_FIELD = SdkField
            .<ResaleAuthorizationAvailabilityEndDateFilter> builder(MarshallingType.SDK_POJO).memberName("AvailabilityEndDate")
            .getter(getter(ResaleAuthorizationFilters::availabilityEndDate)).setter(setter(Builder::availabilityEndDate))
            .constructor(ResaleAuthorizationAvailabilityEndDateFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityEndDate").build())
            .build();

    private static final SdkField<ResaleAuthorizationManufacturerAccountIdFilter> MANUFACTURER_ACCOUNT_ID_FIELD = SdkField
            .<ResaleAuthorizationManufacturerAccountIdFilter> builder(MarshallingType.SDK_POJO)
            .memberName("ManufacturerAccountId").getter(getter(ResaleAuthorizationFilters::manufacturerAccountId))
            .setter(setter(Builder::manufacturerAccountId)).constructor(ResaleAuthorizationManufacturerAccountIdFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManufacturerAccountId").build())
            .build();

    private static final SdkField<ResaleAuthorizationProductNameFilter> PRODUCT_NAME_FIELD = SdkField
            .<ResaleAuthorizationProductNameFilter> builder(MarshallingType.SDK_POJO).memberName("ProductName")
            .getter(getter(ResaleAuthorizationFilters::productName)).setter(setter(Builder::productName))
            .constructor(ResaleAuthorizationProductNameFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductName").build()).build();

    private static final SdkField<ResaleAuthorizationManufacturerLegalNameFilter> MANUFACTURER_LEGAL_NAME_FIELD = SdkField
            .<ResaleAuthorizationManufacturerLegalNameFilter> builder(MarshallingType.SDK_POJO)
            .memberName("ManufacturerLegalName").getter(getter(ResaleAuthorizationFilters::manufacturerLegalName))
            .setter(setter(Builder::manufacturerLegalName)).constructor(ResaleAuthorizationManufacturerLegalNameFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManufacturerLegalName").build())
            .build();

    private static final SdkField<ResaleAuthorizationResellerAccountIDFilter> RESELLER_ACCOUNT_ID_FIELD = SdkField
            .<ResaleAuthorizationResellerAccountIDFilter> builder(MarshallingType.SDK_POJO).memberName("ResellerAccountID")
            .getter(getter(ResaleAuthorizationFilters::resellerAccountID)).setter(setter(Builder::resellerAccountID))
            .constructor(ResaleAuthorizationResellerAccountIDFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResellerAccountID").build()).build();

    private static final SdkField<ResaleAuthorizationResellerLegalNameFilter> RESELLER_LEGAL_NAME_FIELD = SdkField
            .<ResaleAuthorizationResellerLegalNameFilter> builder(MarshallingType.SDK_POJO).memberName("ResellerLegalName")
            .getter(getter(ResaleAuthorizationFilters::resellerLegalName)).setter(setter(Builder::resellerLegalName))
            .constructor(ResaleAuthorizationResellerLegalNameFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResellerLegalName").build()).build();

    private static final SdkField<ResaleAuthorizationStatusFilter> STATUS_FIELD = SdkField
            .<ResaleAuthorizationStatusFilter> builder(MarshallingType.SDK_POJO).memberName("Status")
            .getter(getter(ResaleAuthorizationFilters::status)).setter(setter(Builder::status))
            .constructor(ResaleAuthorizationStatusFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<ResaleAuthorizationOfferExtendedStatusFilter> OFFER_EXTENDED_STATUS_FIELD = SdkField
            .<ResaleAuthorizationOfferExtendedStatusFilter> builder(MarshallingType.SDK_POJO).memberName("OfferExtendedStatus")
            .getter(getter(ResaleAuthorizationFilters::offerExtendedStatus)).setter(setter(Builder::offerExtendedStatus))
            .constructor(ResaleAuthorizationOfferExtendedStatusFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OfferExtendedStatus").build())
            .build();

    private static final SdkField<ResaleAuthorizationLastModifiedDateFilter> LAST_MODIFIED_DATE_FIELD = SdkField
            .<ResaleAuthorizationLastModifiedDateFilter> builder(MarshallingType.SDK_POJO).memberName("LastModifiedDate")
            .getter(getter(ResaleAuthorizationFilters::lastModifiedDate)).setter(setter(Builder::lastModifiedDate))
            .constructor(ResaleAuthorizationLastModifiedDateFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedDate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTITY_ID_FIELD, NAME_FIELD,
            PRODUCT_ID_FIELD, CREATED_DATE_FIELD, AVAILABILITY_END_DATE_FIELD, MANUFACTURER_ACCOUNT_ID_FIELD, PRODUCT_NAME_FIELD,
            MANUFACTURER_LEGAL_NAME_FIELD, RESELLER_ACCOUNT_ID_FIELD, RESELLER_LEGAL_NAME_FIELD, STATUS_FIELD,
            OFFER_EXTENDED_STATUS_FIELD, LAST_MODIFIED_DATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final ResaleAuthorizationEntityIdFilter entityId;

    private final ResaleAuthorizationNameFilter name;

    private final ResaleAuthorizationProductIdFilter productId;

    private final ResaleAuthorizationCreatedDateFilter createdDate;

    private final ResaleAuthorizationAvailabilityEndDateFilter availabilityEndDate;

    private final ResaleAuthorizationManufacturerAccountIdFilter manufacturerAccountId;

    private final ResaleAuthorizationProductNameFilter productName;

    private final ResaleAuthorizationManufacturerLegalNameFilter manufacturerLegalName;

    private final ResaleAuthorizationResellerAccountIDFilter resellerAccountID;

    private final ResaleAuthorizationResellerLegalNameFilter resellerLegalName;

    private final ResaleAuthorizationStatusFilter status;

    private final ResaleAuthorizationOfferExtendedStatusFilter offerExtendedStatus;

    private final ResaleAuthorizationLastModifiedDateFilter lastModifiedDate;

    private ResaleAuthorizationFilters(BuilderImpl builder) {
        this.entityId = builder.entityId;
        this.name = builder.name;
        this.productId = builder.productId;
        this.createdDate = builder.createdDate;
        this.availabilityEndDate = builder.availabilityEndDate;
        this.manufacturerAccountId = builder.manufacturerAccountId;
        this.productName = builder.productName;
        this.manufacturerLegalName = builder.manufacturerLegalName;
        this.resellerAccountID = builder.resellerAccountID;
        this.resellerLegalName = builder.resellerLegalName;
        this.status = builder.status;
        this.offerExtendedStatus = builder.offerExtendedStatus;
        this.lastModifiedDate = builder.lastModifiedDate;
    }

    /**
     * <p>
     * Allows filtering on the <code>EntityId</code> of a ResaleAuthorization.
     * </p>
     * 
     * @return Allows filtering on the <code>EntityId</code> of a ResaleAuthorization.
     */
    public final ResaleAuthorizationEntityIdFilter entityId() {
        return entityId;
    }

    /**
     * <p>
     * Allows filtering on the <code>Name</code> of a ResaleAuthorization.
     * </p>
     * 
     * @return Allows filtering on the <code>Name</code> of a ResaleAuthorization.
     */
    public final ResaleAuthorizationNameFilter name() {
        return name;
    }

    /**
     * <p>
     * Allows filtering on the <code>ProductId</code> of a ResaleAuthorization.
     * </p>
     * 
     * @return Allows filtering on the <code>ProductId</code> of a ResaleAuthorization.
     */
    public final ResaleAuthorizationProductIdFilter productId() {
        return productId;
    }

    /**
     * <p>
     * Allows filtering on the <code>CreatedDate</code> of a ResaleAuthorization.
     * </p>
     * 
     * @return Allows filtering on the <code>CreatedDate</code> of a ResaleAuthorization.
     */
    public final ResaleAuthorizationCreatedDateFilter createdDate() {
        return createdDate;
    }

    /**
     * <p>
     * Allows filtering on the <code>AvailabilityEndDate</code> of a ResaleAuthorization.
     * </p>
     * 
     * @return Allows filtering on the <code>AvailabilityEndDate</code> of a ResaleAuthorization.
     */
    public final ResaleAuthorizationAvailabilityEndDateFilter availabilityEndDate() {
        return availabilityEndDate;
    }

    /**
     * <p>
     * Allows filtering on the <code>ManufacturerAccountId</code> of a ResaleAuthorization.
     * </p>
     * 
     * @return Allows filtering on the <code>ManufacturerAccountId</code> of a ResaleAuthorization.
     */
    public final ResaleAuthorizationManufacturerAccountIdFilter manufacturerAccountId() {
        return manufacturerAccountId;
    }

    /**
     * <p>
     * Allows filtering on the <code>ProductName</code> of a ResaleAuthorization.
     * </p>
     * 
     * @return Allows filtering on the <code>ProductName</code> of a ResaleAuthorization.
     */
    public final ResaleAuthorizationProductNameFilter productName() {
        return productName;
    }

    /**
     * <p>
     * Allows filtering on the <code>ManufacturerLegalName</code> of a ResaleAuthorization.
     * </p>
     * 
     * @return Allows filtering on the <code>ManufacturerLegalName</code> of a ResaleAuthorization.
     */
    public final ResaleAuthorizationManufacturerLegalNameFilter manufacturerLegalName() {
        return manufacturerLegalName;
    }

    /**
     * <p>
     * Allows filtering on the <code>ResellerAccountID</code> of a ResaleAuthorization.
     * </p>
     * 
     * @return Allows filtering on the <code>ResellerAccountID</code> of a ResaleAuthorization.
     */
    public final ResaleAuthorizationResellerAccountIDFilter resellerAccountID() {
        return resellerAccountID;
    }

    /**
     * <p>
     * Allows filtering on the <code>ResellerLegalName</code> of a ResaleAuthorization.
     * </p>
     * 
     * @return Allows filtering on the <code>ResellerLegalName</code> of a ResaleAuthorization.
     */
    public final ResaleAuthorizationResellerLegalNameFilter resellerLegalName() {
        return resellerLegalName;
    }

    /**
     * <p>
     * Allows filtering on the <code>Status</code> of a ResaleAuthorization.
     * </p>
     * 
     * @return Allows filtering on the <code>Status</code> of a ResaleAuthorization.
     */
    public final ResaleAuthorizationStatusFilter status() {
        return status;
    }

    /**
     * <p>
     * Allows filtering on the <code>OfferExtendedStatus</code> of a ResaleAuthorization.
     * </p>
     * 
     * @return Allows filtering on the <code>OfferExtendedStatus</code> of a ResaleAuthorization.
     */
    public final ResaleAuthorizationOfferExtendedStatusFilter offerExtendedStatus() {
        return offerExtendedStatus;
    }

    /**
     * <p>
     * Allows filtering on the <code>LastModifiedDate</code> of a ResaleAuthorization.
     * </p>
     * 
     * @return Allows filtering on the <code>LastModifiedDate</code> of a ResaleAuthorization.
     */
    public final ResaleAuthorizationLastModifiedDateFilter lastModifiedDate() {
        return lastModifiedDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(entityId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(productId());
        hashCode = 31 * hashCode + Objects.hashCode(createdDate());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityEndDate());
        hashCode = 31 * hashCode + Objects.hashCode(manufacturerAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(productName());
        hashCode = 31 * hashCode + Objects.hashCode(manufacturerLegalName());
        hashCode = 31 * hashCode + Objects.hashCode(resellerAccountID());
        hashCode = 31 * hashCode + Objects.hashCode(resellerLegalName());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(offerExtendedStatus());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedDate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResaleAuthorizationFilters)) {
            return false;
        }
        ResaleAuthorizationFilters other = (ResaleAuthorizationFilters) obj;
        return Objects.equals(entityId(), other.entityId()) && Objects.equals(name(), other.name())
                && Objects.equals(productId(), other.productId()) && Objects.equals(createdDate(), other.createdDate())
                && Objects.equals(availabilityEndDate(), other.availabilityEndDate())
                && Objects.equals(manufacturerAccountId(), other.manufacturerAccountId())
                && Objects.equals(productName(), other.productName())
                && Objects.equals(manufacturerLegalName(), other.manufacturerLegalName())
                && Objects.equals(resellerAccountID(), other.resellerAccountID())
                && Objects.equals(resellerLegalName(), other.resellerLegalName()) && Objects.equals(status(), other.status())
                && Objects.equals(offerExtendedStatus(), other.offerExtendedStatus())
                && Objects.equals(lastModifiedDate(), other.lastModifiedDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResaleAuthorizationFilters").add("EntityId", entityId()).add("Name", name())
                .add("ProductId", productId()).add("CreatedDate", createdDate())
                .add("AvailabilityEndDate", availabilityEndDate()).add("ManufacturerAccountId", manufacturerAccountId())
                .add("ProductName", productName()).add("ManufacturerLegalName", manufacturerLegalName())
                .add("ResellerAccountID", resellerAccountID()).add("ResellerLegalName", resellerLegalName())
                .add("Status", status()).add("OfferExtendedStatus", offerExtendedStatus())
                .add("LastModifiedDate", lastModifiedDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EntityId":
            return Optional.ofNullable(clazz.cast(entityId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "ProductId":
            return Optional.ofNullable(clazz.cast(productId()));
        case "CreatedDate":
            return Optional.ofNullable(clazz.cast(createdDate()));
        case "AvailabilityEndDate":
            return Optional.ofNullable(clazz.cast(availabilityEndDate()));
        case "ManufacturerAccountId":
            return Optional.ofNullable(clazz.cast(manufacturerAccountId()));
        case "ProductName":
            return Optional.ofNullable(clazz.cast(productName()));
        case "ManufacturerLegalName":
            return Optional.ofNullable(clazz.cast(manufacturerLegalName()));
        case "ResellerAccountID":
            return Optional.ofNullable(clazz.cast(resellerAccountID()));
        case "ResellerLegalName":
            return Optional.ofNullable(clazz.cast(resellerLegalName()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "OfferExtendedStatus":
            return Optional.ofNullable(clazz.cast(offerExtendedStatus()));
        case "LastModifiedDate":
            return Optional.ofNullable(clazz.cast(lastModifiedDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResaleAuthorizationFilters, T> g) {
        return obj -> g.apply((ResaleAuthorizationFilters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResaleAuthorizationFilters> {
        /**
         * <p>
         * Allows filtering on the <code>EntityId</code> of a ResaleAuthorization.
         * </p>
         * 
         * @param entityId
         *        Allows filtering on the <code>EntityId</code> of a ResaleAuthorization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityId(ResaleAuthorizationEntityIdFilter entityId);

        /**
         * <p>
         * Allows filtering on the <code>EntityId</code> of a ResaleAuthorization.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ResaleAuthorizationEntityIdFilter.Builder} avoiding the need to create one manually via
         * {@link ResaleAuthorizationEntityIdFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResaleAuthorizationEntityIdFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #entityId(ResaleAuthorizationEntityIdFilter)}.
         * 
         * @param entityId
         *        a consumer that will call methods on {@link ResaleAuthorizationEntityIdFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #entityId(ResaleAuthorizationEntityIdFilter)
         */
        default Builder entityId(Consumer<ResaleAuthorizationEntityIdFilter.Builder> entityId) {
            return entityId(ResaleAuthorizationEntityIdFilter.builder().applyMutation(entityId).build());
        }

        /**
         * <p>
         * Allows filtering on the <code>Name</code> of a ResaleAuthorization.
         * </p>
         * 
         * @param name
         *        Allows filtering on the <code>Name</code> of a ResaleAuthorization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(ResaleAuthorizationNameFilter name);

        /**
         * <p>
         * Allows filtering on the <code>Name</code> of a ResaleAuthorization.
         * </p>
         * This is a convenience method that creates an instance of the {@link ResaleAuthorizationNameFilter.Builder}
         * avoiding the need to create one manually via {@link ResaleAuthorizationNameFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResaleAuthorizationNameFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #name(ResaleAuthorizationNameFilter)}.
         * 
         * @param name
         *        a consumer that will call methods on {@link ResaleAuthorizationNameFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #name(ResaleAuthorizationNameFilter)
         */
        default Builder name(Consumer<ResaleAuthorizationNameFilter.Builder> name) {
            return name(ResaleAuthorizationNameFilter.builder().applyMutation(name).build());
        }

        /**
         * <p>
         * Allows filtering on the <code>ProductId</code> of a ResaleAuthorization.
         * </p>
         * 
         * @param productId
         *        Allows filtering on the <code>ProductId</code> of a ResaleAuthorization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productId(ResaleAuthorizationProductIdFilter productId);

        /**
         * <p>
         * Allows filtering on the <code>ProductId</code> of a ResaleAuthorization.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ResaleAuthorizationProductIdFilter.Builder} avoiding the need to create one manually via
         * {@link ResaleAuthorizationProductIdFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResaleAuthorizationProductIdFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #productId(ResaleAuthorizationProductIdFilter)}.
         * 
         * @param productId
         *        a consumer that will call methods on {@link ResaleAuthorizationProductIdFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #productId(ResaleAuthorizationProductIdFilter)
         */
        default Builder productId(Consumer<ResaleAuthorizationProductIdFilter.Builder> productId) {
            return productId(ResaleAuthorizationProductIdFilter.builder().applyMutation(productId).build());
        }

        /**
         * <p>
         * Allows filtering on the <code>CreatedDate</code> of a ResaleAuthorization.
         * </p>
         * 
         * @param createdDate
         *        Allows filtering on the <code>CreatedDate</code> of a ResaleAuthorization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdDate(ResaleAuthorizationCreatedDateFilter createdDate);

        /**
         * <p>
         * Allows filtering on the <code>CreatedDate</code> of a ResaleAuthorization.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ResaleAuthorizationCreatedDateFilter.Builder} avoiding the need to create one manually via
         * {@link ResaleAuthorizationCreatedDateFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResaleAuthorizationCreatedDateFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #createdDate(ResaleAuthorizationCreatedDateFilter)}.
         * 
         * @param createdDate
         *        a consumer that will call methods on {@link ResaleAuthorizationCreatedDateFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #createdDate(ResaleAuthorizationCreatedDateFilter)
         */
        default Builder createdDate(Consumer<ResaleAuthorizationCreatedDateFilter.Builder> createdDate) {
            return createdDate(ResaleAuthorizationCreatedDateFilter.builder().applyMutation(createdDate).build());
        }

        /**
         * <p>
         * Allows filtering on the <code>AvailabilityEndDate</code> of a ResaleAuthorization.
         * </p>
         * 
         * @param availabilityEndDate
         *        Allows filtering on the <code>AvailabilityEndDate</code> of a ResaleAuthorization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityEndDate(ResaleAuthorizationAvailabilityEndDateFilter availabilityEndDate);

        /**
         * <p>
         * Allows filtering on the <code>AvailabilityEndDate</code> of a ResaleAuthorization.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ResaleAuthorizationAvailabilityEndDateFilter.Builder} avoiding the need to create one manually via
         * {@link ResaleAuthorizationAvailabilityEndDateFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResaleAuthorizationAvailabilityEndDateFilter.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #availabilityEndDate(ResaleAuthorizationAvailabilityEndDateFilter)}.
         * 
         * @param availabilityEndDate
         *        a consumer that will call methods on {@link ResaleAuthorizationAvailabilityEndDateFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #availabilityEndDate(ResaleAuthorizationAvailabilityEndDateFilter)
         */
        default Builder availabilityEndDate(Consumer<ResaleAuthorizationAvailabilityEndDateFilter.Builder> availabilityEndDate) {
            return availabilityEndDate(ResaleAuthorizationAvailabilityEndDateFilter.builder().applyMutation(availabilityEndDate)
                    .build());
        }

        /**
         * <p>
         * Allows filtering on the <code>ManufacturerAccountId</code> of a ResaleAuthorization.
         * </p>
         * 
         * @param manufacturerAccountId
         *        Allows filtering on the <code>ManufacturerAccountId</code> of a ResaleAuthorization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder manufacturerAccountId(ResaleAuthorizationManufacturerAccountIdFilter manufacturerAccountId);

        /**
         * <p>
         * Allows filtering on the <code>ManufacturerAccountId</code> of a ResaleAuthorization.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ResaleAuthorizationManufacturerAccountIdFilter.Builder} avoiding the need to create one manually via
         * {@link ResaleAuthorizationManufacturerAccountIdFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResaleAuthorizationManufacturerAccountIdFilter.Builder#build()}
         * is called immediately and its result is passed to
         * {@link #manufacturerAccountId(ResaleAuthorizationManufacturerAccountIdFilter)}.
         * 
         * @param manufacturerAccountId
         *        a consumer that will call methods on {@link ResaleAuthorizationManufacturerAccountIdFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #manufacturerAccountId(ResaleAuthorizationManufacturerAccountIdFilter)
         */
        default Builder manufacturerAccountId(
                Consumer<ResaleAuthorizationManufacturerAccountIdFilter.Builder> manufacturerAccountId) {
            return manufacturerAccountId(ResaleAuthorizationManufacturerAccountIdFilter.builder()
                    .applyMutation(manufacturerAccountId).build());
        }

        /**
         * <p>
         * Allows filtering on the <code>ProductName</code> of a ResaleAuthorization.
         * </p>
         * 
         * @param productName
         *        Allows filtering on the <code>ProductName</code> of a ResaleAuthorization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productName(ResaleAuthorizationProductNameFilter productName);

        /**
         * <p>
         * Allows filtering on the <code>ProductName</code> of a ResaleAuthorization.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ResaleAuthorizationProductNameFilter.Builder} avoiding the need to create one manually via
         * {@link ResaleAuthorizationProductNameFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResaleAuthorizationProductNameFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #productName(ResaleAuthorizationProductNameFilter)}.
         * 
         * @param productName
         *        a consumer that will call methods on {@link ResaleAuthorizationProductNameFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #productName(ResaleAuthorizationProductNameFilter)
         */
        default Builder productName(Consumer<ResaleAuthorizationProductNameFilter.Builder> productName) {
            return productName(ResaleAuthorizationProductNameFilter.builder().applyMutation(productName).build());
        }

        /**
         * <p>
         * Allows filtering on the <code>ManufacturerLegalName</code> of a ResaleAuthorization.
         * </p>
         * 
         * @param manufacturerLegalName
         *        Allows filtering on the <code>ManufacturerLegalName</code> of a ResaleAuthorization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder manufacturerLegalName(ResaleAuthorizationManufacturerLegalNameFilter manufacturerLegalName);

        /**
         * <p>
         * Allows filtering on the <code>ManufacturerLegalName</code> of a ResaleAuthorization.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ResaleAuthorizationManufacturerLegalNameFilter.Builder} avoiding the need to create one manually via
         * {@link ResaleAuthorizationManufacturerLegalNameFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResaleAuthorizationManufacturerLegalNameFilter.Builder#build()}
         * is called immediately and its result is passed to
         * {@link #manufacturerLegalName(ResaleAuthorizationManufacturerLegalNameFilter)}.
         * 
         * @param manufacturerLegalName
         *        a consumer that will call methods on {@link ResaleAuthorizationManufacturerLegalNameFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #manufacturerLegalName(ResaleAuthorizationManufacturerLegalNameFilter)
         */
        default Builder manufacturerLegalName(
                Consumer<ResaleAuthorizationManufacturerLegalNameFilter.Builder> manufacturerLegalName) {
            return manufacturerLegalName(ResaleAuthorizationManufacturerLegalNameFilter.builder()
                    .applyMutation(manufacturerLegalName).build());
        }

        /**
         * <p>
         * Allows filtering on the <code>ResellerAccountID</code> of a ResaleAuthorization.
         * </p>
         * 
         * @param resellerAccountID
         *        Allows filtering on the <code>ResellerAccountID</code> of a ResaleAuthorization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resellerAccountID(ResaleAuthorizationResellerAccountIDFilter resellerAccountID);

        /**
         * <p>
         * Allows filtering on the <code>ResellerAccountID</code> of a ResaleAuthorization.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ResaleAuthorizationResellerAccountIDFilter.Builder} avoiding the need to create one manually via
         * {@link ResaleAuthorizationResellerAccountIDFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResaleAuthorizationResellerAccountIDFilter.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #resellerAccountID(ResaleAuthorizationResellerAccountIDFilter)}.
         * 
         * @param resellerAccountID
         *        a consumer that will call methods on {@link ResaleAuthorizationResellerAccountIDFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resellerAccountID(ResaleAuthorizationResellerAccountIDFilter)
         */
        default Builder resellerAccountID(Consumer<ResaleAuthorizationResellerAccountIDFilter.Builder> resellerAccountID) {
            return resellerAccountID(ResaleAuthorizationResellerAccountIDFilter.builder().applyMutation(resellerAccountID)
                    .build());
        }

        /**
         * <p>
         * Allows filtering on the <code>ResellerLegalName</code> of a ResaleAuthorization.
         * </p>
         * 
         * @param resellerLegalName
         *        Allows filtering on the <code>ResellerLegalName</code> of a ResaleAuthorization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resellerLegalName(ResaleAuthorizationResellerLegalNameFilter resellerLegalName);

        /**
         * <p>
         * Allows filtering on the <code>ResellerLegalName</code> of a ResaleAuthorization.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ResaleAuthorizationResellerLegalNameFilter.Builder} avoiding the need to create one manually via
         * {@link ResaleAuthorizationResellerLegalNameFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResaleAuthorizationResellerLegalNameFilter.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #resellerLegalName(ResaleAuthorizationResellerLegalNameFilter)}.
         * 
         * @param resellerLegalName
         *        a consumer that will call methods on {@link ResaleAuthorizationResellerLegalNameFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resellerLegalName(ResaleAuthorizationResellerLegalNameFilter)
         */
        default Builder resellerLegalName(Consumer<ResaleAuthorizationResellerLegalNameFilter.Builder> resellerLegalName) {
            return resellerLegalName(ResaleAuthorizationResellerLegalNameFilter.builder().applyMutation(resellerLegalName)
                    .build());
        }

        /**
         * <p>
         * Allows filtering on the <code>Status</code> of a ResaleAuthorization.
         * </p>
         * 
         * @param status
         *        Allows filtering on the <code>Status</code> of a ResaleAuthorization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(ResaleAuthorizationStatusFilter status);

        /**
         * <p>
         * Allows filtering on the <code>Status</code> of a ResaleAuthorization.
         * </p>
         * This is a convenience method that creates an instance of the {@link ResaleAuthorizationStatusFilter.Builder}
         * avoiding the need to create one manually via {@link ResaleAuthorizationStatusFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResaleAuthorizationStatusFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #status(ResaleAuthorizationStatusFilter)}.
         * 
         * @param status
         *        a consumer that will call methods on {@link ResaleAuthorizationStatusFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #status(ResaleAuthorizationStatusFilter)
         */
        default Builder status(Consumer<ResaleAuthorizationStatusFilter.Builder> status) {
            return status(ResaleAuthorizationStatusFilter.builder().applyMutation(status).build());
        }

        /**
         * <p>
         * Allows filtering on the <code>OfferExtendedStatus</code> of a ResaleAuthorization.
         * </p>
         * 
         * @param offerExtendedStatus
         *        Allows filtering on the <code>OfferExtendedStatus</code> of a ResaleAuthorization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder offerExtendedStatus(ResaleAuthorizationOfferExtendedStatusFilter offerExtendedStatus);

        /**
         * <p>
         * Allows filtering on the <code>OfferExtendedStatus</code> of a ResaleAuthorization.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ResaleAuthorizationOfferExtendedStatusFilter.Builder} avoiding the need to create one manually via
         * {@link ResaleAuthorizationOfferExtendedStatusFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResaleAuthorizationOfferExtendedStatusFilter.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #offerExtendedStatus(ResaleAuthorizationOfferExtendedStatusFilter)}.
         * 
         * @param offerExtendedStatus
         *        a consumer that will call methods on {@link ResaleAuthorizationOfferExtendedStatusFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #offerExtendedStatus(ResaleAuthorizationOfferExtendedStatusFilter)
         */
        default Builder offerExtendedStatus(Consumer<ResaleAuthorizationOfferExtendedStatusFilter.Builder> offerExtendedStatus) {
            return offerExtendedStatus(ResaleAuthorizationOfferExtendedStatusFilter.builder().applyMutation(offerExtendedStatus)
                    .build());
        }

        /**
         * <p>
         * Allows filtering on the <code>LastModifiedDate</code> of a ResaleAuthorization.
         * </p>
         * 
         * @param lastModifiedDate
         *        Allows filtering on the <code>LastModifiedDate</code> of a ResaleAuthorization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedDate(ResaleAuthorizationLastModifiedDateFilter lastModifiedDate);

        /**
         * <p>
         * Allows filtering on the <code>LastModifiedDate</code> of a ResaleAuthorization.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ResaleAuthorizationLastModifiedDateFilter.Builder} avoiding the need to create one manually via
         * {@link ResaleAuthorizationLastModifiedDateFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResaleAuthorizationLastModifiedDateFilter.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #lastModifiedDate(ResaleAuthorizationLastModifiedDateFilter)}.
         * 
         * @param lastModifiedDate
         *        a consumer that will call methods on {@link ResaleAuthorizationLastModifiedDateFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lastModifiedDate(ResaleAuthorizationLastModifiedDateFilter)
         */
        default Builder lastModifiedDate(Consumer<ResaleAuthorizationLastModifiedDateFilter.Builder> lastModifiedDate) {
            return lastModifiedDate(ResaleAuthorizationLastModifiedDateFilter.builder().applyMutation(lastModifiedDate).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ResaleAuthorizationEntityIdFilter entityId;

        private ResaleAuthorizationNameFilter name;

        private ResaleAuthorizationProductIdFilter productId;

        private ResaleAuthorizationCreatedDateFilter createdDate;

        private ResaleAuthorizationAvailabilityEndDateFilter availabilityEndDate;

        private ResaleAuthorizationManufacturerAccountIdFilter manufacturerAccountId;

        private ResaleAuthorizationProductNameFilter productName;

        private ResaleAuthorizationManufacturerLegalNameFilter manufacturerLegalName;

        private ResaleAuthorizationResellerAccountIDFilter resellerAccountID;

        private ResaleAuthorizationResellerLegalNameFilter resellerLegalName;

        private ResaleAuthorizationStatusFilter status;

        private ResaleAuthorizationOfferExtendedStatusFilter offerExtendedStatus;

        private ResaleAuthorizationLastModifiedDateFilter lastModifiedDate;

        private BuilderImpl() {
        }

        private BuilderImpl(ResaleAuthorizationFilters model) {
            entityId(model.entityId);
            name(model.name);
            productId(model.productId);
            createdDate(model.createdDate);
            availabilityEndDate(model.availabilityEndDate);
            manufacturerAccountId(model.manufacturerAccountId);
            productName(model.productName);
            manufacturerLegalName(model.manufacturerLegalName);
            resellerAccountID(model.resellerAccountID);
            resellerLegalName(model.resellerLegalName);
            status(model.status);
            offerExtendedStatus(model.offerExtendedStatus);
            lastModifiedDate(model.lastModifiedDate);
        }

        public final ResaleAuthorizationEntityIdFilter.Builder getEntityId() {
            return entityId != null ? entityId.toBuilder() : null;
        }

        public final void setEntityId(ResaleAuthorizationEntityIdFilter.BuilderImpl entityId) {
            this.entityId = entityId != null ? entityId.build() : null;
        }

        @Override
        public final Builder entityId(ResaleAuthorizationEntityIdFilter entityId) {
            this.entityId = entityId;
            return this;
        }

        public final ResaleAuthorizationNameFilter.Builder getName() {
            return name != null ? name.toBuilder() : null;
        }

        public final void setName(ResaleAuthorizationNameFilter.BuilderImpl name) {
            this.name = name != null ? name.build() : null;
        }

        @Override
        public final Builder name(ResaleAuthorizationNameFilter name) {
            this.name = name;
            return this;
        }

        public final ResaleAuthorizationProductIdFilter.Builder getProductId() {
            return productId != null ? productId.toBuilder() : null;
        }

        public final void setProductId(ResaleAuthorizationProductIdFilter.BuilderImpl productId) {
            this.productId = productId != null ? productId.build() : null;
        }

        @Override
        public final Builder productId(ResaleAuthorizationProductIdFilter productId) {
            this.productId = productId;
            return this;
        }

        public final ResaleAuthorizationCreatedDateFilter.Builder getCreatedDate() {
            return createdDate != null ? createdDate.toBuilder() : null;
        }

        public final void setCreatedDate(ResaleAuthorizationCreatedDateFilter.BuilderImpl createdDate) {
            this.createdDate = createdDate != null ? createdDate.build() : null;
        }

        @Override
        public final Builder createdDate(ResaleAuthorizationCreatedDateFilter createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final ResaleAuthorizationAvailabilityEndDateFilter.Builder getAvailabilityEndDate() {
            return availabilityEndDate != null ? availabilityEndDate.toBuilder() : null;
        }

        public final void setAvailabilityEndDate(ResaleAuthorizationAvailabilityEndDateFilter.BuilderImpl availabilityEndDate) {
            this.availabilityEndDate = availabilityEndDate != null ? availabilityEndDate.build() : null;
        }

        @Override
        public final Builder availabilityEndDate(ResaleAuthorizationAvailabilityEndDateFilter availabilityEndDate) {
            this.availabilityEndDate = availabilityEndDate;
            return this;
        }

        public final ResaleAuthorizationManufacturerAccountIdFilter.Builder getManufacturerAccountId() {
            return manufacturerAccountId != null ? manufacturerAccountId.toBuilder() : null;
        }

        public final void setManufacturerAccountId(
                ResaleAuthorizationManufacturerAccountIdFilter.BuilderImpl manufacturerAccountId) {
            this.manufacturerAccountId = manufacturerAccountId != null ? manufacturerAccountId.build() : null;
        }

        @Override
        public final Builder manufacturerAccountId(ResaleAuthorizationManufacturerAccountIdFilter manufacturerAccountId) {
            this.manufacturerAccountId = manufacturerAccountId;
            return this;
        }

        public final ResaleAuthorizationProductNameFilter.Builder getProductName() {
            return productName != null ? productName.toBuilder() : null;
        }

        public final void setProductName(ResaleAuthorizationProductNameFilter.BuilderImpl productName) {
            this.productName = productName != null ? productName.build() : null;
        }

        @Override
        public final Builder productName(ResaleAuthorizationProductNameFilter productName) {
            this.productName = productName;
            return this;
        }

        public final ResaleAuthorizationManufacturerLegalNameFilter.Builder getManufacturerLegalName() {
            return manufacturerLegalName != null ? manufacturerLegalName.toBuilder() : null;
        }

        public final void setManufacturerLegalName(
                ResaleAuthorizationManufacturerLegalNameFilter.BuilderImpl manufacturerLegalName) {
            this.manufacturerLegalName = manufacturerLegalName != null ? manufacturerLegalName.build() : null;
        }

        @Override
        public final Builder manufacturerLegalName(ResaleAuthorizationManufacturerLegalNameFilter manufacturerLegalName) {
            this.manufacturerLegalName = manufacturerLegalName;
            return this;
        }

        public final ResaleAuthorizationResellerAccountIDFilter.Builder getResellerAccountID() {
            return resellerAccountID != null ? resellerAccountID.toBuilder() : null;
        }

        public final void setResellerAccountID(ResaleAuthorizationResellerAccountIDFilter.BuilderImpl resellerAccountID) {
            this.resellerAccountID = resellerAccountID != null ? resellerAccountID.build() : null;
        }

        @Override
        public final Builder resellerAccountID(ResaleAuthorizationResellerAccountIDFilter resellerAccountID) {
            this.resellerAccountID = resellerAccountID;
            return this;
        }

        public final ResaleAuthorizationResellerLegalNameFilter.Builder getResellerLegalName() {
            return resellerLegalName != null ? resellerLegalName.toBuilder() : null;
        }

        public final void setResellerLegalName(ResaleAuthorizationResellerLegalNameFilter.BuilderImpl resellerLegalName) {
            this.resellerLegalName = resellerLegalName != null ? resellerLegalName.build() : null;
        }

        @Override
        public final Builder resellerLegalName(ResaleAuthorizationResellerLegalNameFilter resellerLegalName) {
            this.resellerLegalName = resellerLegalName;
            return this;
        }

        public final ResaleAuthorizationStatusFilter.Builder getStatus() {
            return status != null ? status.toBuilder() : null;
        }

        public final void setStatus(ResaleAuthorizationStatusFilter.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        public final Builder status(ResaleAuthorizationStatusFilter status) {
            this.status = status;
            return this;
        }

        public final ResaleAuthorizationOfferExtendedStatusFilter.Builder getOfferExtendedStatus() {
            return offerExtendedStatus != null ? offerExtendedStatus.toBuilder() : null;
        }

        public final void setOfferExtendedStatus(ResaleAuthorizationOfferExtendedStatusFilter.BuilderImpl offerExtendedStatus) {
            this.offerExtendedStatus = offerExtendedStatus != null ? offerExtendedStatus.build() : null;
        }

        @Override
        public final Builder offerExtendedStatus(ResaleAuthorizationOfferExtendedStatusFilter offerExtendedStatus) {
            this.offerExtendedStatus = offerExtendedStatus;
            return this;
        }

        public final ResaleAuthorizationLastModifiedDateFilter.Builder getLastModifiedDate() {
            return lastModifiedDate != null ? lastModifiedDate.toBuilder() : null;
        }

        public final void setLastModifiedDate(ResaleAuthorizationLastModifiedDateFilter.BuilderImpl lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate != null ? lastModifiedDate.build() : null;
        }

        @Override
        public final Builder lastModifiedDate(ResaleAuthorizationLastModifiedDateFilter lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        @Override
        public ResaleAuthorizationFilters build() {
            return new ResaleAuthorizationFilters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
