/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.marketplacecatalog.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartChangeSetRequest extends MarketplaceCatalogRequest implements
        ToCopyableBuilder<StartChangeSetRequest.Builder, StartChangeSetRequest> {
    private static final SdkField<String> CATALOG_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Catalog")
            .getter(getter(StartChangeSetRequest::catalog)).setter(setter(Builder::catalog))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Catalog").build()).build();

    private static final SdkField<List<Change>> CHANGE_SET_FIELD = SdkField
            .<List<Change>> builder(MarshallingType.LIST)
            .memberName("ChangeSet")
            .getter(getter(StartChangeSetRequest::changeSet))
            .setter(setter(Builder::changeSet))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChangeSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Change> builder(MarshallingType.SDK_POJO)
                                            .constructor(Change::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CHANGE_SET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChangeSetName").getter(getter(StartChangeSetRequest::changeSetName))
            .setter(setter(Builder::changeSetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChangeSetName").build()).build();

    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientRequestToken")
            .getter(getter(StartChangeSetRequest::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<List<Tag>> CHANGE_SET_TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("ChangeSetTags")
            .getter(getter(StartChangeSetRequest::changeSetTags))
            .setter(setter(Builder::changeSetTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChangeSetTags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_FIELD,
            CHANGE_SET_FIELD, CHANGE_SET_NAME_FIELD, CLIENT_REQUEST_TOKEN_FIELD, CHANGE_SET_TAGS_FIELD));

    private final String catalog;

    private final List<Change> changeSet;

    private final String changeSetName;

    private final String clientRequestToken;

    private final List<Tag> changeSetTags;

    private StartChangeSetRequest(BuilderImpl builder) {
        super(builder);
        this.catalog = builder.catalog;
        this.changeSet = builder.changeSet;
        this.changeSetName = builder.changeSetName;
        this.clientRequestToken = builder.clientRequestToken;
        this.changeSetTags = builder.changeSetTags;
    }

    /**
     * <p>
     * The catalog related to the request. Fixed value: <code>AWSMarketplace</code>
     * </p>
     * 
     * @return The catalog related to the request. Fixed value: <code>AWSMarketplace</code>
     */
    public final String catalog() {
        return catalog;
    }

    /**
     * For responses, this returns true if the service returned a value for the ChangeSet property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasChangeSet() {
        return changeSet != null && !(changeSet instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Array of <code>change</code> object.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasChangeSet} method.
     * </p>
     * 
     * @return Array of <code>change</code> object.
     */
    public final List<Change> changeSet() {
        return changeSet;
    }

    /**
     * <p>
     * Optional case sensitive string of up to 100 ASCII characters. The change set name can be used to filter the list
     * of change sets.
     * </p>
     * 
     * @return Optional case sensitive string of up to 100 ASCII characters. The change set name can be used to filter
     *         the list of change sets.
     */
    public final String changeSetName() {
        return changeSetName;
    }

    /**
     * <p>
     * A unique token to identify the request to ensure idempotency.
     * </p>
     * 
     * @return A unique token to identify the request to ensure idempotency.
     */
    public final String clientRequestToken() {
        return clientRequestToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ChangeSetTags property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasChangeSetTags() {
        return changeSetTags != null && !(changeSetTags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of objects specifying each key name and value for the <code>ChangeSetTags</code> property.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasChangeSetTags} method.
     * </p>
     * 
     * @return A list of objects specifying each key name and value for the <code>ChangeSetTags</code> property.
     */
    public final List<Tag> changeSetTags() {
        return changeSetTags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(catalog());
        hashCode = 31 * hashCode + Objects.hashCode(hasChangeSet() ? changeSet() : null);
        hashCode = 31 * hashCode + Objects.hashCode(changeSetName());
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasChangeSetTags() ? changeSetTags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartChangeSetRequest)) {
            return false;
        }
        StartChangeSetRequest other = (StartChangeSetRequest) obj;
        return Objects.equals(catalog(), other.catalog()) && hasChangeSet() == other.hasChangeSet()
                && Objects.equals(changeSet(), other.changeSet()) && Objects.equals(changeSetName(), other.changeSetName())
                && Objects.equals(clientRequestToken(), other.clientRequestToken())
                && hasChangeSetTags() == other.hasChangeSetTags() && Objects.equals(changeSetTags(), other.changeSetTags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartChangeSetRequest").add("Catalog", catalog())
                .add("ChangeSet", hasChangeSet() ? changeSet() : null).add("ChangeSetName", changeSetName())
                .add("ClientRequestToken", clientRequestToken())
                .add("ChangeSetTags", hasChangeSetTags() ? changeSetTags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Catalog":
            return Optional.ofNullable(clazz.cast(catalog()));
        case "ChangeSet":
            return Optional.ofNullable(clazz.cast(changeSet()));
        case "ChangeSetName":
            return Optional.ofNullable(clazz.cast(changeSetName()));
        case "ClientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        case "ChangeSetTags":
            return Optional.ofNullable(clazz.cast(changeSetTags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartChangeSetRequest, T> g) {
        return obj -> g.apply((StartChangeSetRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MarketplaceCatalogRequest.Builder, SdkPojo, CopyableBuilder<Builder, StartChangeSetRequest> {
        /**
         * <p>
         * The catalog related to the request. Fixed value: <code>AWSMarketplace</code>
         * </p>
         * 
         * @param catalog
         *        The catalog related to the request. Fixed value: <code>AWSMarketplace</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder catalog(String catalog);

        /**
         * <p>
         * Array of <code>change</code> object.
         * </p>
         * 
         * @param changeSet
         *        Array of <code>change</code> object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder changeSet(Collection<Change> changeSet);

        /**
         * <p>
         * Array of <code>change</code> object.
         * </p>
         * 
         * @param changeSet
         *        Array of <code>change</code> object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder changeSet(Change... changeSet);

        /**
         * <p>
         * Array of <code>change</code> object.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.marketplacecatalog.model.Change.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.marketplacecatalog.model.Change#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.marketplacecatalog.model.Change.Builder#build()} is called immediately
         * and its result is passed to {@link #changeSet(List<Change>)}.
         * 
         * @param changeSet
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.marketplacecatalog.model.Change.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #changeSet(java.util.Collection<Change>)
         */
        Builder changeSet(Consumer<Change.Builder>... changeSet);

        /**
         * <p>
         * Optional case sensitive string of up to 100 ASCII characters. The change set name can be used to filter the
         * list of change sets.
         * </p>
         * 
         * @param changeSetName
         *        Optional case sensitive string of up to 100 ASCII characters. The change set name can be used to
         *        filter the list of change sets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder changeSetName(String changeSetName);

        /**
         * <p>
         * A unique token to identify the request to ensure idempotency.
         * </p>
         * 
         * @param clientRequestToken
         *        A unique token to identify the request to ensure idempotency.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        /**
         * <p>
         * A list of objects specifying each key name and value for the <code>ChangeSetTags</code> property.
         * </p>
         * 
         * @param changeSetTags
         *        A list of objects specifying each key name and value for the <code>ChangeSetTags</code> property.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder changeSetTags(Collection<Tag> changeSetTags);

        /**
         * <p>
         * A list of objects specifying each key name and value for the <code>ChangeSetTags</code> property.
         * </p>
         * 
         * @param changeSetTags
         *        A list of objects specifying each key name and value for the <code>ChangeSetTags</code> property.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder changeSetTags(Tag... changeSetTags);

        /**
         * <p>
         * A list of objects specifying each key name and value for the <code>ChangeSetTags</code> property.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.marketplacecatalog.model.Tag.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.marketplacecatalog.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.marketplacecatalog.model.Tag.Builder#build()} is called immediately
         * and its result is passed to {@link #changeSetTags(List<Tag>)}.
         * 
         * @param changeSetTags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.marketplacecatalog.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #changeSetTags(java.util.Collection<Tag>)
         */
        Builder changeSetTags(Consumer<Tag.Builder>... changeSetTags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MarketplaceCatalogRequest.BuilderImpl implements Builder {
        private String catalog;

        private List<Change> changeSet = DefaultSdkAutoConstructList.getInstance();

        private String changeSetName;

        private String clientRequestToken;

        private List<Tag> changeSetTags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StartChangeSetRequest model) {
            super(model);
            catalog(model.catalog);
            changeSet(model.changeSet);
            changeSetName(model.changeSetName);
            clientRequestToken(model.clientRequestToken);
            changeSetTags(model.changeSetTags);
        }

        public final String getCatalog() {
            return catalog;
        }

        public final void setCatalog(String catalog) {
            this.catalog = catalog;
        }

        @Override
        public final Builder catalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        public final List<Change.Builder> getChangeSet() {
            List<Change.Builder> result = RequestedChangeListCopier.copyToBuilder(this.changeSet);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setChangeSet(Collection<Change.BuilderImpl> changeSet) {
            this.changeSet = RequestedChangeListCopier.copyFromBuilder(changeSet);
        }

        @Override
        public final Builder changeSet(Collection<Change> changeSet) {
            this.changeSet = RequestedChangeListCopier.copy(changeSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder changeSet(Change... changeSet) {
            changeSet(Arrays.asList(changeSet));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder changeSet(Consumer<Change.Builder>... changeSet) {
            changeSet(Stream.of(changeSet).map(c -> Change.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getChangeSetName() {
            return changeSetName;
        }

        public final void setChangeSetName(String changeSetName) {
            this.changeSetName = changeSetName;
        }

        @Override
        public final Builder changeSetName(String changeSetName) {
            this.changeSetName = changeSetName;
            return this;
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final List<Tag.Builder> getChangeSetTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.changeSetTags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setChangeSetTags(Collection<Tag.BuilderImpl> changeSetTags) {
            this.changeSetTags = TagListCopier.copyFromBuilder(changeSetTags);
        }

        @Override
        public final Builder changeSetTags(Collection<Tag> changeSetTags) {
            this.changeSetTags = TagListCopier.copy(changeSetTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder changeSetTags(Tag... changeSetTags) {
            changeSetTags(Arrays.asList(changeSetTags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder changeSetTags(Consumer<Tag.Builder>... changeSetTags) {
            changeSetTags(Stream.of(changeSetTags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartChangeSetRequest build() {
            return new StartChangeSetRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
