/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.marketplacecatalog.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum OfferStateString {
    DRAFT("Draft"),
    RELEASED("Released"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, OfferStateString> VALUE_MAP;
    private final String value;

    private OfferStateString(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static OfferStateString fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<OfferStateString> knownValues() {
        EnumSet<OfferStateString> knownValues = EnumSet.allOf(OfferStateString.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(OfferStateString.class, OfferStateString::toString);
    }
}

