/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.marketplacecatalog;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.marketplacecatalog.model.BatchDescribeEntitiesRequest;
import software.amazon.awssdk.services.marketplacecatalog.model.BatchDescribeEntitiesResponse;
import software.amazon.awssdk.services.marketplacecatalog.model.CancelChangeSetRequest;
import software.amazon.awssdk.services.marketplacecatalog.model.CancelChangeSetResponse;
import software.amazon.awssdk.services.marketplacecatalog.model.DeleteResourcePolicyRequest;
import software.amazon.awssdk.services.marketplacecatalog.model.DeleteResourcePolicyResponse;
import software.amazon.awssdk.services.marketplacecatalog.model.DescribeChangeSetRequest;
import software.amazon.awssdk.services.marketplacecatalog.model.DescribeChangeSetResponse;
import software.amazon.awssdk.services.marketplacecatalog.model.DescribeEntityRequest;
import software.amazon.awssdk.services.marketplacecatalog.model.DescribeEntityResponse;
import software.amazon.awssdk.services.marketplacecatalog.model.GetResourcePolicyRequest;
import software.amazon.awssdk.services.marketplacecatalog.model.GetResourcePolicyResponse;
import software.amazon.awssdk.services.marketplacecatalog.model.ListChangeSetsRequest;
import software.amazon.awssdk.services.marketplacecatalog.model.ListChangeSetsResponse;
import software.amazon.awssdk.services.marketplacecatalog.model.ListEntitiesRequest;
import software.amazon.awssdk.services.marketplacecatalog.model.ListEntitiesResponse;
import software.amazon.awssdk.services.marketplacecatalog.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.marketplacecatalog.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.marketplacecatalog.model.PutResourcePolicyRequest;
import software.amazon.awssdk.services.marketplacecatalog.model.PutResourcePolicyResponse;
import software.amazon.awssdk.services.marketplacecatalog.model.StartChangeSetRequest;
import software.amazon.awssdk.services.marketplacecatalog.model.StartChangeSetResponse;
import software.amazon.awssdk.services.marketplacecatalog.model.TagResourceRequest;
import software.amazon.awssdk.services.marketplacecatalog.model.TagResourceResponse;
import software.amazon.awssdk.services.marketplacecatalog.model.UntagResourceRequest;
import software.amazon.awssdk.services.marketplacecatalog.model.UntagResourceResponse;
import software.amazon.awssdk.services.marketplacecatalog.paginators.ListChangeSetsPublisher;
import software.amazon.awssdk.services.marketplacecatalog.paginators.ListEntitiesPublisher;

/**
 * Service client for accessing AWS Marketplace Catalog asynchronously. This can be created using the static
 * {@link #builder()} method.
 *
 * <p>
 * Catalog API actions allow you to manage your entities through list, describe, and update capabilities. An entity can
 * be a product or an offer on AWS Marketplace.
 * </p>
 * <p>
 * You can automate your entity update process by integrating the AWS Marketplace Catalog API with your AWS Marketplace
 * product build or deployment pipelines. You can also create your own applications on top of the Catalog API to manage
 * your products on AWS Marketplace.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface MarketplaceCatalogAsyncClient extends AwsClient {
    String SERVICE_NAME = "aws-marketplace";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "catalog.marketplace";

    /**
     * <p>
     * Returns metadata and content for multiple entities.
     * </p>
     *
     * @param batchDescribeEntitiesRequest
     * @return A Java Future containing the result of the BatchDescribeEntities operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Access is denied.</p>
     *         <p>
     *         HTTP status code: 403</li>
     *         <li>InternalServiceException There was an internal service exception.</p>
     *         <p>
     *         HTTP status code: 500</li>
     *         <li>ThrottlingException Too many requests.</p>
     *         <p>
     *         HTTP status code: 429</li>
     *         <li>ValidationException An error occurred during validation.</p>
     *         <p>
     *         HTTP status code: 422</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MarketplaceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample MarketplaceCatalogAsyncClient.BatchDescribeEntities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/marketplace-catalog-2018-09-17/BatchDescribeEntities"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchDescribeEntitiesResponse> batchDescribeEntities(
            BatchDescribeEntitiesRequest batchDescribeEntitiesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns metadata and content for multiple entities.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchDescribeEntitiesRequest.Builder} avoiding the
     * need to create one manually via {@link BatchDescribeEntitiesRequest#builder()}
     * </p>
     *
     * @param batchDescribeEntitiesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.marketplacecatalog.model.BatchDescribeEntitiesRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the BatchDescribeEntities operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Access is denied.</p>
     *         <p>
     *         HTTP status code: 403</li>
     *         <li>InternalServiceException There was an internal service exception.</p>
     *         <p>
     *         HTTP status code: 500</li>
     *         <li>ThrottlingException Too many requests.</p>
     *         <p>
     *         HTTP status code: 429</li>
     *         <li>ValidationException An error occurred during validation.</p>
     *         <p>
     *         HTTP status code: 422</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MarketplaceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample MarketplaceCatalogAsyncClient.BatchDescribeEntities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/marketplace-catalog-2018-09-17/BatchDescribeEntities"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchDescribeEntitiesResponse> batchDescribeEntities(
            Consumer<BatchDescribeEntitiesRequest.Builder> batchDescribeEntitiesRequest) {
        return batchDescribeEntities(BatchDescribeEntitiesRequest.builder().applyMutation(batchDescribeEntitiesRequest).build());
    }

    /**
     * <p>
     * Used to cancel an open change request. Must be sent before the status of the request changes to
     * <code>APPLYING</code>, the final stage of completing your change request. You can describe a change during the
     * 60-day request history retention period for API calls.
     * </p>
     *
     * @param cancelChangeSetRequest
     * @return A Java Future containing the result of the CancelChangeSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException There was an internal service exception.</p>
     *         <p>
     *         HTTP status code: 500</li>
     *         <li>AccessDeniedException Access is denied.</p>
     *         <p>
     *         HTTP status code: 403</li>
     *         <li>ValidationException An error occurred during validation.</p>
     *         <p>
     *         HTTP status code: 422</li>
     *         <li>ResourceNotFoundException The specified resource wasn't found.</p>
     *         <p>
     *         HTTP status code: 404</li>
     *         <li>ResourceInUseException The resource is currently in use.</li>
     *         <li>ThrottlingException Too many requests.</p>
     *         <p>
     *         HTTP status code: 429</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MarketplaceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample MarketplaceCatalogAsyncClient.CancelChangeSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/marketplace-catalog-2018-09-17/CancelChangeSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CancelChangeSetResponse> cancelChangeSet(CancelChangeSetRequest cancelChangeSetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Used to cancel an open change request. Must be sent before the status of the request changes to
     * <code>APPLYING</code>, the final stage of completing your change request. You can describe a change during the
     * 60-day request history retention period for API calls.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelChangeSetRequest.Builder} avoiding the need
     * to create one manually via {@link CancelChangeSetRequest#builder()}
     * </p>
     *
     * @param cancelChangeSetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.marketplacecatalog.model.CancelChangeSetRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the CancelChangeSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException There was an internal service exception.</p>
     *         <p>
     *         HTTP status code: 500</li>
     *         <li>AccessDeniedException Access is denied.</p>
     *         <p>
     *         HTTP status code: 403</li>
     *         <li>ValidationException An error occurred during validation.</p>
     *         <p>
     *         HTTP status code: 422</li>
     *         <li>ResourceNotFoundException The specified resource wasn't found.</p>
     *         <p>
     *         HTTP status code: 404</li>
     *         <li>ResourceInUseException The resource is currently in use.</li>
     *         <li>ThrottlingException Too many requests.</p>
     *         <p>
     *         HTTP status code: 429</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MarketplaceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample MarketplaceCatalogAsyncClient.CancelChangeSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/marketplace-catalog-2018-09-17/CancelChangeSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CancelChangeSetResponse> cancelChangeSet(
            Consumer<CancelChangeSetRequest.Builder> cancelChangeSetRequest) {
        return cancelChangeSet(CancelChangeSetRequest.builder().applyMutation(cancelChangeSetRequest).build());
    }

    /**
     * <p>
     * Deletes a resource-based policy on an entity that is identified by its resource ARN.
     * </p>
     *
     * @param deleteResourcePolicyRequest
     * @return A Java Future containing the result of the DeleteResourcePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException There was an internal service exception.</p>
     *         <p>
     *         HTTP status code: 500</li>
     *         <li>AccessDeniedException Access is denied.</p>
     *         <p>
     *         HTTP status code: 403</li>
     *         <li>ValidationException An error occurred during validation.</p>
     *         <p>
     *         HTTP status code: 422</li>
     *         <li>ResourceNotFoundException The specified resource wasn't found.</p>
     *         <p>
     *         HTTP status code: 404</li>
     *         <li>ThrottlingException Too many requests.</p>
     *         <p>
     *         HTTP status code: 429</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MarketplaceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample MarketplaceCatalogAsyncClient.DeleteResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/marketplace-catalog-2018-09-17/DeleteResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteResourcePolicyResponse> deleteResourcePolicy(
            DeleteResourcePolicyRequest deleteResourcePolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a resource-based policy on an entity that is identified by its resource ARN.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteResourcePolicyRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteResourcePolicyRequest#builder()}
     * </p>
     *
     * @param deleteResourcePolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.marketplacecatalog.model.DeleteResourcePolicyRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteResourcePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException There was an internal service exception.</p>
     *         <p>
     *         HTTP status code: 500</li>
     *         <li>AccessDeniedException Access is denied.</p>
     *         <p>
     *         HTTP status code: 403</li>
     *         <li>ValidationException An error occurred during validation.</p>
     *         <p>
     *         HTTP status code: 422</li>
     *         <li>ResourceNotFoundException The specified resource wasn't found.</p>
     *         <p>
     *         HTTP status code: 404</li>
     *         <li>ThrottlingException Too many requests.</p>
     *         <p>
     *         HTTP status code: 429</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MarketplaceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample MarketplaceCatalogAsyncClient.DeleteResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/marketplace-catalog-2018-09-17/DeleteResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteResourcePolicyResponse> deleteResourcePolicy(
            Consumer<DeleteResourcePolicyRequest.Builder> deleteResourcePolicyRequest) {
        return deleteResourcePolicy(DeleteResourcePolicyRequest.builder().applyMutation(deleteResourcePolicyRequest).build());
    }

    /**
     * <p>
     * Provides information about a given change set.
     * </p>
     *
     * @param describeChangeSetRequest
     * @return A Java Future containing the result of the DescribeChangeSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException There was an internal service exception.</p>
     *         <p>
     *         HTTP status code: 500</li>
     *         <li>AccessDeniedException Access is denied.</p>
     *         <p>
     *         HTTP status code: 403</li>
     *         <li>ValidationException An error occurred during validation.</p>
     *         <p>
     *         HTTP status code: 422</li>
     *         <li>ResourceNotFoundException The specified resource wasn't found.</p>
     *         <p>
     *         HTTP status code: 404</li>
     *         <li>ThrottlingException Too many requests.</p>
     *         <p>
     *         HTTP status code: 429</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MarketplaceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample MarketplaceCatalogAsyncClient.DescribeChangeSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/marketplace-catalog-2018-09-17/DescribeChangeSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeChangeSetResponse> describeChangeSet(DescribeChangeSetRequest describeChangeSetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides information about a given change set.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeChangeSetRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeChangeSetRequest#builder()}
     * </p>
     *
     * @param describeChangeSetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.marketplacecatalog.model.DescribeChangeSetRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeChangeSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException There was an internal service exception.</p>
     *         <p>
     *         HTTP status code: 500</li>
     *         <li>AccessDeniedException Access is denied.</p>
     *         <p>
     *         HTTP status code: 403</li>
     *         <li>ValidationException An error occurred during validation.</p>
     *         <p>
     *         HTTP status code: 422</li>
     *         <li>ResourceNotFoundException The specified resource wasn't found.</p>
     *         <p>
     *         HTTP status code: 404</li>
     *         <li>ThrottlingException Too many requests.</p>
     *         <p>
     *         HTTP status code: 429</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MarketplaceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample MarketplaceCatalogAsyncClient.DescribeChangeSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/marketplace-catalog-2018-09-17/DescribeChangeSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeChangeSetResponse> describeChangeSet(
            Consumer<DescribeChangeSetRequest.Builder> describeChangeSetRequest) {
        return describeChangeSet(DescribeChangeSetRequest.builder().applyMutation(describeChangeSetRequest).build());
    }

    /**
     * <p>
     * Returns the metadata and content of the entity.
     * </p>
     *
     * @param describeEntityRequest
     * @return A Java Future containing the result of the DescribeEntity operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException There was an internal service exception.</p>
     *         <p>
     *         HTTP status code: 500</li>
     *         <li>AccessDeniedException Access is denied.</p>
     *         <p>
     *         HTTP status code: 403</li>
     *         <li>ValidationException An error occurred during validation.</p>
     *         <p>
     *         HTTP status code: 422</li>
     *         <li>ResourceNotSupportedException Currently, the specified resource is not supported.</li>
     *         <li>ResourceNotFoundException The specified resource wasn't found.</p>
     *         <p>
     *         HTTP status code: 404</li>
     *         <li>ThrottlingException Too many requests.</p>
     *         <p>
     *         HTTP status code: 429</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MarketplaceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample MarketplaceCatalogAsyncClient.DescribeEntity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/marketplace-catalog-2018-09-17/DescribeEntity"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeEntityResponse> describeEntity(DescribeEntityRequest describeEntityRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the metadata and content of the entity.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEntityRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeEntityRequest#builder()}
     * </p>
     *
     * @param describeEntityRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.marketplacecatalog.model.DescribeEntityRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeEntity operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException There was an internal service exception.</p>
     *         <p>
     *         HTTP status code: 500</li>
     *         <li>AccessDeniedException Access is denied.</p>
     *         <p>
     *         HTTP status code: 403</li>
     *         <li>ValidationException An error occurred during validation.</p>
     *         <p>
     *         HTTP status code: 422</li>
     *         <li>ResourceNotSupportedException Currently, the specified resource is not supported.</li>
     *         <li>ResourceNotFoundException The specified resource wasn't found.</p>
     *         <p>
     *         HTTP status code: 404</li>
     *         <li>ThrottlingException Too many requests.</p>
     *         <p>
     *         HTTP status code: 429</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MarketplaceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample MarketplaceCatalogAsyncClient.DescribeEntity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/marketplace-catalog-2018-09-17/DescribeEntity"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeEntityResponse> describeEntity(Consumer<DescribeEntityRequest.Builder> describeEntityRequest) {
        return describeEntity(DescribeEntityRequest.builder().applyMutation(describeEntityRequest).build());
    }

    /**
     * <p>
     * Gets a resource-based policy of an entity that is identified by its resource ARN.
     * </p>
     *
     * @param getResourcePolicyRequest
     * @return A Java Future containing the result of the GetResourcePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException There was an internal service exception.</p>
     *         <p>
     *         HTTP status code: 500</li>
     *         <li>AccessDeniedException Access is denied.</p>
     *         <p>
     *         HTTP status code: 403</li>
     *         <li>ValidationException An error occurred during validation.</p>
     *         <p>
     *         HTTP status code: 422</li>
     *         <li>ResourceNotFoundException The specified resource wasn't found.</p>
     *         <p>
     *         HTTP status code: 404</li>
     *         <li>ThrottlingException Too many requests.</p>
     *         <p>
     *         HTTP status code: 429</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MarketplaceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample MarketplaceCatalogAsyncClient.GetResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/marketplace-catalog-2018-09-17/GetResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetResourcePolicyResponse> getResourcePolicy(GetResourcePolicyRequest getResourcePolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a resource-based policy of an entity that is identified by its resource ARN.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetResourcePolicyRequest.Builder} avoiding the need
     * to create one manually via {@link GetResourcePolicyRequest#builder()}
     * </p>
     *
     * @param getResourcePolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.marketplacecatalog.model.GetResourcePolicyRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetResourcePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException There was an internal service exception.</p>
     *         <p>
     *         HTTP status code: 500</li>
     *         <li>AccessDeniedException Access is denied.</p>
     *         <p>
     *         HTTP status code: 403</li>
     *         <li>ValidationException An error occurred during validation.</p>
     *         <p>
     *         HTTP status code: 422</li>
     *         <li>ResourceNotFoundException The specified resource wasn't found.</p>
     *         <p>
     *         HTTP status code: 404</li>
     *         <li>ThrottlingException Too many requests.</p>
     *         <p>
     *         HTTP status code: 429</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MarketplaceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample MarketplaceCatalogAsyncClient.GetResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/marketplace-catalog-2018-09-17/GetResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetResourcePolicyResponse> getResourcePolicy(
            Consumer<GetResourcePolicyRequest.Builder> getResourcePolicyRequest) {
        return getResourcePolicy(GetResourcePolicyRequest.builder().applyMutation(getResourcePolicyRequest).build());
    }

    /**
     * <p>
     * Returns the list of change sets owned by the account being used to make the call. You can filter this list by
     * providing any combination of <code>entityId</code>, <code>ChangeSetName</code>, and status. If you provide more
     * than one filter, the API operation applies a logical AND between the filters.
     * </p>
     * <p>
     * You can describe a change during the 60-day request history retention period for API calls.
     * </p>
     *
     * @param listChangeSetsRequest
     * @return A Java Future containing the result of the ListChangeSets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException There was an internal service exception.</p>
     *         <p>
     *         HTTP status code: 500</li>
     *         <li>AccessDeniedException Access is denied.</p>
     *         <p>
     *         HTTP status code: 403</li>
     *         <li>ValidationException An error occurred during validation.</p>
     *         <p>
     *         HTTP status code: 422</li>
     *         <li>ThrottlingException Too many requests.</p>
     *         <p>
     *         HTTP status code: 429</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MarketplaceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample MarketplaceCatalogAsyncClient.ListChangeSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/marketplace-catalog-2018-09-17/ListChangeSets"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListChangeSetsResponse> listChangeSets(ListChangeSetsRequest listChangeSetsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the list of change sets owned by the account being used to make the call. You can filter this list by
     * providing any combination of <code>entityId</code>, <code>ChangeSetName</code>, and status. If you provide more
     * than one filter, the API operation applies a logical AND between the filters.
     * </p>
     * <p>
     * You can describe a change during the 60-day request history retention period for API calls.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListChangeSetsRequest.Builder} avoiding the need to
     * create one manually via {@link ListChangeSetsRequest#builder()}
     * </p>
     *
     * @param listChangeSetsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.marketplacecatalog.model.ListChangeSetsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListChangeSets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException There was an internal service exception.</p>
     *         <p>
     *         HTTP status code: 500</li>
     *         <li>AccessDeniedException Access is denied.</p>
     *         <p>
     *         HTTP status code: 403</li>
     *         <li>ValidationException An error occurred during validation.</p>
     *         <p>
     *         HTTP status code: 422</li>
     *         <li>ThrottlingException Too many requests.</p>
     *         <p>
     *         HTTP status code: 429</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MarketplaceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample MarketplaceCatalogAsyncClient.ListChangeSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/marketplace-catalog-2018-09-17/ListChangeSets"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListChangeSetsResponse> listChangeSets(Consumer<ListChangeSetsRequest.Builder> listChangeSetsRequest) {
        return listChangeSets(ListChangeSetsRequest.builder().applyMutation(listChangeSetsRequest).build());
    }

    /**
     * <p>
     * Returns the list of change sets owned by the account being used to make the call. You can filter this list by
     * providing any combination of <code>entityId</code>, <code>ChangeSetName</code>, and status. If you provide more
     * than one filter, the API operation applies a logical AND between the filters.
     * </p>
     * <p>
     * You can describe a change during the 60-day request history retention period for API calls.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listChangeSets(software.amazon.awssdk.services.marketplacecatalog.model.ListChangeSetsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.marketplacecatalog.paginators.ListChangeSetsPublisher publisher = client.listChangeSetsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.marketplacecatalog.paginators.ListChangeSetsPublisher publisher = client.listChangeSetsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.marketplacecatalog.model.ListChangeSetsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.marketplacecatalog.model.ListChangeSetsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listChangeSets(software.amazon.awssdk.services.marketplacecatalog.model.ListChangeSetsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listChangeSetsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException There was an internal service exception.</p>
     *         <p>
     *         HTTP status code: 500</li>
     *         <li>AccessDeniedException Access is denied.</p>
     *         <p>
     *         HTTP status code: 403</li>
     *         <li>ValidationException An error occurred during validation.</p>
     *         <p>
     *         HTTP status code: 422</li>
     *         <li>ThrottlingException Too many requests.</p>
     *         <p>
     *         HTTP status code: 429</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MarketplaceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample MarketplaceCatalogAsyncClient.ListChangeSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/marketplace-catalog-2018-09-17/ListChangeSets"
     *      target="_top">AWS API Documentation</a>
     */
    default ListChangeSetsPublisher listChangeSetsPaginator(ListChangeSetsRequest listChangeSetsRequest) {
        return new ListChangeSetsPublisher(this, listChangeSetsRequest);
    }

    /**
     * <p>
     * Returns the list of change sets owned by the account being used to make the call. You can filter this list by
     * providing any combination of <code>entityId</code>, <code>ChangeSetName</code>, and status. If you provide more
     * than one filter, the API operation applies a logical AND between the filters.
     * </p>
     * <p>
     * You can describe a change during the 60-day request history retention period for API calls.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listChangeSets(software.amazon.awssdk.services.marketplacecatalog.model.ListChangeSetsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.marketplacecatalog.paginators.ListChangeSetsPublisher publisher = client.listChangeSetsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.marketplacecatalog.paginators.ListChangeSetsPublisher publisher = client.listChangeSetsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.marketplacecatalog.model.ListChangeSetsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.marketplacecatalog.model.ListChangeSetsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listChangeSets(software.amazon.awssdk.services.marketplacecatalog.model.ListChangeSetsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListChangeSetsRequest.Builder} avoiding the need to
     * create one manually via {@link ListChangeSetsRequest#builder()}
     * </p>
     *
     * @param listChangeSetsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.marketplacecatalog.model.ListChangeSetsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException There was an internal service exception.</p>
     *         <p>
     *         HTTP status code: 500</li>
     *         <li>AccessDeniedException Access is denied.</p>
     *         <p>
     *         HTTP status code: 403</li>
     *         <li>ValidationException An error occurred during validation.</p>
     *         <p>
     *         HTTP status code: 422</li>
     *         <li>ThrottlingException Too many requests.</p>
     *         <p>
     *         HTTP status code: 429</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MarketplaceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample MarketplaceCatalogAsyncClient.ListChangeSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/marketplace-catalog-2018-09-17/ListChangeSets"
     *      target="_top">AWS API Documentation</a>
     */
    default ListChangeSetsPublisher listChangeSetsPaginator(Consumer<ListChangeSetsRequest.Builder> listChangeSetsRequest) {
        return listChangeSetsPaginator(ListChangeSetsRequest.builder().applyMutation(listChangeSetsRequest).build());
    }

    /**
     * <p>
     * Provides the list of entities of a given type.
     * </p>
     *
     * @param listEntitiesRequest
     * @return A Java Future containing the result of the ListEntities operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException There was an internal service exception.</p>
     *         <p>
     *         HTTP status code: 500</li>
     *         <li>AccessDeniedException Access is denied.</p>
     *         <p>
     *         HTTP status code: 403</li>
     *         <li>ValidationException An error occurred during validation.</p>
     *         <p>
     *         HTTP status code: 422</li>
     *         <li>ResourceNotFoundException The specified resource wasn't found.</p>
     *         <p>
     *         HTTP status code: 404</li>
     *         <li>ThrottlingException Too many requests.</p>
     *         <p>
     *         HTTP status code: 429</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MarketplaceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample MarketplaceCatalogAsyncClient.ListEntities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/marketplace-catalog-2018-09-17/ListEntities"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListEntitiesResponse> listEntities(ListEntitiesRequest listEntitiesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides the list of entities of a given type.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEntitiesRequest.Builder} avoiding the need to
     * create one manually via {@link ListEntitiesRequest#builder()}
     * </p>
     *
     * @param listEntitiesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.marketplacecatalog.model.ListEntitiesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListEntities operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException There was an internal service exception.</p>
     *         <p>
     *         HTTP status code: 500</li>
     *         <li>AccessDeniedException Access is denied.</p>
     *         <p>
     *         HTTP status code: 403</li>
     *         <li>ValidationException An error occurred during validation.</p>
     *         <p>
     *         HTTP status code: 422</li>
     *         <li>ResourceNotFoundException The specified resource wasn't found.</p>
     *         <p>
     *         HTTP status code: 404</li>
     *         <li>ThrottlingException Too many requests.</p>
     *         <p>
     *         HTTP status code: 429</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MarketplaceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample MarketplaceCatalogAsyncClient.ListEntities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/marketplace-catalog-2018-09-17/ListEntities"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListEntitiesResponse> listEntities(Consumer<ListEntitiesRequest.Builder> listEntitiesRequest) {
        return listEntities(ListEntitiesRequest.builder().applyMutation(listEntitiesRequest).build());
    }

    /**
     * <p>
     * Provides the list of entities of a given type.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listEntities(software.amazon.awssdk.services.marketplacecatalog.model.ListEntitiesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.marketplacecatalog.paginators.ListEntitiesPublisher publisher = client.listEntitiesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.marketplacecatalog.paginators.ListEntitiesPublisher publisher = client.listEntitiesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.marketplacecatalog.model.ListEntitiesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.marketplacecatalog.model.ListEntitiesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEntities(software.amazon.awssdk.services.marketplacecatalog.model.ListEntitiesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listEntitiesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException There was an internal service exception.</p>
     *         <p>
     *         HTTP status code: 500</li>
     *         <li>AccessDeniedException Access is denied.</p>
     *         <p>
     *         HTTP status code: 403</li>
     *         <li>ValidationException An error occurred during validation.</p>
     *         <p>
     *         HTTP status code: 422</li>
     *         <li>ResourceNotFoundException The specified resource wasn't found.</p>
     *         <p>
     *         HTTP status code: 404</li>
     *         <li>ThrottlingException Too many requests.</p>
     *         <p>
     *         HTTP status code: 429</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MarketplaceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample MarketplaceCatalogAsyncClient.ListEntities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/marketplace-catalog-2018-09-17/ListEntities"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEntitiesPublisher listEntitiesPaginator(ListEntitiesRequest listEntitiesRequest) {
        return new ListEntitiesPublisher(this, listEntitiesRequest);
    }

    /**
     * <p>
     * Provides the list of entities of a given type.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listEntities(software.amazon.awssdk.services.marketplacecatalog.model.ListEntitiesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.marketplacecatalog.paginators.ListEntitiesPublisher publisher = client.listEntitiesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.marketplacecatalog.paginators.ListEntitiesPublisher publisher = client.listEntitiesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.marketplacecatalog.model.ListEntitiesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.marketplacecatalog.model.ListEntitiesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEntities(software.amazon.awssdk.services.marketplacecatalog.model.ListEntitiesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEntitiesRequest.Builder} avoiding the need to
     * create one manually via {@link ListEntitiesRequest#builder()}
     * </p>
     *
     * @param listEntitiesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.marketplacecatalog.model.ListEntitiesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException There was an internal service exception.</p>
     *         <p>
     *         HTTP status code: 500</li>
     *         <li>AccessDeniedException Access is denied.</p>
     *         <p>
     *         HTTP status code: 403</li>
     *         <li>ValidationException An error occurred during validation.</p>
     *         <p>
     *         HTTP status code: 422</li>
     *         <li>ResourceNotFoundException The specified resource wasn't found.</p>
     *         <p>
     *         HTTP status code: 404</li>
     *         <li>ThrottlingException Too many requests.</p>
     *         <p>
     *         HTTP status code: 429</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MarketplaceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample MarketplaceCatalogAsyncClient.ListEntities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/marketplace-catalog-2018-09-17/ListEntities"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEntitiesPublisher listEntitiesPaginator(Consumer<ListEntitiesRequest.Builder> listEntitiesRequest) {
        return listEntitiesPaginator(ListEntitiesRequest.builder().applyMutation(listEntitiesRequest).build());
    }

    /**
     * <p>
     * Lists all tags that have been added to a resource (either an <a
     * href="https://docs.aws.amazon.com/marketplace-catalog/latest/api-reference/welcome.html#catalog-api-entities"
     * >entity</a> or <a href=
     * "https://docs.aws.amazon.com/marketplace-catalog/latest/api-reference/welcome.html#working-with-change-sets"
     * >change set</a>).
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource wasn't found.</p>
     *         <p>
     *         HTTP status code: 404</li>
     *         <li>InternalServiceException There was an internal service exception.</p>
     *         <p>
     *         HTTP status code: 500</li>
     *         <li>AccessDeniedException Access is denied.</p>
     *         <p>
     *         HTTP status code: 403</li>
     *         <li>ValidationException An error occurred during validation.</p>
     *         <p>
     *         HTTP status code: 422</li>
     *         <li>ThrottlingException Too many requests.</p>
     *         <p>
     *         HTTP status code: 429</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MarketplaceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample MarketplaceCatalogAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/marketplace-catalog-2018-09-17/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all tags that have been added to a resource (either an <a
     * href="https://docs.aws.amazon.com/marketplace-catalog/latest/api-reference/welcome.html#catalog-api-entities"
     * >entity</a> or <a href=
     * "https://docs.aws.amazon.com/marketplace-catalog/latest/api-reference/welcome.html#working-with-change-sets"
     * >change set</a>).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.marketplacecatalog.model.ListTagsForResourceRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource wasn't found.</p>
     *         <p>
     *         HTTP status code: 404</li>
     *         <li>InternalServiceException There was an internal service exception.</p>
     *         <p>
     *         HTTP status code: 500</li>
     *         <li>AccessDeniedException Access is denied.</p>
     *         <p>
     *         HTTP status code: 403</li>
     *         <li>ValidationException An error occurred during validation.</p>
     *         <p>
     *         HTTP status code: 422</li>
     *         <li>ThrottlingException Too many requests.</p>
     *         <p>
     *         HTTP status code: 429</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MarketplaceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample MarketplaceCatalogAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/marketplace-catalog-2018-09-17/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Attaches a resource-based policy to an entity. Examples of an entity include: <code>AmiProduct</code> and
     * <code>ContainerProduct</code>.
     * </p>
     *
     * @param putResourcePolicyRequest
     * @return A Java Future containing the result of the PutResourcePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException There was an internal service exception.</p>
     *         <p>
     *         HTTP status code: 500</li>
     *         <li>AccessDeniedException Access is denied.</p>
     *         <p>
     *         HTTP status code: 403</li>
     *         <li>ValidationException An error occurred during validation.</p>
     *         <p>
     *         HTTP status code: 422</li>
     *         <li>ResourceNotFoundException The specified resource wasn't found.</p>
     *         <p>
     *         HTTP status code: 404</li>
     *         <li>ThrottlingException Too many requests.</p>
     *         <p>
     *         HTTP status code: 429</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MarketplaceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample MarketplaceCatalogAsyncClient.PutResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/marketplace-catalog-2018-09-17/PutResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutResourcePolicyResponse> putResourcePolicy(PutResourcePolicyRequest putResourcePolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Attaches a resource-based policy to an entity. Examples of an entity include: <code>AmiProduct</code> and
     * <code>ContainerProduct</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutResourcePolicyRequest.Builder} avoiding the need
     * to create one manually via {@link PutResourcePolicyRequest#builder()}
     * </p>
     *
     * @param putResourcePolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.marketplacecatalog.model.PutResourcePolicyRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the PutResourcePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException There was an internal service exception.</p>
     *         <p>
     *         HTTP status code: 500</li>
     *         <li>AccessDeniedException Access is denied.</p>
     *         <p>
     *         HTTP status code: 403</li>
     *         <li>ValidationException An error occurred during validation.</p>
     *         <p>
     *         HTTP status code: 422</li>
     *         <li>ResourceNotFoundException The specified resource wasn't found.</p>
     *         <p>
     *         HTTP status code: 404</li>
     *         <li>ThrottlingException Too many requests.</p>
     *         <p>
     *         HTTP status code: 429</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MarketplaceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample MarketplaceCatalogAsyncClient.PutResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/marketplace-catalog-2018-09-17/PutResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutResourcePolicyResponse> putResourcePolicy(
            Consumer<PutResourcePolicyRequest.Builder> putResourcePolicyRequest) {
        return putResourcePolicy(PutResourcePolicyRequest.builder().applyMutation(putResourcePolicyRequest).build());
    }

    /**
     * <p>
     * Allows you to request changes for your entities. Within a single <code>ChangeSet</code>, you can't start the same
     * change type against the same entity multiple times. Additionally, when a <code>ChangeSet</code> is running, all
     * the entities targeted by the different changes are locked until the change set has completed (either succeeded,
     * cancelled, or failed). If you try to start a change set containing a change against an entity that is already
     * locked, you will receive a <code>ResourceInUseException</code> error.
     * </p>
     * <p>
     * For example, you can't start the <code>ChangeSet</code> described in the <a href=
     * "https://docs.aws.amazon.com/marketplace-catalog/latest/api-reference/API_StartChangeSet.html#API_StartChangeSet_Examples"
     * >example</a> later in this topic because it contains two changes to run the same change type (
     * <code>AddRevisions</code>) against the same entity (<code>entity-id@1</code>).
     * </p>
     * <p>
     * For more information about working with change sets, see <a href=
     * "https://docs.aws.amazon.com/marketplace-catalog/latest/api-reference/welcome.html#working-with-change-sets">
     * Working with change sets</a>. For information about change types for single-AMI products, see <a href=
     * "https://docs.aws.amazon.com/marketplace-catalog/latest/api-reference/ami-products.html#working-with-single-AMI-products"
     * >Working with single-AMI products</a>. Also, for more information about change types available for
     * container-based products, see <a href=
     * "https://docs.aws.amazon.com/marketplace-catalog/latest/api-reference/container-products.html#working-with-container-products"
     * >Working with container products</a>.
     * </p>
     *
     * @param startChangeSetRequest
     * @return A Java Future containing the result of the StartChangeSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException There was an internal service exception.</p>
     *         <p>
     *         HTTP status code: 500</li>
     *         <li>AccessDeniedException Access is denied.</p>
     *         <p>
     *         HTTP status code: 403</li>
     *         <li>ValidationException An error occurred during validation.</p>
     *         <p>
     *         HTTP status code: 422</li>
     *         <li>ResourceNotFoundException The specified resource wasn't found.</p>
     *         <p>
     *         HTTP status code: 404</li>
     *         <li>ResourceInUseException The resource is currently in use.</li>
     *         <li>ThrottlingException Too many requests.</p>
     *         <p>
     *         HTTP status code: 429</li>
     *         <li>ServiceQuotaExceededException The maximum number of open requests per account has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MarketplaceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample MarketplaceCatalogAsyncClient.StartChangeSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/marketplace-catalog-2018-09-17/StartChangeSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartChangeSetResponse> startChangeSet(StartChangeSetRequest startChangeSetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Allows you to request changes for your entities. Within a single <code>ChangeSet</code>, you can't start the same
     * change type against the same entity multiple times. Additionally, when a <code>ChangeSet</code> is running, all
     * the entities targeted by the different changes are locked until the change set has completed (either succeeded,
     * cancelled, or failed). If you try to start a change set containing a change against an entity that is already
     * locked, you will receive a <code>ResourceInUseException</code> error.
     * </p>
     * <p>
     * For example, you can't start the <code>ChangeSet</code> described in the <a href=
     * "https://docs.aws.amazon.com/marketplace-catalog/latest/api-reference/API_StartChangeSet.html#API_StartChangeSet_Examples"
     * >example</a> later in this topic because it contains two changes to run the same change type (
     * <code>AddRevisions</code>) against the same entity (<code>entity-id@1</code>).
     * </p>
     * <p>
     * For more information about working with change sets, see <a href=
     * "https://docs.aws.amazon.com/marketplace-catalog/latest/api-reference/welcome.html#working-with-change-sets">
     * Working with change sets</a>. For information about change types for single-AMI products, see <a href=
     * "https://docs.aws.amazon.com/marketplace-catalog/latest/api-reference/ami-products.html#working-with-single-AMI-products"
     * >Working with single-AMI products</a>. Also, for more information about change types available for
     * container-based products, see <a href=
     * "https://docs.aws.amazon.com/marketplace-catalog/latest/api-reference/container-products.html#working-with-container-products"
     * >Working with container products</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartChangeSetRequest.Builder} avoiding the need to
     * create one manually via {@link StartChangeSetRequest#builder()}
     * </p>
     *
     * @param startChangeSetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.marketplacecatalog.model.StartChangeSetRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the StartChangeSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceException There was an internal service exception.</p>
     *         <p>
     *         HTTP status code: 500</li>
     *         <li>AccessDeniedException Access is denied.</p>
     *         <p>
     *         HTTP status code: 403</li>
     *         <li>ValidationException An error occurred during validation.</p>
     *         <p>
     *         HTTP status code: 422</li>
     *         <li>ResourceNotFoundException The specified resource wasn't found.</p>
     *         <p>
     *         HTTP status code: 404</li>
     *         <li>ResourceInUseException The resource is currently in use.</li>
     *         <li>ThrottlingException Too many requests.</p>
     *         <p>
     *         HTTP status code: 429</li>
     *         <li>ServiceQuotaExceededException The maximum number of open requests per account has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MarketplaceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample MarketplaceCatalogAsyncClient.StartChangeSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/marketplace-catalog-2018-09-17/StartChangeSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartChangeSetResponse> startChangeSet(Consumer<StartChangeSetRequest.Builder> startChangeSetRequest) {
        return startChangeSet(StartChangeSetRequest.builder().applyMutation(startChangeSetRequest).build());
    }

    /**
     * <p>
     * Tags a resource (either an <a
     * href="https://docs.aws.amazon.com/marketplace-catalog/latest/api-reference/welcome.html#catalog-api-entities"
     * >entity</a> or <a href=
     * "https://docs.aws.amazon.com/marketplace-catalog/latest/api-reference/welcome.html#working-with-change-sets"
     * >change set</a>).
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource wasn't found.</p>
     *         <p>
     *         HTTP status code: 404</li>
     *         <li>InternalServiceException There was an internal service exception.</p>
     *         <p>
     *         HTTP status code: 500</li>
     *         <li>AccessDeniedException Access is denied.</p>
     *         <p>
     *         HTTP status code: 403</li>
     *         <li>ValidationException An error occurred during validation.</p>
     *         <p>
     *         HTTP status code: 422</li>
     *         <li>ThrottlingException Too many requests.</p>
     *         <p>
     *         HTTP status code: 429</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MarketplaceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample MarketplaceCatalogAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/marketplace-catalog-2018-09-17/TagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Tags a resource (either an <a
     * href="https://docs.aws.amazon.com/marketplace-catalog/latest/api-reference/welcome.html#catalog-api-entities"
     * >entity</a> or <a href=
     * "https://docs.aws.amazon.com/marketplace-catalog/latest/api-reference/welcome.html#working-with-change-sets"
     * >change set</a>).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.marketplacecatalog.model.TagResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource wasn't found.</p>
     *         <p>
     *         HTTP status code: 404</li>
     *         <li>InternalServiceException There was an internal service exception.</p>
     *         <p>
     *         HTTP status code: 500</li>
     *         <li>AccessDeniedException Access is denied.</p>
     *         <p>
     *         HTTP status code: 403</li>
     *         <li>ValidationException An error occurred during validation.</p>
     *         <p>
     *         HTTP status code: 422</li>
     *         <li>ThrottlingException Too many requests.</p>
     *         <p>
     *         HTTP status code: 429</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MarketplaceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample MarketplaceCatalogAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/marketplace-catalog-2018-09-17/TagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes a tag or list of tags from a resource (either an <a
     * href="https://docs.aws.amazon.com/marketplace-catalog/latest/api-reference/welcome.html#catalog-api-entities"
     * >entity</a> or <a href=
     * "https://docs.aws.amazon.com/marketplace-catalog/latest/api-reference/welcome.html#working-with-change-sets"
     * >change set</a>).
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource wasn't found.</p>
     *         <p>
     *         HTTP status code: 404</li>
     *         <li>InternalServiceException There was an internal service exception.</p>
     *         <p>
     *         HTTP status code: 500</li>
     *         <li>AccessDeniedException Access is denied.</p>
     *         <p>
     *         HTTP status code: 403</li>
     *         <li>ValidationException An error occurred during validation.</p>
     *         <p>
     *         HTTP status code: 422</li>
     *         <li>ThrottlingException Too many requests.</p>
     *         <p>
     *         HTTP status code: 429</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MarketplaceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample MarketplaceCatalogAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/marketplace-catalog-2018-09-17/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a tag or list of tags from a resource (either an <a
     * href="https://docs.aws.amazon.com/marketplace-catalog/latest/api-reference/welcome.html#catalog-api-entities"
     * >entity</a> or <a href=
     * "https://docs.aws.amazon.com/marketplace-catalog/latest/api-reference/welcome.html#working-with-change-sets"
     * >change set</a>).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.marketplacecatalog.model.UntagResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource wasn't found.</p>
     *         <p>
     *         HTTP status code: 404</li>
     *         <li>InternalServiceException There was an internal service exception.</p>
     *         <p>
     *         HTTP status code: 500</li>
     *         <li>AccessDeniedException Access is denied.</p>
     *         <p>
     *         HTTP status code: 403</li>
     *         <li>ValidationException An error occurred during validation.</p>
     *         <p>
     *         HTTP status code: 422</li>
     *         <li>ThrottlingException Too many requests.</p>
     *         <p>
     *         HTTP status code: 429</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MarketplaceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample MarketplaceCatalogAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/marketplace-catalog-2018-09-17/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    @Override
    default MarketplaceCatalogServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link MarketplaceCatalogAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static MarketplaceCatalogAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link MarketplaceCatalogAsyncClient}.
     */
    static MarketplaceCatalogAsyncClientBuilder builder() {
        return new DefaultMarketplaceCatalogAsyncClientBuilder();
    }
}
