/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.marketplacecatalog.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Object containing all the filter fields for AMI products. Client can add a maximum of 8 filters in a single
 * <code>ListEntities</code> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AmiProductFilters implements SdkPojo, Serializable,
        ToCopyableBuilder<AmiProductFilters.Builder, AmiProductFilters> {
    private static final SdkField<AmiProductEntityIdFilter> ENTITY_ID_FIELD = SdkField
            .<AmiProductEntityIdFilter> builder(MarshallingType.SDK_POJO).memberName("EntityId")
            .getter(getter(AmiProductFilters::entityId)).setter(setter(Builder::entityId))
            .constructor(AmiProductEntityIdFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntityId").build()).build();

    private static final SdkField<AmiProductLastModifiedDateFilter> LAST_MODIFIED_DATE_FIELD = SdkField
            .<AmiProductLastModifiedDateFilter> builder(MarshallingType.SDK_POJO).memberName("LastModifiedDate")
            .getter(getter(AmiProductFilters::lastModifiedDate)).setter(setter(Builder::lastModifiedDate))
            .constructor(AmiProductLastModifiedDateFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedDate").build()).build();

    private static final SdkField<AmiProductTitleFilter> PRODUCT_TITLE_FIELD = SdkField
            .<AmiProductTitleFilter> builder(MarshallingType.SDK_POJO).memberName("ProductTitle")
            .getter(getter(AmiProductFilters::productTitle)).setter(setter(Builder::productTitle))
            .constructor(AmiProductTitleFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductTitle").build()).build();

    private static final SdkField<AmiProductVisibilityFilter> VISIBILITY_FIELD = SdkField
            .<AmiProductVisibilityFilter> builder(MarshallingType.SDK_POJO).memberName("Visibility")
            .getter(getter(AmiProductFilters::visibility)).setter(setter(Builder::visibility))
            .constructor(AmiProductVisibilityFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Visibility").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTITY_ID_FIELD,
            LAST_MODIFIED_DATE_FIELD, PRODUCT_TITLE_FIELD, VISIBILITY_FIELD));

    private static final long serialVersionUID = 1L;

    private final AmiProductEntityIdFilter entityId;

    private final AmiProductLastModifiedDateFilter lastModifiedDate;

    private final AmiProductTitleFilter productTitle;

    private final AmiProductVisibilityFilter visibility;

    private AmiProductFilters(BuilderImpl builder) {
        this.entityId = builder.entityId;
        this.lastModifiedDate = builder.lastModifiedDate;
        this.productTitle = builder.productTitle;
        this.visibility = builder.visibility;
    }

    /**
     * <p>
     * Unique identifier for the AMI product.
     * </p>
     * 
     * @return Unique identifier for the AMI product.
     */
    public final AmiProductEntityIdFilter entityId() {
        return entityId;
    }

    /**
     * <p>
     * The last date on which the AMI product was modified.
     * </p>
     * 
     * @return The last date on which the AMI product was modified.
     */
    public final AmiProductLastModifiedDateFilter lastModifiedDate() {
        return lastModifiedDate;
    }

    /**
     * <p>
     * The title of the AMI product.
     * </p>
     * 
     * @return The title of the AMI product.
     */
    public final AmiProductTitleFilter productTitle() {
        return productTitle;
    }

    /**
     * <p>
     * The visibility of the AMI product.
     * </p>
     * 
     * @return The visibility of the AMI product.
     */
    public final AmiProductVisibilityFilter visibility() {
        return visibility;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(entityId());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(productTitle());
        hashCode = 31 * hashCode + Objects.hashCode(visibility());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AmiProductFilters)) {
            return false;
        }
        AmiProductFilters other = (AmiProductFilters) obj;
        return Objects.equals(entityId(), other.entityId()) && Objects.equals(lastModifiedDate(), other.lastModifiedDate())
                && Objects.equals(productTitle(), other.productTitle()) && Objects.equals(visibility(), other.visibility());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AmiProductFilters").add("EntityId", entityId()).add("LastModifiedDate", lastModifiedDate())
                .add("ProductTitle", productTitle()).add("Visibility", visibility()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EntityId":
            return Optional.ofNullable(clazz.cast(entityId()));
        case "LastModifiedDate":
            return Optional.ofNullable(clazz.cast(lastModifiedDate()));
        case "ProductTitle":
            return Optional.ofNullable(clazz.cast(productTitle()));
        case "Visibility":
            return Optional.ofNullable(clazz.cast(visibility()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AmiProductFilters, T> g) {
        return obj -> g.apply((AmiProductFilters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AmiProductFilters> {
        /**
         * <p>
         * Unique identifier for the AMI product.
         * </p>
         * 
         * @param entityId
         *        Unique identifier for the AMI product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityId(AmiProductEntityIdFilter entityId);

        /**
         * <p>
         * Unique identifier for the AMI product.
         * </p>
         * This is a convenience method that creates an instance of the {@link AmiProductEntityIdFilter.Builder}
         * avoiding the need to create one manually via {@link AmiProductEntityIdFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AmiProductEntityIdFilter.Builder#build()} is called immediately
         * and its result is passed to {@link #entityId(AmiProductEntityIdFilter)}.
         * 
         * @param entityId
         *        a consumer that will call methods on {@link AmiProductEntityIdFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #entityId(AmiProductEntityIdFilter)
         */
        default Builder entityId(Consumer<AmiProductEntityIdFilter.Builder> entityId) {
            return entityId(AmiProductEntityIdFilter.builder().applyMutation(entityId).build());
        }

        /**
         * <p>
         * The last date on which the AMI product was modified.
         * </p>
         * 
         * @param lastModifiedDate
         *        The last date on which the AMI product was modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedDate(AmiProductLastModifiedDateFilter lastModifiedDate);

        /**
         * <p>
         * The last date on which the AMI product was modified.
         * </p>
         * This is a convenience method that creates an instance of the {@link AmiProductLastModifiedDateFilter.Builder}
         * avoiding the need to create one manually via {@link AmiProductLastModifiedDateFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AmiProductLastModifiedDateFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #lastModifiedDate(AmiProductLastModifiedDateFilter)}.
         * 
         * @param lastModifiedDate
         *        a consumer that will call methods on {@link AmiProductLastModifiedDateFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lastModifiedDate(AmiProductLastModifiedDateFilter)
         */
        default Builder lastModifiedDate(Consumer<AmiProductLastModifiedDateFilter.Builder> lastModifiedDate) {
            return lastModifiedDate(AmiProductLastModifiedDateFilter.builder().applyMutation(lastModifiedDate).build());
        }

        /**
         * <p>
         * The title of the AMI product.
         * </p>
         * 
         * @param productTitle
         *        The title of the AMI product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productTitle(AmiProductTitleFilter productTitle);

        /**
         * <p>
         * The title of the AMI product.
         * </p>
         * This is a convenience method that creates an instance of the {@link AmiProductTitleFilter.Builder} avoiding
         * the need to create one manually via {@link AmiProductTitleFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AmiProductTitleFilter.Builder#build()} is called immediately and
         * its result is passed to {@link #productTitle(AmiProductTitleFilter)}.
         * 
         * @param productTitle
         *        a consumer that will call methods on {@link AmiProductTitleFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #productTitle(AmiProductTitleFilter)
         */
        default Builder productTitle(Consumer<AmiProductTitleFilter.Builder> productTitle) {
            return productTitle(AmiProductTitleFilter.builder().applyMutation(productTitle).build());
        }

        /**
         * <p>
         * The visibility of the AMI product.
         * </p>
         * 
         * @param visibility
         *        The visibility of the AMI product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder visibility(AmiProductVisibilityFilter visibility);

        /**
         * <p>
         * The visibility of the AMI product.
         * </p>
         * This is a convenience method that creates an instance of the {@link AmiProductVisibilityFilter.Builder}
         * avoiding the need to create one manually via {@link AmiProductVisibilityFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AmiProductVisibilityFilter.Builder#build()} is called immediately
         * and its result is passed to {@link #visibility(AmiProductVisibilityFilter)}.
         * 
         * @param visibility
         *        a consumer that will call methods on {@link AmiProductVisibilityFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #visibility(AmiProductVisibilityFilter)
         */
        default Builder visibility(Consumer<AmiProductVisibilityFilter.Builder> visibility) {
            return visibility(AmiProductVisibilityFilter.builder().applyMutation(visibility).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AmiProductEntityIdFilter entityId;

        private AmiProductLastModifiedDateFilter lastModifiedDate;

        private AmiProductTitleFilter productTitle;

        private AmiProductVisibilityFilter visibility;

        private BuilderImpl() {
        }

        private BuilderImpl(AmiProductFilters model) {
            entityId(model.entityId);
            lastModifiedDate(model.lastModifiedDate);
            productTitle(model.productTitle);
            visibility(model.visibility);
        }

        public final AmiProductEntityIdFilter.Builder getEntityId() {
            return entityId != null ? entityId.toBuilder() : null;
        }

        public final void setEntityId(AmiProductEntityIdFilter.BuilderImpl entityId) {
            this.entityId = entityId != null ? entityId.build() : null;
        }

        @Override
        public final Builder entityId(AmiProductEntityIdFilter entityId) {
            this.entityId = entityId;
            return this;
        }

        public final AmiProductLastModifiedDateFilter.Builder getLastModifiedDate() {
            return lastModifiedDate != null ? lastModifiedDate.toBuilder() : null;
        }

        public final void setLastModifiedDate(AmiProductLastModifiedDateFilter.BuilderImpl lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate != null ? lastModifiedDate.build() : null;
        }

        @Override
        public final Builder lastModifiedDate(AmiProductLastModifiedDateFilter lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final AmiProductTitleFilter.Builder getProductTitle() {
            return productTitle != null ? productTitle.toBuilder() : null;
        }

        public final void setProductTitle(AmiProductTitleFilter.BuilderImpl productTitle) {
            this.productTitle = productTitle != null ? productTitle.build() : null;
        }

        @Override
        public final Builder productTitle(AmiProductTitleFilter productTitle) {
            this.productTitle = productTitle;
            return this;
        }

        public final AmiProductVisibilityFilter.Builder getVisibility() {
            return visibility != null ? visibility.toBuilder() : null;
        }

        public final void setVisibility(AmiProductVisibilityFilter.BuilderImpl visibility) {
            this.visibility = visibility != null ? visibility.build() : null;
        }

        @Override
        public final Builder visibility(AmiProductVisibilityFilter visibility) {
            this.visibility = visibility;
            return this;
        }

        @Override
        public AmiProductFilters build() {
            return new AmiProductFilters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
