/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.marketplacecatalog.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Object that contains summarized information about an AMI product.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AmiProductSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<AmiProductSummary.Builder, AmiProductSummary> {
    private static final SdkField<String> PRODUCT_TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProductTitle").getter(getter(AmiProductSummary::productTitle)).setter(setter(Builder::productTitle))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductTitle").build()).build();

    private static final SdkField<String> VISIBILITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Visibility").getter(getter(AmiProductSummary::visibilityAsString)).setter(setter(Builder::visibility))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Visibility").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRODUCT_TITLE_FIELD,
            VISIBILITY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String productTitle;

    private final String visibility;

    private AmiProductSummary(BuilderImpl builder) {
        this.productTitle = builder.productTitle;
        this.visibility = builder.visibility;
    }

    /**
     * <p>
     * The title of the AMI product.
     * </p>
     * 
     * @return The title of the AMI product.
     */
    public final String productTitle() {
        return productTitle;
    }

    /**
     * <p>
     * The lifecycle of the AMI product.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #visibility} will
     * return {@link AmiProductVisibilityString#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #visibilityAsString}.
     * </p>
     * 
     * @return The lifecycle of the AMI product.
     * @see AmiProductVisibilityString
     */
    public final AmiProductVisibilityString visibility() {
        return AmiProductVisibilityString.fromValue(visibility);
    }

    /**
     * <p>
     * The lifecycle of the AMI product.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #visibility} will
     * return {@link AmiProductVisibilityString#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #visibilityAsString}.
     * </p>
     * 
     * @return The lifecycle of the AMI product.
     * @see AmiProductVisibilityString
     */
    public final String visibilityAsString() {
        return visibility;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(productTitle());
        hashCode = 31 * hashCode + Objects.hashCode(visibilityAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AmiProductSummary)) {
            return false;
        }
        AmiProductSummary other = (AmiProductSummary) obj;
        return Objects.equals(productTitle(), other.productTitle())
                && Objects.equals(visibilityAsString(), other.visibilityAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AmiProductSummary").add("ProductTitle", productTitle()).add("Visibility", visibilityAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProductTitle":
            return Optional.ofNullable(clazz.cast(productTitle()));
        case "Visibility":
            return Optional.ofNullable(clazz.cast(visibilityAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AmiProductSummary, T> g) {
        return obj -> g.apply((AmiProductSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AmiProductSummary> {
        /**
         * <p>
         * The title of the AMI product.
         * </p>
         * 
         * @param productTitle
         *        The title of the AMI product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productTitle(String productTitle);

        /**
         * <p>
         * The lifecycle of the AMI product.
         * </p>
         * 
         * @param visibility
         *        The lifecycle of the AMI product.
         * @see AmiProductVisibilityString
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AmiProductVisibilityString
         */
        Builder visibility(String visibility);

        /**
         * <p>
         * The lifecycle of the AMI product.
         * </p>
         * 
         * @param visibility
         *        The lifecycle of the AMI product.
         * @see AmiProductVisibilityString
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AmiProductVisibilityString
         */
        Builder visibility(AmiProductVisibilityString visibility);
    }

    static final class BuilderImpl implements Builder {
        private String productTitle;

        private String visibility;

        private BuilderImpl() {
        }

        private BuilderImpl(AmiProductSummary model) {
            productTitle(model.productTitle);
            visibility(model.visibility);
        }

        public final String getProductTitle() {
            return productTitle;
        }

        public final void setProductTitle(String productTitle) {
            this.productTitle = productTitle;
        }

        @Override
        public final Builder productTitle(String productTitle) {
            this.productTitle = productTitle;
            return this;
        }

        public final String getVisibility() {
            return visibility;
        }

        public final void setVisibility(String visibility) {
            this.visibility = visibility;
        }

        @Override
        public final Builder visibility(String visibility) {
            this.visibility = visibility;
            return this;
        }

        @Override
        public final Builder visibility(AmiProductVisibilityString visibility) {
            this.visibility(visibility == null ? null : visibility.toString());
            return this;
        }

        @Override
        public AmiProductSummary build() {
            return new AmiProductSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
