/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.marketplacecatalog.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchDescribeEntitiesResponse extends MarketplaceCatalogResponse implements
        ToCopyableBuilder<BatchDescribeEntitiesResponse.Builder, BatchDescribeEntitiesResponse> {
    private static final SdkField<Map<String, EntityDetail>> ENTITY_DETAILS_FIELD = SdkField
            .<Map<String, EntityDetail>> builder(MarshallingType.MAP)
            .memberName("EntityDetails")
            .getter(getter(BatchDescribeEntitiesResponse::entityDetails))
            .setter(setter(Builder::entityDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntityDetails").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<EntityDetail> builder(MarshallingType.SDK_POJO)
                                            .constructor(EntityDetail::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, BatchDescribeErrorDetail>> ERRORS_FIELD = SdkField
            .<Map<String, BatchDescribeErrorDetail>> builder(MarshallingType.MAP)
            .memberName("Errors")
            .getter(getter(BatchDescribeEntitiesResponse::errors))
            .setter(setter(Builder::errors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Errors").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<BatchDescribeErrorDetail> builder(MarshallingType.SDK_POJO)
                                            .constructor(BatchDescribeErrorDetail::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTITY_DETAILS_FIELD,
            ERRORS_FIELD));

    private final Map<String, EntityDetail> entityDetails;

    private final Map<String, BatchDescribeErrorDetail> errors;

    private BatchDescribeEntitiesResponse(BuilderImpl builder) {
        super(builder);
        this.entityDetails = builder.entityDetails;
        this.errors = builder.errors;
    }

    /**
     * For responses, this returns true if the service returned a value for the EntityDetails property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEntityDetails() {
        return entityDetails != null && !(entityDetails instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Details about each entity.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEntityDetails} method.
     * </p>
     * 
     * @return Details about each entity.
     */
    public final Map<String, EntityDetail> entityDetails() {
        return entityDetails;
    }

    /**
     * For responses, this returns true if the service returned a value for the Errors property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasErrors() {
        return errors != null && !(errors instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map of errors returned, with <code>EntityId</code> as the key and <code>errorDetail</code> as the value.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasErrors} method.
     * </p>
     * 
     * @return A map of errors returned, with <code>EntityId</code> as the key and <code>errorDetail</code> as the
     *         value.
     */
    public final Map<String, BatchDescribeErrorDetail> errors() {
        return errors;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasEntityDetails() ? entityDetails() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasErrors() ? errors() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDescribeEntitiesResponse)) {
            return false;
        }
        BatchDescribeEntitiesResponse other = (BatchDescribeEntitiesResponse) obj;
        return hasEntityDetails() == other.hasEntityDetails() && Objects.equals(entityDetails(), other.entityDetails())
                && hasErrors() == other.hasErrors() && Objects.equals(errors(), other.errors());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchDescribeEntitiesResponse")
                .add("EntityDetails", hasEntityDetails() ? entityDetails() : null).add("Errors", hasErrors() ? errors() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EntityDetails":
            return Optional.ofNullable(clazz.cast(entityDetails()));
        case "Errors":
            return Optional.ofNullable(clazz.cast(errors()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchDescribeEntitiesResponse, T> g) {
        return obj -> g.apply((BatchDescribeEntitiesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MarketplaceCatalogResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, BatchDescribeEntitiesResponse> {
        /**
         * <p>
         * Details about each entity.
         * </p>
         * 
         * @param entityDetails
         *        Details about each entity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityDetails(Map<String, EntityDetail> entityDetails);

        /**
         * <p>
         * A map of errors returned, with <code>EntityId</code> as the key and <code>errorDetail</code> as the value.
         * </p>
         * 
         * @param errors
         *        A map of errors returned, with <code>EntityId</code> as the key and <code>errorDetail</code> as the
         *        value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(Map<String, BatchDescribeErrorDetail> errors);
    }

    static final class BuilderImpl extends MarketplaceCatalogResponse.BuilderImpl implements Builder {
        private Map<String, EntityDetail> entityDetails = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, BatchDescribeErrorDetail> errors = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDescribeEntitiesResponse model) {
            super(model);
            entityDetails(model.entityDetails);
            errors(model.errors);
        }

        public final Map<String, EntityDetail.Builder> getEntityDetails() {
            Map<String, EntityDetail.Builder> result = EntityDetailsCopier.copyToBuilder(this.entityDetails);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setEntityDetails(Map<String, EntityDetail.BuilderImpl> entityDetails) {
            this.entityDetails = EntityDetailsCopier.copyFromBuilder(entityDetails);
        }

        @Override
        public final Builder entityDetails(Map<String, EntityDetail> entityDetails) {
            this.entityDetails = EntityDetailsCopier.copy(entityDetails);
            return this;
        }

        public final Map<String, BatchDescribeErrorDetail.Builder> getErrors() {
            Map<String, BatchDescribeErrorDetail.Builder> result = ErrorsCopier.copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setErrors(Map<String, BatchDescribeErrorDetail.BuilderImpl> errors) {
            this.errors = ErrorsCopier.copyFromBuilder(errors);
        }

        @Override
        public final Builder errors(Map<String, BatchDescribeErrorDetail> errors) {
            this.errors = ErrorsCopier.copy(errors);
            return this;
        }

        @Override
        public BatchDescribeEntitiesResponse build() {
            return new BatchDescribeEntitiesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
