/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.marketplacecatalog.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Object that allows filtering on product title.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataProductTitleFilter implements SdkPojo, Serializable,
        ToCopyableBuilder<DataProductTitleFilter.Builder, DataProductTitleFilter> {
    private static final SdkField<List<String>> VALUE_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ValueList")
            .getter(getter(DataProductTitleFilter::valueList))
            .setter(setter(Builder::valueList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValueList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> WILD_CARD_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WildCardValue").getter(getter(DataProductTitleFilter::wildCardValue))
            .setter(setter(Builder::wildCardValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WildCardValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALUE_LIST_FIELD,
            WILD_CARD_VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> valueList;

    private final String wildCardValue;

    private DataProductTitleFilter(BuilderImpl builder) {
        this.valueList = builder.valueList;
        this.wildCardValue = builder.wildCardValue;
    }

    /**
     * For responses, this returns true if the service returned a value for the ValueList property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasValueList() {
        return valueList != null && !(valueList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A string array of unique product title values to be filtered on.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasValueList} method.
     * </p>
     * 
     * @return A string array of unique product title values to be filtered on.
     */
    public final List<String> valueList() {
        return valueList;
    }

    /**
     * <p>
     * A string that will be the <code>wildCard</code> input for product tile filter. It matches the provided value as a
     * substring in the actual value.
     * </p>
     * 
     * @return A string that will be the <code>wildCard</code> input for product tile filter. It matches the provided
     *         value as a substring in the actual value.
     */
    public final String wildCardValue() {
        return wildCardValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasValueList() ? valueList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(wildCardValue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataProductTitleFilter)) {
            return false;
        }
        DataProductTitleFilter other = (DataProductTitleFilter) obj;
        return hasValueList() == other.hasValueList() && Objects.equals(valueList(), other.valueList())
                && Objects.equals(wildCardValue(), other.wildCardValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataProductTitleFilter").add("ValueList", hasValueList() ? valueList() : null)
                .add("WildCardValue", wildCardValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ValueList":
            return Optional.ofNullable(clazz.cast(valueList()));
        case "WildCardValue":
            return Optional.ofNullable(clazz.cast(wildCardValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataProductTitleFilter, T> g) {
        return obj -> g.apply((DataProductTitleFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataProductTitleFilter> {
        /**
         * <p>
         * A string array of unique product title values to be filtered on.
         * </p>
         * 
         * @param valueList
         *        A string array of unique product title values to be filtered on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder valueList(Collection<String> valueList);

        /**
         * <p>
         * A string array of unique product title values to be filtered on.
         * </p>
         * 
         * @param valueList
         *        A string array of unique product title values to be filtered on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder valueList(String... valueList);

        /**
         * <p>
         * A string that will be the <code>wildCard</code> input for product tile filter. It matches the provided value
         * as a substring in the actual value.
         * </p>
         * 
         * @param wildCardValue
         *        A string that will be the <code>wildCard</code> input for product tile filter. It matches the provided
         *        value as a substring in the actual value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder wildCardValue(String wildCardValue);
    }

    static final class BuilderImpl implements Builder {
        private List<String> valueList = DefaultSdkAutoConstructList.getInstance();

        private String wildCardValue;

        private BuilderImpl() {
        }

        private BuilderImpl(DataProductTitleFilter model) {
            valueList(model.valueList);
            wildCardValue(model.wildCardValue);
        }

        public final Collection<String> getValueList() {
            if (valueList instanceof SdkAutoConstructList) {
                return null;
            }
            return valueList;
        }

        public final void setValueList(Collection<String> valueList) {
            this.valueList = DataProductTitleFilterValueListCopier.copy(valueList);
        }

        @Override
        public final Builder valueList(Collection<String> valueList) {
            this.valueList = DataProductTitleFilterValueListCopier.copy(valueList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder valueList(String... valueList) {
            valueList(Arrays.asList(valueList));
            return this;
        }

        public final String getWildCardValue() {
            return wildCardValue;
        }

        public final void setWildCardValue(String wildCardValue) {
            this.wildCardValue = wildCardValue;
        }

        @Override
        public final Builder wildCardValue(String wildCardValue) {
            this.wildCardValue = wildCardValue;
            return this;
        }

        @Override
        public DataProductTitleFilter build() {
            return new DataProductTitleFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
