/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.marketplacecatalog.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that contains metadata and details about the entity.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EntityDetail implements SdkPojo, Serializable, ToCopyableBuilder<EntityDetail.Builder, EntityDetail> {
    private static final SdkField<String> ENTITY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EntityType").getter(getter(EntityDetail::entityType)).setter(setter(Builder::entityType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntityType").build()).build();

    private static final SdkField<String> ENTITY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EntityArn").getter(getter(EntityDetail::entityArn)).setter(setter(Builder::entityArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntityArn").build()).build();

    private static final SdkField<String> ENTITY_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EntityIdentifier").getter(getter(EntityDetail::entityIdentifier))
            .setter(setter(Builder::entityIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntityIdentifier").build()).build();

    private static final SdkField<String> LAST_MODIFIED_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LastModifiedDate").getter(getter(EntityDetail::lastModifiedDate))
            .setter(setter(Builder::lastModifiedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedDate").build()).build();

    private static final SdkField<Document> DETAILS_DOCUMENT_FIELD = SdkField.<Document> builder(MarshallingType.DOCUMENT)
            .memberName("DetailsDocument").getter(getter(EntityDetail::detailsDocument)).setter(setter(Builder::detailsDocument))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DetailsDocument").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTITY_TYPE_FIELD,
            ENTITY_ARN_FIELD, ENTITY_IDENTIFIER_FIELD, LAST_MODIFIED_DATE_FIELD, DETAILS_DOCUMENT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String entityType;

    private final String entityArn;

    private final String entityIdentifier;

    private final String lastModifiedDate;

    private final Document detailsDocument;

    private EntityDetail(BuilderImpl builder) {
        this.entityType = builder.entityType;
        this.entityArn = builder.entityArn;
        this.entityIdentifier = builder.entityIdentifier;
        this.lastModifiedDate = builder.lastModifiedDate;
        this.detailsDocument = builder.detailsDocument;
    }

    /**
     * <p>
     * The entity type of the entity, in the format of <code>EntityType@Version</code>.
     * </p>
     * 
     * @return The entity type of the entity, in the format of <code>EntityType@Version</code>.
     */
    public final String entityType() {
        return entityType;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the entity.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the entity.
     */
    public final String entityArn() {
        return entityArn;
    }

    /**
     * <p>
     * The ID of the entity, in the format of <code>EntityId@RevisionId</code>.
     * </p>
     * 
     * @return The ID of the entity, in the format of <code>EntityId@RevisionId</code>.
     */
    public final String entityIdentifier() {
        return entityIdentifier;
    }

    /**
     * <p>
     * The last time the entity was modified.
     * </p>
     * 
     * @return The last time the entity was modified.
     */
    public final String lastModifiedDate() {
        return lastModifiedDate;
    }

    /**
     * <p>
     * An object that contains all the details of the entity.
     * </p>
     * 
     * @return An object that contains all the details of the entity.
     */
    public final Document detailsDocument() {
        return detailsDocument;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(entityType());
        hashCode = 31 * hashCode + Objects.hashCode(entityArn());
        hashCode = 31 * hashCode + Objects.hashCode(entityIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(detailsDocument());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EntityDetail)) {
            return false;
        }
        EntityDetail other = (EntityDetail) obj;
        return Objects.equals(entityType(), other.entityType()) && Objects.equals(entityArn(), other.entityArn())
                && Objects.equals(entityIdentifier(), other.entityIdentifier())
                && Objects.equals(lastModifiedDate(), other.lastModifiedDate())
                && Objects.equals(detailsDocument(), other.detailsDocument());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EntityDetail").add("EntityType", entityType()).add("EntityArn", entityArn())
                .add("EntityIdentifier", entityIdentifier()).add("LastModifiedDate", lastModifiedDate())
                .add("DetailsDocument", detailsDocument()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EntityType":
            return Optional.ofNullable(clazz.cast(entityType()));
        case "EntityArn":
            return Optional.ofNullable(clazz.cast(entityArn()));
        case "EntityIdentifier":
            return Optional.ofNullable(clazz.cast(entityIdentifier()));
        case "LastModifiedDate":
            return Optional.ofNullable(clazz.cast(lastModifiedDate()));
        case "DetailsDocument":
            return Optional.ofNullable(clazz.cast(detailsDocument()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EntityDetail, T> g) {
        return obj -> g.apply((EntityDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EntityDetail> {
        /**
         * <p>
         * The entity type of the entity, in the format of <code>EntityType@Version</code>.
         * </p>
         * 
         * @param entityType
         *        The entity type of the entity, in the format of <code>EntityType@Version</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityType(String entityType);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the entity.
         * </p>
         * 
         * @param entityArn
         *        The Amazon Resource Name (ARN) of the entity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityArn(String entityArn);

        /**
         * <p>
         * The ID of the entity, in the format of <code>EntityId@RevisionId</code>.
         * </p>
         * 
         * @param entityIdentifier
         *        The ID of the entity, in the format of <code>EntityId@RevisionId</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityIdentifier(String entityIdentifier);

        /**
         * <p>
         * The last time the entity was modified.
         * </p>
         * 
         * @param lastModifiedDate
         *        The last time the entity was modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedDate(String lastModifiedDate);

        /**
         * <p>
         * An object that contains all the details of the entity.
         * </p>
         * 
         * @param detailsDocument
         *        An object that contains all the details of the entity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detailsDocument(Document detailsDocument);
    }

    static final class BuilderImpl implements Builder {
        private String entityType;

        private String entityArn;

        private String entityIdentifier;

        private String lastModifiedDate;

        private Document detailsDocument;

        private BuilderImpl() {
        }

        private BuilderImpl(EntityDetail model) {
            entityType(model.entityType);
            entityArn(model.entityArn);
            entityIdentifier(model.entityIdentifier);
            lastModifiedDate(model.lastModifiedDate);
            detailsDocument(model.detailsDocument);
        }

        public final String getEntityType() {
            return entityType;
        }

        public final void setEntityType(String entityType) {
            this.entityType = entityType;
        }

        @Override
        public final Builder entityType(String entityType) {
            this.entityType = entityType;
            return this;
        }

        public final String getEntityArn() {
            return entityArn;
        }

        public final void setEntityArn(String entityArn) {
            this.entityArn = entityArn;
        }

        @Override
        public final Builder entityArn(String entityArn) {
            this.entityArn = entityArn;
            return this;
        }

        public final String getEntityIdentifier() {
            return entityIdentifier;
        }

        public final void setEntityIdentifier(String entityIdentifier) {
            this.entityIdentifier = entityIdentifier;
        }

        @Override
        public final Builder entityIdentifier(String entityIdentifier) {
            this.entityIdentifier = entityIdentifier;
            return this;
        }

        public final String getLastModifiedDate() {
            return lastModifiedDate;
        }

        public final void setLastModifiedDate(String lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(String lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final Document getDetailsDocument() {
            return detailsDocument;
        }

        public final void setDetailsDocument(Document detailsDocument) {
            this.detailsDocument = detailsDocument;
        }

        @Override
        public final Builder detailsDocument(Document detailsDocument) {
            this.detailsDocument = detailsDocument;
            return this;
        }

        @Override
        public EntityDetail build() {
            return new EntityDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
