/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.marketplacecatalog.model;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;

@Generated("software.amazon.awssdk:codegen")
final class EntityDetailsCopier {
    static Map<String, EntityDetail> copy(Map<String, ? extends EntityDetail> entityDetailsParam) {
        Map<String, EntityDetail> map;
        if (entityDetailsParam == null || entityDetailsParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, EntityDetail> modifiableMap = new LinkedHashMap<>();
            entityDetailsParam.forEach((key, value) -> {
                modifiableMap.put(key, value);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, EntityDetail> copyFromBuilder(Map<String, ? extends EntityDetail.Builder> entityDetailsParam) {
        Map<String, EntityDetail> map;
        if (entityDetailsParam == null || entityDetailsParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, EntityDetail> modifiableMap = new LinkedHashMap<>();
            entityDetailsParam.forEach((key, value) -> {
                EntityDetail member = value == null ? null : value.build();
                modifiableMap.put(key, member);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, EntityDetail.Builder> copyToBuilder(Map<String, ? extends EntityDetail> entityDetailsParam) {
        Map<String, EntityDetail.Builder> map;
        if (entityDetailsParam == null || entityDetailsParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, EntityDetail.Builder> modifiableMap = new LinkedHashMap<>();
            entityDetailsParam.forEach((key, value) -> {
                EntityDetail.Builder member = value == null ? null : value.toBuilder();
                modifiableMap.put(key, member);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }
}
