/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.marketplacecatalog.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Object containing all the filter fields per entity type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EntityTypeFilters implements SdkPojo, Serializable,
        ToCopyableBuilder<EntityTypeFilters.Builder, EntityTypeFilters> {
    private static final SdkField<DataProductFilters> DATA_PRODUCT_FILTERS_FIELD = SdkField
            .<DataProductFilters> builder(MarshallingType.SDK_POJO).memberName("DataProductFilters")
            .getter(getter(EntityTypeFilters::dataProductFilters)).setter(setter(Builder::dataProductFilters))
            .constructor(DataProductFilters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataProductFilters").build())
            .build();

    private static final SdkField<SaaSProductFilters> SAA_S_PRODUCT_FILTERS_FIELD = SdkField
            .<SaaSProductFilters> builder(MarshallingType.SDK_POJO).memberName("SaaSProductFilters")
            .getter(getter(EntityTypeFilters::saaSProductFilters)).setter(setter(Builder::saaSProductFilters))
            .constructor(SaaSProductFilters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SaaSProductFilters").build())
            .build();

    private static final SdkField<AmiProductFilters> AMI_PRODUCT_FILTERS_FIELD = SdkField
            .<AmiProductFilters> builder(MarshallingType.SDK_POJO).memberName("AmiProductFilters")
            .getter(getter(EntityTypeFilters::amiProductFilters)).setter(setter(Builder::amiProductFilters))
            .constructor(AmiProductFilters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AmiProductFilters").build()).build();

    private static final SdkField<OfferFilters> OFFER_FILTERS_FIELD = SdkField.<OfferFilters> builder(MarshallingType.SDK_POJO)
            .memberName("OfferFilters").getter(getter(EntityTypeFilters::offerFilters)).setter(setter(Builder::offerFilters))
            .constructor(OfferFilters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OfferFilters").build()).build();

    private static final SdkField<ContainerProductFilters> CONTAINER_PRODUCT_FILTERS_FIELD = SdkField
            .<ContainerProductFilters> builder(MarshallingType.SDK_POJO).memberName("ContainerProductFilters")
            .getter(getter(EntityTypeFilters::containerProductFilters)).setter(setter(Builder::containerProductFilters))
            .constructor(ContainerProductFilters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContainerProductFilters").build())
            .build();

    private static final SdkField<ResaleAuthorizationFilters> RESALE_AUTHORIZATION_FILTERS_FIELD = SdkField
            .<ResaleAuthorizationFilters> builder(MarshallingType.SDK_POJO)
            .memberName("ResaleAuthorizationFilters")
            .getter(getter(EntityTypeFilters::resaleAuthorizationFilters))
            .setter(setter(Builder::resaleAuthorizationFilters))
            .constructor(ResaleAuthorizationFilters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResaleAuthorizationFilters").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_PRODUCT_FILTERS_FIELD,
            SAA_S_PRODUCT_FILTERS_FIELD, AMI_PRODUCT_FILTERS_FIELD, OFFER_FILTERS_FIELD, CONTAINER_PRODUCT_FILTERS_FIELD,
            RESALE_AUTHORIZATION_FILTERS_FIELD));

    private static final long serialVersionUID = 1L;

    private final DataProductFilters dataProductFilters;

    private final SaaSProductFilters saaSProductFilters;

    private final AmiProductFilters amiProductFilters;

    private final OfferFilters offerFilters;

    private final ContainerProductFilters containerProductFilters;

    private final ResaleAuthorizationFilters resaleAuthorizationFilters;

    private final Type type;

    private EntityTypeFilters(BuilderImpl builder) {
        this.dataProductFilters = builder.dataProductFilters;
        this.saaSProductFilters = builder.saaSProductFilters;
        this.amiProductFilters = builder.amiProductFilters;
        this.offerFilters = builder.offerFilters;
        this.containerProductFilters = builder.containerProductFilters;
        this.resaleAuthorizationFilters = builder.resaleAuthorizationFilters;
        this.type = builder.type;
    }

    /**
     * <p>
     * A filter for data products.
     * </p>
     * 
     * @return A filter for data products.
     */
    public final DataProductFilters dataProductFilters() {
        return dataProductFilters;
    }

    /**
     * <p>
     * A filter for SaaS products.
     * </p>
     * 
     * @return A filter for SaaS products.
     */
    public final SaaSProductFilters saaSProductFilters() {
        return saaSProductFilters;
    }

    /**
     * <p>
     * A filter for AMI products.
     * </p>
     * 
     * @return A filter for AMI products.
     */
    public final AmiProductFilters amiProductFilters() {
        return amiProductFilters;
    }

    /**
     * <p>
     * A filter for offers.
     * </p>
     * 
     * @return A filter for offers.
     */
    public final OfferFilters offerFilters() {
        return offerFilters;
    }

    /**
     * <p>
     * A filter for container products.
     * </p>
     * 
     * @return A filter for container products.
     */
    public final ContainerProductFilters containerProductFilters() {
        return containerProductFilters;
    }

    /**
     * <p>
     * A filter for Resale Authorizations.
     * </p>
     * 
     * @return A filter for Resale Authorizations.
     */
    public final ResaleAuthorizationFilters resaleAuthorizationFilters() {
        return resaleAuthorizationFilters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dataProductFilters());
        hashCode = 31 * hashCode + Objects.hashCode(saaSProductFilters());
        hashCode = 31 * hashCode + Objects.hashCode(amiProductFilters());
        hashCode = 31 * hashCode + Objects.hashCode(offerFilters());
        hashCode = 31 * hashCode + Objects.hashCode(containerProductFilters());
        hashCode = 31 * hashCode + Objects.hashCode(resaleAuthorizationFilters());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EntityTypeFilters)) {
            return false;
        }
        EntityTypeFilters other = (EntityTypeFilters) obj;
        return Objects.equals(dataProductFilters(), other.dataProductFilters())
                && Objects.equals(saaSProductFilters(), other.saaSProductFilters())
                && Objects.equals(amiProductFilters(), other.amiProductFilters())
                && Objects.equals(offerFilters(), other.offerFilters())
                && Objects.equals(containerProductFilters(), other.containerProductFilters())
                && Objects.equals(resaleAuthorizationFilters(), other.resaleAuthorizationFilters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EntityTypeFilters").add("DataProductFilters", dataProductFilters())
                .add("SaaSProductFilters", saaSProductFilters()).add("AmiProductFilters", amiProductFilters())
                .add("OfferFilters", offerFilters()).add("ContainerProductFilters", containerProductFilters())
                .add("ResaleAuthorizationFilters", resaleAuthorizationFilters()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DataProductFilters":
            return Optional.ofNullable(clazz.cast(dataProductFilters()));
        case "SaaSProductFilters":
            return Optional.ofNullable(clazz.cast(saaSProductFilters()));
        case "AmiProductFilters":
            return Optional.ofNullable(clazz.cast(amiProductFilters()));
        case "OfferFilters":
            return Optional.ofNullable(clazz.cast(offerFilters()));
        case "ContainerProductFilters":
            return Optional.ofNullable(clazz.cast(containerProductFilters()));
        case "ResaleAuthorizationFilters":
            return Optional.ofNullable(clazz.cast(resaleAuthorizationFilters()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #dataProductFilters()} initialized to the given value.
     *
     * <p>
     * A filter for data products.
     * </p>
     * 
     * @param dataProductFilters
     *        A filter for data products.
     */
    public static EntityTypeFilters fromDataProductFilters(DataProductFilters dataProductFilters) {
        return builder().dataProductFilters(dataProductFilters).build();
    }

    /**
     * Create an instance of this class with {@link #dataProductFilters()} initialized to the given value.
     *
     * <p>
     * A filter for data products.
     * </p>
     * 
     * @param dataProductFilters
     *        A filter for data products.
     */
    public static EntityTypeFilters fromDataProductFilters(Consumer<DataProductFilters.Builder> dataProductFilters) {
        DataProductFilters.Builder builder = DataProductFilters.builder();
        dataProductFilters.accept(builder);
        return fromDataProductFilters(builder.build());
    }

    /**
     * Create an instance of this class with {@link #saaSProductFilters()} initialized to the given value.
     *
     * <p>
     * A filter for SaaS products.
     * </p>
     * 
     * @param saaSProductFilters
     *        A filter for SaaS products.
     */
    public static EntityTypeFilters fromSaaSProductFilters(SaaSProductFilters saaSProductFilters) {
        return builder().saaSProductFilters(saaSProductFilters).build();
    }

    /**
     * Create an instance of this class with {@link #saaSProductFilters()} initialized to the given value.
     *
     * <p>
     * A filter for SaaS products.
     * </p>
     * 
     * @param saaSProductFilters
     *        A filter for SaaS products.
     */
    public static EntityTypeFilters fromSaaSProductFilters(Consumer<SaaSProductFilters.Builder> saaSProductFilters) {
        SaaSProductFilters.Builder builder = SaaSProductFilters.builder();
        saaSProductFilters.accept(builder);
        return fromSaaSProductFilters(builder.build());
    }

    /**
     * Create an instance of this class with {@link #amiProductFilters()} initialized to the given value.
     *
     * <p>
     * A filter for AMI products.
     * </p>
     * 
     * @param amiProductFilters
     *        A filter for AMI products.
     */
    public static EntityTypeFilters fromAmiProductFilters(AmiProductFilters amiProductFilters) {
        return builder().amiProductFilters(amiProductFilters).build();
    }

    /**
     * Create an instance of this class with {@link #amiProductFilters()} initialized to the given value.
     *
     * <p>
     * A filter for AMI products.
     * </p>
     * 
     * @param amiProductFilters
     *        A filter for AMI products.
     */
    public static EntityTypeFilters fromAmiProductFilters(Consumer<AmiProductFilters.Builder> amiProductFilters) {
        AmiProductFilters.Builder builder = AmiProductFilters.builder();
        amiProductFilters.accept(builder);
        return fromAmiProductFilters(builder.build());
    }

    /**
     * Create an instance of this class with {@link #offerFilters()} initialized to the given value.
     *
     * <p>
     * A filter for offers.
     * </p>
     * 
     * @param offerFilters
     *        A filter for offers.
     */
    public static EntityTypeFilters fromOfferFilters(OfferFilters offerFilters) {
        return builder().offerFilters(offerFilters).build();
    }

    /**
     * Create an instance of this class with {@link #offerFilters()} initialized to the given value.
     *
     * <p>
     * A filter for offers.
     * </p>
     * 
     * @param offerFilters
     *        A filter for offers.
     */
    public static EntityTypeFilters fromOfferFilters(Consumer<OfferFilters.Builder> offerFilters) {
        OfferFilters.Builder builder = OfferFilters.builder();
        offerFilters.accept(builder);
        return fromOfferFilters(builder.build());
    }

    /**
     * Create an instance of this class with {@link #containerProductFilters()} initialized to the given value.
     *
     * <p>
     * A filter for container products.
     * </p>
     * 
     * @param containerProductFilters
     *        A filter for container products.
     */
    public static EntityTypeFilters fromContainerProductFilters(ContainerProductFilters containerProductFilters) {
        return builder().containerProductFilters(containerProductFilters).build();
    }

    /**
     * Create an instance of this class with {@link #containerProductFilters()} initialized to the given value.
     *
     * <p>
     * A filter for container products.
     * </p>
     * 
     * @param containerProductFilters
     *        A filter for container products.
     */
    public static EntityTypeFilters fromContainerProductFilters(Consumer<ContainerProductFilters.Builder> containerProductFilters) {
        ContainerProductFilters.Builder builder = ContainerProductFilters.builder();
        containerProductFilters.accept(builder);
        return fromContainerProductFilters(builder.build());
    }

    /**
     * Create an instance of this class with {@link #resaleAuthorizationFilters()} initialized to the given value.
     *
     * <p>
     * A filter for Resale Authorizations.
     * </p>
     * 
     * @param resaleAuthorizationFilters
     *        A filter for Resale Authorizations.
     */
    public static EntityTypeFilters fromResaleAuthorizationFilters(ResaleAuthorizationFilters resaleAuthorizationFilters) {
        return builder().resaleAuthorizationFilters(resaleAuthorizationFilters).build();
    }

    /**
     * Create an instance of this class with {@link #resaleAuthorizationFilters()} initialized to the given value.
     *
     * <p>
     * A filter for Resale Authorizations.
     * </p>
     * 
     * @param resaleAuthorizationFilters
     *        A filter for Resale Authorizations.
     */
    public static EntityTypeFilters fromResaleAuthorizationFilters(
            Consumer<ResaleAuthorizationFilters.Builder> resaleAuthorizationFilters) {
        ResaleAuthorizationFilters.Builder builder = ResaleAuthorizationFilters.builder();
        resaleAuthorizationFilters.accept(builder);
        return fromResaleAuthorizationFilters(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EntityTypeFilters, T> g) {
        return obj -> g.apply((EntityTypeFilters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EntityTypeFilters> {
        /**
         * <p>
         * A filter for data products.
         * </p>
         * 
         * @param dataProductFilters
         *        A filter for data products.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataProductFilters(DataProductFilters dataProductFilters);

        /**
         * <p>
         * A filter for data products.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataProductFilters.Builder} avoiding the
         * need to create one manually via {@link DataProductFilters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataProductFilters.Builder#build()} is called immediately and its
         * result is passed to {@link #dataProductFilters(DataProductFilters)}.
         * 
         * @param dataProductFilters
         *        a consumer that will call methods on {@link DataProductFilters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataProductFilters(DataProductFilters)
         */
        default Builder dataProductFilters(Consumer<DataProductFilters.Builder> dataProductFilters) {
            return dataProductFilters(DataProductFilters.builder().applyMutation(dataProductFilters).build());
        }

        /**
         * <p>
         * A filter for SaaS products.
         * </p>
         * 
         * @param saaSProductFilters
         *        A filter for SaaS products.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder saaSProductFilters(SaaSProductFilters saaSProductFilters);

        /**
         * <p>
         * A filter for SaaS products.
         * </p>
         * This is a convenience method that creates an instance of the {@link SaaSProductFilters.Builder} avoiding the
         * need to create one manually via {@link SaaSProductFilters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SaaSProductFilters.Builder#build()} is called immediately and its
         * result is passed to {@link #saaSProductFilters(SaaSProductFilters)}.
         * 
         * @param saaSProductFilters
         *        a consumer that will call methods on {@link SaaSProductFilters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #saaSProductFilters(SaaSProductFilters)
         */
        default Builder saaSProductFilters(Consumer<SaaSProductFilters.Builder> saaSProductFilters) {
            return saaSProductFilters(SaaSProductFilters.builder().applyMutation(saaSProductFilters).build());
        }

        /**
         * <p>
         * A filter for AMI products.
         * </p>
         * 
         * @param amiProductFilters
         *        A filter for AMI products.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amiProductFilters(AmiProductFilters amiProductFilters);

        /**
         * <p>
         * A filter for AMI products.
         * </p>
         * This is a convenience method that creates an instance of the {@link AmiProductFilters.Builder} avoiding the
         * need to create one manually via {@link AmiProductFilters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AmiProductFilters.Builder#build()} is called immediately and its
         * result is passed to {@link #amiProductFilters(AmiProductFilters)}.
         * 
         * @param amiProductFilters
         *        a consumer that will call methods on {@link AmiProductFilters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #amiProductFilters(AmiProductFilters)
         */
        default Builder amiProductFilters(Consumer<AmiProductFilters.Builder> amiProductFilters) {
            return amiProductFilters(AmiProductFilters.builder().applyMutation(amiProductFilters).build());
        }

        /**
         * <p>
         * A filter for offers.
         * </p>
         * 
         * @param offerFilters
         *        A filter for offers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder offerFilters(OfferFilters offerFilters);

        /**
         * <p>
         * A filter for offers.
         * </p>
         * This is a convenience method that creates an instance of the {@link OfferFilters.Builder} avoiding the need
         * to create one manually via {@link OfferFilters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OfferFilters.Builder#build()} is called immediately and its
         * result is passed to {@link #offerFilters(OfferFilters)}.
         * 
         * @param offerFilters
         *        a consumer that will call methods on {@link OfferFilters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #offerFilters(OfferFilters)
         */
        default Builder offerFilters(Consumer<OfferFilters.Builder> offerFilters) {
            return offerFilters(OfferFilters.builder().applyMutation(offerFilters).build());
        }

        /**
         * <p>
         * A filter for container products.
         * </p>
         * 
         * @param containerProductFilters
         *        A filter for container products.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containerProductFilters(ContainerProductFilters containerProductFilters);

        /**
         * <p>
         * A filter for container products.
         * </p>
         * This is a convenience method that creates an instance of the {@link ContainerProductFilters.Builder} avoiding
         * the need to create one manually via {@link ContainerProductFilters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ContainerProductFilters.Builder#build()} is called immediately
         * and its result is passed to {@link #containerProductFilters(ContainerProductFilters)}.
         * 
         * @param containerProductFilters
         *        a consumer that will call methods on {@link ContainerProductFilters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #containerProductFilters(ContainerProductFilters)
         */
        default Builder containerProductFilters(Consumer<ContainerProductFilters.Builder> containerProductFilters) {
            return containerProductFilters(ContainerProductFilters.builder().applyMutation(containerProductFilters).build());
        }

        /**
         * <p>
         * A filter for Resale Authorizations.
         * </p>
         * 
         * @param resaleAuthorizationFilters
         *        A filter for Resale Authorizations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resaleAuthorizationFilters(ResaleAuthorizationFilters resaleAuthorizationFilters);

        /**
         * <p>
         * A filter for Resale Authorizations.
         * </p>
         * This is a convenience method that creates an instance of the {@link ResaleAuthorizationFilters.Builder}
         * avoiding the need to create one manually via {@link ResaleAuthorizationFilters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResaleAuthorizationFilters.Builder#build()} is called immediately
         * and its result is passed to {@link #resaleAuthorizationFilters(ResaleAuthorizationFilters)}.
         * 
         * @param resaleAuthorizationFilters
         *        a consumer that will call methods on {@link ResaleAuthorizationFilters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resaleAuthorizationFilters(ResaleAuthorizationFilters)
         */
        default Builder resaleAuthorizationFilters(Consumer<ResaleAuthorizationFilters.Builder> resaleAuthorizationFilters) {
            return resaleAuthorizationFilters(ResaleAuthorizationFilters.builder().applyMutation(resaleAuthorizationFilters)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private DataProductFilters dataProductFilters;

        private SaaSProductFilters saaSProductFilters;

        private AmiProductFilters amiProductFilters;

        private OfferFilters offerFilters;

        private ContainerProductFilters containerProductFilters;

        private ResaleAuthorizationFilters resaleAuthorizationFilters;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(EntityTypeFilters model) {
            dataProductFilters(model.dataProductFilters);
            saaSProductFilters(model.saaSProductFilters);
            amiProductFilters(model.amiProductFilters);
            offerFilters(model.offerFilters);
            containerProductFilters(model.containerProductFilters);
            resaleAuthorizationFilters(model.resaleAuthorizationFilters);
        }

        public final DataProductFilters.Builder getDataProductFilters() {
            return dataProductFilters != null ? dataProductFilters.toBuilder() : null;
        }

        public final void setDataProductFilters(DataProductFilters.BuilderImpl dataProductFilters) {
            Object oldValue = this.dataProductFilters;
            this.dataProductFilters = dataProductFilters != null ? dataProductFilters.build() : null;
            handleUnionValueChange(Type.DATA_PRODUCT_FILTERS, oldValue, this.dataProductFilters);
        }

        @Override
        public final Builder dataProductFilters(DataProductFilters dataProductFilters) {
            Object oldValue = this.dataProductFilters;
            this.dataProductFilters = dataProductFilters;
            handleUnionValueChange(Type.DATA_PRODUCT_FILTERS, oldValue, this.dataProductFilters);
            return this;
        }

        public final SaaSProductFilters.Builder getSaaSProductFilters() {
            return saaSProductFilters != null ? saaSProductFilters.toBuilder() : null;
        }

        public final void setSaaSProductFilters(SaaSProductFilters.BuilderImpl saaSProductFilters) {
            Object oldValue = this.saaSProductFilters;
            this.saaSProductFilters = saaSProductFilters != null ? saaSProductFilters.build() : null;
            handleUnionValueChange(Type.SAA_S_PRODUCT_FILTERS, oldValue, this.saaSProductFilters);
        }

        @Override
        public final Builder saaSProductFilters(SaaSProductFilters saaSProductFilters) {
            Object oldValue = this.saaSProductFilters;
            this.saaSProductFilters = saaSProductFilters;
            handleUnionValueChange(Type.SAA_S_PRODUCT_FILTERS, oldValue, this.saaSProductFilters);
            return this;
        }

        public final AmiProductFilters.Builder getAmiProductFilters() {
            return amiProductFilters != null ? amiProductFilters.toBuilder() : null;
        }

        public final void setAmiProductFilters(AmiProductFilters.BuilderImpl amiProductFilters) {
            Object oldValue = this.amiProductFilters;
            this.amiProductFilters = amiProductFilters != null ? amiProductFilters.build() : null;
            handleUnionValueChange(Type.AMI_PRODUCT_FILTERS, oldValue, this.amiProductFilters);
        }

        @Override
        public final Builder amiProductFilters(AmiProductFilters amiProductFilters) {
            Object oldValue = this.amiProductFilters;
            this.amiProductFilters = amiProductFilters;
            handleUnionValueChange(Type.AMI_PRODUCT_FILTERS, oldValue, this.amiProductFilters);
            return this;
        }

        public final OfferFilters.Builder getOfferFilters() {
            return offerFilters != null ? offerFilters.toBuilder() : null;
        }

        public final void setOfferFilters(OfferFilters.BuilderImpl offerFilters) {
            Object oldValue = this.offerFilters;
            this.offerFilters = offerFilters != null ? offerFilters.build() : null;
            handleUnionValueChange(Type.OFFER_FILTERS, oldValue, this.offerFilters);
        }

        @Override
        public final Builder offerFilters(OfferFilters offerFilters) {
            Object oldValue = this.offerFilters;
            this.offerFilters = offerFilters;
            handleUnionValueChange(Type.OFFER_FILTERS, oldValue, this.offerFilters);
            return this;
        }

        public final ContainerProductFilters.Builder getContainerProductFilters() {
            return containerProductFilters != null ? containerProductFilters.toBuilder() : null;
        }

        public final void setContainerProductFilters(ContainerProductFilters.BuilderImpl containerProductFilters) {
            Object oldValue = this.containerProductFilters;
            this.containerProductFilters = containerProductFilters != null ? containerProductFilters.build() : null;
            handleUnionValueChange(Type.CONTAINER_PRODUCT_FILTERS, oldValue, this.containerProductFilters);
        }

        @Override
        public final Builder containerProductFilters(ContainerProductFilters containerProductFilters) {
            Object oldValue = this.containerProductFilters;
            this.containerProductFilters = containerProductFilters;
            handleUnionValueChange(Type.CONTAINER_PRODUCT_FILTERS, oldValue, this.containerProductFilters);
            return this;
        }

        public final ResaleAuthorizationFilters.Builder getResaleAuthorizationFilters() {
            return resaleAuthorizationFilters != null ? resaleAuthorizationFilters.toBuilder() : null;
        }

        public final void setResaleAuthorizationFilters(ResaleAuthorizationFilters.BuilderImpl resaleAuthorizationFilters) {
            Object oldValue = this.resaleAuthorizationFilters;
            this.resaleAuthorizationFilters = resaleAuthorizationFilters != null ? resaleAuthorizationFilters.build() : null;
            handleUnionValueChange(Type.RESALE_AUTHORIZATION_FILTERS, oldValue, this.resaleAuthorizationFilters);
        }

        @Override
        public final Builder resaleAuthorizationFilters(ResaleAuthorizationFilters resaleAuthorizationFilters) {
            Object oldValue = this.resaleAuthorizationFilters;
            this.resaleAuthorizationFilters = resaleAuthorizationFilters;
            handleUnionValueChange(Type.RESALE_AUTHORIZATION_FILTERS, oldValue, this.resaleAuthorizationFilters);
            return this;
        }

        @Override
        public EntityTypeFilters build() {
            return new EntityTypeFilters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see EntityTypeFilters#type()
     */
    public enum Type {
        DATA_PRODUCT_FILTERS,

        SAA_S_PRODUCT_FILTERS,

        AMI_PRODUCT_FILTERS,

        OFFER_FILTERS,

        CONTAINER_PRODUCT_FILTERS,

        RESALE_AUTHORIZATION_FILTERS,

        UNKNOWN_TO_SDK_VERSION
    }
}
