/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.marketplacecatalog.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Object containing all the sort fields per entity type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EntityTypeSort implements SdkPojo, Serializable, ToCopyableBuilder<EntityTypeSort.Builder, EntityTypeSort> {
    private static final SdkField<DataProductSort> DATA_PRODUCT_SORT_FIELD = SdkField
            .<DataProductSort> builder(MarshallingType.SDK_POJO).memberName("DataProductSort")
            .getter(getter(EntityTypeSort::dataProductSort)).setter(setter(Builder::dataProductSort))
            .constructor(DataProductSort::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataProductSort").build()).build();

    private static final SdkField<SaaSProductSort> SAA_S_PRODUCT_SORT_FIELD = SdkField
            .<SaaSProductSort> builder(MarshallingType.SDK_POJO).memberName("SaaSProductSort")
            .getter(getter(EntityTypeSort::saaSProductSort)).setter(setter(Builder::saaSProductSort))
            .constructor(SaaSProductSort::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SaaSProductSort").build()).build();

    private static final SdkField<AmiProductSort> AMI_PRODUCT_SORT_FIELD = SdkField
            .<AmiProductSort> builder(MarshallingType.SDK_POJO).memberName("AmiProductSort")
            .getter(getter(EntityTypeSort::amiProductSort)).setter(setter(Builder::amiProductSort))
            .constructor(AmiProductSort::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AmiProductSort").build()).build();

    private static final SdkField<OfferSort> OFFER_SORT_FIELD = SdkField.<OfferSort> builder(MarshallingType.SDK_POJO)
            .memberName("OfferSort").getter(getter(EntityTypeSort::offerSort)).setter(setter(Builder::offerSort))
            .constructor(OfferSort::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OfferSort").build()).build();

    private static final SdkField<ContainerProductSort> CONTAINER_PRODUCT_SORT_FIELD = SdkField
            .<ContainerProductSort> builder(MarshallingType.SDK_POJO).memberName("ContainerProductSort")
            .getter(getter(EntityTypeSort::containerProductSort)).setter(setter(Builder::containerProductSort))
            .constructor(ContainerProductSort::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContainerProductSort").build())
            .build();

    private static final SdkField<ResaleAuthorizationSort> RESALE_AUTHORIZATION_SORT_FIELD = SdkField
            .<ResaleAuthorizationSort> builder(MarshallingType.SDK_POJO).memberName("ResaleAuthorizationSort")
            .getter(getter(EntityTypeSort::resaleAuthorizationSort)).setter(setter(Builder::resaleAuthorizationSort))
            .constructor(ResaleAuthorizationSort::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResaleAuthorizationSort").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_PRODUCT_SORT_FIELD,
            SAA_S_PRODUCT_SORT_FIELD, AMI_PRODUCT_SORT_FIELD, OFFER_SORT_FIELD, CONTAINER_PRODUCT_SORT_FIELD,
            RESALE_AUTHORIZATION_SORT_FIELD));

    private static final long serialVersionUID = 1L;

    private final DataProductSort dataProductSort;

    private final SaaSProductSort saaSProductSort;

    private final AmiProductSort amiProductSort;

    private final OfferSort offerSort;

    private final ContainerProductSort containerProductSort;

    private final ResaleAuthorizationSort resaleAuthorizationSort;

    private final Type type;

    private EntityTypeSort(BuilderImpl builder) {
        this.dataProductSort = builder.dataProductSort;
        this.saaSProductSort = builder.saaSProductSort;
        this.amiProductSort = builder.amiProductSort;
        this.offerSort = builder.offerSort;
        this.containerProductSort = builder.containerProductSort;
        this.resaleAuthorizationSort = builder.resaleAuthorizationSort;
        this.type = builder.type;
    }

    /**
     * <p>
     * A sort for data products.
     * </p>
     * 
     * @return A sort for data products.
     */
    public final DataProductSort dataProductSort() {
        return dataProductSort;
    }

    /**
     * <p>
     * A sort for SaaS products.
     * </p>
     * 
     * @return A sort for SaaS products.
     */
    public final SaaSProductSort saaSProductSort() {
        return saaSProductSort;
    }

    /**
     * <p>
     * A sort for AMI products.
     * </p>
     * 
     * @return A sort for AMI products.
     */
    public final AmiProductSort amiProductSort() {
        return amiProductSort;
    }

    /**
     * <p>
     * A sort for offers.
     * </p>
     * 
     * @return A sort for offers.
     */
    public final OfferSort offerSort() {
        return offerSort;
    }

    /**
     * <p>
     * A sort for container products.
     * </p>
     * 
     * @return A sort for container products.
     */
    public final ContainerProductSort containerProductSort() {
        return containerProductSort;
    }

    /**
     * <p>
     * A sort for Resale Authorizations.
     * </p>
     * 
     * @return A sort for Resale Authorizations.
     */
    public final ResaleAuthorizationSort resaleAuthorizationSort() {
        return resaleAuthorizationSort;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dataProductSort());
        hashCode = 31 * hashCode + Objects.hashCode(saaSProductSort());
        hashCode = 31 * hashCode + Objects.hashCode(amiProductSort());
        hashCode = 31 * hashCode + Objects.hashCode(offerSort());
        hashCode = 31 * hashCode + Objects.hashCode(containerProductSort());
        hashCode = 31 * hashCode + Objects.hashCode(resaleAuthorizationSort());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EntityTypeSort)) {
            return false;
        }
        EntityTypeSort other = (EntityTypeSort) obj;
        return Objects.equals(dataProductSort(), other.dataProductSort())
                && Objects.equals(saaSProductSort(), other.saaSProductSort())
                && Objects.equals(amiProductSort(), other.amiProductSort()) && Objects.equals(offerSort(), other.offerSort())
                && Objects.equals(containerProductSort(), other.containerProductSort())
                && Objects.equals(resaleAuthorizationSort(), other.resaleAuthorizationSort());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EntityTypeSort").add("DataProductSort", dataProductSort())
                .add("SaaSProductSort", saaSProductSort()).add("AmiProductSort", amiProductSort()).add("OfferSort", offerSort())
                .add("ContainerProductSort", containerProductSort()).add("ResaleAuthorizationSort", resaleAuthorizationSort())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DataProductSort":
            return Optional.ofNullable(clazz.cast(dataProductSort()));
        case "SaaSProductSort":
            return Optional.ofNullable(clazz.cast(saaSProductSort()));
        case "AmiProductSort":
            return Optional.ofNullable(clazz.cast(amiProductSort()));
        case "OfferSort":
            return Optional.ofNullable(clazz.cast(offerSort()));
        case "ContainerProductSort":
            return Optional.ofNullable(clazz.cast(containerProductSort()));
        case "ResaleAuthorizationSort":
            return Optional.ofNullable(clazz.cast(resaleAuthorizationSort()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #dataProductSort()} initialized to the given value.
     *
     * <p>
     * A sort for data products.
     * </p>
     * 
     * @param dataProductSort
     *        A sort for data products.
     */
    public static EntityTypeSort fromDataProductSort(DataProductSort dataProductSort) {
        return builder().dataProductSort(dataProductSort).build();
    }

    /**
     * Create an instance of this class with {@link #dataProductSort()} initialized to the given value.
     *
     * <p>
     * A sort for data products.
     * </p>
     * 
     * @param dataProductSort
     *        A sort for data products.
     */
    public static EntityTypeSort fromDataProductSort(Consumer<DataProductSort.Builder> dataProductSort) {
        DataProductSort.Builder builder = DataProductSort.builder();
        dataProductSort.accept(builder);
        return fromDataProductSort(builder.build());
    }

    /**
     * Create an instance of this class with {@link #saaSProductSort()} initialized to the given value.
     *
     * <p>
     * A sort for SaaS products.
     * </p>
     * 
     * @param saaSProductSort
     *        A sort for SaaS products.
     */
    public static EntityTypeSort fromSaaSProductSort(SaaSProductSort saaSProductSort) {
        return builder().saaSProductSort(saaSProductSort).build();
    }

    /**
     * Create an instance of this class with {@link #saaSProductSort()} initialized to the given value.
     *
     * <p>
     * A sort for SaaS products.
     * </p>
     * 
     * @param saaSProductSort
     *        A sort for SaaS products.
     */
    public static EntityTypeSort fromSaaSProductSort(Consumer<SaaSProductSort.Builder> saaSProductSort) {
        SaaSProductSort.Builder builder = SaaSProductSort.builder();
        saaSProductSort.accept(builder);
        return fromSaaSProductSort(builder.build());
    }

    /**
     * Create an instance of this class with {@link #amiProductSort()} initialized to the given value.
     *
     * <p>
     * A sort for AMI products.
     * </p>
     * 
     * @param amiProductSort
     *        A sort for AMI products.
     */
    public static EntityTypeSort fromAmiProductSort(AmiProductSort amiProductSort) {
        return builder().amiProductSort(amiProductSort).build();
    }

    /**
     * Create an instance of this class with {@link #amiProductSort()} initialized to the given value.
     *
     * <p>
     * A sort for AMI products.
     * </p>
     * 
     * @param amiProductSort
     *        A sort for AMI products.
     */
    public static EntityTypeSort fromAmiProductSort(Consumer<AmiProductSort.Builder> amiProductSort) {
        AmiProductSort.Builder builder = AmiProductSort.builder();
        amiProductSort.accept(builder);
        return fromAmiProductSort(builder.build());
    }

    /**
     * Create an instance of this class with {@link #offerSort()} initialized to the given value.
     *
     * <p>
     * A sort for offers.
     * </p>
     * 
     * @param offerSort
     *        A sort for offers.
     */
    public static EntityTypeSort fromOfferSort(OfferSort offerSort) {
        return builder().offerSort(offerSort).build();
    }

    /**
     * Create an instance of this class with {@link #offerSort()} initialized to the given value.
     *
     * <p>
     * A sort for offers.
     * </p>
     * 
     * @param offerSort
     *        A sort for offers.
     */
    public static EntityTypeSort fromOfferSort(Consumer<OfferSort.Builder> offerSort) {
        OfferSort.Builder builder = OfferSort.builder();
        offerSort.accept(builder);
        return fromOfferSort(builder.build());
    }

    /**
     * Create an instance of this class with {@link #containerProductSort()} initialized to the given value.
     *
     * <p>
     * A sort for container products.
     * </p>
     * 
     * @param containerProductSort
     *        A sort for container products.
     */
    public static EntityTypeSort fromContainerProductSort(ContainerProductSort containerProductSort) {
        return builder().containerProductSort(containerProductSort).build();
    }

    /**
     * Create an instance of this class with {@link #containerProductSort()} initialized to the given value.
     *
     * <p>
     * A sort for container products.
     * </p>
     * 
     * @param containerProductSort
     *        A sort for container products.
     */
    public static EntityTypeSort fromContainerProductSort(Consumer<ContainerProductSort.Builder> containerProductSort) {
        ContainerProductSort.Builder builder = ContainerProductSort.builder();
        containerProductSort.accept(builder);
        return fromContainerProductSort(builder.build());
    }

    /**
     * Create an instance of this class with {@link #resaleAuthorizationSort()} initialized to the given value.
     *
     * <p>
     * A sort for Resale Authorizations.
     * </p>
     * 
     * @param resaleAuthorizationSort
     *        A sort for Resale Authorizations.
     */
    public static EntityTypeSort fromResaleAuthorizationSort(ResaleAuthorizationSort resaleAuthorizationSort) {
        return builder().resaleAuthorizationSort(resaleAuthorizationSort).build();
    }

    /**
     * Create an instance of this class with {@link #resaleAuthorizationSort()} initialized to the given value.
     *
     * <p>
     * A sort for Resale Authorizations.
     * </p>
     * 
     * @param resaleAuthorizationSort
     *        A sort for Resale Authorizations.
     */
    public static EntityTypeSort fromResaleAuthorizationSort(Consumer<ResaleAuthorizationSort.Builder> resaleAuthorizationSort) {
        ResaleAuthorizationSort.Builder builder = ResaleAuthorizationSort.builder();
        resaleAuthorizationSort.accept(builder);
        return fromResaleAuthorizationSort(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EntityTypeSort, T> g) {
        return obj -> g.apply((EntityTypeSort) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EntityTypeSort> {
        /**
         * <p>
         * A sort for data products.
         * </p>
         * 
         * @param dataProductSort
         *        A sort for data products.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataProductSort(DataProductSort dataProductSort);

        /**
         * <p>
         * A sort for data products.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataProductSort.Builder} avoiding the
         * need to create one manually via {@link DataProductSort#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataProductSort.Builder#build()} is called immediately and its
         * result is passed to {@link #dataProductSort(DataProductSort)}.
         * 
         * @param dataProductSort
         *        a consumer that will call methods on {@link DataProductSort.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataProductSort(DataProductSort)
         */
        default Builder dataProductSort(Consumer<DataProductSort.Builder> dataProductSort) {
            return dataProductSort(DataProductSort.builder().applyMutation(dataProductSort).build());
        }

        /**
         * <p>
         * A sort for SaaS products.
         * </p>
         * 
         * @param saaSProductSort
         *        A sort for SaaS products.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder saaSProductSort(SaaSProductSort saaSProductSort);

        /**
         * <p>
         * A sort for SaaS products.
         * </p>
         * This is a convenience method that creates an instance of the {@link SaaSProductSort.Builder} avoiding the
         * need to create one manually via {@link SaaSProductSort#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SaaSProductSort.Builder#build()} is called immediately and its
         * result is passed to {@link #saaSProductSort(SaaSProductSort)}.
         * 
         * @param saaSProductSort
         *        a consumer that will call methods on {@link SaaSProductSort.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #saaSProductSort(SaaSProductSort)
         */
        default Builder saaSProductSort(Consumer<SaaSProductSort.Builder> saaSProductSort) {
            return saaSProductSort(SaaSProductSort.builder().applyMutation(saaSProductSort).build());
        }

        /**
         * <p>
         * A sort for AMI products.
         * </p>
         * 
         * @param amiProductSort
         *        A sort for AMI products.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amiProductSort(AmiProductSort amiProductSort);

        /**
         * <p>
         * A sort for AMI products.
         * </p>
         * This is a convenience method that creates an instance of the {@link AmiProductSort.Builder} avoiding the need
         * to create one manually via {@link AmiProductSort#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AmiProductSort.Builder#build()} is called immediately and its
         * result is passed to {@link #amiProductSort(AmiProductSort)}.
         * 
         * @param amiProductSort
         *        a consumer that will call methods on {@link AmiProductSort.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #amiProductSort(AmiProductSort)
         */
        default Builder amiProductSort(Consumer<AmiProductSort.Builder> amiProductSort) {
            return amiProductSort(AmiProductSort.builder().applyMutation(amiProductSort).build());
        }

        /**
         * <p>
         * A sort for offers.
         * </p>
         * 
         * @param offerSort
         *        A sort for offers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder offerSort(OfferSort offerSort);

        /**
         * <p>
         * A sort for offers.
         * </p>
         * This is a convenience method that creates an instance of the {@link OfferSort.Builder} avoiding the need to
         * create one manually via {@link OfferSort#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OfferSort.Builder#build()} is called immediately and its result
         * is passed to {@link #offerSort(OfferSort)}.
         * 
         * @param offerSort
         *        a consumer that will call methods on {@link OfferSort.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #offerSort(OfferSort)
         */
        default Builder offerSort(Consumer<OfferSort.Builder> offerSort) {
            return offerSort(OfferSort.builder().applyMutation(offerSort).build());
        }

        /**
         * <p>
         * A sort for container products.
         * </p>
         * 
         * @param containerProductSort
         *        A sort for container products.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containerProductSort(ContainerProductSort containerProductSort);

        /**
         * <p>
         * A sort for container products.
         * </p>
         * This is a convenience method that creates an instance of the {@link ContainerProductSort.Builder} avoiding
         * the need to create one manually via {@link ContainerProductSort#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ContainerProductSort.Builder#build()} is called immediately and
         * its result is passed to {@link #containerProductSort(ContainerProductSort)}.
         * 
         * @param containerProductSort
         *        a consumer that will call methods on {@link ContainerProductSort.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #containerProductSort(ContainerProductSort)
         */
        default Builder containerProductSort(Consumer<ContainerProductSort.Builder> containerProductSort) {
            return containerProductSort(ContainerProductSort.builder().applyMutation(containerProductSort).build());
        }

        /**
         * <p>
         * A sort for Resale Authorizations.
         * </p>
         * 
         * @param resaleAuthorizationSort
         *        A sort for Resale Authorizations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resaleAuthorizationSort(ResaleAuthorizationSort resaleAuthorizationSort);

        /**
         * <p>
         * A sort for Resale Authorizations.
         * </p>
         * This is a convenience method that creates an instance of the {@link ResaleAuthorizationSort.Builder} avoiding
         * the need to create one manually via {@link ResaleAuthorizationSort#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResaleAuthorizationSort.Builder#build()} is called immediately
         * and its result is passed to {@link #resaleAuthorizationSort(ResaleAuthorizationSort)}.
         * 
         * @param resaleAuthorizationSort
         *        a consumer that will call methods on {@link ResaleAuthorizationSort.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resaleAuthorizationSort(ResaleAuthorizationSort)
         */
        default Builder resaleAuthorizationSort(Consumer<ResaleAuthorizationSort.Builder> resaleAuthorizationSort) {
            return resaleAuthorizationSort(ResaleAuthorizationSort.builder().applyMutation(resaleAuthorizationSort).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private DataProductSort dataProductSort;

        private SaaSProductSort saaSProductSort;

        private AmiProductSort amiProductSort;

        private OfferSort offerSort;

        private ContainerProductSort containerProductSort;

        private ResaleAuthorizationSort resaleAuthorizationSort;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(EntityTypeSort model) {
            dataProductSort(model.dataProductSort);
            saaSProductSort(model.saaSProductSort);
            amiProductSort(model.amiProductSort);
            offerSort(model.offerSort);
            containerProductSort(model.containerProductSort);
            resaleAuthorizationSort(model.resaleAuthorizationSort);
        }

        public final DataProductSort.Builder getDataProductSort() {
            return dataProductSort != null ? dataProductSort.toBuilder() : null;
        }

        public final void setDataProductSort(DataProductSort.BuilderImpl dataProductSort) {
            Object oldValue = this.dataProductSort;
            this.dataProductSort = dataProductSort != null ? dataProductSort.build() : null;
            handleUnionValueChange(Type.DATA_PRODUCT_SORT, oldValue, this.dataProductSort);
        }

        @Override
        public final Builder dataProductSort(DataProductSort dataProductSort) {
            Object oldValue = this.dataProductSort;
            this.dataProductSort = dataProductSort;
            handleUnionValueChange(Type.DATA_PRODUCT_SORT, oldValue, this.dataProductSort);
            return this;
        }

        public final SaaSProductSort.Builder getSaaSProductSort() {
            return saaSProductSort != null ? saaSProductSort.toBuilder() : null;
        }

        public final void setSaaSProductSort(SaaSProductSort.BuilderImpl saaSProductSort) {
            Object oldValue = this.saaSProductSort;
            this.saaSProductSort = saaSProductSort != null ? saaSProductSort.build() : null;
            handleUnionValueChange(Type.SAA_S_PRODUCT_SORT, oldValue, this.saaSProductSort);
        }

        @Override
        public final Builder saaSProductSort(SaaSProductSort saaSProductSort) {
            Object oldValue = this.saaSProductSort;
            this.saaSProductSort = saaSProductSort;
            handleUnionValueChange(Type.SAA_S_PRODUCT_SORT, oldValue, this.saaSProductSort);
            return this;
        }

        public final AmiProductSort.Builder getAmiProductSort() {
            return amiProductSort != null ? amiProductSort.toBuilder() : null;
        }

        public final void setAmiProductSort(AmiProductSort.BuilderImpl amiProductSort) {
            Object oldValue = this.amiProductSort;
            this.amiProductSort = amiProductSort != null ? amiProductSort.build() : null;
            handleUnionValueChange(Type.AMI_PRODUCT_SORT, oldValue, this.amiProductSort);
        }

        @Override
        public final Builder amiProductSort(AmiProductSort amiProductSort) {
            Object oldValue = this.amiProductSort;
            this.amiProductSort = amiProductSort;
            handleUnionValueChange(Type.AMI_PRODUCT_SORT, oldValue, this.amiProductSort);
            return this;
        }

        public final OfferSort.Builder getOfferSort() {
            return offerSort != null ? offerSort.toBuilder() : null;
        }

        public final void setOfferSort(OfferSort.BuilderImpl offerSort) {
            Object oldValue = this.offerSort;
            this.offerSort = offerSort != null ? offerSort.build() : null;
            handleUnionValueChange(Type.OFFER_SORT, oldValue, this.offerSort);
        }

        @Override
        public final Builder offerSort(OfferSort offerSort) {
            Object oldValue = this.offerSort;
            this.offerSort = offerSort;
            handleUnionValueChange(Type.OFFER_SORT, oldValue, this.offerSort);
            return this;
        }

        public final ContainerProductSort.Builder getContainerProductSort() {
            return containerProductSort != null ? containerProductSort.toBuilder() : null;
        }

        public final void setContainerProductSort(ContainerProductSort.BuilderImpl containerProductSort) {
            Object oldValue = this.containerProductSort;
            this.containerProductSort = containerProductSort != null ? containerProductSort.build() : null;
            handleUnionValueChange(Type.CONTAINER_PRODUCT_SORT, oldValue, this.containerProductSort);
        }

        @Override
        public final Builder containerProductSort(ContainerProductSort containerProductSort) {
            Object oldValue = this.containerProductSort;
            this.containerProductSort = containerProductSort;
            handleUnionValueChange(Type.CONTAINER_PRODUCT_SORT, oldValue, this.containerProductSort);
            return this;
        }

        public final ResaleAuthorizationSort.Builder getResaleAuthorizationSort() {
            return resaleAuthorizationSort != null ? resaleAuthorizationSort.toBuilder() : null;
        }

        public final void setResaleAuthorizationSort(ResaleAuthorizationSort.BuilderImpl resaleAuthorizationSort) {
            Object oldValue = this.resaleAuthorizationSort;
            this.resaleAuthorizationSort = resaleAuthorizationSort != null ? resaleAuthorizationSort.build() : null;
            handleUnionValueChange(Type.RESALE_AUTHORIZATION_SORT, oldValue, this.resaleAuthorizationSort);
        }

        @Override
        public final Builder resaleAuthorizationSort(ResaleAuthorizationSort resaleAuthorizationSort) {
            Object oldValue = this.resaleAuthorizationSort;
            this.resaleAuthorizationSort = resaleAuthorizationSort;
            handleUnionValueChange(Type.RESALE_AUTHORIZATION_SORT, oldValue, this.resaleAuthorizationSort);
            return this;
        }

        @Override
        public EntityTypeSort build() {
            return new EntityTypeSort(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see EntityTypeSort#type()
     */
    public enum Type {
        DATA_PRODUCT_SORT,

        SAA_S_PRODUCT_SORT,

        AMI_PRODUCT_SORT,

        OFFER_SORT,

        CONTAINER_PRODUCT_SORT,

        RESALE_AUTHORIZATION_SORT,

        UNKNOWN_TO_SDK_VERSION
    }
}
