/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.marketplacecatalog.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A filter object, used to optionally filter results from calls to the <code>ListEntities</code> and
 * <code>ListChangeSets</code> actions.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Filter implements SdkPojo, Serializable, ToCopyableBuilder<Filter.Builder, Filter> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(Filter::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<List<String>> VALUE_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ValueList")
            .getter(getter(Filter::valueList))
            .setter(setter(Builder::valueList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValueList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, VALUE_LIST_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final List<String> valueList;

    private Filter(BuilderImpl builder) {
        this.name = builder.name;
        this.valueList = builder.valueList;
    }

    /**
     * <p>
     * For <code>ListEntities</code>, the supported value for this is an <code>EntityId</code>.
     * </p>
     * <p>
     * For <code>ListChangeSets</code>, the supported values are as follows:
     * </p>
     * 
     * @return For <code>ListEntities</code>, the supported value for this is an <code>EntityId</code>.</p>
     *         <p>
     *         For <code>ListChangeSets</code>, the supported values are as follows:
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the ValueList property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasValueList() {
        return valueList != null && !(valueList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * <code>ListEntities</code> - This is a list of unique <code>EntityId</code>s.
     * </p>
     * <p>
     * <code>ListChangeSets</code> - The supported filter names and associated <code>ValueList</code>s is as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ChangeSetName</code> - The supported <code>ValueList</code> is a list of non-unique
     * <code>ChangeSetName</code>s. These are defined when you call the <code>StartChangeSet</code> action.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Status</code> - The supported <code>ValueList</code> is a list of statuses for all change set requests.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>EntityId</code> - The supported <code>ValueList</code> is a list of unique <code>EntityId</code>s.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>BeforeStartTime</code> - The supported <code>ValueList</code> is a list of all change sets that started
     * before the filter value.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AfterStartTime</code> - The supported <code>ValueList</code> is a list of all change sets that started
     * after the filter value.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>BeforeEndTime</code> - The supported <code>ValueList</code> is a list of all change sets that ended before
     * the filter value.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AfterEndTime</code> - The supported <code>ValueList</code> is a list of all change sets that ended after
     * the filter value.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasValueList} method.
     * </p>
     * 
     * @return <code>ListEntities</code> - This is a list of unique <code>EntityId</code>s.</p>
     *         <p>
     *         <code>ListChangeSets</code> - The supported filter names and associated <code>ValueList</code>s is as
     *         follows:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ChangeSetName</code> - The supported <code>ValueList</code> is a list of non-unique
     *         <code>ChangeSetName</code>s. These are defined when you call the <code>StartChangeSet</code> action.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Status</code> - The supported <code>ValueList</code> is a list of statuses for all change set
     *         requests.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>EntityId</code> - The supported <code>ValueList</code> is a list of unique <code>EntityId</code>s.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>BeforeStartTime</code> - The supported <code>ValueList</code> is a list of all change sets that
     *         started before the filter value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AfterStartTime</code> - The supported <code>ValueList</code> is a list of all change sets that
     *         started after the filter value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>BeforeEndTime</code> - The supported <code>ValueList</code> is a list of all change sets that ended
     *         before the filter value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AfterEndTime</code> - The supported <code>ValueList</code> is a list of all change sets that ended
     *         after the filter value.
     *         </p>
     *         </li>
     */
    public final List<String> valueList() {
        return valueList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasValueList() ? valueList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Filter)) {
            return false;
        }
        Filter other = (Filter) obj;
        return Objects.equals(name(), other.name()) && hasValueList() == other.hasValueList()
                && Objects.equals(valueList(), other.valueList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Filter").add("Name", name()).add("ValueList", hasValueList() ? valueList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "ValueList":
            return Optional.ofNullable(clazz.cast(valueList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Filter, T> g) {
        return obj -> g.apply((Filter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Filter> {
        /**
         * <p>
         * For <code>ListEntities</code>, the supported value for this is an <code>EntityId</code>.
         * </p>
         * <p>
         * For <code>ListChangeSets</code>, the supported values are as follows:
         * </p>
         * 
         * @param name
         *        For <code>ListEntities</code>, the supported value for this is an <code>EntityId</code>.</p>
         *        <p>
         *        For <code>ListChangeSets</code>, the supported values are as follows:
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * <code>ListEntities</code> - This is a list of unique <code>EntityId</code>s.
         * </p>
         * <p>
         * <code>ListChangeSets</code> - The supported filter names and associated <code>ValueList</code>s is as
         * follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ChangeSetName</code> - The supported <code>ValueList</code> is a list of non-unique
         * <code>ChangeSetName</code>s. These are defined when you call the <code>StartChangeSet</code> action.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Status</code> - The supported <code>ValueList</code> is a list of statuses for all change set requests.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>EntityId</code> - The supported <code>ValueList</code> is a list of unique <code>EntityId</code>s.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>BeforeStartTime</code> - The supported <code>ValueList</code> is a list of all change sets that started
         * before the filter value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AfterStartTime</code> - The supported <code>ValueList</code> is a list of all change sets that started
         * after the filter value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>BeforeEndTime</code> - The supported <code>ValueList</code> is a list of all change sets that ended
         * before the filter value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AfterEndTime</code> - The supported <code>ValueList</code> is a list of all change sets that ended
         * after the filter value.
         * </p>
         * </li>
         * </ul>
         * 
         * @param valueList
         *        <code>ListEntities</code> - This is a list of unique <code>EntityId</code>s.</p>
         *        <p>
         *        <code>ListChangeSets</code> - The supported filter names and associated <code>ValueList</code>s is as
         *        follows:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ChangeSetName</code> - The supported <code>ValueList</code> is a list of non-unique
         *        <code>ChangeSetName</code>s. These are defined when you call the <code>StartChangeSet</code> action.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Status</code> - The supported <code>ValueList</code> is a list of statuses for all change set
         *        requests.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>EntityId</code> - The supported <code>ValueList</code> is a list of unique <code>EntityId</code>
         *        s.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>BeforeStartTime</code> - The supported <code>ValueList</code> is a list of all change sets that
         *        started before the filter value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AfterStartTime</code> - The supported <code>ValueList</code> is a list of all change sets that
         *        started after the filter value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>BeforeEndTime</code> - The supported <code>ValueList</code> is a list of all change sets that
         *        ended before the filter value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AfterEndTime</code> - The supported <code>ValueList</code> is a list of all change sets that
         *        ended after the filter value.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder valueList(Collection<String> valueList);

        /**
         * <p>
         * <code>ListEntities</code> - This is a list of unique <code>EntityId</code>s.
         * </p>
         * <p>
         * <code>ListChangeSets</code> - The supported filter names and associated <code>ValueList</code>s is as
         * follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ChangeSetName</code> - The supported <code>ValueList</code> is a list of non-unique
         * <code>ChangeSetName</code>s. These are defined when you call the <code>StartChangeSet</code> action.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Status</code> - The supported <code>ValueList</code> is a list of statuses for all change set requests.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>EntityId</code> - The supported <code>ValueList</code> is a list of unique <code>EntityId</code>s.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>BeforeStartTime</code> - The supported <code>ValueList</code> is a list of all change sets that started
         * before the filter value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AfterStartTime</code> - The supported <code>ValueList</code> is a list of all change sets that started
         * after the filter value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>BeforeEndTime</code> - The supported <code>ValueList</code> is a list of all change sets that ended
         * before the filter value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AfterEndTime</code> - The supported <code>ValueList</code> is a list of all change sets that ended
         * after the filter value.
         * </p>
         * </li>
         * </ul>
         * 
         * @param valueList
         *        <code>ListEntities</code> - This is a list of unique <code>EntityId</code>s.</p>
         *        <p>
         *        <code>ListChangeSets</code> - The supported filter names and associated <code>ValueList</code>s is as
         *        follows:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ChangeSetName</code> - The supported <code>ValueList</code> is a list of non-unique
         *        <code>ChangeSetName</code>s. These are defined when you call the <code>StartChangeSet</code> action.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Status</code> - The supported <code>ValueList</code> is a list of statuses for all change set
         *        requests.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>EntityId</code> - The supported <code>ValueList</code> is a list of unique <code>EntityId</code>
         *        s.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>BeforeStartTime</code> - The supported <code>ValueList</code> is a list of all change sets that
         *        started before the filter value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AfterStartTime</code> - The supported <code>ValueList</code> is a list of all change sets that
         *        started after the filter value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>BeforeEndTime</code> - The supported <code>ValueList</code> is a list of all change sets that
         *        ended before the filter value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AfterEndTime</code> - The supported <code>ValueList</code> is a list of all change sets that
         *        ended after the filter value.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder valueList(String... valueList);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private List<String> valueList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Filter model) {
            name(model.name);
            valueList(model.valueList);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Collection<String> getValueList() {
            if (valueList instanceof SdkAutoConstructList) {
                return null;
            }
            return valueList;
        }

        public final void setValueList(Collection<String> valueList) {
            this.valueList = ValueListCopier.copy(valueList);
        }

        @Override
        public final Builder valueList(Collection<String> valueList) {
            this.valueList = ValueListCopier.copy(valueList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder valueList(String... valueList) {
            valueList(Arrays.asList(valueList));
            return this;
        }

        @Override
        public Filter build() {
            return new Filter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
