/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.marketplacecatalog.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListEntitiesResponse extends MarketplaceCatalogResponse implements
        ToCopyableBuilder<ListEntitiesResponse.Builder, ListEntitiesResponse> {
    private static final SdkField<List<EntitySummary>> ENTITY_SUMMARY_LIST_FIELD = SdkField
            .<List<EntitySummary>> builder(MarshallingType.LIST)
            .memberName("EntitySummaryList")
            .getter(getter(ListEntitiesResponse::entitySummaryList))
            .setter(setter(Builder::entitySummaryList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntitySummaryList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EntitySummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(EntitySummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListEntitiesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTITY_SUMMARY_LIST_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<EntitySummary> entitySummaryList;

    private final String nextToken;

    private ListEntitiesResponse(BuilderImpl builder) {
        super(builder);
        this.entitySummaryList = builder.entitySummaryList;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the EntitySummaryList property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEntitySummaryList() {
        return entitySummaryList != null && !(entitySummaryList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Array of <code>EntitySummary</code> objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEntitySummaryList} method.
     * </p>
     * 
     * @return Array of <code>EntitySummary</code> objects.
     */
    public final List<EntitySummary> entitySummaryList() {
        return entitySummaryList;
    }

    /**
     * <p>
     * The value of the next token if it exists. Null if there is no more result.
     * </p>
     * 
     * @return The value of the next token if it exists. Null if there is no more result.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasEntitySummaryList() ? entitySummaryList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEntitiesResponse)) {
            return false;
        }
        ListEntitiesResponse other = (ListEntitiesResponse) obj;
        return hasEntitySummaryList() == other.hasEntitySummaryList()
                && Objects.equals(entitySummaryList(), other.entitySummaryList())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListEntitiesResponse")
                .add("EntitySummaryList", hasEntitySummaryList() ? entitySummaryList() : null).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EntitySummaryList":
            return Optional.ofNullable(clazz.cast(entitySummaryList()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListEntitiesResponse, T> g) {
        return obj -> g.apply((ListEntitiesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MarketplaceCatalogResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListEntitiesResponse> {
        /**
         * <p>
         * Array of <code>EntitySummary</code> objects.
         * </p>
         * 
         * @param entitySummaryList
         *        Array of <code>EntitySummary</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entitySummaryList(Collection<EntitySummary> entitySummaryList);

        /**
         * <p>
         * Array of <code>EntitySummary</code> objects.
         * </p>
         * 
         * @param entitySummaryList
         *        Array of <code>EntitySummary</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entitySummaryList(EntitySummary... entitySummaryList);

        /**
         * <p>
         * Array of <code>EntitySummary</code> objects.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.marketplacecatalog.model.EntitySummary.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.marketplacecatalog.model.EntitySummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.marketplacecatalog.model.EntitySummary.Builder#build()} is called
         * immediately and its result is passed to {@link #entitySummaryList(List<EntitySummary>)}.
         * 
         * @param entitySummaryList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.marketplacecatalog.model.EntitySummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #entitySummaryList(java.util.Collection<EntitySummary>)
         */
        Builder entitySummaryList(Consumer<EntitySummary.Builder>... entitySummaryList);

        /**
         * <p>
         * The value of the next token if it exists. Null if there is no more result.
         * </p>
         * 
         * @param nextToken
         *        The value of the next token if it exists. Null if there is no more result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends MarketplaceCatalogResponse.BuilderImpl implements Builder {
        private List<EntitySummary> entitySummaryList = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListEntitiesResponse model) {
            super(model);
            entitySummaryList(model.entitySummaryList);
            nextToken(model.nextToken);
        }

        public final List<EntitySummary.Builder> getEntitySummaryList() {
            List<EntitySummary.Builder> result = EntitySummaryListCopier.copyToBuilder(this.entitySummaryList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEntitySummaryList(Collection<EntitySummary.BuilderImpl> entitySummaryList) {
            this.entitySummaryList = EntitySummaryListCopier.copyFromBuilder(entitySummaryList);
        }

        @Override
        public final Builder entitySummaryList(Collection<EntitySummary> entitySummaryList) {
            this.entitySummaryList = EntitySummaryListCopier.copy(entitySummaryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entitySummaryList(EntitySummary... entitySummaryList) {
            entitySummaryList(Arrays.asList(entitySummaryList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entitySummaryList(Consumer<EntitySummary.Builder>... entitySummaryList) {
            entitySummaryList(Stream.of(entitySummaryList).map(c -> EntitySummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListEntitiesResponse build() {
            return new ListEntitiesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
