/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.marketplacecatalog.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Allows filtering on the <code>AvailabilityEndDate</code> of an offer.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OfferAvailabilityEndDateFilter implements SdkPojo, Serializable,
        ToCopyableBuilder<OfferAvailabilityEndDateFilter.Builder, OfferAvailabilityEndDateFilter> {
    private static final SdkField<OfferAvailabilityEndDateFilterDateRange> DATE_RANGE_FIELD = SdkField
            .<OfferAvailabilityEndDateFilterDateRange> builder(MarshallingType.SDK_POJO).memberName("DateRange")
            .getter(getter(OfferAvailabilityEndDateFilter::dateRange)).setter(setter(Builder::dateRange))
            .constructor(OfferAvailabilityEndDateFilterDateRange::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DateRange").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATE_RANGE_FIELD));

    private static final long serialVersionUID = 1L;

    private final OfferAvailabilityEndDateFilterDateRange dateRange;

    private OfferAvailabilityEndDateFilter(BuilderImpl builder) {
        this.dateRange = builder.dateRange;
    }

    /**
     * <p>
     * Allows filtering on the <code>AvailabilityEndDate</code> of an offer with date range as input.
     * </p>
     * 
     * @return Allows filtering on the <code>AvailabilityEndDate</code> of an offer with date range as input.
     */
    public final OfferAvailabilityEndDateFilterDateRange dateRange() {
        return dateRange;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dateRange());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OfferAvailabilityEndDateFilter)) {
            return false;
        }
        OfferAvailabilityEndDateFilter other = (OfferAvailabilityEndDateFilter) obj;
        return Objects.equals(dateRange(), other.dateRange());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OfferAvailabilityEndDateFilter").add("DateRange", dateRange()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DateRange":
            return Optional.ofNullable(clazz.cast(dateRange()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OfferAvailabilityEndDateFilter, T> g) {
        return obj -> g.apply((OfferAvailabilityEndDateFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OfferAvailabilityEndDateFilter> {
        /**
         * <p>
         * Allows filtering on the <code>AvailabilityEndDate</code> of an offer with date range as input.
         * </p>
         * 
         * @param dateRange
         *        Allows filtering on the <code>AvailabilityEndDate</code> of an offer with date range as input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dateRange(OfferAvailabilityEndDateFilterDateRange dateRange);

        /**
         * <p>
         * Allows filtering on the <code>AvailabilityEndDate</code> of an offer with date range as input.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link OfferAvailabilityEndDateFilterDateRange.Builder} avoiding the need to create one manually via
         * {@link OfferAvailabilityEndDateFilterDateRange#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OfferAvailabilityEndDateFilterDateRange.Builder#build()} is
         * called immediately and its result is passed to {@link #dateRange(OfferAvailabilityEndDateFilterDateRange)}.
         * 
         * @param dateRange
         *        a consumer that will call methods on {@link OfferAvailabilityEndDateFilterDateRange.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dateRange(OfferAvailabilityEndDateFilterDateRange)
         */
        default Builder dateRange(Consumer<OfferAvailabilityEndDateFilterDateRange.Builder> dateRange) {
            return dateRange(OfferAvailabilityEndDateFilterDateRange.builder().applyMutation(dateRange).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private OfferAvailabilityEndDateFilterDateRange dateRange;

        private BuilderImpl() {
        }

        private BuilderImpl(OfferAvailabilityEndDateFilter model) {
            dateRange(model.dateRange);
        }

        public final OfferAvailabilityEndDateFilterDateRange.Builder getDateRange() {
            return dateRange != null ? dateRange.toBuilder() : null;
        }

        public final void setDateRange(OfferAvailabilityEndDateFilterDateRange.BuilderImpl dateRange) {
            this.dateRange = dateRange != null ? dateRange.build() : null;
        }

        @Override
        public final Builder dateRange(OfferAvailabilityEndDateFilterDateRange dateRange) {
            this.dateRange = dateRange;
            return this;
        }

        @Override
        public OfferAvailabilityEndDateFilter build() {
            return new OfferAvailabilityEndDateFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
