/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.marketplacecatalog.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Allows filtering on <code>CreatedDate</code> of a ResaleAuthorization with date range as input.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResaleAuthorizationCreatedDateFilterDateRange implements SdkPojo, Serializable,
        ToCopyableBuilder<ResaleAuthorizationCreatedDateFilterDateRange.Builder, ResaleAuthorizationCreatedDateFilterDateRange> {
    private static final SdkField<String> AFTER_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AfterValue").getter(getter(ResaleAuthorizationCreatedDateFilterDateRange::afterValue))
            .setter(setter(Builder::afterValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AfterValue").build()).build();

    private static final SdkField<String> BEFORE_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BeforeValue").getter(getter(ResaleAuthorizationCreatedDateFilterDateRange::beforeValue))
            .setter(setter(Builder::beforeValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BeforeValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AFTER_VALUE_FIELD,
            BEFORE_VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String afterValue;

    private final String beforeValue;

    private ResaleAuthorizationCreatedDateFilterDateRange(BuilderImpl builder) {
        this.afterValue = builder.afterValue;
        this.beforeValue = builder.beforeValue;
    }

    /**
     * <p>
     * Allows filtering on <code>CreatedDate</code> of a ResaleAuthorization after a date.
     * </p>
     * 
     * @return Allows filtering on <code>CreatedDate</code> of a ResaleAuthorization after a date.
     */
    public final String afterValue() {
        return afterValue;
    }

    /**
     * <p>
     * Allows filtering on <code>CreatedDate</code> of a ResaleAuthorization before a date.
     * </p>
     * 
     * @return Allows filtering on <code>CreatedDate</code> of a ResaleAuthorization before a date.
     */
    public final String beforeValue() {
        return beforeValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(afterValue());
        hashCode = 31 * hashCode + Objects.hashCode(beforeValue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResaleAuthorizationCreatedDateFilterDateRange)) {
            return false;
        }
        ResaleAuthorizationCreatedDateFilterDateRange other = (ResaleAuthorizationCreatedDateFilterDateRange) obj;
        return Objects.equals(afterValue(), other.afterValue()) && Objects.equals(beforeValue(), other.beforeValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResaleAuthorizationCreatedDateFilterDateRange").add("AfterValue", afterValue())
                .add("BeforeValue", beforeValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AfterValue":
            return Optional.ofNullable(clazz.cast(afterValue()));
        case "BeforeValue":
            return Optional.ofNullable(clazz.cast(beforeValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResaleAuthorizationCreatedDateFilterDateRange, T> g) {
        return obj -> g.apply((ResaleAuthorizationCreatedDateFilterDateRange) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResaleAuthorizationCreatedDateFilterDateRange> {
        /**
         * <p>
         * Allows filtering on <code>CreatedDate</code> of a ResaleAuthorization after a date.
         * </p>
         * 
         * @param afterValue
         *        Allows filtering on <code>CreatedDate</code> of a ResaleAuthorization after a date.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder afterValue(String afterValue);

        /**
         * <p>
         * Allows filtering on <code>CreatedDate</code> of a ResaleAuthorization before a date.
         * </p>
         * 
         * @param beforeValue
         *        Allows filtering on <code>CreatedDate</code> of a ResaleAuthorization before a date.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder beforeValue(String beforeValue);
    }

    static final class BuilderImpl implements Builder {
        private String afterValue;

        private String beforeValue;

        private BuilderImpl() {
        }

        private BuilderImpl(ResaleAuthorizationCreatedDateFilterDateRange model) {
            afterValue(model.afterValue);
            beforeValue(model.beforeValue);
        }

        public final String getAfterValue() {
            return afterValue;
        }

        public final void setAfterValue(String afterValue) {
            this.afterValue = afterValue;
        }

        @Override
        public final Builder afterValue(String afterValue) {
            this.afterValue = afterValue;
            return this;
        }

        public final String getBeforeValue() {
            return beforeValue;
        }

        public final void setBeforeValue(String beforeValue) {
            this.beforeValue = beforeValue;
        }

        @Override
        public final Builder beforeValue(String beforeValue) {
            this.beforeValue = beforeValue;
            return this;
        }

        @Override
        public ResaleAuthorizationCreatedDateFilterDateRange build() {
            return new ResaleAuthorizationCreatedDateFilterDateRange(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
