/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.marketplacecatalog.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summarized information about a Resale Authorization.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResaleAuthorizationSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ResaleAuthorizationSummary.Builder, ResaleAuthorizationSummary> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(ResaleAuthorizationSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> PRODUCT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProductId").getter(getter(ResaleAuthorizationSummary::productId)).setter(setter(Builder::productId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductId").build()).build();

    private static final SdkField<String> PRODUCT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProductName").getter(getter(ResaleAuthorizationSummary::productName))
            .setter(setter(Builder::productName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductName").build()).build();

    private static final SdkField<String> MANUFACTURER_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ManufacturerAccountId").getter(getter(ResaleAuthorizationSummary::manufacturerAccountId))
            .setter(setter(Builder::manufacturerAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManufacturerAccountId").build())
            .build();

    private static final SdkField<String> MANUFACTURER_LEGAL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ManufacturerLegalName").getter(getter(ResaleAuthorizationSummary::manufacturerLegalName))
            .setter(setter(Builder::manufacturerLegalName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManufacturerLegalName").build())
            .build();

    private static final SdkField<String> RESELLER_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResellerAccountID").getter(getter(ResaleAuthorizationSummary::resellerAccountID))
            .setter(setter(Builder::resellerAccountID))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResellerAccountID").build()).build();

    private static final SdkField<String> RESELLER_LEGAL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResellerLegalName").getter(getter(ResaleAuthorizationSummary::resellerLegalName))
            .setter(setter(Builder::resellerLegalName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResellerLegalName").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(ResaleAuthorizationSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> OFFER_EXTENDED_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OfferExtendedStatus").getter(getter(ResaleAuthorizationSummary::offerExtendedStatus))
            .setter(setter(Builder::offerExtendedStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OfferExtendedStatus").build())
            .build();

    private static final SdkField<String> CREATED_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreatedDate").getter(getter(ResaleAuthorizationSummary::createdDate))
            .setter(setter(Builder::createdDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedDate").build()).build();

    private static final SdkField<String> AVAILABILITY_END_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AvailabilityEndDate").getter(getter(ResaleAuthorizationSummary::availabilityEndDate))
            .setter(setter(Builder::availabilityEndDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityEndDate").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(NAME_FIELD, PRODUCT_ID_FIELD, PRODUCT_NAME_FIELD, MANUFACTURER_ACCOUNT_ID_FIELD,
                    MANUFACTURER_LEGAL_NAME_FIELD, RESELLER_ACCOUNT_ID_FIELD, RESELLER_LEGAL_NAME_FIELD, STATUS_FIELD,
                    OFFER_EXTENDED_STATUS_FIELD, CREATED_DATE_FIELD, AVAILABILITY_END_DATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String productId;

    private final String productName;

    private final String manufacturerAccountId;

    private final String manufacturerLegalName;

    private final String resellerAccountID;

    private final String resellerLegalName;

    private final String status;

    private final String offerExtendedStatus;

    private final String createdDate;

    private final String availabilityEndDate;

    private ResaleAuthorizationSummary(BuilderImpl builder) {
        this.name = builder.name;
        this.productId = builder.productId;
        this.productName = builder.productName;
        this.manufacturerAccountId = builder.manufacturerAccountId;
        this.manufacturerLegalName = builder.manufacturerLegalName;
        this.resellerAccountID = builder.resellerAccountID;
        this.resellerLegalName = builder.resellerLegalName;
        this.status = builder.status;
        this.offerExtendedStatus = builder.offerExtendedStatus;
        this.createdDate = builder.createdDate;
        this.availabilityEndDate = builder.availabilityEndDate;
    }

    /**
     * <p>
     * The name of the ResaleAuthorization.
     * </p>
     * 
     * @return The name of the ResaleAuthorization.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The product ID of the ResaleAuthorization.
     * </p>
     * 
     * @return The product ID of the ResaleAuthorization.
     */
    public final String productId() {
        return productId;
    }

    /**
     * <p>
     * The product name of the ResaleAuthorization.
     * </p>
     * 
     * @return The product name of the ResaleAuthorization.
     */
    public final String productName() {
        return productName;
    }

    /**
     * <p>
     * The manufacturer account ID of the ResaleAuthorization.
     * </p>
     * 
     * @return The manufacturer account ID of the ResaleAuthorization.
     */
    public final String manufacturerAccountId() {
        return manufacturerAccountId;
    }

    /**
     * <p>
     * The manufacturer legal name of the ResaleAuthorization.
     * </p>
     * 
     * @return The manufacturer legal name of the ResaleAuthorization.
     */
    public final String manufacturerLegalName() {
        return manufacturerLegalName;
    }

    /**
     * <p>
     * The reseller account ID of the ResaleAuthorization.
     * </p>
     * 
     * @return The reseller account ID of the ResaleAuthorization.
     */
    public final String resellerAccountID() {
        return resellerAccountID;
    }

    /**
     * <p>
     * The reseller legal name of the ResaleAuthorization
     * </p>
     * 
     * @return The reseller legal name of the ResaleAuthorization
     */
    public final String resellerLegalName() {
        return resellerLegalName;
    }

    /**
     * <p>
     * The status of the ResaleAuthorization.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ResaleAuthorizationStatusString#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the ResaleAuthorization.
     * @see ResaleAuthorizationStatusString
     */
    public final ResaleAuthorizationStatusString status() {
        return ResaleAuthorizationStatusString.fromValue(status);
    }

    /**
     * <p>
     * The status of the ResaleAuthorization.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ResaleAuthorizationStatusString#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the ResaleAuthorization.
     * @see ResaleAuthorizationStatusString
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The offer extended status of the ResaleAuthorization
     * </p>
     * 
     * @return The offer extended status of the ResaleAuthorization
     */
    public final String offerExtendedStatus() {
        return offerExtendedStatus;
    }

    /**
     * <p>
     * The created date of the ResaleAuthorization.
     * </p>
     * 
     * @return The created date of the ResaleAuthorization.
     */
    public final String createdDate() {
        return createdDate;
    }

    /**
     * <p>
     * The availability end date of the ResaleAuthorization.
     * </p>
     * 
     * @return The availability end date of the ResaleAuthorization.
     */
    public final String availabilityEndDate() {
        return availabilityEndDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(productId());
        hashCode = 31 * hashCode + Objects.hashCode(productName());
        hashCode = 31 * hashCode + Objects.hashCode(manufacturerAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(manufacturerLegalName());
        hashCode = 31 * hashCode + Objects.hashCode(resellerAccountID());
        hashCode = 31 * hashCode + Objects.hashCode(resellerLegalName());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(offerExtendedStatus());
        hashCode = 31 * hashCode + Objects.hashCode(createdDate());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityEndDate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResaleAuthorizationSummary)) {
            return false;
        }
        ResaleAuthorizationSummary other = (ResaleAuthorizationSummary) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(productId(), other.productId())
                && Objects.equals(productName(), other.productName())
                && Objects.equals(manufacturerAccountId(), other.manufacturerAccountId())
                && Objects.equals(manufacturerLegalName(), other.manufacturerLegalName())
                && Objects.equals(resellerAccountID(), other.resellerAccountID())
                && Objects.equals(resellerLegalName(), other.resellerLegalName())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(offerExtendedStatus(), other.offerExtendedStatus())
                && Objects.equals(createdDate(), other.createdDate())
                && Objects.equals(availabilityEndDate(), other.availabilityEndDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResaleAuthorizationSummary").add("Name", name()).add("ProductId", productId())
                .add("ProductName", productName()).add("ManufacturerAccountId", manufacturerAccountId())
                .add("ManufacturerLegalName", manufacturerLegalName()).add("ResellerAccountID", resellerAccountID())
                .add("ResellerLegalName", resellerLegalName()).add("Status", statusAsString())
                .add("OfferExtendedStatus", offerExtendedStatus()).add("CreatedDate", createdDate())
                .add("AvailabilityEndDate", availabilityEndDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "ProductId":
            return Optional.ofNullable(clazz.cast(productId()));
        case "ProductName":
            return Optional.ofNullable(clazz.cast(productName()));
        case "ManufacturerAccountId":
            return Optional.ofNullable(clazz.cast(manufacturerAccountId()));
        case "ManufacturerLegalName":
            return Optional.ofNullable(clazz.cast(manufacturerLegalName()));
        case "ResellerAccountID":
            return Optional.ofNullable(clazz.cast(resellerAccountID()));
        case "ResellerLegalName":
            return Optional.ofNullable(clazz.cast(resellerLegalName()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "OfferExtendedStatus":
            return Optional.ofNullable(clazz.cast(offerExtendedStatus()));
        case "CreatedDate":
            return Optional.ofNullable(clazz.cast(createdDate()));
        case "AvailabilityEndDate":
            return Optional.ofNullable(clazz.cast(availabilityEndDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResaleAuthorizationSummary, T> g) {
        return obj -> g.apply((ResaleAuthorizationSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResaleAuthorizationSummary> {
        /**
         * <p>
         * The name of the ResaleAuthorization.
         * </p>
         * 
         * @param name
         *        The name of the ResaleAuthorization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The product ID of the ResaleAuthorization.
         * </p>
         * 
         * @param productId
         *        The product ID of the ResaleAuthorization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productId(String productId);

        /**
         * <p>
         * The product name of the ResaleAuthorization.
         * </p>
         * 
         * @param productName
         *        The product name of the ResaleAuthorization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productName(String productName);

        /**
         * <p>
         * The manufacturer account ID of the ResaleAuthorization.
         * </p>
         * 
         * @param manufacturerAccountId
         *        The manufacturer account ID of the ResaleAuthorization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder manufacturerAccountId(String manufacturerAccountId);

        /**
         * <p>
         * The manufacturer legal name of the ResaleAuthorization.
         * </p>
         * 
         * @param manufacturerLegalName
         *        The manufacturer legal name of the ResaleAuthorization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder manufacturerLegalName(String manufacturerLegalName);

        /**
         * <p>
         * The reseller account ID of the ResaleAuthorization.
         * </p>
         * 
         * @param resellerAccountID
         *        The reseller account ID of the ResaleAuthorization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resellerAccountID(String resellerAccountID);

        /**
         * <p>
         * The reseller legal name of the ResaleAuthorization
         * </p>
         * 
         * @param resellerLegalName
         *        The reseller legal name of the ResaleAuthorization
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resellerLegalName(String resellerLegalName);

        /**
         * <p>
         * The status of the ResaleAuthorization.
         * </p>
         * 
         * @param status
         *        The status of the ResaleAuthorization.
         * @see ResaleAuthorizationStatusString
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResaleAuthorizationStatusString
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the ResaleAuthorization.
         * </p>
         * 
         * @param status
         *        The status of the ResaleAuthorization.
         * @see ResaleAuthorizationStatusString
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResaleAuthorizationStatusString
         */
        Builder status(ResaleAuthorizationStatusString status);

        /**
         * <p>
         * The offer extended status of the ResaleAuthorization
         * </p>
         * 
         * @param offerExtendedStatus
         *        The offer extended status of the ResaleAuthorization
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder offerExtendedStatus(String offerExtendedStatus);

        /**
         * <p>
         * The created date of the ResaleAuthorization.
         * </p>
         * 
         * @param createdDate
         *        The created date of the ResaleAuthorization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdDate(String createdDate);

        /**
         * <p>
         * The availability end date of the ResaleAuthorization.
         * </p>
         * 
         * @param availabilityEndDate
         *        The availability end date of the ResaleAuthorization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityEndDate(String availabilityEndDate);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String productId;

        private String productName;

        private String manufacturerAccountId;

        private String manufacturerLegalName;

        private String resellerAccountID;

        private String resellerLegalName;

        private String status;

        private String offerExtendedStatus;

        private String createdDate;

        private String availabilityEndDate;

        private BuilderImpl() {
        }

        private BuilderImpl(ResaleAuthorizationSummary model) {
            name(model.name);
            productId(model.productId);
            productName(model.productName);
            manufacturerAccountId(model.manufacturerAccountId);
            manufacturerLegalName(model.manufacturerLegalName);
            resellerAccountID(model.resellerAccountID);
            resellerLegalName(model.resellerLegalName);
            status(model.status);
            offerExtendedStatus(model.offerExtendedStatus);
            createdDate(model.createdDate);
            availabilityEndDate(model.availabilityEndDate);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getProductId() {
            return productId;
        }

        public final void setProductId(String productId) {
            this.productId = productId;
        }

        @Override
        public final Builder productId(String productId) {
            this.productId = productId;
            return this;
        }

        public final String getProductName() {
            return productName;
        }

        public final void setProductName(String productName) {
            this.productName = productName;
        }

        @Override
        public final Builder productName(String productName) {
            this.productName = productName;
            return this;
        }

        public final String getManufacturerAccountId() {
            return manufacturerAccountId;
        }

        public final void setManufacturerAccountId(String manufacturerAccountId) {
            this.manufacturerAccountId = manufacturerAccountId;
        }

        @Override
        public final Builder manufacturerAccountId(String manufacturerAccountId) {
            this.manufacturerAccountId = manufacturerAccountId;
            return this;
        }

        public final String getManufacturerLegalName() {
            return manufacturerLegalName;
        }

        public final void setManufacturerLegalName(String manufacturerLegalName) {
            this.manufacturerLegalName = manufacturerLegalName;
        }

        @Override
        public final Builder manufacturerLegalName(String manufacturerLegalName) {
            this.manufacturerLegalName = manufacturerLegalName;
            return this;
        }

        public final String getResellerAccountID() {
            return resellerAccountID;
        }

        public final void setResellerAccountID(String resellerAccountID) {
            this.resellerAccountID = resellerAccountID;
        }

        @Override
        public final Builder resellerAccountID(String resellerAccountID) {
            this.resellerAccountID = resellerAccountID;
            return this;
        }

        public final String getResellerLegalName() {
            return resellerLegalName;
        }

        public final void setResellerLegalName(String resellerLegalName) {
            this.resellerLegalName = resellerLegalName;
        }

        @Override
        public final Builder resellerLegalName(String resellerLegalName) {
            this.resellerLegalName = resellerLegalName;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ResaleAuthorizationStatusString status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getOfferExtendedStatus() {
            return offerExtendedStatus;
        }

        public final void setOfferExtendedStatus(String offerExtendedStatus) {
            this.offerExtendedStatus = offerExtendedStatus;
        }

        @Override
        public final Builder offerExtendedStatus(String offerExtendedStatus) {
            this.offerExtendedStatus = offerExtendedStatus;
            return this;
        }

        public final String getCreatedDate() {
            return createdDate;
        }

        public final void setCreatedDate(String createdDate) {
            this.createdDate = createdDate;
        }

        @Override
        public final Builder createdDate(String createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final String getAvailabilityEndDate() {
            return availabilityEndDate;
        }

        public final void setAvailabilityEndDate(String availabilityEndDate) {
            this.availabilityEndDate = availabilityEndDate;
        }

        @Override
        public final Builder availabilityEndDate(String availabilityEndDate) {
            this.availabilityEndDate = availabilityEndDate;
            return this;
        }

        @Override
        public ResaleAuthorizationSummary build() {
            return new ResaleAuthorizationSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
