/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.marketplacecatalog.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Object containing all the filter fields for SaaS products. Client can add a maximum of 8 filters in a single
 * <code>ListEntities</code> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SaaSProductFilters implements SdkPojo, Serializable,
        ToCopyableBuilder<SaaSProductFilters.Builder, SaaSProductFilters> {
    private static final SdkField<SaaSProductEntityIdFilter> ENTITY_ID_FIELD = SdkField
            .<SaaSProductEntityIdFilter> builder(MarshallingType.SDK_POJO).memberName("EntityId")
            .getter(getter(SaaSProductFilters::entityId)).setter(setter(Builder::entityId))
            .constructor(SaaSProductEntityIdFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntityId").build()).build();

    private static final SdkField<SaaSProductTitleFilter> PRODUCT_TITLE_FIELD = SdkField
            .<SaaSProductTitleFilter> builder(MarshallingType.SDK_POJO).memberName("ProductTitle")
            .getter(getter(SaaSProductFilters::productTitle)).setter(setter(Builder::productTitle))
            .constructor(SaaSProductTitleFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductTitle").build()).build();

    private static final SdkField<SaaSProductVisibilityFilter> VISIBILITY_FIELD = SdkField
            .<SaaSProductVisibilityFilter> builder(MarshallingType.SDK_POJO).memberName("Visibility")
            .getter(getter(SaaSProductFilters::visibility)).setter(setter(Builder::visibility))
            .constructor(SaaSProductVisibilityFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Visibility").build()).build();

    private static final SdkField<SaaSProductLastModifiedDateFilter> LAST_MODIFIED_DATE_FIELD = SdkField
            .<SaaSProductLastModifiedDateFilter> builder(MarshallingType.SDK_POJO).memberName("LastModifiedDate")
            .getter(getter(SaaSProductFilters::lastModifiedDate)).setter(setter(Builder::lastModifiedDate))
            .constructor(SaaSProductLastModifiedDateFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedDate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTITY_ID_FIELD,
            PRODUCT_TITLE_FIELD, VISIBILITY_FIELD, LAST_MODIFIED_DATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final SaaSProductEntityIdFilter entityId;

    private final SaaSProductTitleFilter productTitle;

    private final SaaSProductVisibilityFilter visibility;

    private final SaaSProductLastModifiedDateFilter lastModifiedDate;

    private SaaSProductFilters(BuilderImpl builder) {
        this.entityId = builder.entityId;
        this.productTitle = builder.productTitle;
        this.visibility = builder.visibility;
        this.lastModifiedDate = builder.lastModifiedDate;
    }

    /**
     * <p>
     * Unique identifier for the SaaS product.
     * </p>
     * 
     * @return Unique identifier for the SaaS product.
     */
    public final SaaSProductEntityIdFilter entityId() {
        return entityId;
    }

    /**
     * <p>
     * The title of the SaaS product.
     * </p>
     * 
     * @return The title of the SaaS product.
     */
    public final SaaSProductTitleFilter productTitle() {
        return productTitle;
    }

    /**
     * <p>
     * The visibility of the SaaS product.
     * </p>
     * 
     * @return The visibility of the SaaS product.
     */
    public final SaaSProductVisibilityFilter visibility() {
        return visibility;
    }

    /**
     * <p>
     * The last date on which the SaaS product was modified.
     * </p>
     * 
     * @return The last date on which the SaaS product was modified.
     */
    public final SaaSProductLastModifiedDateFilter lastModifiedDate() {
        return lastModifiedDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(entityId());
        hashCode = 31 * hashCode + Objects.hashCode(productTitle());
        hashCode = 31 * hashCode + Objects.hashCode(visibility());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedDate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SaaSProductFilters)) {
            return false;
        }
        SaaSProductFilters other = (SaaSProductFilters) obj;
        return Objects.equals(entityId(), other.entityId()) && Objects.equals(productTitle(), other.productTitle())
                && Objects.equals(visibility(), other.visibility())
                && Objects.equals(lastModifiedDate(), other.lastModifiedDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SaaSProductFilters").add("EntityId", entityId()).add("ProductTitle", productTitle())
                .add("Visibility", visibility()).add("LastModifiedDate", lastModifiedDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EntityId":
            return Optional.ofNullable(clazz.cast(entityId()));
        case "ProductTitle":
            return Optional.ofNullable(clazz.cast(productTitle()));
        case "Visibility":
            return Optional.ofNullable(clazz.cast(visibility()));
        case "LastModifiedDate":
            return Optional.ofNullable(clazz.cast(lastModifiedDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SaaSProductFilters, T> g) {
        return obj -> g.apply((SaaSProductFilters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SaaSProductFilters> {
        /**
         * <p>
         * Unique identifier for the SaaS product.
         * </p>
         * 
         * @param entityId
         *        Unique identifier for the SaaS product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityId(SaaSProductEntityIdFilter entityId);

        /**
         * <p>
         * Unique identifier for the SaaS product.
         * </p>
         * This is a convenience method that creates an instance of the {@link SaaSProductEntityIdFilter.Builder}
         * avoiding the need to create one manually via {@link SaaSProductEntityIdFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SaaSProductEntityIdFilter.Builder#build()} is called immediately
         * and its result is passed to {@link #entityId(SaaSProductEntityIdFilter)}.
         * 
         * @param entityId
         *        a consumer that will call methods on {@link SaaSProductEntityIdFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #entityId(SaaSProductEntityIdFilter)
         */
        default Builder entityId(Consumer<SaaSProductEntityIdFilter.Builder> entityId) {
            return entityId(SaaSProductEntityIdFilter.builder().applyMutation(entityId).build());
        }

        /**
         * <p>
         * The title of the SaaS product.
         * </p>
         * 
         * @param productTitle
         *        The title of the SaaS product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productTitle(SaaSProductTitleFilter productTitle);

        /**
         * <p>
         * The title of the SaaS product.
         * </p>
         * This is a convenience method that creates an instance of the {@link SaaSProductTitleFilter.Builder} avoiding
         * the need to create one manually via {@link SaaSProductTitleFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SaaSProductTitleFilter.Builder#build()} is called immediately and
         * its result is passed to {@link #productTitle(SaaSProductTitleFilter)}.
         * 
         * @param productTitle
         *        a consumer that will call methods on {@link SaaSProductTitleFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #productTitle(SaaSProductTitleFilter)
         */
        default Builder productTitle(Consumer<SaaSProductTitleFilter.Builder> productTitle) {
            return productTitle(SaaSProductTitleFilter.builder().applyMutation(productTitle).build());
        }

        /**
         * <p>
         * The visibility of the SaaS product.
         * </p>
         * 
         * @param visibility
         *        The visibility of the SaaS product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder visibility(SaaSProductVisibilityFilter visibility);

        /**
         * <p>
         * The visibility of the SaaS product.
         * </p>
         * This is a convenience method that creates an instance of the {@link SaaSProductVisibilityFilter.Builder}
         * avoiding the need to create one manually via {@link SaaSProductVisibilityFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SaaSProductVisibilityFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #visibility(SaaSProductVisibilityFilter)}.
         * 
         * @param visibility
         *        a consumer that will call methods on {@link SaaSProductVisibilityFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #visibility(SaaSProductVisibilityFilter)
         */
        default Builder visibility(Consumer<SaaSProductVisibilityFilter.Builder> visibility) {
            return visibility(SaaSProductVisibilityFilter.builder().applyMutation(visibility).build());
        }

        /**
         * <p>
         * The last date on which the SaaS product was modified.
         * </p>
         * 
         * @param lastModifiedDate
         *        The last date on which the SaaS product was modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedDate(SaaSProductLastModifiedDateFilter lastModifiedDate);

        /**
         * <p>
         * The last date on which the SaaS product was modified.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link SaaSProductLastModifiedDateFilter.Builder} avoiding the need to create one manually via
         * {@link SaaSProductLastModifiedDateFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SaaSProductLastModifiedDateFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #lastModifiedDate(SaaSProductLastModifiedDateFilter)}.
         * 
         * @param lastModifiedDate
         *        a consumer that will call methods on {@link SaaSProductLastModifiedDateFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lastModifiedDate(SaaSProductLastModifiedDateFilter)
         */
        default Builder lastModifiedDate(Consumer<SaaSProductLastModifiedDateFilter.Builder> lastModifiedDate) {
            return lastModifiedDate(SaaSProductLastModifiedDateFilter.builder().applyMutation(lastModifiedDate).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private SaaSProductEntityIdFilter entityId;

        private SaaSProductTitleFilter productTitle;

        private SaaSProductVisibilityFilter visibility;

        private SaaSProductLastModifiedDateFilter lastModifiedDate;

        private BuilderImpl() {
        }

        private BuilderImpl(SaaSProductFilters model) {
            entityId(model.entityId);
            productTitle(model.productTitle);
            visibility(model.visibility);
            lastModifiedDate(model.lastModifiedDate);
        }

        public final SaaSProductEntityIdFilter.Builder getEntityId() {
            return entityId != null ? entityId.toBuilder() : null;
        }

        public final void setEntityId(SaaSProductEntityIdFilter.BuilderImpl entityId) {
            this.entityId = entityId != null ? entityId.build() : null;
        }

        @Override
        public final Builder entityId(SaaSProductEntityIdFilter entityId) {
            this.entityId = entityId;
            return this;
        }

        public final SaaSProductTitleFilter.Builder getProductTitle() {
            return productTitle != null ? productTitle.toBuilder() : null;
        }

        public final void setProductTitle(SaaSProductTitleFilter.BuilderImpl productTitle) {
            this.productTitle = productTitle != null ? productTitle.build() : null;
        }

        @Override
        public final Builder productTitle(SaaSProductTitleFilter productTitle) {
            this.productTitle = productTitle;
            return this;
        }

        public final SaaSProductVisibilityFilter.Builder getVisibility() {
            return visibility != null ? visibility.toBuilder() : null;
        }

        public final void setVisibility(SaaSProductVisibilityFilter.BuilderImpl visibility) {
            this.visibility = visibility != null ? visibility.build() : null;
        }

        @Override
        public final Builder visibility(SaaSProductVisibilityFilter visibility) {
            this.visibility = visibility;
            return this;
        }

        public final SaaSProductLastModifiedDateFilter.Builder getLastModifiedDate() {
            return lastModifiedDate != null ? lastModifiedDate.toBuilder() : null;
        }

        public final void setLastModifiedDate(SaaSProductLastModifiedDateFilter.BuilderImpl lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate != null ? lastModifiedDate.build() : null;
        }

        @Override
        public final Builder lastModifiedDate(SaaSProductLastModifiedDateFilter lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        @Override
        public SaaSProductFilters build() {
            return new SaaSProductFilters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
