/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.marketplaceentitlement;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.marketplaceentitlement.model.GetEntitlementsRequest;
import software.amazon.awssdk.services.marketplaceentitlement.model.GetEntitlementsResponse;
import software.amazon.awssdk.services.marketplaceentitlement.paginators.GetEntitlementsPublisher;

/**
 * Service client for accessing AWS Marketplace Entitlement Service asynchronously. This can be created using the static
 * {@link #builder()} method.
 *
 * <fullname>AWS Marketplace Entitlement Service</fullname>
 * <p>
 * This reference provides descriptions of the AWS Marketplace Entitlement Service API.
 * </p>
 * <p>
 * AWS Marketplace Entitlement Service is used to determine the entitlement of a customer to a given product. An
 * entitlement represents capacity in a product owned by the customer. For example, a customer might own some number of
 * users or seats in an SaaS application or some amount of data capacity in a multi-tenant database.
 * </p>
 * <p>
 * <b>Getting Entitlement Records</b>
 * </p>
 * <ul>
 * <li>
 * <p>
 * <i>GetEntitlements</i>- Gets the entitlements for a Marketplace product.
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface MarketplaceEntitlementAsyncClient extends AwsClient {
    String SERVICE_NAME = "aws-marketplace";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "entitlement.marketplace";

    /**
     * <p>
     * GetEntitlements retrieves entitlement values for a given product. The results can be filtered based on customer
     * identifier or product dimensions.
     * </p>
     *
     * @param getEntitlementsRequest
     *        The GetEntitlementsRequest contains parameters for the GetEntitlements operation.
     * @return A Java Future containing the result of the GetEntitlements operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more parameters in your request was invalid.</li>
     *         <li>ThrottlingException The calls to the GetEntitlements API are throttled.</li>
     *         <li>InternalServiceErrorException An internal error has occurred. Retry your request. If the problem
     *         persists, post a message with details on the AWS forums.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MarketplaceEntitlementException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample MarketplaceEntitlementAsyncClient.GetEntitlements
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entitlement.marketplace-2017-01-11/GetEntitlements"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetEntitlementsResponse> getEntitlements(GetEntitlementsRequest getEntitlementsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * GetEntitlements retrieves entitlement values for a given product. The results can be filtered based on customer
     * identifier or product dimensions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetEntitlementsRequest.Builder} avoiding the need
     * to create one manually via {@link GetEntitlementsRequest#builder()}
     * </p>
     *
     * @param getEntitlementsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.marketplaceentitlement.model.GetEntitlementsRequest.Builder} to
     *        create a request. The GetEntitlementsRequest contains parameters for the GetEntitlements operation.
     * @return A Java Future containing the result of the GetEntitlements operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more parameters in your request was invalid.</li>
     *         <li>ThrottlingException The calls to the GetEntitlements API are throttled.</li>
     *         <li>InternalServiceErrorException An internal error has occurred. Retry your request. If the problem
     *         persists, post a message with details on the AWS forums.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MarketplaceEntitlementException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample MarketplaceEntitlementAsyncClient.GetEntitlements
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entitlement.marketplace-2017-01-11/GetEntitlements"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetEntitlementsResponse> getEntitlements(
            Consumer<GetEntitlementsRequest.Builder> getEntitlementsRequest) {
        return getEntitlements(GetEntitlementsRequest.builder().applyMutation(getEntitlementsRequest).build());
    }

    /**
     * <p>
     * GetEntitlements retrieves entitlement values for a given product. The results can be filtered based on customer
     * identifier or product dimensions.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getEntitlements(software.amazon.awssdk.services.marketplaceentitlement.model.GetEntitlementsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.marketplaceentitlement.paginators.GetEntitlementsPublisher publisher = client.getEntitlementsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.marketplaceentitlement.paginators.GetEntitlementsPublisher publisher = client.getEntitlementsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.marketplaceentitlement.model.GetEntitlementsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.marketplaceentitlement.model.GetEntitlementsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getEntitlements(software.amazon.awssdk.services.marketplaceentitlement.model.GetEntitlementsRequest)}
     * operation.</b>
     * </p>
     *
     * @param getEntitlementsRequest
     *        The GetEntitlementsRequest contains parameters for the GetEntitlements operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more parameters in your request was invalid.</li>
     *         <li>ThrottlingException The calls to the GetEntitlements API are throttled.</li>
     *         <li>InternalServiceErrorException An internal error has occurred. Retry your request. If the problem
     *         persists, post a message with details on the AWS forums.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MarketplaceEntitlementException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample MarketplaceEntitlementAsyncClient.GetEntitlements
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entitlement.marketplace-2017-01-11/GetEntitlements"
     *      target="_top">AWS API Documentation</a>
     */
    default GetEntitlementsPublisher getEntitlementsPaginator(GetEntitlementsRequest getEntitlementsRequest) {
        return new GetEntitlementsPublisher(this, getEntitlementsRequest);
    }

    /**
     * <p>
     * GetEntitlements retrieves entitlement values for a given product. The results can be filtered based on customer
     * identifier or product dimensions.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getEntitlements(software.amazon.awssdk.services.marketplaceentitlement.model.GetEntitlementsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.marketplaceentitlement.paginators.GetEntitlementsPublisher publisher = client.getEntitlementsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.marketplaceentitlement.paginators.GetEntitlementsPublisher publisher = client.getEntitlementsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.marketplaceentitlement.model.GetEntitlementsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.marketplaceentitlement.model.GetEntitlementsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getEntitlements(software.amazon.awssdk.services.marketplaceentitlement.model.GetEntitlementsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetEntitlementsRequest.Builder} avoiding the need
     * to create one manually via {@link GetEntitlementsRequest#builder()}
     * </p>
     *
     * @param getEntitlementsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.marketplaceentitlement.model.GetEntitlementsRequest.Builder} to
     *        create a request. The GetEntitlementsRequest contains parameters for the GetEntitlements operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more parameters in your request was invalid.</li>
     *         <li>ThrottlingException The calls to the GetEntitlements API are throttled.</li>
     *         <li>InternalServiceErrorException An internal error has occurred. Retry your request. If the problem
     *         persists, post a message with details on the AWS forums.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MarketplaceEntitlementException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample MarketplaceEntitlementAsyncClient.GetEntitlements
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entitlement.marketplace-2017-01-11/GetEntitlements"
     *      target="_top">AWS API Documentation</a>
     */
    default GetEntitlementsPublisher getEntitlementsPaginator(Consumer<GetEntitlementsRequest.Builder> getEntitlementsRequest) {
        return getEntitlementsPaginator(GetEntitlementsRequest.builder().applyMutation(getEntitlementsRequest).build());
    }

    @Override
    default MarketplaceEntitlementServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link MarketplaceEntitlementAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static MarketplaceEntitlementAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link MarketplaceEntitlementAsyncClient}.
     */
    static MarketplaceEntitlementAsyncClientBuilder builder() {
        return new DefaultMarketplaceEntitlementAsyncClientBuilder();
    }
}
