/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Displays details of the selected bridge.
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListedBridge implements SdkPojo, Serializable, ToCopyableBuilder<ListedBridge.Builder, ListedBridge> {
    private static final SdkField<String> BRIDGE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BridgeArn").getter(getter(ListedBridge::bridgeArn)).setter(setter(Builder::bridgeArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bridgeArn").build()).build();

    private static final SdkField<String> BRIDGE_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BridgeState").getter(getter(ListedBridge::bridgeStateAsString)).setter(setter(Builder::bridgeState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bridgeState").build()).build();

    private static final SdkField<String> BRIDGE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BridgeType").getter(getter(ListedBridge::bridgeType)).setter(setter(Builder::bridgeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bridgeType").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(ListedBridge::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> PLACEMENT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PlacementArn").getter(getter(ListedBridge::placementArn)).setter(setter(Builder::placementArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("placementArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BRIDGE_ARN_FIELD,
            BRIDGE_STATE_FIELD, BRIDGE_TYPE_FIELD, NAME_FIELD, PLACEMENT_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String bridgeArn;

    private final String bridgeState;

    private final String bridgeType;

    private final String name;

    private final String placementArn;

    private ListedBridge(BuilderImpl builder) {
        this.bridgeArn = builder.bridgeArn;
        this.bridgeState = builder.bridgeState;
        this.bridgeType = builder.bridgeType;
        this.name = builder.name;
        this.placementArn = builder.placementArn;
    }

    /**
     * The ARN of the bridge.
     * 
     * @return The ARN of the bridge.
     */
    public final String bridgeArn() {
        return bridgeArn;
    }

    /**
     * Returns the value of the BridgeState property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #bridgeState} will
     * return {@link BridgeState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #bridgeStateAsString}.
     * </p>
     * 
     * @return The value of the BridgeState property for this object.
     * @see BridgeState
     */
    public final BridgeState bridgeState() {
        return BridgeState.fromValue(bridgeState);
    }

    /**
     * Returns the value of the BridgeState property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #bridgeState} will
     * return {@link BridgeState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #bridgeStateAsString}.
     * </p>
     * 
     * @return The value of the BridgeState property for this object.
     * @see BridgeState
     */
    public final String bridgeStateAsString() {
        return bridgeState;
    }

    /**
     * The type of the bridge.
     * 
     * @return The type of the bridge.
     */
    public final String bridgeType() {
        return bridgeType;
    }

    /**
     * The name of the bridge.
     * 
     * @return The name of the bridge.
     */
    public final String name() {
        return name;
    }

    /**
     * The ARN of the gateway associated with the bridge.
     * 
     * @return The ARN of the gateway associated with the bridge.
     */
    public final String placementArn() {
        return placementArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(bridgeArn());
        hashCode = 31 * hashCode + Objects.hashCode(bridgeStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(bridgeType());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(placementArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListedBridge)) {
            return false;
        }
        ListedBridge other = (ListedBridge) obj;
        return Objects.equals(bridgeArn(), other.bridgeArn())
                && Objects.equals(bridgeStateAsString(), other.bridgeStateAsString())
                && Objects.equals(bridgeType(), other.bridgeType()) && Objects.equals(name(), other.name())
                && Objects.equals(placementArn(), other.placementArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListedBridge").add("BridgeArn", bridgeArn()).add("BridgeState", bridgeStateAsString())
                .add("BridgeType", bridgeType()).add("Name", name()).add("PlacementArn", placementArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BridgeArn":
            return Optional.ofNullable(clazz.cast(bridgeArn()));
        case "BridgeState":
            return Optional.ofNullable(clazz.cast(bridgeStateAsString()));
        case "BridgeType":
            return Optional.ofNullable(clazz.cast(bridgeType()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "PlacementArn":
            return Optional.ofNullable(clazz.cast(placementArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListedBridge, T> g) {
        return obj -> g.apply((ListedBridge) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ListedBridge> {
        /**
         * The ARN of the bridge.
         * 
         * @param bridgeArn
         *        The ARN of the bridge.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bridgeArn(String bridgeArn);

        /**
         * Sets the value of the BridgeState property for this object.
         *
         * @param bridgeState
         *        The new value for the BridgeState property for this object.
         * @see BridgeState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BridgeState
         */
        Builder bridgeState(String bridgeState);

        /**
         * Sets the value of the BridgeState property for this object.
         *
         * @param bridgeState
         *        The new value for the BridgeState property for this object.
         * @see BridgeState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BridgeState
         */
        Builder bridgeState(BridgeState bridgeState);

        /**
         * The type of the bridge.
         * 
         * @param bridgeType
         *        The type of the bridge.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bridgeType(String bridgeType);

        /**
         * The name of the bridge.
         * 
         * @param name
         *        The name of the bridge.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * The ARN of the gateway associated with the bridge.
         * 
         * @param placementArn
         *        The ARN of the gateway associated with the bridge.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder placementArn(String placementArn);
    }

    static final class BuilderImpl implements Builder {
        private String bridgeArn;

        private String bridgeState;

        private String bridgeType;

        private String name;

        private String placementArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ListedBridge model) {
            bridgeArn(model.bridgeArn);
            bridgeState(model.bridgeState);
            bridgeType(model.bridgeType);
            name(model.name);
            placementArn(model.placementArn);
        }

        public final String getBridgeArn() {
            return bridgeArn;
        }

        public final void setBridgeArn(String bridgeArn) {
            this.bridgeArn = bridgeArn;
        }

        @Override
        public final Builder bridgeArn(String bridgeArn) {
            this.bridgeArn = bridgeArn;
            return this;
        }

        public final String getBridgeState() {
            return bridgeState;
        }

        public final void setBridgeState(String bridgeState) {
            this.bridgeState = bridgeState;
        }

        @Override
        public final Builder bridgeState(String bridgeState) {
            this.bridgeState = bridgeState;
            return this;
        }

        @Override
        public final Builder bridgeState(BridgeState bridgeState) {
            this.bridgeState(bridgeState == null ? null : bridgeState.toString());
            return this;
        }

        public final String getBridgeType() {
            return bridgeType;
        }

        public final void setBridgeType(String bridgeType) {
            this.bridgeType = bridgeType;
        }

        @Override
        public final Builder bridgeType(String bridgeType) {
            this.bridgeType = bridgeType;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getPlacementArn() {
            return placementArn;
        }

        public final void setPlacementArn(String placementArn) {
            this.placementArn = placementArn;
        }

        @Override
        public final Builder placementArn(String placementArn) {
            this.placementArn = placementArn;
            return this;
        }

        @Override
        public ListedBridge build() {
            return new ListedBridge(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
