/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * When you mimic a multi-channel audio layout with multiple mono-channel tracks, you can tag each channel layout
 * manually. For example, you would tag the tracks that contain your left, right, and center audio with Left (L), Right
 * (R), and Center (C), respectively. When you don't specify a value, MediaConvert labels your track as Center (C) by
 * default. To use audio layout tagging, your output must be in a QuickTime (.mov) container; your audio codec must be
 * AAC, WAV, or AIFF; and you must set up your audio track to have only one channel.
 */
@Generated("software.amazon.awssdk:codegen")
public final class AudioChannelTaggingSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<AudioChannelTaggingSettings.Builder, AudioChannelTaggingSettings> {
    private static final SdkField<String> CHANNEL_TAG_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChannelTag").getter(getter(AudioChannelTaggingSettings::channelTagAsString))
            .setter(setter(Builder::channelTag))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channelTag").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_TAG_FIELD));

    private static final long serialVersionUID = 1L;

    private final String channelTag;

    private AudioChannelTaggingSettings(BuilderImpl builder) {
        this.channelTag = builder.channelTag;
    }

    /**
     * You can add a tag for this mono-channel audio track to mimic its placement in a multi-channel layout. For
     * example, if this track is the left surround channel, choose Left surround (LS).
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #channelTag} will
     * return {@link AudioChannelTag#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #channelTagAsString}.
     * </p>
     * 
     * @return You can add a tag for this mono-channel audio track to mimic its placement in a multi-channel layout. For
     *         example, if this track is the left surround channel, choose Left surround (LS).
     * @see AudioChannelTag
     */
    public final AudioChannelTag channelTag() {
        return AudioChannelTag.fromValue(channelTag);
    }

    /**
     * You can add a tag for this mono-channel audio track to mimic its placement in a multi-channel layout. For
     * example, if this track is the left surround channel, choose Left surround (LS).
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #channelTag} will
     * return {@link AudioChannelTag#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #channelTagAsString}.
     * </p>
     * 
     * @return You can add a tag for this mono-channel audio track to mimic its placement in a multi-channel layout. For
     *         example, if this track is the left surround channel, choose Left surround (LS).
     * @see AudioChannelTag
     */
    public final String channelTagAsString() {
        return channelTag;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(channelTagAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AudioChannelTaggingSettings)) {
            return false;
        }
        AudioChannelTaggingSettings other = (AudioChannelTaggingSettings) obj;
        return Objects.equals(channelTagAsString(), other.channelTagAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AudioChannelTaggingSettings").add("ChannelTag", channelTagAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ChannelTag":
            return Optional.ofNullable(clazz.cast(channelTagAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AudioChannelTaggingSettings, T> g) {
        return obj -> g.apply((AudioChannelTaggingSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AudioChannelTaggingSettings> {
        /**
         * You can add a tag for this mono-channel audio track to mimic its placement in a multi-channel layout. For
         * example, if this track is the left surround channel, choose Left surround (LS).
         * 
         * @param channelTag
         *        You can add a tag for this mono-channel audio track to mimic its placement in a multi-channel layout.
         *        For example, if this track is the left surround channel, choose Left surround (LS).
         * @see AudioChannelTag
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AudioChannelTag
         */
        Builder channelTag(String channelTag);

        /**
         * You can add a tag for this mono-channel audio track to mimic its placement in a multi-channel layout. For
         * example, if this track is the left surround channel, choose Left surround (LS).
         * 
         * @param channelTag
         *        You can add a tag for this mono-channel audio track to mimic its placement in a multi-channel layout.
         *        For example, if this track is the left surround channel, choose Left surround (LS).
         * @see AudioChannelTag
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AudioChannelTag
         */
        Builder channelTag(AudioChannelTag channelTag);
    }

    static final class BuilderImpl implements Builder {
        private String channelTag;

        private BuilderImpl() {
        }

        private BuilderImpl(AudioChannelTaggingSettings model) {
            channelTag(model.channelTag);
        }

        public final String getChannelTag() {
            return channelTag;
        }

        @Override
        public final Builder channelTag(String channelTag) {
            this.channelTag = channelTag;
            return this;
        }

        @Override
        public final Builder channelTag(AudioChannelTag channelTag) {
            this.channelTag(channelTag == null ? null : channelTag.toString());
            return this;
        }

        public final void setChannelTag(String channelTag) {
            this.channelTag = channelTag;
        }

        @Override
        public AudioChannelTaggingSettings build() {
            return new AudioChannelTaggingSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
