/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Use Audio selectors (AudioSelectors) to specify a track or set of tracks from the input that you will use in your
 * outputs. You can use multiple Audio selectors per input.
 */
@Generated("software.amazon.awssdk:codegen")
public final class AudioSelector implements SdkPojo, Serializable, ToCopyableBuilder<AudioSelector.Builder, AudioSelector> {
    private static final SdkField<String> CUSTOM_LANGUAGE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CustomLanguageCode").getter(getter(AudioSelector::customLanguageCode))
            .setter(setter(Builder::customLanguageCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customLanguageCode").build())
            .build();

    private static final SdkField<String> DEFAULT_SELECTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DefaultSelection").getter(getter(AudioSelector::defaultSelectionAsString))
            .setter(setter(Builder::defaultSelection))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultSelection").build()).build();

    private static final SdkField<String> EXTERNAL_AUDIO_FILE_INPUT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExternalAudioFileInput").getter(getter(AudioSelector::externalAudioFileInput))
            .setter(setter(Builder::externalAudioFileInput))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("externalAudioFileInput").build())
            .build();

    private static final SdkField<String> LANGUAGE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LanguageCode").getter(getter(AudioSelector::languageCodeAsString)).setter(setter(Builder::languageCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("languageCode").build()).build();

    private static final SdkField<Integer> OFFSET_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Offset").getter(getter(AudioSelector::offset)).setter(setter(Builder::offset))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("offset").build()).build();

    private static final SdkField<List<Integer>> PIDS_FIELD = SdkField
            .<List<Integer>> builder(MarshallingType.LIST)
            .memberName("Pids")
            .getter(getter(AudioSelector::pids))
            .setter(setter(Builder::pids))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pids").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Integer> builder(MarshallingType.INTEGER)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> PROGRAM_SELECTION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ProgramSelection").getter(getter(AudioSelector::programSelection))
            .setter(setter(Builder::programSelection))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("programSelection").build()).build();

    private static final SdkField<RemixSettings> REMIX_SETTINGS_FIELD = SdkField
            .<RemixSettings> builder(MarshallingType.SDK_POJO).memberName("RemixSettings")
            .getter(getter(AudioSelector::remixSettings)).setter(setter(Builder::remixSettings))
            .constructor(RemixSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("remixSettings").build()).build();

    private static final SdkField<String> SELECTOR_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SelectorType").getter(getter(AudioSelector::selectorTypeAsString)).setter(setter(Builder::selectorType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("selectorType").build()).build();

    private static final SdkField<List<Integer>> TRACKS_FIELD = SdkField
            .<List<Integer>> builder(MarshallingType.LIST)
            .memberName("Tracks")
            .getter(getter(AudioSelector::tracks))
            .setter(setter(Builder::tracks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tracks").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Integer> builder(MarshallingType.INTEGER)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CUSTOM_LANGUAGE_CODE_FIELD,
            DEFAULT_SELECTION_FIELD, EXTERNAL_AUDIO_FILE_INPUT_FIELD, LANGUAGE_CODE_FIELD, OFFSET_FIELD, PIDS_FIELD,
            PROGRAM_SELECTION_FIELD, REMIX_SETTINGS_FIELD, SELECTOR_TYPE_FIELD, TRACKS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String customLanguageCode;

    private final String defaultSelection;

    private final String externalAudioFileInput;

    private final String languageCode;

    private final Integer offset;

    private final List<Integer> pids;

    private final Integer programSelection;

    private final RemixSettings remixSettings;

    private final String selectorType;

    private final List<Integer> tracks;

    private AudioSelector(BuilderImpl builder) {
        this.customLanguageCode = builder.customLanguageCode;
        this.defaultSelection = builder.defaultSelection;
        this.externalAudioFileInput = builder.externalAudioFileInput;
        this.languageCode = builder.languageCode;
        this.offset = builder.offset;
        this.pids = builder.pids;
        this.programSelection = builder.programSelection;
        this.remixSettings = builder.remixSettings;
        this.selectorType = builder.selectorType;
        this.tracks = builder.tracks;
    }

    /**
     * Selects a specific language code from within an audio source, using the ISO 639-2 or ISO 639-3 three-letter
     * language code
     * 
     * @return Selects a specific language code from within an audio source, using the ISO 639-2 or ISO 639-3
     *         three-letter language code
     */
    public final String customLanguageCode() {
        return customLanguageCode;
    }

    /**
     * Enable this setting on one audio selector to set it as the default for the job. The service uses this default for
     * outputs where it can't find the specified input audio. If you don't set a default, those outputs have no audio.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #defaultSelection}
     * will return {@link AudioDefaultSelection#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #defaultSelectionAsString}.
     * </p>
     * 
     * @return Enable this setting on one audio selector to set it as the default for the job. The service uses this
     *         default for outputs where it can't find the specified input audio. If you don't set a default, those
     *         outputs have no audio.
     * @see AudioDefaultSelection
     */
    public final AudioDefaultSelection defaultSelection() {
        return AudioDefaultSelection.fromValue(defaultSelection);
    }

    /**
     * Enable this setting on one audio selector to set it as the default for the job. The service uses this default for
     * outputs where it can't find the specified input audio. If you don't set a default, those outputs have no audio.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #defaultSelection}
     * will return {@link AudioDefaultSelection#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #defaultSelectionAsString}.
     * </p>
     * 
     * @return Enable this setting on one audio selector to set it as the default for the job. The service uses this
     *         default for outputs where it can't find the specified input audio. If you don't set a default, those
     *         outputs have no audio.
     * @see AudioDefaultSelection
     */
    public final String defaultSelectionAsString() {
        return defaultSelection;
    }

    /**
     * Specifies audio data from an external file source.
     * 
     * @return Specifies audio data from an external file source.
     */
    public final String externalAudioFileInput() {
        return externalAudioFileInput;
    }

    /**
     * Selects a specific language code from within an audio source.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #languageCode} will
     * return {@link LanguageCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #languageCodeAsString}.
     * </p>
     * 
     * @return Selects a specific language code from within an audio source.
     * @see LanguageCode
     */
    public final LanguageCode languageCode() {
        return LanguageCode.fromValue(languageCode);
    }

    /**
     * Selects a specific language code from within an audio source.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #languageCode} will
     * return {@link LanguageCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #languageCodeAsString}.
     * </p>
     * 
     * @return Selects a specific language code from within an audio source.
     * @see LanguageCode
     */
    public final String languageCodeAsString() {
        return languageCode;
    }

    /**
     * Specifies a time delta in milliseconds to offset the audio from the input video.
     * 
     * @return Specifies a time delta in milliseconds to offset the audio from the input video.
     */
    public final Integer offset() {
        return offset;
    }

    /**
     * Returns true if the Pids property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasPids() {
        return pids != null && !(pids instanceof SdkAutoConstructList);
    }

    /**
     * Selects a specific PID from within an audio source (e.g. 257 selects PID 0x101).
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPids()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Selects a specific PID from within an audio source (e.g. 257 selects PID 0x101).
     */
    public final List<Integer> pids() {
        return pids;
    }

    /**
     * Use this setting for input streams that contain Dolby E, to have the service extract specific program data from
     * the track. To select multiple programs, create multiple selectors with the same Track and different Program
     * numbers. In the console, this setting is visible when you set Selector type to Track. Choose the program number
     * from the dropdown list. If you are sending a JSON file, provide the program ID, which is part of the audio
     * metadata. If your input file has incorrect metadata, you can choose All channels instead of a program number to
     * have the service ignore the program IDs and include all the programs in the track.
     * 
     * @return Use this setting for input streams that contain Dolby E, to have the service extract specific program
     *         data from the track. To select multiple programs, create multiple selectors with the same Track and
     *         different Program numbers. In the console, this setting is visible when you set Selector type to Track.
     *         Choose the program number from the dropdown list. If you are sending a JSON file, provide the program ID,
     *         which is part of the audio metadata. If your input file has incorrect metadata, you can choose All
     *         channels instead of a program number to have the service ignore the program IDs and include all the
     *         programs in the track.
     */
    public final Integer programSelection() {
        return programSelection;
    }

    /**
     * Use these settings to reorder the audio channels of one input to match those of another input. This allows you to
     * combine the two files into a single output, one after the other.
     * 
     * @return Use these settings to reorder the audio channels of one input to match those of another input. This
     *         allows you to combine the two files into a single output, one after the other.
     */
    public final RemixSettings remixSettings() {
        return remixSettings;
    }

    /**
     * Specifies the type of the audio selector.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #selectorType} will
     * return {@link AudioSelectorType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #selectorTypeAsString}.
     * </p>
     * 
     * @return Specifies the type of the audio selector.
     * @see AudioSelectorType
     */
    public final AudioSelectorType selectorType() {
        return AudioSelectorType.fromValue(selectorType);
    }

    /**
     * Specifies the type of the audio selector.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #selectorType} will
     * return {@link AudioSelectorType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #selectorTypeAsString}.
     * </p>
     * 
     * @return Specifies the type of the audio selector.
     * @see AudioSelectorType
     */
    public final String selectorTypeAsString() {
        return selectorType;
    }

    /**
     * Returns true if the Tracks property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTracks() {
        return tracks != null && !(tracks instanceof SdkAutoConstructList);
    }

    /**
     * Identify a track from the input audio to include in this selector by entering the track index number. To include
     * several tracks in a single audio selector, specify multiple tracks as follows. Using the console, enter a
     * comma-separated list. For examle, type "1,2,3" to include tracks 1 through 3. Specifying directly in your JSON
     * job file, provide the track numbers in an array. For example, "tracks": [1,2,3].
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTracks()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Identify a track from the input audio to include in this selector by entering the track index number. To
     *         include several tracks in a single audio selector, specify multiple tracks as follows. Using the console,
     *         enter a comma-separated list. For examle, type "1,2,3" to include tracks 1 through 3. Specifying directly
     *         in your JSON job file, provide the track numbers in an array. For example, "tracks": [1,2,3].
     */
    public final List<Integer> tracks() {
        return tracks;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(customLanguageCode());
        hashCode = 31 * hashCode + Objects.hashCode(defaultSelectionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(externalAudioFileInput());
        hashCode = 31 * hashCode + Objects.hashCode(languageCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(offset());
        hashCode = 31 * hashCode + Objects.hashCode(hasPids() ? pids() : null);
        hashCode = 31 * hashCode + Objects.hashCode(programSelection());
        hashCode = 31 * hashCode + Objects.hashCode(remixSettings());
        hashCode = 31 * hashCode + Objects.hashCode(selectorTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTracks() ? tracks() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AudioSelector)) {
            return false;
        }
        AudioSelector other = (AudioSelector) obj;
        return Objects.equals(customLanguageCode(), other.customLanguageCode())
                && Objects.equals(defaultSelectionAsString(), other.defaultSelectionAsString())
                && Objects.equals(externalAudioFileInput(), other.externalAudioFileInput())
                && Objects.equals(languageCodeAsString(), other.languageCodeAsString())
                && Objects.equals(offset(), other.offset()) && hasPids() == other.hasPids()
                && Objects.equals(pids(), other.pids()) && Objects.equals(programSelection(), other.programSelection())
                && Objects.equals(remixSettings(), other.remixSettings())
                && Objects.equals(selectorTypeAsString(), other.selectorTypeAsString()) && hasTracks() == other.hasTracks()
                && Objects.equals(tracks(), other.tracks());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AudioSelector").add("CustomLanguageCode", customLanguageCode())
                .add("DefaultSelection", defaultSelectionAsString()).add("ExternalAudioFileInput", externalAudioFileInput())
                .add("LanguageCode", languageCodeAsString()).add("Offset", offset()).add("Pids", hasPids() ? pids() : null)
                .add("ProgramSelection", programSelection()).add("RemixSettings", remixSettings())
                .add("SelectorType", selectorTypeAsString()).add("Tracks", hasTracks() ? tracks() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CustomLanguageCode":
            return Optional.ofNullable(clazz.cast(customLanguageCode()));
        case "DefaultSelection":
            return Optional.ofNullable(clazz.cast(defaultSelectionAsString()));
        case "ExternalAudioFileInput":
            return Optional.ofNullable(clazz.cast(externalAudioFileInput()));
        case "LanguageCode":
            return Optional.ofNullable(clazz.cast(languageCodeAsString()));
        case "Offset":
            return Optional.ofNullable(clazz.cast(offset()));
        case "Pids":
            return Optional.ofNullable(clazz.cast(pids()));
        case "ProgramSelection":
            return Optional.ofNullable(clazz.cast(programSelection()));
        case "RemixSettings":
            return Optional.ofNullable(clazz.cast(remixSettings()));
        case "SelectorType":
            return Optional.ofNullable(clazz.cast(selectorTypeAsString()));
        case "Tracks":
            return Optional.ofNullable(clazz.cast(tracks()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AudioSelector, T> g) {
        return obj -> g.apply((AudioSelector) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AudioSelector> {
        /**
         * Selects a specific language code from within an audio source, using the ISO 639-2 or ISO 639-3 three-letter
         * language code
         * 
         * @param customLanguageCode
         *        Selects a specific language code from within an audio source, using the ISO 639-2 or ISO 639-3
         *        three-letter language code
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customLanguageCode(String customLanguageCode);

        /**
         * Enable this setting on one audio selector to set it as the default for the job. The service uses this default
         * for outputs where it can't find the specified input audio. If you don't set a default, those outputs have no
         * audio.
         * 
         * @param defaultSelection
         *        Enable this setting on one audio selector to set it as the default for the job. The service uses this
         *        default for outputs where it can't find the specified input audio. If you don't set a default, those
         *        outputs have no audio.
         * @see AudioDefaultSelection
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AudioDefaultSelection
         */
        Builder defaultSelection(String defaultSelection);

        /**
         * Enable this setting on one audio selector to set it as the default for the job. The service uses this default
         * for outputs where it can't find the specified input audio. If you don't set a default, those outputs have no
         * audio.
         * 
         * @param defaultSelection
         *        Enable this setting on one audio selector to set it as the default for the job. The service uses this
         *        default for outputs where it can't find the specified input audio. If you don't set a default, those
         *        outputs have no audio.
         * @see AudioDefaultSelection
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AudioDefaultSelection
         */
        Builder defaultSelection(AudioDefaultSelection defaultSelection);

        /**
         * Specifies audio data from an external file source.
         * 
         * @param externalAudioFileInput
         *        Specifies audio data from an external file source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder externalAudioFileInput(String externalAudioFileInput);

        /**
         * Selects a specific language code from within an audio source.
         * 
         * @param languageCode
         *        Selects a specific language code from within an audio source.
         * @see LanguageCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LanguageCode
         */
        Builder languageCode(String languageCode);

        /**
         * Selects a specific language code from within an audio source.
         * 
         * @param languageCode
         *        Selects a specific language code from within an audio source.
         * @see LanguageCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LanguageCode
         */
        Builder languageCode(LanguageCode languageCode);

        /**
         * Specifies a time delta in milliseconds to offset the audio from the input video.
         * 
         * @param offset
         *        Specifies a time delta in milliseconds to offset the audio from the input video.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder offset(Integer offset);

        /**
         * Selects a specific PID from within an audio source (e.g. 257 selects PID 0x101).
         * 
         * @param pids
         *        Selects a specific PID from within an audio source (e.g. 257 selects PID 0x101).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pids(Collection<Integer> pids);

        /**
         * Selects a specific PID from within an audio source (e.g. 257 selects PID 0x101).
         * 
         * @param pids
         *        Selects a specific PID from within an audio source (e.g. 257 selects PID 0x101).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pids(Integer... pids);

        /**
         * Use this setting for input streams that contain Dolby E, to have the service extract specific program data
         * from the track. To select multiple programs, create multiple selectors with the same Track and different
         * Program numbers. In the console, this setting is visible when you set Selector type to Track. Choose the
         * program number from the dropdown list. If you are sending a JSON file, provide the program ID, which is part
         * of the audio metadata. If your input file has incorrect metadata, you can choose All channels instead of a
         * program number to have the service ignore the program IDs and include all the programs in the track.
         * 
         * @param programSelection
         *        Use this setting for input streams that contain Dolby E, to have the service extract specific program
         *        data from the track. To select multiple programs, create multiple selectors with the same Track and
         *        different Program numbers. In the console, this setting is visible when you set Selector type to
         *        Track. Choose the program number from the dropdown list. If you are sending a JSON file, provide the
         *        program ID, which is part of the audio metadata. If your input file has incorrect metadata, you can
         *        choose All channels instead of a program number to have the service ignore the program IDs and include
         *        all the programs in the track.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder programSelection(Integer programSelection);

        /**
         * Use these settings to reorder the audio channels of one input to match those of another input. This allows
         * you to combine the two files into a single output, one after the other.
         * 
         * @param remixSettings
         *        Use these settings to reorder the audio channels of one input to match those of another input. This
         *        allows you to combine the two files into a single output, one after the other.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remixSettings(RemixSettings remixSettings);

        /**
         * Use these settings to reorder the audio channels of one input to match those of another input. This allows
         * you to combine the two files into a single output, one after the other. This is a convenience that creates an
         * instance of the {@link RemixSettings.Builder} avoiding the need to create one manually via
         * {@link RemixSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link RemixSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #remixSettings(RemixSettings)}.
         * 
         * @param remixSettings
         *        a consumer that will call methods on {@link RemixSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #remixSettings(RemixSettings)
         */
        default Builder remixSettings(Consumer<RemixSettings.Builder> remixSettings) {
            return remixSettings(RemixSettings.builder().applyMutation(remixSettings).build());
        }

        /**
         * Specifies the type of the audio selector.
         * 
         * @param selectorType
         *        Specifies the type of the audio selector.
         * @see AudioSelectorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AudioSelectorType
         */
        Builder selectorType(String selectorType);

        /**
         * Specifies the type of the audio selector.
         * 
         * @param selectorType
         *        Specifies the type of the audio selector.
         * @see AudioSelectorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AudioSelectorType
         */
        Builder selectorType(AudioSelectorType selectorType);

        /**
         * Identify a track from the input audio to include in this selector by entering the track index number. To
         * include several tracks in a single audio selector, specify multiple tracks as follows. Using the console,
         * enter a comma-separated list. For examle, type "1,2,3" to include tracks 1 through 3. Specifying directly in
         * your JSON job file, provide the track numbers in an array. For example, "tracks": [1,2,3].
         * 
         * @param tracks
         *        Identify a track from the input audio to include in this selector by entering the track index number.
         *        To include several tracks in a single audio selector, specify multiple tracks as follows. Using the
         *        console, enter a comma-separated list. For examle, type "1,2,3" to include tracks 1 through 3.
         *        Specifying directly in your JSON job file, provide the track numbers in an array. For example,
         *        "tracks": [1,2,3].
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tracks(Collection<Integer> tracks);

        /**
         * Identify a track from the input audio to include in this selector by entering the track index number. To
         * include several tracks in a single audio selector, specify multiple tracks as follows. Using the console,
         * enter a comma-separated list. For examle, type "1,2,3" to include tracks 1 through 3. Specifying directly in
         * your JSON job file, provide the track numbers in an array. For example, "tracks": [1,2,3].
         * 
         * @param tracks
         *        Identify a track from the input audio to include in this selector by entering the track index number.
         *        To include several tracks in a single audio selector, specify multiple tracks as follows. Using the
         *        console, enter a comma-separated list. For examle, type "1,2,3" to include tracks 1 through 3.
         *        Specifying directly in your JSON job file, provide the track numbers in an array. For example,
         *        "tracks": [1,2,3].
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tracks(Integer... tracks);
    }

    static final class BuilderImpl implements Builder {
        private String customLanguageCode;

        private String defaultSelection;

        private String externalAudioFileInput;

        private String languageCode;

        private Integer offset;

        private List<Integer> pids = DefaultSdkAutoConstructList.getInstance();

        private Integer programSelection;

        private RemixSettings remixSettings;

        private String selectorType;

        private List<Integer> tracks = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AudioSelector model) {
            customLanguageCode(model.customLanguageCode);
            defaultSelection(model.defaultSelection);
            externalAudioFileInput(model.externalAudioFileInput);
            languageCode(model.languageCode);
            offset(model.offset);
            pids(model.pids);
            programSelection(model.programSelection);
            remixSettings(model.remixSettings);
            selectorType(model.selectorType);
            tracks(model.tracks);
        }

        public final String getCustomLanguageCode() {
            return customLanguageCode;
        }

        @Override
        public final Builder customLanguageCode(String customLanguageCode) {
            this.customLanguageCode = customLanguageCode;
            return this;
        }

        public final void setCustomLanguageCode(String customLanguageCode) {
            this.customLanguageCode = customLanguageCode;
        }

        public final String getDefaultSelection() {
            return defaultSelection;
        }

        @Override
        public final Builder defaultSelection(String defaultSelection) {
            this.defaultSelection = defaultSelection;
            return this;
        }

        @Override
        public final Builder defaultSelection(AudioDefaultSelection defaultSelection) {
            this.defaultSelection(defaultSelection == null ? null : defaultSelection.toString());
            return this;
        }

        public final void setDefaultSelection(String defaultSelection) {
            this.defaultSelection = defaultSelection;
        }

        public final String getExternalAudioFileInput() {
            return externalAudioFileInput;
        }

        @Override
        public final Builder externalAudioFileInput(String externalAudioFileInput) {
            this.externalAudioFileInput = externalAudioFileInput;
            return this;
        }

        public final void setExternalAudioFileInput(String externalAudioFileInput) {
            this.externalAudioFileInput = externalAudioFileInput;
        }

        public final String getLanguageCode() {
            return languageCode;
        }

        @Override
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        @Override
        public final Builder languageCode(LanguageCode languageCode) {
            this.languageCode(languageCode == null ? null : languageCode.toString());
            return this;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        public final Integer getOffset() {
            return offset;
        }

        @Override
        public final Builder offset(Integer offset) {
            this.offset = offset;
            return this;
        }

        public final void setOffset(Integer offset) {
            this.offset = offset;
        }

        public final Collection<Integer> getPids() {
            if (pids instanceof SdkAutoConstructList) {
                return null;
            }
            return pids;
        }

        @Override
        public final Builder pids(Collection<Integer> pids) {
            this.pids = ___listOf__integerMin1Max2147483647Copier.copy(pids);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pids(Integer... pids) {
            pids(Arrays.asList(pids));
            return this;
        }

        public final void setPids(Collection<Integer> pids) {
            this.pids = ___listOf__integerMin1Max2147483647Copier.copy(pids);
        }

        public final Integer getProgramSelection() {
            return programSelection;
        }

        @Override
        public final Builder programSelection(Integer programSelection) {
            this.programSelection = programSelection;
            return this;
        }

        public final void setProgramSelection(Integer programSelection) {
            this.programSelection = programSelection;
        }

        public final RemixSettings.Builder getRemixSettings() {
            return remixSettings != null ? remixSettings.toBuilder() : null;
        }

        @Override
        public final Builder remixSettings(RemixSettings remixSettings) {
            this.remixSettings = remixSettings;
            return this;
        }

        public final void setRemixSettings(RemixSettings.BuilderImpl remixSettings) {
            this.remixSettings = remixSettings != null ? remixSettings.build() : null;
        }

        public final String getSelectorType() {
            return selectorType;
        }

        @Override
        public final Builder selectorType(String selectorType) {
            this.selectorType = selectorType;
            return this;
        }

        @Override
        public final Builder selectorType(AudioSelectorType selectorType) {
            this.selectorType(selectorType == null ? null : selectorType.toString());
            return this;
        }

        public final void setSelectorType(String selectorType) {
            this.selectorType = selectorType;
        }

        public final Collection<Integer> getTracks() {
            if (tracks instanceof SdkAutoConstructList) {
                return null;
            }
            return tracks;
        }

        @Override
        public final Builder tracks(Collection<Integer> tracks) {
            this.tracks = ___listOf__integerMin1Max2147483647Copier.copy(tracks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tracks(Integer... tracks) {
            tracks(Arrays.asList(tracks));
            return this;
        }

        public final void setTracks(Collection<Integer> tracks) {
            this.tracks = ___listOf__integerMin1Max2147483647Copier.copy(tracks);
        }

        @Override
        public AudioSelector build() {
            return new AudioSelector(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
