/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Required when you set Codec, under VideoDescription>CodecSettings to the value AV1.
 */
@Generated("software.amazon.awssdk:codegen")
public final class Av1Settings implements SdkPojo, Serializable, ToCopyableBuilder<Av1Settings.Builder, Av1Settings> {
    private static final SdkField<String> ADAPTIVE_QUANTIZATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AdaptiveQuantization").getter(getter(Av1Settings::adaptiveQuantizationAsString))
            .setter(setter(Builder::adaptiveQuantization))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("adaptiveQuantization").build())
            .build();

    private static final SdkField<String> FRAMERATE_CONTROL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FramerateControl").getter(getter(Av1Settings::framerateControlAsString))
            .setter(setter(Builder::framerateControl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("framerateControl").build()).build();

    private static final SdkField<String> FRAMERATE_CONVERSION_ALGORITHM_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("FramerateConversionAlgorithm")
            .getter(getter(Av1Settings::framerateConversionAlgorithmAsString))
            .setter(setter(Builder::framerateConversionAlgorithm))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("framerateConversionAlgorithm")
                    .build()).build();

    private static final SdkField<Integer> FRAMERATE_DENOMINATOR_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("FramerateDenominator").getter(getter(Av1Settings::framerateDenominator))
            .setter(setter(Builder::framerateDenominator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("framerateDenominator").build())
            .build();

    private static final SdkField<Integer> FRAMERATE_NUMERATOR_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("FramerateNumerator").getter(getter(Av1Settings::framerateNumerator))
            .setter(setter(Builder::framerateNumerator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("framerateNumerator").build())
            .build();

    private static final SdkField<Double> GOP_SIZE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("GopSize").getter(getter(Av1Settings::gopSize)).setter(setter(Builder::gopSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gopSize").build()).build();

    private static final SdkField<Integer> MAX_BITRATE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxBitrate").getter(getter(Av1Settings::maxBitrate)).setter(setter(Builder::maxBitrate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxBitrate").build()).build();

    private static final SdkField<Integer> NUMBER_B_FRAMES_BETWEEN_REFERENCE_FRAMES_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("NumberBFramesBetweenReferenceFrames")
            .getter(getter(Av1Settings::numberBFramesBetweenReferenceFrames))
            .setter(setter(Builder::numberBFramesBetweenReferenceFrames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("numberBFramesBetweenReferenceFrames").build()).build();

    private static final SdkField<Av1QvbrSettings> QVBR_SETTINGS_FIELD = SdkField
            .<Av1QvbrSettings> builder(MarshallingType.SDK_POJO).memberName("QvbrSettings")
            .getter(getter(Av1Settings::qvbrSettings)).setter(setter(Builder::qvbrSettings))
            .constructor(Av1QvbrSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("qvbrSettings").build()).build();

    private static final SdkField<String> RATE_CONTROL_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RateControlMode").getter(getter(Av1Settings::rateControlModeAsString))
            .setter(setter(Builder::rateControlMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rateControlMode").build()).build();

    private static final SdkField<Integer> SLICES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Slices").getter(getter(Av1Settings::slices)).setter(setter(Builder::slices))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("slices").build()).build();

    private static final SdkField<String> SPATIAL_ADAPTIVE_QUANTIZATION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SpatialAdaptiveQuantization")
            .getter(getter(Av1Settings::spatialAdaptiveQuantizationAsString))
            .setter(setter(Builder::spatialAdaptiveQuantization))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("spatialAdaptiveQuantization")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADAPTIVE_QUANTIZATION_FIELD,
            FRAMERATE_CONTROL_FIELD, FRAMERATE_CONVERSION_ALGORITHM_FIELD, FRAMERATE_DENOMINATOR_FIELD,
            FRAMERATE_NUMERATOR_FIELD, GOP_SIZE_FIELD, MAX_BITRATE_FIELD, NUMBER_B_FRAMES_BETWEEN_REFERENCE_FRAMES_FIELD,
            QVBR_SETTINGS_FIELD, RATE_CONTROL_MODE_FIELD, SLICES_FIELD, SPATIAL_ADAPTIVE_QUANTIZATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String adaptiveQuantization;

    private final String framerateControl;

    private final String framerateConversionAlgorithm;

    private final Integer framerateDenominator;

    private final Integer framerateNumerator;

    private final Double gopSize;

    private final Integer maxBitrate;

    private final Integer numberBFramesBetweenReferenceFrames;

    private final Av1QvbrSettings qvbrSettings;

    private final String rateControlMode;

    private final Integer slices;

    private final String spatialAdaptiveQuantization;

    private Av1Settings(BuilderImpl builder) {
        this.adaptiveQuantization = builder.adaptiveQuantization;
        this.framerateControl = builder.framerateControl;
        this.framerateConversionAlgorithm = builder.framerateConversionAlgorithm;
        this.framerateDenominator = builder.framerateDenominator;
        this.framerateNumerator = builder.framerateNumerator;
        this.gopSize = builder.gopSize;
        this.maxBitrate = builder.maxBitrate;
        this.numberBFramesBetweenReferenceFrames = builder.numberBFramesBetweenReferenceFrames;
        this.qvbrSettings = builder.qvbrSettings;
        this.rateControlMode = builder.rateControlMode;
        this.slices = builder.slices;
        this.spatialAdaptiveQuantization = builder.spatialAdaptiveQuantization;
    }

    /**
     * Specify the strength of any adaptive quantization filters that you enable. The value that you choose here applies
     * to Spatial adaptive quantization (spatialAdaptiveQuantization).
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #adaptiveQuantization} will return {@link Av1AdaptiveQuantization#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #adaptiveQuantizationAsString}.
     * </p>
     * 
     * @return Specify the strength of any adaptive quantization filters that you enable. The value that you choose here
     *         applies to Spatial adaptive quantization (spatialAdaptiveQuantization).
     * @see Av1AdaptiveQuantization
     */
    public final Av1AdaptiveQuantization adaptiveQuantization() {
        return Av1AdaptiveQuantization.fromValue(adaptiveQuantization);
    }

    /**
     * Specify the strength of any adaptive quantization filters that you enable. The value that you choose here applies
     * to Spatial adaptive quantization (spatialAdaptiveQuantization).
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #adaptiveQuantization} will return {@link Av1AdaptiveQuantization#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #adaptiveQuantizationAsString}.
     * </p>
     * 
     * @return Specify the strength of any adaptive quantization filters that you enable. The value that you choose here
     *         applies to Spatial adaptive quantization (spatialAdaptiveQuantization).
     * @see Av1AdaptiveQuantization
     */
    public final String adaptiveQuantizationAsString() {
        return adaptiveQuantization;
    }

    /**
     * If you are using the console, use the Framerate setting to specify the frame rate for this output. If you want to
     * keep the same frame rate as the input video, choose Follow source. If you want to do frame rate conversion,
     * choose a frame rate from the dropdown list or choose Custom. The framerates shown in the dropdown list are
     * decimal approximations of fractions. If you choose Custom, specify your frame rate as a fraction. If you are
     * creating your transcoding job specification as a JSON file without the console, use FramerateControl to specify
     * which value the service uses for the frame rate for this output. Choose INITIALIZE_FROM_SOURCE if you want the
     * service to use the frame rate from the input. Choose SPECIFIED if you want the service to use the frame rate you
     * specify in the settings FramerateNumerator and FramerateDenominator.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #framerateControl}
     * will return {@link Av1FramerateControl#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #framerateControlAsString}.
     * </p>
     * 
     * @return If you are using the console, use the Framerate setting to specify the frame rate for this output. If you
     *         want to keep the same frame rate as the input video, choose Follow source. If you want to do frame rate
     *         conversion, choose a frame rate from the dropdown list or choose Custom. The framerates shown in the
     *         dropdown list are decimal approximations of fractions. If you choose Custom, specify your frame rate as a
     *         fraction. If you are creating your transcoding job specification as a JSON file without the console, use
     *         FramerateControl to specify which value the service uses for the frame rate for this output. Choose
     *         INITIALIZE_FROM_SOURCE if you want the service to use the frame rate from the input. Choose SPECIFIED if
     *         you want the service to use the frame rate you specify in the settings FramerateNumerator and
     *         FramerateDenominator.
     * @see Av1FramerateControl
     */
    public final Av1FramerateControl framerateControl() {
        return Av1FramerateControl.fromValue(framerateControl);
    }

    /**
     * If you are using the console, use the Framerate setting to specify the frame rate for this output. If you want to
     * keep the same frame rate as the input video, choose Follow source. If you want to do frame rate conversion,
     * choose a frame rate from the dropdown list or choose Custom. The framerates shown in the dropdown list are
     * decimal approximations of fractions. If you choose Custom, specify your frame rate as a fraction. If you are
     * creating your transcoding job specification as a JSON file without the console, use FramerateControl to specify
     * which value the service uses for the frame rate for this output. Choose INITIALIZE_FROM_SOURCE if you want the
     * service to use the frame rate from the input. Choose SPECIFIED if you want the service to use the frame rate you
     * specify in the settings FramerateNumerator and FramerateDenominator.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #framerateControl}
     * will return {@link Av1FramerateControl#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #framerateControlAsString}.
     * </p>
     * 
     * @return If you are using the console, use the Framerate setting to specify the frame rate for this output. If you
     *         want to keep the same frame rate as the input video, choose Follow source. If you want to do frame rate
     *         conversion, choose a frame rate from the dropdown list or choose Custom. The framerates shown in the
     *         dropdown list are decimal approximations of fractions. If you choose Custom, specify your frame rate as a
     *         fraction. If you are creating your transcoding job specification as a JSON file without the console, use
     *         FramerateControl to specify which value the service uses for the frame rate for this output. Choose
     *         INITIALIZE_FROM_SOURCE if you want the service to use the frame rate from the input. Choose SPECIFIED if
     *         you want the service to use the frame rate you specify in the settings FramerateNumerator and
     *         FramerateDenominator.
     * @see Av1FramerateControl
     */
    public final String framerateControlAsString() {
        return framerateControl;
    }

    /**
     * Choose the method that you want MediaConvert to use when increasing or decreasing the frame rate. We recommend
     * using drop duplicate (DUPLICATE_DROP) for numerically simple conversions, such as 60 fps to 30 fps. For
     * numerically complex conversions, you can use interpolate (INTERPOLATE) to avoid stutter. This results in a smooth
     * picture, but might introduce undesirable video artifacts. For complex frame rate conversions, especially if your
     * source video has already been converted from its original cadence, use FrameFormer (FRAMEFORMER) to do
     * motion-compensated interpolation. FrameFormer chooses the best conversion method frame by frame. Note that using
     * FrameFormer increases the transcoding time and incurs a significant add-on cost.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #framerateConversionAlgorithm} will return {@link Av1FramerateConversionAlgorithm#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #framerateConversionAlgorithmAsString}.
     * </p>
     * 
     * @return Choose the method that you want MediaConvert to use when increasing or decreasing the frame rate. We
     *         recommend using drop duplicate (DUPLICATE_DROP) for numerically simple conversions, such as 60 fps to 30
     *         fps. For numerically complex conversions, you can use interpolate (INTERPOLATE) to avoid stutter. This
     *         results in a smooth picture, but might introduce undesirable video artifacts. For complex frame rate
     *         conversions, especially if your source video has already been converted from its original cadence, use
     *         FrameFormer (FRAMEFORMER) to do motion-compensated interpolation. FrameFormer chooses the best conversion
     *         method frame by frame. Note that using FrameFormer increases the transcoding time and incurs a
     *         significant add-on cost.
     * @see Av1FramerateConversionAlgorithm
     */
    public final Av1FramerateConversionAlgorithm framerateConversionAlgorithm() {
        return Av1FramerateConversionAlgorithm.fromValue(framerateConversionAlgorithm);
    }

    /**
     * Choose the method that you want MediaConvert to use when increasing or decreasing the frame rate. We recommend
     * using drop duplicate (DUPLICATE_DROP) for numerically simple conversions, such as 60 fps to 30 fps. For
     * numerically complex conversions, you can use interpolate (INTERPOLATE) to avoid stutter. This results in a smooth
     * picture, but might introduce undesirable video artifacts. For complex frame rate conversions, especially if your
     * source video has already been converted from its original cadence, use FrameFormer (FRAMEFORMER) to do
     * motion-compensated interpolation. FrameFormer chooses the best conversion method frame by frame. Note that using
     * FrameFormer increases the transcoding time and incurs a significant add-on cost.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #framerateConversionAlgorithm} will return {@link Av1FramerateConversionAlgorithm#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #framerateConversionAlgorithmAsString}.
     * </p>
     * 
     * @return Choose the method that you want MediaConvert to use when increasing or decreasing the frame rate. We
     *         recommend using drop duplicate (DUPLICATE_DROP) for numerically simple conversions, such as 60 fps to 30
     *         fps. For numerically complex conversions, you can use interpolate (INTERPOLATE) to avoid stutter. This
     *         results in a smooth picture, but might introduce undesirable video artifacts. For complex frame rate
     *         conversions, especially if your source video has already been converted from its original cadence, use
     *         FrameFormer (FRAMEFORMER) to do motion-compensated interpolation. FrameFormer chooses the best conversion
     *         method frame by frame. Note that using FrameFormer increases the transcoding time and incurs a
     *         significant add-on cost.
     * @see Av1FramerateConversionAlgorithm
     */
    public final String framerateConversionAlgorithmAsString() {
        return framerateConversionAlgorithm;
    }

    /**
     * When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a fraction. For
     * example, 24000 / 1001 = 23.976 fps. Use FramerateDenominator to specify the denominator of this fraction. In this
     * example, use 1001 for the value of FramerateDenominator. When you use the console for transcode jobs that use
     * frame rate conversion, provide the value as a decimal number for Framerate. In this example, specify 23.976.
     * 
     * @return When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a
     *         fraction. For example, 24000 / 1001 = 23.976 fps. Use FramerateDenominator to specify the denominator of
     *         this fraction. In this example, use 1001 for the value of FramerateDenominator. When you use the console
     *         for transcode jobs that use frame rate conversion, provide the value as a decimal number for Framerate.
     *         In this example, specify 23.976.
     */
    public final Integer framerateDenominator() {
        return framerateDenominator;
    }

    /**
     * When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a fraction. For
     * example, 24000 / 1001 = 23.976 fps. Use FramerateNumerator to specify the numerator of this fraction. In this
     * example, use 24000 for the value of FramerateNumerator. When you use the console for transcode jobs that use
     * frame rate conversion, provide the value as a decimal number for Framerate. In this example, specify 23.976.
     * 
     * @return When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a
     *         fraction. For example, 24000 / 1001 = 23.976 fps. Use FramerateNumerator to specify the numerator of this
     *         fraction. In this example, use 24000 for the value of FramerateNumerator. When you use the console for
     *         transcode jobs that use frame rate conversion, provide the value as a decimal number for Framerate. In
     *         this example, specify 23.976.
     */
    public final Integer framerateNumerator() {
        return framerateNumerator;
    }

    /**
     * Specify the GOP length (keyframe interval) in frames. With AV1, MediaConvert doesn't support GOP length in
     * seconds. This value must be greater than zero and preferably equal to 1 + ((numberBFrames + 1) * x), where x is
     * an integer value.
     * 
     * @return Specify the GOP length (keyframe interval) in frames. With AV1, MediaConvert doesn't support GOP length
     *         in seconds. This value must be greater than zero and preferably equal to 1 + ((numberBFrames + 1) * x),
     *         where x is an integer value.
     */
    public final Double gopSize() {
        return gopSize;
    }

    /**
     * Maximum bitrate in bits/second. For example, enter five megabits per second as 5000000. Required when Rate
     * control mode is QVBR.
     * 
     * @return Maximum bitrate in bits/second. For example, enter five megabits per second as 5000000. Required when
     *         Rate control mode is QVBR.
     */
    public final Integer maxBitrate() {
        return maxBitrate;
    }

    /**
     * Specify from the number of B-frames, in the range of 0-15. For AV1 encoding, we recommend using 7 or 15. Choose a
     * larger number for a lower bitrate and smaller file size; choose a smaller number for better video quality.
     * 
     * @return Specify from the number of B-frames, in the range of 0-15. For AV1 encoding, we recommend using 7 or 15.
     *         Choose a larger number for a lower bitrate and smaller file size; choose a smaller number for better
     *         video quality.
     */
    public final Integer numberBFramesBetweenReferenceFrames() {
        return numberBFramesBetweenReferenceFrames;
    }

    /**
     * Settings for quality-defined variable bitrate encoding with the AV1 codec. Required when you set Rate control
     * mode to QVBR. Not valid when you set Rate control mode to a value other than QVBR, or when you don't define Rate
     * control mode.
     * 
     * @return Settings for quality-defined variable bitrate encoding with the AV1 codec. Required when you set Rate
     *         control mode to QVBR. Not valid when you set Rate control mode to a value other than QVBR, or when you
     *         don't define Rate control mode.
     */
    public final Av1QvbrSettings qvbrSettings() {
        return qvbrSettings;
    }

    /**
     * 'With AV1 outputs, for rate control mode, MediaConvert supports only quality-defined variable bitrate (QVBR). You
     * can''t use CBR or VBR.'
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #rateControlMode}
     * will return {@link Av1RateControlMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #rateControlModeAsString}.
     * </p>
     * 
     * @return 'With AV1 outputs, for rate control mode, MediaConvert supports only quality-defined variable bitrate
     *         (QVBR). You can''t use CBR or VBR.'
     * @see Av1RateControlMode
     */
    public final Av1RateControlMode rateControlMode() {
        return Av1RateControlMode.fromValue(rateControlMode);
    }

    /**
     * 'With AV1 outputs, for rate control mode, MediaConvert supports only quality-defined variable bitrate (QVBR). You
     * can''t use CBR or VBR.'
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #rateControlMode}
     * will return {@link Av1RateControlMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #rateControlModeAsString}.
     * </p>
     * 
     * @return 'With AV1 outputs, for rate control mode, MediaConvert supports only quality-defined variable bitrate
     *         (QVBR). You can''t use CBR or VBR.'
     * @see Av1RateControlMode
     */
    public final String rateControlModeAsString() {
        return rateControlMode;
    }

    /**
     * Specify the number of slices per picture. This value must be 1, 2, 4, 8, 16, or 32. For progressive pictures,
     * this value must be less than or equal to the number of macroblock rows. For interlaced pictures, this value must
     * be less than or equal to half the number of macroblock rows.
     * 
     * @return Specify the number of slices per picture. This value must be 1, 2, 4, 8, 16, or 32. For progressive
     *         pictures, this value must be less than or equal to the number of macroblock rows. For interlaced
     *         pictures, this value must be less than or equal to half the number of macroblock rows.
     */
    public final Integer slices() {
        return slices;
    }

    /**
     * Keep the default value, Enabled (ENABLED), to adjust quantization within each frame based on spatial variation of
     * content complexity. When you enable this feature, the encoder uses fewer bits on areas that can sustain more
     * distortion with no noticeable visual degradation and uses more bits on areas where any small distortion will be
     * noticeable. For example, complex textured blocks are encoded with fewer bits and smooth textured blocks are
     * encoded with more bits. Enabling this feature will almost always improve your video quality. Note, though, that
     * this feature doesn't take into account where the viewer's attention is likely to be. If viewers are likely to be
     * focusing their attention on a part of the screen with a lot of complex texture, you might choose to disable this
     * feature. Related setting: When you enable spatial adaptive quantization, set the value for Adaptive quantization
     * (adaptiveQuantization) depending on your content. For homogeneous content, such as cartoons and video games, set
     * it to Low. For content with a wider variety of textures, set it to High or Higher.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #spatialAdaptiveQuantization} will return {@link Av1SpatialAdaptiveQuantization#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #spatialAdaptiveQuantizationAsString}.
     * </p>
     * 
     * @return Keep the default value, Enabled (ENABLED), to adjust quantization within each frame based on spatial
     *         variation of content complexity. When you enable this feature, the encoder uses fewer bits on areas that
     *         can sustain more distortion with no noticeable visual degradation and uses more bits on areas where any
     *         small distortion will be noticeable. For example, complex textured blocks are encoded with fewer bits and
     *         smooth textured blocks are encoded with more bits. Enabling this feature will almost always improve your
     *         video quality. Note, though, that this feature doesn't take into account where the viewer's attention is
     *         likely to be. If viewers are likely to be focusing their attention on a part of the screen with a lot of
     *         complex texture, you might choose to disable this feature. Related setting: When you enable spatial
     *         adaptive quantization, set the value for Adaptive quantization (adaptiveQuantization) depending on your
     *         content. For homogeneous content, such as cartoons and video games, set it to Low. For content with a
     *         wider variety of textures, set it to High or Higher.
     * @see Av1SpatialAdaptiveQuantization
     */
    public final Av1SpatialAdaptiveQuantization spatialAdaptiveQuantization() {
        return Av1SpatialAdaptiveQuantization.fromValue(spatialAdaptiveQuantization);
    }

    /**
     * Keep the default value, Enabled (ENABLED), to adjust quantization within each frame based on spatial variation of
     * content complexity. When you enable this feature, the encoder uses fewer bits on areas that can sustain more
     * distortion with no noticeable visual degradation and uses more bits on areas where any small distortion will be
     * noticeable. For example, complex textured blocks are encoded with fewer bits and smooth textured blocks are
     * encoded with more bits. Enabling this feature will almost always improve your video quality. Note, though, that
     * this feature doesn't take into account where the viewer's attention is likely to be. If viewers are likely to be
     * focusing their attention on a part of the screen with a lot of complex texture, you might choose to disable this
     * feature. Related setting: When you enable spatial adaptive quantization, set the value for Adaptive quantization
     * (adaptiveQuantization) depending on your content. For homogeneous content, such as cartoons and video games, set
     * it to Low. For content with a wider variety of textures, set it to High or Higher.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #spatialAdaptiveQuantization} will return {@link Av1SpatialAdaptiveQuantization#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #spatialAdaptiveQuantizationAsString}.
     * </p>
     * 
     * @return Keep the default value, Enabled (ENABLED), to adjust quantization within each frame based on spatial
     *         variation of content complexity. When you enable this feature, the encoder uses fewer bits on areas that
     *         can sustain more distortion with no noticeable visual degradation and uses more bits on areas where any
     *         small distortion will be noticeable. For example, complex textured blocks are encoded with fewer bits and
     *         smooth textured blocks are encoded with more bits. Enabling this feature will almost always improve your
     *         video quality. Note, though, that this feature doesn't take into account where the viewer's attention is
     *         likely to be. If viewers are likely to be focusing their attention on a part of the screen with a lot of
     *         complex texture, you might choose to disable this feature. Related setting: When you enable spatial
     *         adaptive quantization, set the value for Adaptive quantization (adaptiveQuantization) depending on your
     *         content. For homogeneous content, such as cartoons and video games, set it to Low. For content with a
     *         wider variety of textures, set it to High or Higher.
     * @see Av1SpatialAdaptiveQuantization
     */
    public final String spatialAdaptiveQuantizationAsString() {
        return spatialAdaptiveQuantization;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(adaptiveQuantizationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(framerateControlAsString());
        hashCode = 31 * hashCode + Objects.hashCode(framerateConversionAlgorithmAsString());
        hashCode = 31 * hashCode + Objects.hashCode(framerateDenominator());
        hashCode = 31 * hashCode + Objects.hashCode(framerateNumerator());
        hashCode = 31 * hashCode + Objects.hashCode(gopSize());
        hashCode = 31 * hashCode + Objects.hashCode(maxBitrate());
        hashCode = 31 * hashCode + Objects.hashCode(numberBFramesBetweenReferenceFrames());
        hashCode = 31 * hashCode + Objects.hashCode(qvbrSettings());
        hashCode = 31 * hashCode + Objects.hashCode(rateControlModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(slices());
        hashCode = 31 * hashCode + Objects.hashCode(spatialAdaptiveQuantizationAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Av1Settings)) {
            return false;
        }
        Av1Settings other = (Av1Settings) obj;
        return Objects.equals(adaptiveQuantizationAsString(), other.adaptiveQuantizationAsString())
                && Objects.equals(framerateControlAsString(), other.framerateControlAsString())
                && Objects.equals(framerateConversionAlgorithmAsString(), other.framerateConversionAlgorithmAsString())
                && Objects.equals(framerateDenominator(), other.framerateDenominator())
                && Objects.equals(framerateNumerator(), other.framerateNumerator()) && Objects.equals(gopSize(), other.gopSize())
                && Objects.equals(maxBitrate(), other.maxBitrate())
                && Objects.equals(numberBFramesBetweenReferenceFrames(), other.numberBFramesBetweenReferenceFrames())
                && Objects.equals(qvbrSettings(), other.qvbrSettings())
                && Objects.equals(rateControlModeAsString(), other.rateControlModeAsString())
                && Objects.equals(slices(), other.slices())
                && Objects.equals(spatialAdaptiveQuantizationAsString(), other.spatialAdaptiveQuantizationAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Av1Settings").add("AdaptiveQuantization", adaptiveQuantizationAsString())
                .add("FramerateControl", framerateControlAsString())
                .add("FramerateConversionAlgorithm", framerateConversionAlgorithmAsString())
                .add("FramerateDenominator", framerateDenominator()).add("FramerateNumerator", framerateNumerator())
                .add("GopSize", gopSize()).add("MaxBitrate", maxBitrate())
                .add("NumberBFramesBetweenReferenceFrames", numberBFramesBetweenReferenceFrames())
                .add("QvbrSettings", qvbrSettings()).add("RateControlMode", rateControlModeAsString()).add("Slices", slices())
                .add("SpatialAdaptiveQuantization", spatialAdaptiveQuantizationAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AdaptiveQuantization":
            return Optional.ofNullable(clazz.cast(adaptiveQuantizationAsString()));
        case "FramerateControl":
            return Optional.ofNullable(clazz.cast(framerateControlAsString()));
        case "FramerateConversionAlgorithm":
            return Optional.ofNullable(clazz.cast(framerateConversionAlgorithmAsString()));
        case "FramerateDenominator":
            return Optional.ofNullable(clazz.cast(framerateDenominator()));
        case "FramerateNumerator":
            return Optional.ofNullable(clazz.cast(framerateNumerator()));
        case "GopSize":
            return Optional.ofNullable(clazz.cast(gopSize()));
        case "MaxBitrate":
            return Optional.ofNullable(clazz.cast(maxBitrate()));
        case "NumberBFramesBetweenReferenceFrames":
            return Optional.ofNullable(clazz.cast(numberBFramesBetweenReferenceFrames()));
        case "QvbrSettings":
            return Optional.ofNullable(clazz.cast(qvbrSettings()));
        case "RateControlMode":
            return Optional.ofNullable(clazz.cast(rateControlModeAsString()));
        case "Slices":
            return Optional.ofNullable(clazz.cast(slices()));
        case "SpatialAdaptiveQuantization":
            return Optional.ofNullable(clazz.cast(spatialAdaptiveQuantizationAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Av1Settings, T> g) {
        return obj -> g.apply((Av1Settings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Av1Settings> {
        /**
         * Specify the strength of any adaptive quantization filters that you enable. The value that you choose here
         * applies to Spatial adaptive quantization (spatialAdaptiveQuantization).
         * 
         * @param adaptiveQuantization
         *        Specify the strength of any adaptive quantization filters that you enable. The value that you choose
         *        here applies to Spatial adaptive quantization (spatialAdaptiveQuantization).
         * @see Av1AdaptiveQuantization
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Av1AdaptiveQuantization
         */
        Builder adaptiveQuantization(String adaptiveQuantization);

        /**
         * Specify the strength of any adaptive quantization filters that you enable. The value that you choose here
         * applies to Spatial adaptive quantization (spatialAdaptiveQuantization).
         * 
         * @param adaptiveQuantization
         *        Specify the strength of any adaptive quantization filters that you enable. The value that you choose
         *        here applies to Spatial adaptive quantization (spatialAdaptiveQuantization).
         * @see Av1AdaptiveQuantization
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Av1AdaptiveQuantization
         */
        Builder adaptiveQuantization(Av1AdaptiveQuantization adaptiveQuantization);

        /**
         * If you are using the console, use the Framerate setting to specify the frame rate for this output. If you
         * want to keep the same frame rate as the input video, choose Follow source. If you want to do frame rate
         * conversion, choose a frame rate from the dropdown list or choose Custom. The framerates shown in the dropdown
         * list are decimal approximations of fractions. If you choose Custom, specify your frame rate as a fraction. If
         * you are creating your transcoding job specification as a JSON file without the console, use FramerateControl
         * to specify which value the service uses for the frame rate for this output. Choose INITIALIZE_FROM_SOURCE if
         * you want the service to use the frame rate from the input. Choose SPECIFIED if you want the service to use
         * the frame rate you specify in the settings FramerateNumerator and FramerateDenominator.
         * 
         * @param framerateControl
         *        If you are using the console, use the Framerate setting to specify the frame rate for this output. If
         *        you want to keep the same frame rate as the input video, choose Follow source. If you want to do frame
         *        rate conversion, choose a frame rate from the dropdown list or choose Custom. The framerates shown in
         *        the dropdown list are decimal approximations of fractions. If you choose Custom, specify your frame
         *        rate as a fraction. If you are creating your transcoding job specification as a JSON file without the
         *        console, use FramerateControl to specify which value the service uses for the frame rate for this
         *        output. Choose INITIALIZE_FROM_SOURCE if you want the service to use the frame rate from the input.
         *        Choose SPECIFIED if you want the service to use the frame rate you specify in the settings
         *        FramerateNumerator and FramerateDenominator.
         * @see Av1FramerateControl
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Av1FramerateControl
         */
        Builder framerateControl(String framerateControl);

        /**
         * If you are using the console, use the Framerate setting to specify the frame rate for this output. If you
         * want to keep the same frame rate as the input video, choose Follow source. If you want to do frame rate
         * conversion, choose a frame rate from the dropdown list or choose Custom. The framerates shown in the dropdown
         * list are decimal approximations of fractions. If you choose Custom, specify your frame rate as a fraction. If
         * you are creating your transcoding job specification as a JSON file without the console, use FramerateControl
         * to specify which value the service uses for the frame rate for this output. Choose INITIALIZE_FROM_SOURCE if
         * you want the service to use the frame rate from the input. Choose SPECIFIED if you want the service to use
         * the frame rate you specify in the settings FramerateNumerator and FramerateDenominator.
         * 
         * @param framerateControl
         *        If you are using the console, use the Framerate setting to specify the frame rate for this output. If
         *        you want to keep the same frame rate as the input video, choose Follow source. If you want to do frame
         *        rate conversion, choose a frame rate from the dropdown list or choose Custom. The framerates shown in
         *        the dropdown list are decimal approximations of fractions. If you choose Custom, specify your frame
         *        rate as a fraction. If you are creating your transcoding job specification as a JSON file without the
         *        console, use FramerateControl to specify which value the service uses for the frame rate for this
         *        output. Choose INITIALIZE_FROM_SOURCE if you want the service to use the frame rate from the input.
         *        Choose SPECIFIED if you want the service to use the frame rate you specify in the settings
         *        FramerateNumerator and FramerateDenominator.
         * @see Av1FramerateControl
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Av1FramerateControl
         */
        Builder framerateControl(Av1FramerateControl framerateControl);

        /**
         * Choose the method that you want MediaConvert to use when increasing or decreasing the frame rate. We
         * recommend using drop duplicate (DUPLICATE_DROP) for numerically simple conversions, such as 60 fps to 30 fps.
         * For numerically complex conversions, you can use interpolate (INTERPOLATE) to avoid stutter. This results in
         * a smooth picture, but might introduce undesirable video artifacts. For complex frame rate conversions,
         * especially if your source video has already been converted from its original cadence, use FrameFormer
         * (FRAMEFORMER) to do motion-compensated interpolation. FrameFormer chooses the best conversion method frame by
         * frame. Note that using FrameFormer increases the transcoding time and incurs a significant add-on cost.
         * 
         * @param framerateConversionAlgorithm
         *        Choose the method that you want MediaConvert to use when increasing or decreasing the frame rate. We
         *        recommend using drop duplicate (DUPLICATE_DROP) for numerically simple conversions, such as 60 fps to
         *        30 fps. For numerically complex conversions, you can use interpolate (INTERPOLATE) to avoid stutter.
         *        This results in a smooth picture, but might introduce undesirable video artifacts. For complex frame
         *        rate conversions, especially if your source video has already been converted from its original
         *        cadence, use FrameFormer (FRAMEFORMER) to do motion-compensated interpolation. FrameFormer chooses the
         *        best conversion method frame by frame. Note that using FrameFormer increases the transcoding time and
         *        incurs a significant add-on cost.
         * @see Av1FramerateConversionAlgorithm
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Av1FramerateConversionAlgorithm
         */
        Builder framerateConversionAlgorithm(String framerateConversionAlgorithm);

        /**
         * Choose the method that you want MediaConvert to use when increasing or decreasing the frame rate. We
         * recommend using drop duplicate (DUPLICATE_DROP) for numerically simple conversions, such as 60 fps to 30 fps.
         * For numerically complex conversions, you can use interpolate (INTERPOLATE) to avoid stutter. This results in
         * a smooth picture, but might introduce undesirable video artifacts. For complex frame rate conversions,
         * especially if your source video has already been converted from its original cadence, use FrameFormer
         * (FRAMEFORMER) to do motion-compensated interpolation. FrameFormer chooses the best conversion method frame by
         * frame. Note that using FrameFormer increases the transcoding time and incurs a significant add-on cost.
         * 
         * @param framerateConversionAlgorithm
         *        Choose the method that you want MediaConvert to use when increasing or decreasing the frame rate. We
         *        recommend using drop duplicate (DUPLICATE_DROP) for numerically simple conversions, such as 60 fps to
         *        30 fps. For numerically complex conversions, you can use interpolate (INTERPOLATE) to avoid stutter.
         *        This results in a smooth picture, but might introduce undesirable video artifacts. For complex frame
         *        rate conversions, especially if your source video has already been converted from its original
         *        cadence, use FrameFormer (FRAMEFORMER) to do motion-compensated interpolation. FrameFormer chooses the
         *        best conversion method frame by frame. Note that using FrameFormer increases the transcoding time and
         *        incurs a significant add-on cost.
         * @see Av1FramerateConversionAlgorithm
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Av1FramerateConversionAlgorithm
         */
        Builder framerateConversionAlgorithm(Av1FramerateConversionAlgorithm framerateConversionAlgorithm);

        /**
         * When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a fraction.
         * For example, 24000 / 1001 = 23.976 fps. Use FramerateDenominator to specify the denominator of this fraction.
         * In this example, use 1001 for the value of FramerateDenominator. When you use the console for transcode jobs
         * that use frame rate conversion, provide the value as a decimal number for Framerate. In this example, specify
         * 23.976.
         * 
         * @param framerateDenominator
         *        When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a
         *        fraction. For example, 24000 / 1001 = 23.976 fps. Use FramerateDenominator to specify the denominator
         *        of this fraction. In this example, use 1001 for the value of FramerateDenominator. When you use the
         *        console for transcode jobs that use frame rate conversion, provide the value as a decimal number for
         *        Framerate. In this example, specify 23.976.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder framerateDenominator(Integer framerateDenominator);

        /**
         * When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a fraction.
         * For example, 24000 / 1001 = 23.976 fps. Use FramerateNumerator to specify the numerator of this fraction. In
         * this example, use 24000 for the value of FramerateNumerator. When you use the console for transcode jobs that
         * use frame rate conversion, provide the value as a decimal number for Framerate. In this example, specify
         * 23.976.
         * 
         * @param framerateNumerator
         *        When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a
         *        fraction. For example, 24000 / 1001 = 23.976 fps. Use FramerateNumerator to specify the numerator of
         *        this fraction. In this example, use 24000 for the value of FramerateNumerator. When you use the
         *        console for transcode jobs that use frame rate conversion, provide the value as a decimal number for
         *        Framerate. In this example, specify 23.976.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder framerateNumerator(Integer framerateNumerator);

        /**
         * Specify the GOP length (keyframe interval) in frames. With AV1, MediaConvert doesn't support GOP length in
         * seconds. This value must be greater than zero and preferably equal to 1 + ((numberBFrames + 1) * x), where x
         * is an integer value.
         * 
         * @param gopSize
         *        Specify the GOP length (keyframe interval) in frames. With AV1, MediaConvert doesn't support GOP
         *        length in seconds. This value must be greater than zero and preferably equal to 1 + ((numberBFrames +
         *        1) * x), where x is an integer value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gopSize(Double gopSize);

        /**
         * Maximum bitrate in bits/second. For example, enter five megabits per second as 5000000. Required when Rate
         * control mode is QVBR.
         * 
         * @param maxBitrate
         *        Maximum bitrate in bits/second. For example, enter five megabits per second as 5000000. Required when
         *        Rate control mode is QVBR.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxBitrate(Integer maxBitrate);

        /**
         * Specify from the number of B-frames, in the range of 0-15. For AV1 encoding, we recommend using 7 or 15.
         * Choose a larger number for a lower bitrate and smaller file size; choose a smaller number for better video
         * quality.
         * 
         * @param numberBFramesBetweenReferenceFrames
         *        Specify from the number of B-frames, in the range of 0-15. For AV1 encoding, we recommend using 7 or
         *        15. Choose a larger number for a lower bitrate and smaller file size; choose a smaller number for
         *        better video quality.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberBFramesBetweenReferenceFrames(Integer numberBFramesBetweenReferenceFrames);

        /**
         * Settings for quality-defined variable bitrate encoding with the AV1 codec. Required when you set Rate control
         * mode to QVBR. Not valid when you set Rate control mode to a value other than QVBR, or when you don't define
         * Rate control mode.
         * 
         * @param qvbrSettings
         *        Settings for quality-defined variable bitrate encoding with the AV1 codec. Required when you set Rate
         *        control mode to QVBR. Not valid when you set Rate control mode to a value other than QVBR, or when you
         *        don't define Rate control mode.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder qvbrSettings(Av1QvbrSettings qvbrSettings);

        /**
         * Settings for quality-defined variable bitrate encoding with the AV1 codec. Required when you set Rate control
         * mode to QVBR. Not valid when you set Rate control mode to a value other than QVBR, or when you don't define
         * Rate control mode. This is a convenience that creates an instance of the {@link Av1QvbrSettings.Builder}
         * avoiding the need to create one manually via {@link Av1QvbrSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link Av1QvbrSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #qvbrSettings(Av1QvbrSettings)}.
         * 
         * @param qvbrSettings
         *        a consumer that will call methods on {@link Av1QvbrSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #qvbrSettings(Av1QvbrSettings)
         */
        default Builder qvbrSettings(Consumer<Av1QvbrSettings.Builder> qvbrSettings) {
            return qvbrSettings(Av1QvbrSettings.builder().applyMutation(qvbrSettings).build());
        }

        /**
         * 'With AV1 outputs, for rate control mode, MediaConvert supports only quality-defined variable bitrate (QVBR).
         * You can''t use CBR or VBR.'
         * 
         * @param rateControlMode
         *        'With AV1 outputs, for rate control mode, MediaConvert supports only quality-defined variable bitrate
         *        (QVBR). You can''t use CBR or VBR.'
         * @see Av1RateControlMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Av1RateControlMode
         */
        Builder rateControlMode(String rateControlMode);

        /**
         * 'With AV1 outputs, for rate control mode, MediaConvert supports only quality-defined variable bitrate (QVBR).
         * You can''t use CBR or VBR.'
         * 
         * @param rateControlMode
         *        'With AV1 outputs, for rate control mode, MediaConvert supports only quality-defined variable bitrate
         *        (QVBR). You can''t use CBR or VBR.'
         * @see Av1RateControlMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Av1RateControlMode
         */
        Builder rateControlMode(Av1RateControlMode rateControlMode);

        /**
         * Specify the number of slices per picture. This value must be 1, 2, 4, 8, 16, or 32. For progressive pictures,
         * this value must be less than or equal to the number of macroblock rows. For interlaced pictures, this value
         * must be less than or equal to half the number of macroblock rows.
         * 
         * @param slices
         *        Specify the number of slices per picture. This value must be 1, 2, 4, 8, 16, or 32. For progressive
         *        pictures, this value must be less than or equal to the number of macroblock rows. For interlaced
         *        pictures, this value must be less than or equal to half the number of macroblock rows.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slices(Integer slices);

        /**
         * Keep the default value, Enabled (ENABLED), to adjust quantization within each frame based on spatial
         * variation of content complexity. When you enable this feature, the encoder uses fewer bits on areas that can
         * sustain more distortion with no noticeable visual degradation and uses more bits on areas where any small
         * distortion will be noticeable. For example, complex textured blocks are encoded with fewer bits and smooth
         * textured blocks are encoded with more bits. Enabling this feature will almost always improve your video
         * quality. Note, though, that this feature doesn't take into account where the viewer's attention is likely to
         * be. If viewers are likely to be focusing their attention on a part of the screen with a lot of complex
         * texture, you might choose to disable this feature. Related setting: When you enable spatial adaptive
         * quantization, set the value for Adaptive quantization (adaptiveQuantization) depending on your content. For
         * homogeneous content, such as cartoons and video games, set it to Low. For content with a wider variety of
         * textures, set it to High or Higher.
         * 
         * @param spatialAdaptiveQuantization
         *        Keep the default value, Enabled (ENABLED), to adjust quantization within each frame based on spatial
         *        variation of content complexity. When you enable this feature, the encoder uses fewer bits on areas
         *        that can sustain more distortion with no noticeable visual degradation and uses more bits on areas
         *        where any small distortion will be noticeable. For example, complex textured blocks are encoded with
         *        fewer bits and smooth textured blocks are encoded with more bits. Enabling this feature will almost
         *        always improve your video quality. Note, though, that this feature doesn't take into account where the
         *        viewer's attention is likely to be. If viewers are likely to be focusing their attention on a part of
         *        the screen with a lot of complex texture, you might choose to disable this feature. Related setting:
         *        When you enable spatial adaptive quantization, set the value for Adaptive quantization
         *        (adaptiveQuantization) depending on your content. For homogeneous content, such as cartoons and video
         *        games, set it to Low. For content with a wider variety of textures, set it to High or Higher.
         * @see Av1SpatialAdaptiveQuantization
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Av1SpatialAdaptiveQuantization
         */
        Builder spatialAdaptiveQuantization(String spatialAdaptiveQuantization);

        /**
         * Keep the default value, Enabled (ENABLED), to adjust quantization within each frame based on spatial
         * variation of content complexity. When you enable this feature, the encoder uses fewer bits on areas that can
         * sustain more distortion with no noticeable visual degradation and uses more bits on areas where any small
         * distortion will be noticeable. For example, complex textured blocks are encoded with fewer bits and smooth
         * textured blocks are encoded with more bits. Enabling this feature will almost always improve your video
         * quality. Note, though, that this feature doesn't take into account where the viewer's attention is likely to
         * be. If viewers are likely to be focusing their attention on a part of the screen with a lot of complex
         * texture, you might choose to disable this feature. Related setting: When you enable spatial adaptive
         * quantization, set the value for Adaptive quantization (adaptiveQuantization) depending on your content. For
         * homogeneous content, such as cartoons and video games, set it to Low. For content with a wider variety of
         * textures, set it to High or Higher.
         * 
         * @param spatialAdaptiveQuantization
         *        Keep the default value, Enabled (ENABLED), to adjust quantization within each frame based on spatial
         *        variation of content complexity. When you enable this feature, the encoder uses fewer bits on areas
         *        that can sustain more distortion with no noticeable visual degradation and uses more bits on areas
         *        where any small distortion will be noticeable. For example, complex textured blocks are encoded with
         *        fewer bits and smooth textured blocks are encoded with more bits. Enabling this feature will almost
         *        always improve your video quality. Note, though, that this feature doesn't take into account where the
         *        viewer's attention is likely to be. If viewers are likely to be focusing their attention on a part of
         *        the screen with a lot of complex texture, you might choose to disable this feature. Related setting:
         *        When you enable spatial adaptive quantization, set the value for Adaptive quantization
         *        (adaptiveQuantization) depending on your content. For homogeneous content, such as cartoons and video
         *        games, set it to Low. For content with a wider variety of textures, set it to High or Higher.
         * @see Av1SpatialAdaptiveQuantization
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Av1SpatialAdaptiveQuantization
         */
        Builder spatialAdaptiveQuantization(Av1SpatialAdaptiveQuantization spatialAdaptiveQuantization);
    }

    static final class BuilderImpl implements Builder {
        private String adaptiveQuantization;

        private String framerateControl;

        private String framerateConversionAlgorithm;

        private Integer framerateDenominator;

        private Integer framerateNumerator;

        private Double gopSize;

        private Integer maxBitrate;

        private Integer numberBFramesBetweenReferenceFrames;

        private Av1QvbrSettings qvbrSettings;

        private String rateControlMode;

        private Integer slices;

        private String spatialAdaptiveQuantization;

        private BuilderImpl() {
        }

        private BuilderImpl(Av1Settings model) {
            adaptiveQuantization(model.adaptiveQuantization);
            framerateControl(model.framerateControl);
            framerateConversionAlgorithm(model.framerateConversionAlgorithm);
            framerateDenominator(model.framerateDenominator);
            framerateNumerator(model.framerateNumerator);
            gopSize(model.gopSize);
            maxBitrate(model.maxBitrate);
            numberBFramesBetweenReferenceFrames(model.numberBFramesBetweenReferenceFrames);
            qvbrSettings(model.qvbrSettings);
            rateControlMode(model.rateControlMode);
            slices(model.slices);
            spatialAdaptiveQuantization(model.spatialAdaptiveQuantization);
        }

        public final String getAdaptiveQuantization() {
            return adaptiveQuantization;
        }

        @Override
        public final Builder adaptiveQuantization(String adaptiveQuantization) {
            this.adaptiveQuantization = adaptiveQuantization;
            return this;
        }

        @Override
        public final Builder adaptiveQuantization(Av1AdaptiveQuantization adaptiveQuantization) {
            this.adaptiveQuantization(adaptiveQuantization == null ? null : adaptiveQuantization.toString());
            return this;
        }

        public final void setAdaptiveQuantization(String adaptiveQuantization) {
            this.adaptiveQuantization = adaptiveQuantization;
        }

        public final String getFramerateControl() {
            return framerateControl;
        }

        @Override
        public final Builder framerateControl(String framerateControl) {
            this.framerateControl = framerateControl;
            return this;
        }

        @Override
        public final Builder framerateControl(Av1FramerateControl framerateControl) {
            this.framerateControl(framerateControl == null ? null : framerateControl.toString());
            return this;
        }

        public final void setFramerateControl(String framerateControl) {
            this.framerateControl = framerateControl;
        }

        public final String getFramerateConversionAlgorithm() {
            return framerateConversionAlgorithm;
        }

        @Override
        public final Builder framerateConversionAlgorithm(String framerateConversionAlgorithm) {
            this.framerateConversionAlgorithm = framerateConversionAlgorithm;
            return this;
        }

        @Override
        public final Builder framerateConversionAlgorithm(Av1FramerateConversionAlgorithm framerateConversionAlgorithm) {
            this.framerateConversionAlgorithm(framerateConversionAlgorithm == null ? null : framerateConversionAlgorithm
                    .toString());
            return this;
        }

        public final void setFramerateConversionAlgorithm(String framerateConversionAlgorithm) {
            this.framerateConversionAlgorithm = framerateConversionAlgorithm;
        }

        public final Integer getFramerateDenominator() {
            return framerateDenominator;
        }

        @Override
        public final Builder framerateDenominator(Integer framerateDenominator) {
            this.framerateDenominator = framerateDenominator;
            return this;
        }

        public final void setFramerateDenominator(Integer framerateDenominator) {
            this.framerateDenominator = framerateDenominator;
        }

        public final Integer getFramerateNumerator() {
            return framerateNumerator;
        }

        @Override
        public final Builder framerateNumerator(Integer framerateNumerator) {
            this.framerateNumerator = framerateNumerator;
            return this;
        }

        public final void setFramerateNumerator(Integer framerateNumerator) {
            this.framerateNumerator = framerateNumerator;
        }

        public final Double getGopSize() {
            return gopSize;
        }

        @Override
        public final Builder gopSize(Double gopSize) {
            this.gopSize = gopSize;
            return this;
        }

        public final void setGopSize(Double gopSize) {
            this.gopSize = gopSize;
        }

        public final Integer getMaxBitrate() {
            return maxBitrate;
        }

        @Override
        public final Builder maxBitrate(Integer maxBitrate) {
            this.maxBitrate = maxBitrate;
            return this;
        }

        public final void setMaxBitrate(Integer maxBitrate) {
            this.maxBitrate = maxBitrate;
        }

        public final Integer getNumberBFramesBetweenReferenceFrames() {
            return numberBFramesBetweenReferenceFrames;
        }

        @Override
        public final Builder numberBFramesBetweenReferenceFrames(Integer numberBFramesBetweenReferenceFrames) {
            this.numberBFramesBetweenReferenceFrames = numberBFramesBetweenReferenceFrames;
            return this;
        }

        public final void setNumberBFramesBetweenReferenceFrames(Integer numberBFramesBetweenReferenceFrames) {
            this.numberBFramesBetweenReferenceFrames = numberBFramesBetweenReferenceFrames;
        }

        public final Av1QvbrSettings.Builder getQvbrSettings() {
            return qvbrSettings != null ? qvbrSettings.toBuilder() : null;
        }

        @Override
        public final Builder qvbrSettings(Av1QvbrSettings qvbrSettings) {
            this.qvbrSettings = qvbrSettings;
            return this;
        }

        public final void setQvbrSettings(Av1QvbrSettings.BuilderImpl qvbrSettings) {
            this.qvbrSettings = qvbrSettings != null ? qvbrSettings.build() : null;
        }

        public final String getRateControlMode() {
            return rateControlMode;
        }

        @Override
        public final Builder rateControlMode(String rateControlMode) {
            this.rateControlMode = rateControlMode;
            return this;
        }

        @Override
        public final Builder rateControlMode(Av1RateControlMode rateControlMode) {
            this.rateControlMode(rateControlMode == null ? null : rateControlMode.toString());
            return this;
        }

        public final void setRateControlMode(String rateControlMode) {
            this.rateControlMode = rateControlMode;
        }

        public final Integer getSlices() {
            return slices;
        }

        @Override
        public final Builder slices(Integer slices) {
            this.slices = slices;
            return this;
        }

        public final void setSlices(Integer slices) {
            this.slices = slices;
        }

        public final String getSpatialAdaptiveQuantization() {
            return spatialAdaptiveQuantization;
        }

        @Override
        public final Builder spatialAdaptiveQuantization(String spatialAdaptiveQuantization) {
            this.spatialAdaptiveQuantization = spatialAdaptiveQuantization;
            return this;
        }

        @Override
        public final Builder spatialAdaptiveQuantization(Av1SpatialAdaptiveQuantization spatialAdaptiveQuantization) {
            this.spatialAdaptiveQuantization(spatialAdaptiveQuantization == null ? null : spatialAdaptiveQuantization.toString());
            return this;
        }

        public final void setSpatialAdaptiveQuantization(String spatialAdaptiveQuantization) {
            this.spatialAdaptiveQuantization = spatialAdaptiveQuantization;
        }

        @Override
        public Av1Settings build() {
            return new Av1Settings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
