/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Use ad avail blanking settings to specify your output content during SCTE-35 triggered ad avails. You can blank your
 * video or overlay it with an image. MediaConvert also removes any audio and embedded captions during the ad avail. For
 * more information, see https://docs.aws.amazon.com/mediaconvert/latest/ug/ad-avail-blanking.html.
 */
@Generated("software.amazon.awssdk:codegen")
public final class AvailBlanking implements SdkPojo, Serializable, ToCopyableBuilder<AvailBlanking.Builder, AvailBlanking> {
    private static final SdkField<String> AVAIL_BLANKING_IMAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AvailBlankingImage").getter(getter(AvailBlanking::availBlankingImage))
            .setter(setter(Builder::availBlankingImage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availBlankingImage").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AVAIL_BLANKING_IMAGE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String availBlankingImage;

    private AvailBlanking(BuilderImpl builder) {
        this.availBlankingImage = builder.availBlankingImage;
    }

    /**
     * Blanking image to be used. Leave empty for solid black. Only bmp and png images are supported.
     * 
     * @return Blanking image to be used. Leave empty for solid black. Only bmp and png images are supported.
     */
    public final String availBlankingImage() {
        return availBlankingImage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(availBlankingImage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AvailBlanking)) {
            return false;
        }
        AvailBlanking other = (AvailBlanking) obj;
        return Objects.equals(availBlankingImage(), other.availBlankingImage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AvailBlanking").add("AvailBlankingImage", availBlankingImage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AvailBlankingImage":
            return Optional.ofNullable(clazz.cast(availBlankingImage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AvailBlanking, T> g) {
        return obj -> g.apply((AvailBlanking) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AvailBlanking> {
        /**
         * Blanking image to be used. Leave empty for solid black. Only bmp and png images are supported.
         * 
         * @param availBlankingImage
         *        Blanking image to be used. Leave empty for solid black. Only bmp and png images are supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availBlankingImage(String availBlankingImage);
    }

    static final class BuilderImpl implements Builder {
        private String availBlankingImage;

        private BuilderImpl() {
        }

        private BuilderImpl(AvailBlanking model) {
            availBlankingImage(model.availBlankingImage);
        }

        public final String getAvailBlankingImage() {
            return availBlankingImage;
        }

        @Override
        public final Builder availBlankingImage(String availBlankingImage) {
            this.availBlankingImage = availBlankingImage;
            return this;
        }

        public final void setAvailBlankingImage(String availBlankingImage) {
            this.availBlankingImage = availBlankingImage;
        }

        @Override
        public AvailBlanking build() {
            return new AvailBlanking(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
