/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Caption Description for preset
 */
@Generated("software.amazon.awssdk:codegen")
public final class CaptionDescriptionPreset implements SdkPojo, Serializable,
        ToCopyableBuilder<CaptionDescriptionPreset.Builder, CaptionDescriptionPreset> {
    private static final SdkField<String> CUSTOM_LANGUAGE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CustomLanguageCode").getter(getter(CaptionDescriptionPreset::customLanguageCode))
            .setter(setter(Builder::customLanguageCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customLanguageCode").build())
            .build();

    private static final SdkField<CaptionDestinationSettings> DESTINATION_SETTINGS_FIELD = SdkField
            .<CaptionDestinationSettings> builder(MarshallingType.SDK_POJO).memberName("DestinationSettings")
            .getter(getter(CaptionDescriptionPreset::destinationSettings)).setter(setter(Builder::destinationSettings))
            .constructor(CaptionDestinationSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationSettings").build())
            .build();

    private static final SdkField<String> LANGUAGE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LanguageCode").getter(getter(CaptionDescriptionPreset::languageCodeAsString))
            .setter(setter(Builder::languageCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("languageCode").build()).build();

    private static final SdkField<String> LANGUAGE_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LanguageDescription").getter(getter(CaptionDescriptionPreset::languageDescription))
            .setter(setter(Builder::languageDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("languageDescription").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CUSTOM_LANGUAGE_CODE_FIELD,
            DESTINATION_SETTINGS_FIELD, LANGUAGE_CODE_FIELD, LANGUAGE_DESCRIPTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String customLanguageCode;

    private final CaptionDestinationSettings destinationSettings;

    private final String languageCode;

    private final String languageDescription;

    private CaptionDescriptionPreset(BuilderImpl builder) {
        this.customLanguageCode = builder.customLanguageCode;
        this.destinationSettings = builder.destinationSettings;
        this.languageCode = builder.languageCode;
        this.languageDescription = builder.languageDescription;
    }

    /**
     * Specify the language for this captions output track. For most captions output formats, the encoder puts this
     * language information in the output captions metadata. If your output captions format is DVB-Sub or Burn in, the
     * encoder uses this language information when automatically selecting the font script for rendering the captions
     * text. For all outputs, you can use an ISO 639-2 or ISO 639-3 code. For streaming outputs, you can also use any
     * other code in the full RFC-5646 specification. Streaming outputs are those that are in one of the following
     * output groups: CMAF, DASH ISO, Apple HLS, or Microsoft Smooth Streaming.
     * 
     * @return Specify the language for this captions output track. For most captions output formats, the encoder puts
     *         this language information in the output captions metadata. If your output captions format is DVB-Sub or
     *         Burn in, the encoder uses this language information when automatically selecting the font script for
     *         rendering the captions text. For all outputs, you can use an ISO 639-2 or ISO 639-3 code. For streaming
     *         outputs, you can also use any other code in the full RFC-5646 specification. Streaming outputs are those
     *         that are in one of the following output groups: CMAF, DASH ISO, Apple HLS, or Microsoft Smooth Streaming.
     */
    public final String customLanguageCode() {
        return customLanguageCode;
    }

    /**
     * Settings related to one captions tab on the MediaConvert console. In your job JSON, an instance of captions
     * DestinationSettings is equivalent to one captions tab in the console. Usually, one captions tab corresponds to
     * one output captions track. Depending on your output captions format, one tab might correspond to a set of output
     * captions tracks. For more information, see
     * https://docs.aws.amazon.com/mediaconvert/latest/ug/including-captions.html.
     * 
     * @return Settings related to one captions tab on the MediaConvert console. In your job JSON, an instance of
     *         captions DestinationSettings is equivalent to one captions tab in the console. Usually, one captions tab
     *         corresponds to one output captions track. Depending on your output captions format, one tab might
     *         correspond to a set of output captions tracks. For more information, see
     *         https://docs.aws.amazon.com/mediaconvert/latest/ug/including-captions.html.
     */
    public final CaptionDestinationSettings destinationSettings() {
        return destinationSettings;
    }

    /**
     * Specify the language of this captions output track. For most captions output formats, the encoder puts this
     * language information in the output captions metadata. If your output captions format is DVB-Sub or Burn in, the
     * encoder uses this language information to choose the font language for rendering the captions text.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #languageCode} will
     * return {@link LanguageCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #languageCodeAsString}.
     * </p>
     * 
     * @return Specify the language of this captions output track. For most captions output formats, the encoder puts
     *         this language information in the output captions metadata. If your output captions format is DVB-Sub or
     *         Burn in, the encoder uses this language information to choose the font language for rendering the
     *         captions text.
     * @see LanguageCode
     */
    public final LanguageCode languageCode() {
        return LanguageCode.fromValue(languageCode);
    }

    /**
     * Specify the language of this captions output track. For most captions output formats, the encoder puts this
     * language information in the output captions metadata. If your output captions format is DVB-Sub or Burn in, the
     * encoder uses this language information to choose the font language for rendering the captions text.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #languageCode} will
     * return {@link LanguageCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #languageCodeAsString}.
     * </p>
     * 
     * @return Specify the language of this captions output track. For most captions output formats, the encoder puts
     *         this language information in the output captions metadata. If your output captions format is DVB-Sub or
     *         Burn in, the encoder uses this language information to choose the font language for rendering the
     *         captions text.
     * @see LanguageCode
     */
    public final String languageCodeAsString() {
        return languageCode;
    }

    /**
     * Specify a label for this set of output captions. For example, "English", "Director commentary", or "track_2". For
     * streaming outputs, MediaConvert passes this information into destination manifests for display on the
     * end-viewer's player device. For outputs in other output groups, the service ignores this setting.
     * 
     * @return Specify a label for this set of output captions. For example, "English", "Director commentary", or
     *         "track_2". For streaming outputs, MediaConvert passes this information into destination manifests for
     *         display on the end-viewer's player device. For outputs in other output groups, the service ignores this
     *         setting.
     */
    public final String languageDescription() {
        return languageDescription;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(customLanguageCode());
        hashCode = 31 * hashCode + Objects.hashCode(destinationSettings());
        hashCode = 31 * hashCode + Objects.hashCode(languageCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(languageDescription());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CaptionDescriptionPreset)) {
            return false;
        }
        CaptionDescriptionPreset other = (CaptionDescriptionPreset) obj;
        return Objects.equals(customLanguageCode(), other.customLanguageCode())
                && Objects.equals(destinationSettings(), other.destinationSettings())
                && Objects.equals(languageCodeAsString(), other.languageCodeAsString())
                && Objects.equals(languageDescription(), other.languageDescription());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CaptionDescriptionPreset").add("CustomLanguageCode", customLanguageCode())
                .add("DestinationSettings", destinationSettings()).add("LanguageCode", languageCodeAsString())
                .add("LanguageDescription", languageDescription()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CustomLanguageCode":
            return Optional.ofNullable(clazz.cast(customLanguageCode()));
        case "DestinationSettings":
            return Optional.ofNullable(clazz.cast(destinationSettings()));
        case "LanguageCode":
            return Optional.ofNullable(clazz.cast(languageCodeAsString()));
        case "LanguageDescription":
            return Optional.ofNullable(clazz.cast(languageDescription()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CaptionDescriptionPreset, T> g) {
        return obj -> g.apply((CaptionDescriptionPreset) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CaptionDescriptionPreset> {
        /**
         * Specify the language for this captions output track. For most captions output formats, the encoder puts this
         * language information in the output captions metadata. If your output captions format is DVB-Sub or Burn in,
         * the encoder uses this language information when automatically selecting the font script for rendering the
         * captions text. For all outputs, you can use an ISO 639-2 or ISO 639-3 code. For streaming outputs, you can
         * also use any other code in the full RFC-5646 specification. Streaming outputs are those that are in one of
         * the following output groups: CMAF, DASH ISO, Apple HLS, or Microsoft Smooth Streaming.
         * 
         * @param customLanguageCode
         *        Specify the language for this captions output track. For most captions output formats, the encoder
         *        puts this language information in the output captions metadata. If your output captions format is
         *        DVB-Sub or Burn in, the encoder uses this language information when automatically selecting the font
         *        script for rendering the captions text. For all outputs, you can use an ISO 639-2 or ISO 639-3 code.
         *        For streaming outputs, you can also use any other code in the full RFC-5646 specification. Streaming
         *        outputs are those that are in one of the following output groups: CMAF, DASH ISO, Apple HLS, or
         *        Microsoft Smooth Streaming.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customLanguageCode(String customLanguageCode);

        /**
         * Settings related to one captions tab on the MediaConvert console. In your job JSON, an instance of captions
         * DestinationSettings is equivalent to one captions tab in the console. Usually, one captions tab corresponds
         * to one output captions track. Depending on your output captions format, one tab might correspond to a set of
         * output captions tracks. For more information, see
         * https://docs.aws.amazon.com/mediaconvert/latest/ug/including-captions.html.
         * 
         * @param destinationSettings
         *        Settings related to one captions tab on the MediaConvert console. In your job JSON, an instance of
         *        captions DestinationSettings is equivalent to one captions tab in the console. Usually, one captions
         *        tab corresponds to one output captions track. Depending on your output captions format, one tab might
         *        correspond to a set of output captions tracks. For more information, see
         *        https://docs.aws.amazon.com/mediaconvert/latest/ug/including-captions.html.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationSettings(CaptionDestinationSettings destinationSettings);

        /**
         * Settings related to one captions tab on the MediaConvert console. In your job JSON, an instance of captions
         * DestinationSettings is equivalent to one captions tab in the console. Usually, one captions tab corresponds
         * to one output captions track. Depending on your output captions format, one tab might correspond to a set of
         * output captions tracks. For more information, see
         * https://docs.aws.amazon.com/mediaconvert/latest/ug/including-captions.html. This is a convenience that
         * creates an instance of the {@link CaptionDestinationSettings.Builder} avoiding the need to create one
         * manually via {@link CaptionDestinationSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link CaptionDestinationSettings.Builder#build()} is called immediately
         * and its result is passed to {@link #destinationSettings(CaptionDestinationSettings)}.
         * 
         * @param destinationSettings
         *        a consumer that will call methods on {@link CaptionDestinationSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destinationSettings(CaptionDestinationSettings)
         */
        default Builder destinationSettings(Consumer<CaptionDestinationSettings.Builder> destinationSettings) {
            return destinationSettings(CaptionDestinationSettings.builder().applyMutation(destinationSettings).build());
        }

        /**
         * Specify the language of this captions output track. For most captions output formats, the encoder puts this
         * language information in the output captions metadata. If your output captions format is DVB-Sub or Burn in,
         * the encoder uses this language information to choose the font language for rendering the captions text.
         * 
         * @param languageCode
         *        Specify the language of this captions output track. For most captions output formats, the encoder puts
         *        this language information in the output captions metadata. If your output captions format is DVB-Sub
         *        or Burn in, the encoder uses this language information to choose the font language for rendering the
         *        captions text.
         * @see LanguageCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LanguageCode
         */
        Builder languageCode(String languageCode);

        /**
         * Specify the language of this captions output track. For most captions output formats, the encoder puts this
         * language information in the output captions metadata. If your output captions format is DVB-Sub or Burn in,
         * the encoder uses this language information to choose the font language for rendering the captions text.
         * 
         * @param languageCode
         *        Specify the language of this captions output track. For most captions output formats, the encoder puts
         *        this language information in the output captions metadata. If your output captions format is DVB-Sub
         *        or Burn in, the encoder uses this language information to choose the font language for rendering the
         *        captions text.
         * @see LanguageCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LanguageCode
         */
        Builder languageCode(LanguageCode languageCode);

        /**
         * Specify a label for this set of output captions. For example, "English", "Director commentary", or "track_2".
         * For streaming outputs, MediaConvert passes this information into destination manifests for display on the
         * end-viewer's player device. For outputs in other output groups, the service ignores this setting.
         * 
         * @param languageDescription
         *        Specify a label for this set of output captions. For example, "English", "Director commentary", or
         *        "track_2". For streaming outputs, MediaConvert passes this information into destination manifests for
         *        display on the end-viewer's player device. For outputs in other output groups, the service ignores
         *        this setting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder languageDescription(String languageDescription);
    }

    static final class BuilderImpl implements Builder {
        private String customLanguageCode;

        private CaptionDestinationSettings destinationSettings;

        private String languageCode;

        private String languageDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(CaptionDescriptionPreset model) {
            customLanguageCode(model.customLanguageCode);
            destinationSettings(model.destinationSettings);
            languageCode(model.languageCode);
            languageDescription(model.languageDescription);
        }

        public final String getCustomLanguageCode() {
            return customLanguageCode;
        }

        @Override
        public final Builder customLanguageCode(String customLanguageCode) {
            this.customLanguageCode = customLanguageCode;
            return this;
        }

        public final void setCustomLanguageCode(String customLanguageCode) {
            this.customLanguageCode = customLanguageCode;
        }

        public final CaptionDestinationSettings.Builder getDestinationSettings() {
            return destinationSettings != null ? destinationSettings.toBuilder() : null;
        }

        @Override
        public final Builder destinationSettings(CaptionDestinationSettings destinationSettings) {
            this.destinationSettings = destinationSettings;
            return this;
        }

        public final void setDestinationSettings(CaptionDestinationSettings.BuilderImpl destinationSettings) {
            this.destinationSettings = destinationSettings != null ? destinationSettings.build() : null;
        }

        public final String getLanguageCode() {
            return languageCode;
        }

        @Override
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        @Override
        public final Builder languageCode(LanguageCode languageCode) {
            this.languageCode(languageCode == null ? null : languageCode.toString());
            return this;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        public final String getLanguageDescription() {
            return languageDescription;
        }

        @Override
        public final Builder languageDescription(String languageDescription) {
            this.languageDescription = languageDescription;
            return this;
        }

        public final void setLanguageDescription(String languageDescription) {
            this.languageDescription = languageDescription;
        }

        @Override
        public CaptionDescriptionPreset build() {
            return new CaptionDescriptionPreset(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
