/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Settings related to one captions tab on the MediaConvert console. In your job JSON, an instance of captions
 * DestinationSettings is equivalent to one captions tab in the console. Usually, one captions tab corresponds to one
 * output captions track. Depending on your output captions format, one tab might correspond to a set of output captions
 * tracks. For more information, see https://docs.aws.amazon.com/mediaconvert/latest/ug/including-captions.html.
 */
@Generated("software.amazon.awssdk:codegen")
public final class CaptionDestinationSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<CaptionDestinationSettings.Builder, CaptionDestinationSettings> {
    private static final SdkField<BurninDestinationSettings> BURNIN_DESTINATION_SETTINGS_FIELD = SdkField
            .<BurninDestinationSettings> builder(MarshallingType.SDK_POJO).memberName("BurninDestinationSettings")
            .getter(getter(CaptionDestinationSettings::burninDestinationSettings))
            .setter(setter(Builder::burninDestinationSettings)).constructor(BurninDestinationSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("burninDestinationSettings").build())
            .build();

    private static final SdkField<String> DESTINATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DestinationType").getter(getter(CaptionDestinationSettings::destinationTypeAsString))
            .setter(setter(Builder::destinationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationType").build()).build();

    private static final SdkField<DvbSubDestinationSettings> DVB_SUB_DESTINATION_SETTINGS_FIELD = SdkField
            .<DvbSubDestinationSettings> builder(MarshallingType.SDK_POJO).memberName("DvbSubDestinationSettings")
            .getter(getter(CaptionDestinationSettings::dvbSubDestinationSettings))
            .setter(setter(Builder::dvbSubDestinationSettings)).constructor(DvbSubDestinationSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dvbSubDestinationSettings").build())
            .build();

    private static final SdkField<EmbeddedDestinationSettings> EMBEDDED_DESTINATION_SETTINGS_FIELD = SdkField
            .<EmbeddedDestinationSettings> builder(MarshallingType.SDK_POJO)
            .memberName("EmbeddedDestinationSettings")
            .getter(getter(CaptionDestinationSettings::embeddedDestinationSettings))
            .setter(setter(Builder::embeddedDestinationSettings))
            .constructor(EmbeddedDestinationSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("embeddedDestinationSettings")
                    .build()).build();

    private static final SdkField<ImscDestinationSettings> IMSC_DESTINATION_SETTINGS_FIELD = SdkField
            .<ImscDestinationSettings> builder(MarshallingType.SDK_POJO).memberName("ImscDestinationSettings")
            .getter(getter(CaptionDestinationSettings::imscDestinationSettings)).setter(setter(Builder::imscDestinationSettings))
            .constructor(ImscDestinationSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imscDestinationSettings").build())
            .build();

    private static final SdkField<SccDestinationSettings> SCC_DESTINATION_SETTINGS_FIELD = SdkField
            .<SccDestinationSettings> builder(MarshallingType.SDK_POJO).memberName("SccDestinationSettings")
            .getter(getter(CaptionDestinationSettings::sccDestinationSettings)).setter(setter(Builder::sccDestinationSettings))
            .constructor(SccDestinationSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sccDestinationSettings").build())
            .build();

    private static final SdkField<TeletextDestinationSettings> TELETEXT_DESTINATION_SETTINGS_FIELD = SdkField
            .<TeletextDestinationSettings> builder(MarshallingType.SDK_POJO)
            .memberName("TeletextDestinationSettings")
            .getter(getter(CaptionDestinationSettings::teletextDestinationSettings))
            .setter(setter(Builder::teletextDestinationSettings))
            .constructor(TeletextDestinationSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("teletextDestinationSettings")
                    .build()).build();

    private static final SdkField<TtmlDestinationSettings> TTML_DESTINATION_SETTINGS_FIELD = SdkField
            .<TtmlDestinationSettings> builder(MarshallingType.SDK_POJO).memberName("TtmlDestinationSettings")
            .getter(getter(CaptionDestinationSettings::ttmlDestinationSettings)).setter(setter(Builder::ttmlDestinationSettings))
            .constructor(TtmlDestinationSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ttmlDestinationSettings").build())
            .build();

    private static final SdkField<WebvttDestinationSettings> WEBVTT_DESTINATION_SETTINGS_FIELD = SdkField
            .<WebvttDestinationSettings> builder(MarshallingType.SDK_POJO).memberName("WebvttDestinationSettings")
            .getter(getter(CaptionDestinationSettings::webvttDestinationSettings))
            .setter(setter(Builder::webvttDestinationSettings)).constructor(WebvttDestinationSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("webvttDestinationSettings").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            BURNIN_DESTINATION_SETTINGS_FIELD, DESTINATION_TYPE_FIELD, DVB_SUB_DESTINATION_SETTINGS_FIELD,
            EMBEDDED_DESTINATION_SETTINGS_FIELD, IMSC_DESTINATION_SETTINGS_FIELD, SCC_DESTINATION_SETTINGS_FIELD,
            TELETEXT_DESTINATION_SETTINGS_FIELD, TTML_DESTINATION_SETTINGS_FIELD, WEBVTT_DESTINATION_SETTINGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final BurninDestinationSettings burninDestinationSettings;

    private final String destinationType;

    private final DvbSubDestinationSettings dvbSubDestinationSettings;

    private final EmbeddedDestinationSettings embeddedDestinationSettings;

    private final ImscDestinationSettings imscDestinationSettings;

    private final SccDestinationSettings sccDestinationSettings;

    private final TeletextDestinationSettings teletextDestinationSettings;

    private final TtmlDestinationSettings ttmlDestinationSettings;

    private final WebvttDestinationSettings webvttDestinationSettings;

    private CaptionDestinationSettings(BuilderImpl builder) {
        this.burninDestinationSettings = builder.burninDestinationSettings;
        this.destinationType = builder.destinationType;
        this.dvbSubDestinationSettings = builder.dvbSubDestinationSettings;
        this.embeddedDestinationSettings = builder.embeddedDestinationSettings;
        this.imscDestinationSettings = builder.imscDestinationSettings;
        this.sccDestinationSettings = builder.sccDestinationSettings;
        this.teletextDestinationSettings = builder.teletextDestinationSettings;
        this.ttmlDestinationSettings = builder.ttmlDestinationSettings;
        this.webvttDestinationSettings = builder.webvttDestinationSettings;
    }

    /**
     * Settings related to burn-in captions. Set up burn-in captions in the same output as your video. For more
     * information, see https://docs.aws.amazon.com/mediaconvert/latest/ug/burn-in-output-captions.html. When you work
     * directly in your JSON job specification, include this object and any required children when you set
     * destinationType to BURN_IN.
     * 
     * @return Settings related to burn-in captions. Set up burn-in captions in the same output as your video. For more
     *         information, see https://docs.aws.amazon.com/mediaconvert/latest/ug/burn-in-output-captions.html. When
     *         you work directly in your JSON job specification, include this object and any required children when you
     *         set destinationType to BURN_IN.
     */
    public final BurninDestinationSettings burninDestinationSettings() {
        return burninDestinationSettings;
    }

    /**
     * Specify the format for this set of captions on this output. The default format is embedded without SCTE-20. Note
     * that your choice of video output container constrains your choice of output captions format. For more
     * information, see https://docs.aws.amazon.com/mediaconvert/latest/ug/captions-support-tables.html. If you are
     * using SCTE-20 and you want to create an output that complies with the SCTE-43 spec, choose SCTE-20 plus embedded
     * (SCTE20_PLUS_EMBEDDED). To create a non-compliant output where the embedded captions come first, choose Embedded
     * plus SCTE-20 (EMBEDDED_PLUS_SCTE20).
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #destinationType}
     * will return {@link CaptionDestinationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #destinationTypeAsString}.
     * </p>
     * 
     * @return Specify the format for this set of captions on this output. The default format is embedded without
     *         SCTE-20. Note that your choice of video output container constrains your choice of output captions
     *         format. For more information, see
     *         https://docs.aws.amazon.com/mediaconvert/latest/ug/captions-support-tables.html. If you are using SCTE-20
     *         and you want to create an output that complies with the SCTE-43 spec, choose SCTE-20 plus embedded
     *         (SCTE20_PLUS_EMBEDDED). To create a non-compliant output where the embedded captions come first, choose
     *         Embedded plus SCTE-20 (EMBEDDED_PLUS_SCTE20).
     * @see CaptionDestinationType
     */
    public final CaptionDestinationType destinationType() {
        return CaptionDestinationType.fromValue(destinationType);
    }

    /**
     * Specify the format for this set of captions on this output. The default format is embedded without SCTE-20. Note
     * that your choice of video output container constrains your choice of output captions format. For more
     * information, see https://docs.aws.amazon.com/mediaconvert/latest/ug/captions-support-tables.html. If you are
     * using SCTE-20 and you want to create an output that complies with the SCTE-43 spec, choose SCTE-20 plus embedded
     * (SCTE20_PLUS_EMBEDDED). To create a non-compliant output where the embedded captions come first, choose Embedded
     * plus SCTE-20 (EMBEDDED_PLUS_SCTE20).
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #destinationType}
     * will return {@link CaptionDestinationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #destinationTypeAsString}.
     * </p>
     * 
     * @return Specify the format for this set of captions on this output. The default format is embedded without
     *         SCTE-20. Note that your choice of video output container constrains your choice of output captions
     *         format. For more information, see
     *         https://docs.aws.amazon.com/mediaconvert/latest/ug/captions-support-tables.html. If you are using SCTE-20
     *         and you want to create an output that complies with the SCTE-43 spec, choose SCTE-20 plus embedded
     *         (SCTE20_PLUS_EMBEDDED). To create a non-compliant output where the embedded captions come first, choose
     *         Embedded plus SCTE-20 (EMBEDDED_PLUS_SCTE20).
     * @see CaptionDestinationType
     */
    public final String destinationTypeAsString() {
        return destinationType;
    }

    /**
     * Settings related to DVB-Sub captions. Set up DVB-Sub captions in the same output as your video. For more
     * information, see https://docs.aws.amazon.com/mediaconvert/latest/ug/dvb-sub-output-captions.html. When you work
     * directly in your JSON job specification, include this object and any required children when you set
     * destinationType to DVB_SUB.
     * 
     * @return Settings related to DVB-Sub captions. Set up DVB-Sub captions in the same output as your video. For more
     *         information, see https://docs.aws.amazon.com/mediaconvert/latest/ug/dvb-sub-output-captions.html. When
     *         you work directly in your JSON job specification, include this object and any required children when you
     *         set destinationType to DVB_SUB.
     */
    public final DvbSubDestinationSettings dvbSubDestinationSettings() {
        return dvbSubDestinationSettings;
    }

    /**
     * Settings related to CEA/EIA-608 and CEA/EIA-708 (also called embedded or ancillary) captions. Set up embedded
     * captions in the same output as your video. For more information, see
     * https://docs.aws.amazon.com/mediaconvert/latest/ug/embedded-output-captions.html. When you work directly in your
     * JSON job specification, include this object and any required children when you set destinationType to EMBEDDED,
     * EMBEDDED_PLUS_SCTE20, or SCTE20_PLUS_EMBEDDED.
     * 
     * @return Settings related to CEA/EIA-608 and CEA/EIA-708 (also called embedded or ancillary) captions. Set up
     *         embedded captions in the same output as your video. For more information, see
     *         https://docs.aws.amazon.com/mediaconvert/latest/ug/embedded-output-captions.html. When you work directly
     *         in your JSON job specification, include this object and any required children when you set
     *         destinationType to EMBEDDED, EMBEDDED_PLUS_SCTE20, or SCTE20_PLUS_EMBEDDED.
     */
    public final EmbeddedDestinationSettings embeddedDestinationSettings() {
        return embeddedDestinationSettings;
    }

    /**
     * Settings related to IMSC captions. IMSC is a sidecar format that holds captions in a file that is separate from
     * the video container. Set up sidecar captions in the same output group, but different output from your video. For
     * more information, see https://docs.aws.amazon.com/mediaconvert/latest/ug/ttml-and-webvtt-output-captions.html.
     * When you work directly in your JSON job specification, include this object and any required children when you set
     * destinationType to IMSC.
     * 
     * @return Settings related to IMSC captions. IMSC is a sidecar format that holds captions in a file that is
     *         separate from the video container. Set up sidecar captions in the same output group, but different output
     *         from your video. For more information, see
     *         https://docs.aws.amazon.com/mediaconvert/latest/ug/ttml-and-webvtt-output-captions.html. When you work
     *         directly in your JSON job specification, include this object and any required children when you set
     *         destinationType to IMSC.
     */
    public final ImscDestinationSettings imscDestinationSettings() {
        return imscDestinationSettings;
    }

    /**
     * Settings related to SCC captions. SCC is a sidecar format that holds captions in a file that is separate from the
     * video container. Set up sidecar captions in the same output group, but different output from your video. For more
     * information, see https://docs.aws.amazon.com/mediaconvert/latest/ug/scc-srt-output-captions.html. When you work
     * directly in your JSON job specification, include this object and any required children when you set
     * destinationType to SCC.
     * 
     * @return Settings related to SCC captions. SCC is a sidecar format that holds captions in a file that is separate
     *         from the video container. Set up sidecar captions in the same output group, but different output from
     *         your video. For more information, see
     *         https://docs.aws.amazon.com/mediaconvert/latest/ug/scc-srt-output-captions.html. When you work directly
     *         in your JSON job specification, include this object and any required children when you set
     *         destinationType to SCC.
     */
    public final SccDestinationSettings sccDestinationSettings() {
        return sccDestinationSettings;
    }

    /**
     * Settings related to teletext captions. Set up teletext captions in the same output as your video. For more
     * information, see https://docs.aws.amazon.com/mediaconvert/latest/ug/teletext-output-captions.html. When you work
     * directly in your JSON job specification, include this object and any required children when you set
     * destinationType to TELETEXT.
     * 
     * @return Settings related to teletext captions. Set up teletext captions in the same output as your video. For
     *         more information, see https://docs.aws.amazon.com/mediaconvert/latest/ug/teletext-output-captions.html.
     *         When you work directly in your JSON job specification, include this object and any required children when
     *         you set destinationType to TELETEXT.
     */
    public final TeletextDestinationSettings teletextDestinationSettings() {
        return teletextDestinationSettings;
    }

    /**
     * Settings related to TTML captions. TTML is a sidecar format that holds captions in a file that is separate from
     * the video container. Set up sidecar captions in the same output group, but different output from your video. For
     * more information, see https://docs.aws.amazon.com/mediaconvert/latest/ug/ttml-and-webvtt-output-captions.html.
     * When you work directly in your JSON job specification, include this object and any required children when you set
     * destinationType to TTML.
     * 
     * @return Settings related to TTML captions. TTML is a sidecar format that holds captions in a file that is
     *         separate from the video container. Set up sidecar captions in the same output group, but different output
     *         from your video. For more information, see
     *         https://docs.aws.amazon.com/mediaconvert/latest/ug/ttml-and-webvtt-output-captions.html. When you work
     *         directly in your JSON job specification, include this object and any required children when you set
     *         destinationType to TTML.
     */
    public final TtmlDestinationSettings ttmlDestinationSettings() {
        return ttmlDestinationSettings;
    }

    /**
     * WEBVTT Destination Settings
     * 
     * @return WEBVTT Destination Settings
     */
    public final WebvttDestinationSettings webvttDestinationSettings() {
        return webvttDestinationSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(burninDestinationSettings());
        hashCode = 31 * hashCode + Objects.hashCode(destinationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(dvbSubDestinationSettings());
        hashCode = 31 * hashCode + Objects.hashCode(embeddedDestinationSettings());
        hashCode = 31 * hashCode + Objects.hashCode(imscDestinationSettings());
        hashCode = 31 * hashCode + Objects.hashCode(sccDestinationSettings());
        hashCode = 31 * hashCode + Objects.hashCode(teletextDestinationSettings());
        hashCode = 31 * hashCode + Objects.hashCode(ttmlDestinationSettings());
        hashCode = 31 * hashCode + Objects.hashCode(webvttDestinationSettings());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CaptionDestinationSettings)) {
            return false;
        }
        CaptionDestinationSettings other = (CaptionDestinationSettings) obj;
        return Objects.equals(burninDestinationSettings(), other.burninDestinationSettings())
                && Objects.equals(destinationTypeAsString(), other.destinationTypeAsString())
                && Objects.equals(dvbSubDestinationSettings(), other.dvbSubDestinationSettings())
                && Objects.equals(embeddedDestinationSettings(), other.embeddedDestinationSettings())
                && Objects.equals(imscDestinationSettings(), other.imscDestinationSettings())
                && Objects.equals(sccDestinationSettings(), other.sccDestinationSettings())
                && Objects.equals(teletextDestinationSettings(), other.teletextDestinationSettings())
                && Objects.equals(ttmlDestinationSettings(), other.ttmlDestinationSettings())
                && Objects.equals(webvttDestinationSettings(), other.webvttDestinationSettings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CaptionDestinationSettings").add("BurninDestinationSettings", burninDestinationSettings())
                .add("DestinationType", destinationTypeAsString()).add("DvbSubDestinationSettings", dvbSubDestinationSettings())
                .add("EmbeddedDestinationSettings", embeddedDestinationSettings())
                .add("ImscDestinationSettings", imscDestinationSettings())
                .add("SccDestinationSettings", sccDestinationSettings())
                .add("TeletextDestinationSettings", teletextDestinationSettings())
                .add("TtmlDestinationSettings", ttmlDestinationSettings())
                .add("WebvttDestinationSettings", webvttDestinationSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BurninDestinationSettings":
            return Optional.ofNullable(clazz.cast(burninDestinationSettings()));
        case "DestinationType":
            return Optional.ofNullable(clazz.cast(destinationTypeAsString()));
        case "DvbSubDestinationSettings":
            return Optional.ofNullable(clazz.cast(dvbSubDestinationSettings()));
        case "EmbeddedDestinationSettings":
            return Optional.ofNullable(clazz.cast(embeddedDestinationSettings()));
        case "ImscDestinationSettings":
            return Optional.ofNullable(clazz.cast(imscDestinationSettings()));
        case "SccDestinationSettings":
            return Optional.ofNullable(clazz.cast(sccDestinationSettings()));
        case "TeletextDestinationSettings":
            return Optional.ofNullable(clazz.cast(teletextDestinationSettings()));
        case "TtmlDestinationSettings":
            return Optional.ofNullable(clazz.cast(ttmlDestinationSettings()));
        case "WebvttDestinationSettings":
            return Optional.ofNullable(clazz.cast(webvttDestinationSettings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CaptionDestinationSettings, T> g) {
        return obj -> g.apply((CaptionDestinationSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CaptionDestinationSettings> {
        /**
         * Settings related to burn-in captions. Set up burn-in captions in the same output as your video. For more
         * information, see https://docs.aws.amazon.com/mediaconvert/latest/ug/burn-in-output-captions.html. When you
         * work directly in your JSON job specification, include this object and any required children when you set
         * destinationType to BURN_IN.
         * 
         * @param burninDestinationSettings
         *        Settings related to burn-in captions. Set up burn-in captions in the same output as your video. For
         *        more information, see https://docs.aws.amazon.com/mediaconvert/latest/ug/burn-in-output-captions.html.
         *        When you work directly in your JSON job specification, include this object and any required children
         *        when you set destinationType to BURN_IN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder burninDestinationSettings(BurninDestinationSettings burninDestinationSettings);

        /**
         * Settings related to burn-in captions. Set up burn-in captions in the same output as your video. For more
         * information, see https://docs.aws.amazon.com/mediaconvert/latest/ug/burn-in-output-captions.html. When you
         * work directly in your JSON job specification, include this object and any required children when you set
         * destinationType to BURN_IN. This is a convenience that creates an instance of the
         * {@link BurninDestinationSettings.Builder} avoiding the need to create one manually via
         * {@link BurninDestinationSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link BurninDestinationSettings.Builder#build()} is called immediately
         * and its result is passed to {@link #burninDestinationSettings(BurninDestinationSettings)}.
         * 
         * @param burninDestinationSettings
         *        a consumer that will call methods on {@link BurninDestinationSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #burninDestinationSettings(BurninDestinationSettings)
         */
        default Builder burninDestinationSettings(Consumer<BurninDestinationSettings.Builder> burninDestinationSettings) {
            return burninDestinationSettings(BurninDestinationSettings.builder().applyMutation(burninDestinationSettings).build());
        }

        /**
         * Specify the format for this set of captions on this output. The default format is embedded without SCTE-20.
         * Note that your choice of video output container constrains your choice of output captions format. For more
         * information, see https://docs.aws.amazon.com/mediaconvert/latest/ug/captions-support-tables.html. If you are
         * using SCTE-20 and you want to create an output that complies with the SCTE-43 spec, choose SCTE-20 plus
         * embedded (SCTE20_PLUS_EMBEDDED). To create a non-compliant output where the embedded captions come first,
         * choose Embedded plus SCTE-20 (EMBEDDED_PLUS_SCTE20).
         * 
         * @param destinationType
         *        Specify the format for this set of captions on this output. The default format is embedded without
         *        SCTE-20. Note that your choice of video output container constrains your choice of output captions
         *        format. For more information, see
         *        https://docs.aws.amazon.com/mediaconvert/latest/ug/captions-support-tables.html. If you are using
         *        SCTE-20 and you want to create an output that complies with the SCTE-43 spec, choose SCTE-20 plus
         *        embedded (SCTE20_PLUS_EMBEDDED). To create a non-compliant output where the embedded captions come
         *        first, choose Embedded plus SCTE-20 (EMBEDDED_PLUS_SCTE20).
         * @see CaptionDestinationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CaptionDestinationType
         */
        Builder destinationType(String destinationType);

        /**
         * Specify the format for this set of captions on this output. The default format is embedded without SCTE-20.
         * Note that your choice of video output container constrains your choice of output captions format. For more
         * information, see https://docs.aws.amazon.com/mediaconvert/latest/ug/captions-support-tables.html. If you are
         * using SCTE-20 and you want to create an output that complies with the SCTE-43 spec, choose SCTE-20 plus
         * embedded (SCTE20_PLUS_EMBEDDED). To create a non-compliant output where the embedded captions come first,
         * choose Embedded plus SCTE-20 (EMBEDDED_PLUS_SCTE20).
         * 
         * @param destinationType
         *        Specify the format for this set of captions on this output. The default format is embedded without
         *        SCTE-20. Note that your choice of video output container constrains your choice of output captions
         *        format. For more information, see
         *        https://docs.aws.amazon.com/mediaconvert/latest/ug/captions-support-tables.html. If you are using
         *        SCTE-20 and you want to create an output that complies with the SCTE-43 spec, choose SCTE-20 plus
         *        embedded (SCTE20_PLUS_EMBEDDED). To create a non-compliant output where the embedded captions come
         *        first, choose Embedded plus SCTE-20 (EMBEDDED_PLUS_SCTE20).
         * @see CaptionDestinationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CaptionDestinationType
         */
        Builder destinationType(CaptionDestinationType destinationType);

        /**
         * Settings related to DVB-Sub captions. Set up DVB-Sub captions in the same output as your video. For more
         * information, see https://docs.aws.amazon.com/mediaconvert/latest/ug/dvb-sub-output-captions.html. When you
         * work directly in your JSON job specification, include this object and any required children when you set
         * destinationType to DVB_SUB.
         * 
         * @param dvbSubDestinationSettings
         *        Settings related to DVB-Sub captions. Set up DVB-Sub captions in the same output as your video. For
         *        more information, see https://docs.aws.amazon.com/mediaconvert/latest/ug/dvb-sub-output-captions.html.
         *        When you work directly in your JSON job specification, include this object and any required children
         *        when you set destinationType to DVB_SUB.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dvbSubDestinationSettings(DvbSubDestinationSettings dvbSubDestinationSettings);

        /**
         * Settings related to DVB-Sub captions. Set up DVB-Sub captions in the same output as your video. For more
         * information, see https://docs.aws.amazon.com/mediaconvert/latest/ug/dvb-sub-output-captions.html. When you
         * work directly in your JSON job specification, include this object and any required children when you set
         * destinationType to DVB_SUB. This is a convenience that creates an instance of the
         * {@link DvbSubDestinationSettings.Builder} avoiding the need to create one manually via
         * {@link DvbSubDestinationSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link DvbSubDestinationSettings.Builder#build()} is called immediately
         * and its result is passed to {@link #dvbSubDestinationSettings(DvbSubDestinationSettings)}.
         * 
         * @param dvbSubDestinationSettings
         *        a consumer that will call methods on {@link DvbSubDestinationSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dvbSubDestinationSettings(DvbSubDestinationSettings)
         */
        default Builder dvbSubDestinationSettings(Consumer<DvbSubDestinationSettings.Builder> dvbSubDestinationSettings) {
            return dvbSubDestinationSettings(DvbSubDestinationSettings.builder().applyMutation(dvbSubDestinationSettings).build());
        }

        /**
         * Settings related to CEA/EIA-608 and CEA/EIA-708 (also called embedded or ancillary) captions. Set up embedded
         * captions in the same output as your video. For more information, see
         * https://docs.aws.amazon.com/mediaconvert/latest/ug/embedded-output-captions.html. When you work directly in
         * your JSON job specification, include this object and any required children when you set destinationType to
         * EMBEDDED, EMBEDDED_PLUS_SCTE20, or SCTE20_PLUS_EMBEDDED.
         * 
         * @param embeddedDestinationSettings
         *        Settings related to CEA/EIA-608 and CEA/EIA-708 (also called embedded or ancillary) captions. Set up
         *        embedded captions in the same output as your video. For more information, see
         *        https://docs.aws.amazon.com/mediaconvert/latest/ug/embedded-output-captions.html. When you work
         *        directly in your JSON job specification, include this object and any required children when you set
         *        destinationType to EMBEDDED, EMBEDDED_PLUS_SCTE20, or SCTE20_PLUS_EMBEDDED.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder embeddedDestinationSettings(EmbeddedDestinationSettings embeddedDestinationSettings);

        /**
         * Settings related to CEA/EIA-608 and CEA/EIA-708 (also called embedded or ancillary) captions. Set up embedded
         * captions in the same output as your video. For more information, see
         * https://docs.aws.amazon.com/mediaconvert/latest/ug/embedded-output-captions.html. When you work directly in
         * your JSON job specification, include this object and any required children when you set destinationType to
         * EMBEDDED, EMBEDDED_PLUS_SCTE20, or SCTE20_PLUS_EMBEDDED. This is a convenience that creates an instance of
         * the {@link EmbeddedDestinationSettings.Builder} avoiding the need to create one manually via
         * {@link EmbeddedDestinationSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link EmbeddedDestinationSettings.Builder#build()} is called
         * immediately and its result is passed to {@link #embeddedDestinationSettings(EmbeddedDestinationSettings)}.
         * 
         * @param embeddedDestinationSettings
         *        a consumer that will call methods on {@link EmbeddedDestinationSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #embeddedDestinationSettings(EmbeddedDestinationSettings)
         */
        default Builder embeddedDestinationSettings(Consumer<EmbeddedDestinationSettings.Builder> embeddedDestinationSettings) {
            return embeddedDestinationSettings(EmbeddedDestinationSettings.builder().applyMutation(embeddedDestinationSettings)
                    .build());
        }

        /**
         * Settings related to IMSC captions. IMSC is a sidecar format that holds captions in a file that is separate
         * from the video container. Set up sidecar captions in the same output group, but different output from your
         * video. For more information, see
         * https://docs.aws.amazon.com/mediaconvert/latest/ug/ttml-and-webvtt-output-captions.html. When you work
         * directly in your JSON job specification, include this object and any required children when you set
         * destinationType to IMSC.
         * 
         * @param imscDestinationSettings
         *        Settings related to IMSC captions. IMSC is a sidecar format that holds captions in a file that is
         *        separate from the video container. Set up sidecar captions in the same output group, but different
         *        output from your video. For more information, see
         *        https://docs.aws.amazon.com/mediaconvert/latest/ug/ttml-and-webvtt-output-captions.html. When you work
         *        directly in your JSON job specification, include this object and any required children when you set
         *        destinationType to IMSC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imscDestinationSettings(ImscDestinationSettings imscDestinationSettings);

        /**
         * Settings related to IMSC captions. IMSC is a sidecar format that holds captions in a file that is separate
         * from the video container. Set up sidecar captions in the same output group, but different output from your
         * video. For more information, see
         * https://docs.aws.amazon.com/mediaconvert/latest/ug/ttml-and-webvtt-output-captions.html. When you work
         * directly in your JSON job specification, include this object and any required children when you set
         * destinationType to IMSC. This is a convenience that creates an instance of the
         * {@link ImscDestinationSettings.Builder} avoiding the need to create one manually via
         * {@link ImscDestinationSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link ImscDestinationSettings.Builder#build()} is called immediately
         * and its result is passed to {@link #imscDestinationSettings(ImscDestinationSettings)}.
         * 
         * @param imscDestinationSettings
         *        a consumer that will call methods on {@link ImscDestinationSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #imscDestinationSettings(ImscDestinationSettings)
         */
        default Builder imscDestinationSettings(Consumer<ImscDestinationSettings.Builder> imscDestinationSettings) {
            return imscDestinationSettings(ImscDestinationSettings.builder().applyMutation(imscDestinationSettings).build());
        }

        /**
         * Settings related to SCC captions. SCC is a sidecar format that holds captions in a file that is separate from
         * the video container. Set up sidecar captions in the same output group, but different output from your video.
         * For more information, see https://docs.aws.amazon.com/mediaconvert/latest/ug/scc-srt-output-captions.html.
         * When you work directly in your JSON job specification, include this object and any required children when you
         * set destinationType to SCC.
         * 
         * @param sccDestinationSettings
         *        Settings related to SCC captions. SCC is a sidecar format that holds captions in a file that is
         *        separate from the video container. Set up sidecar captions in the same output group, but different
         *        output from your video. For more information, see
         *        https://docs.aws.amazon.com/mediaconvert/latest/ug/scc-srt-output-captions.html. When you work
         *        directly in your JSON job specification, include this object and any required children when you set
         *        destinationType to SCC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sccDestinationSettings(SccDestinationSettings sccDestinationSettings);

        /**
         * Settings related to SCC captions. SCC is a sidecar format that holds captions in a file that is separate from
         * the video container. Set up sidecar captions in the same output group, but different output from your video.
         * For more information, see https://docs.aws.amazon.com/mediaconvert/latest/ug/scc-srt-output-captions.html.
         * When you work directly in your JSON job specification, include this object and any required children when you
         * set destinationType to SCC. This is a convenience that creates an instance of the
         * {@link SccDestinationSettings.Builder} avoiding the need to create one manually via
         * {@link SccDestinationSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link SccDestinationSettings.Builder#build()} is called immediately and
         * its result is passed to {@link #sccDestinationSettings(SccDestinationSettings)}.
         * 
         * @param sccDestinationSettings
         *        a consumer that will call methods on {@link SccDestinationSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sccDestinationSettings(SccDestinationSettings)
         */
        default Builder sccDestinationSettings(Consumer<SccDestinationSettings.Builder> sccDestinationSettings) {
            return sccDestinationSettings(SccDestinationSettings.builder().applyMutation(sccDestinationSettings).build());
        }

        /**
         * Settings related to teletext captions. Set up teletext captions in the same output as your video. For more
         * information, see https://docs.aws.amazon.com/mediaconvert/latest/ug/teletext-output-captions.html. When you
         * work directly in your JSON job specification, include this object and any required children when you set
         * destinationType to TELETEXT.
         * 
         * @param teletextDestinationSettings
         *        Settings related to teletext captions. Set up teletext captions in the same output as your video. For
         *        more information, see
         *        https://docs.aws.amazon.com/mediaconvert/latest/ug/teletext-output-captions.html. When you work
         *        directly in your JSON job specification, include this object and any required children when you set
         *        destinationType to TELETEXT.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder teletextDestinationSettings(TeletextDestinationSettings teletextDestinationSettings);

        /**
         * Settings related to teletext captions. Set up teletext captions in the same output as your video. For more
         * information, see https://docs.aws.amazon.com/mediaconvert/latest/ug/teletext-output-captions.html. When you
         * work directly in your JSON job specification, include this object and any required children when you set
         * destinationType to TELETEXT. This is a convenience that creates an instance of the
         * {@link TeletextDestinationSettings.Builder} avoiding the need to create one manually via
         * {@link TeletextDestinationSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link TeletextDestinationSettings.Builder#build()} is called
         * immediately and its result is passed to {@link #teletextDestinationSettings(TeletextDestinationSettings)}.
         * 
         * @param teletextDestinationSettings
         *        a consumer that will call methods on {@link TeletextDestinationSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #teletextDestinationSettings(TeletextDestinationSettings)
         */
        default Builder teletextDestinationSettings(Consumer<TeletextDestinationSettings.Builder> teletextDestinationSettings) {
            return teletextDestinationSettings(TeletextDestinationSettings.builder().applyMutation(teletextDestinationSettings)
                    .build());
        }

        /**
         * Settings related to TTML captions. TTML is a sidecar format that holds captions in a file that is separate
         * from the video container. Set up sidecar captions in the same output group, but different output from your
         * video. For more information, see
         * https://docs.aws.amazon.com/mediaconvert/latest/ug/ttml-and-webvtt-output-captions.html. When you work
         * directly in your JSON job specification, include this object and any required children when you set
         * destinationType to TTML.
         * 
         * @param ttmlDestinationSettings
         *        Settings related to TTML captions. TTML is a sidecar format that holds captions in a file that is
         *        separate from the video container. Set up sidecar captions in the same output group, but different
         *        output from your video. For more information, see
         *        https://docs.aws.amazon.com/mediaconvert/latest/ug/ttml-and-webvtt-output-captions.html. When you work
         *        directly in your JSON job specification, include this object and any required children when you set
         *        destinationType to TTML.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ttmlDestinationSettings(TtmlDestinationSettings ttmlDestinationSettings);

        /**
         * Settings related to TTML captions. TTML is a sidecar format that holds captions in a file that is separate
         * from the video container. Set up sidecar captions in the same output group, but different output from your
         * video. For more information, see
         * https://docs.aws.amazon.com/mediaconvert/latest/ug/ttml-and-webvtt-output-captions.html. When you work
         * directly in your JSON job specification, include this object and any required children when you set
         * destinationType to TTML. This is a convenience that creates an instance of the
         * {@link TtmlDestinationSettings.Builder} avoiding the need to create one manually via
         * {@link TtmlDestinationSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link TtmlDestinationSettings.Builder#build()} is called immediately
         * and its result is passed to {@link #ttmlDestinationSettings(TtmlDestinationSettings)}.
         * 
         * @param ttmlDestinationSettings
         *        a consumer that will call methods on {@link TtmlDestinationSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ttmlDestinationSettings(TtmlDestinationSettings)
         */
        default Builder ttmlDestinationSettings(Consumer<TtmlDestinationSettings.Builder> ttmlDestinationSettings) {
            return ttmlDestinationSettings(TtmlDestinationSettings.builder().applyMutation(ttmlDestinationSettings).build());
        }

        /**
         * WEBVTT Destination Settings
         * 
         * @param webvttDestinationSettings
         *        WEBVTT Destination Settings
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder webvttDestinationSettings(WebvttDestinationSettings webvttDestinationSettings);

        /**
         * WEBVTT Destination Settings This is a convenience that creates an instance of the
         * {@link WebvttDestinationSettings.Builder} avoiding the need to create one manually via
         * {@link WebvttDestinationSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link WebvttDestinationSettings.Builder#build()} is called immediately
         * and its result is passed to {@link #webvttDestinationSettings(WebvttDestinationSettings)}.
         * 
         * @param webvttDestinationSettings
         *        a consumer that will call methods on {@link WebvttDestinationSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #webvttDestinationSettings(WebvttDestinationSettings)
         */
        default Builder webvttDestinationSettings(Consumer<WebvttDestinationSettings.Builder> webvttDestinationSettings) {
            return webvttDestinationSettings(WebvttDestinationSettings.builder().applyMutation(webvttDestinationSettings).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private BurninDestinationSettings burninDestinationSettings;

        private String destinationType;

        private DvbSubDestinationSettings dvbSubDestinationSettings;

        private EmbeddedDestinationSettings embeddedDestinationSettings;

        private ImscDestinationSettings imscDestinationSettings;

        private SccDestinationSettings sccDestinationSettings;

        private TeletextDestinationSettings teletextDestinationSettings;

        private TtmlDestinationSettings ttmlDestinationSettings;

        private WebvttDestinationSettings webvttDestinationSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(CaptionDestinationSettings model) {
            burninDestinationSettings(model.burninDestinationSettings);
            destinationType(model.destinationType);
            dvbSubDestinationSettings(model.dvbSubDestinationSettings);
            embeddedDestinationSettings(model.embeddedDestinationSettings);
            imscDestinationSettings(model.imscDestinationSettings);
            sccDestinationSettings(model.sccDestinationSettings);
            teletextDestinationSettings(model.teletextDestinationSettings);
            ttmlDestinationSettings(model.ttmlDestinationSettings);
            webvttDestinationSettings(model.webvttDestinationSettings);
        }

        public final BurninDestinationSettings.Builder getBurninDestinationSettings() {
            return burninDestinationSettings != null ? burninDestinationSettings.toBuilder() : null;
        }

        @Override
        public final Builder burninDestinationSettings(BurninDestinationSettings burninDestinationSettings) {
            this.burninDestinationSettings = burninDestinationSettings;
            return this;
        }

        public final void setBurninDestinationSettings(BurninDestinationSettings.BuilderImpl burninDestinationSettings) {
            this.burninDestinationSettings = burninDestinationSettings != null ? burninDestinationSettings.build() : null;
        }

        public final String getDestinationType() {
            return destinationType;
        }

        @Override
        public final Builder destinationType(String destinationType) {
            this.destinationType = destinationType;
            return this;
        }

        @Override
        public final Builder destinationType(CaptionDestinationType destinationType) {
            this.destinationType(destinationType == null ? null : destinationType.toString());
            return this;
        }

        public final void setDestinationType(String destinationType) {
            this.destinationType = destinationType;
        }

        public final DvbSubDestinationSettings.Builder getDvbSubDestinationSettings() {
            return dvbSubDestinationSettings != null ? dvbSubDestinationSettings.toBuilder() : null;
        }

        @Override
        public final Builder dvbSubDestinationSettings(DvbSubDestinationSettings dvbSubDestinationSettings) {
            this.dvbSubDestinationSettings = dvbSubDestinationSettings;
            return this;
        }

        public final void setDvbSubDestinationSettings(DvbSubDestinationSettings.BuilderImpl dvbSubDestinationSettings) {
            this.dvbSubDestinationSettings = dvbSubDestinationSettings != null ? dvbSubDestinationSettings.build() : null;
        }

        public final EmbeddedDestinationSettings.Builder getEmbeddedDestinationSettings() {
            return embeddedDestinationSettings != null ? embeddedDestinationSettings.toBuilder() : null;
        }

        @Override
        public final Builder embeddedDestinationSettings(EmbeddedDestinationSettings embeddedDestinationSettings) {
            this.embeddedDestinationSettings = embeddedDestinationSettings;
            return this;
        }

        public final void setEmbeddedDestinationSettings(EmbeddedDestinationSettings.BuilderImpl embeddedDestinationSettings) {
            this.embeddedDestinationSettings = embeddedDestinationSettings != null ? embeddedDestinationSettings.build() : null;
        }

        public final ImscDestinationSettings.Builder getImscDestinationSettings() {
            return imscDestinationSettings != null ? imscDestinationSettings.toBuilder() : null;
        }

        @Override
        public final Builder imscDestinationSettings(ImscDestinationSettings imscDestinationSettings) {
            this.imscDestinationSettings = imscDestinationSettings;
            return this;
        }

        public final void setImscDestinationSettings(ImscDestinationSettings.BuilderImpl imscDestinationSettings) {
            this.imscDestinationSettings = imscDestinationSettings != null ? imscDestinationSettings.build() : null;
        }

        public final SccDestinationSettings.Builder getSccDestinationSettings() {
            return sccDestinationSettings != null ? sccDestinationSettings.toBuilder() : null;
        }

        @Override
        public final Builder sccDestinationSettings(SccDestinationSettings sccDestinationSettings) {
            this.sccDestinationSettings = sccDestinationSettings;
            return this;
        }

        public final void setSccDestinationSettings(SccDestinationSettings.BuilderImpl sccDestinationSettings) {
            this.sccDestinationSettings = sccDestinationSettings != null ? sccDestinationSettings.build() : null;
        }

        public final TeletextDestinationSettings.Builder getTeletextDestinationSettings() {
            return teletextDestinationSettings != null ? teletextDestinationSettings.toBuilder() : null;
        }

        @Override
        public final Builder teletextDestinationSettings(TeletextDestinationSettings teletextDestinationSettings) {
            this.teletextDestinationSettings = teletextDestinationSettings;
            return this;
        }

        public final void setTeletextDestinationSettings(TeletextDestinationSettings.BuilderImpl teletextDestinationSettings) {
            this.teletextDestinationSettings = teletextDestinationSettings != null ? teletextDestinationSettings.build() : null;
        }

        public final TtmlDestinationSettings.Builder getTtmlDestinationSettings() {
            return ttmlDestinationSettings != null ? ttmlDestinationSettings.toBuilder() : null;
        }

        @Override
        public final Builder ttmlDestinationSettings(TtmlDestinationSettings ttmlDestinationSettings) {
            this.ttmlDestinationSettings = ttmlDestinationSettings;
            return this;
        }

        public final void setTtmlDestinationSettings(TtmlDestinationSettings.BuilderImpl ttmlDestinationSettings) {
            this.ttmlDestinationSettings = ttmlDestinationSettings != null ? ttmlDestinationSettings.build() : null;
        }

        public final WebvttDestinationSettings.Builder getWebvttDestinationSettings() {
            return webvttDestinationSettings != null ? webvttDestinationSettings.toBuilder() : null;
        }

        @Override
        public final Builder webvttDestinationSettings(WebvttDestinationSettings webvttDestinationSettings) {
            this.webvttDestinationSettings = webvttDestinationSettings;
            return this;
        }

        public final void setWebvttDestinationSettings(WebvttDestinationSettings.BuilderImpl webvttDestinationSettings) {
            this.webvttDestinationSettings = webvttDestinationSettings != null ? webvttDestinationSettings.build() : null;
        }

        @Override
        public CaptionDestinationSettings build() {
            return new CaptionDestinationSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
