/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Use these settings to insert a DVB Network Information Table (NIT) in the transport stream of this output. When you
 * work directly in your JSON job specification, include this object only when your job has a transport stream output
 * and the container settings contain the object M2tsSettings.
 */
@Generated("software.amazon.awssdk:codegen")
public final class DvbNitSettings implements SdkPojo, Serializable, ToCopyableBuilder<DvbNitSettings.Builder, DvbNitSettings> {
    private static final SdkField<Integer> NETWORK_ID_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("NetworkId").getter(getter(DvbNitSettings::networkId)).setter(setter(Builder::networkId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkId").build()).build();

    private static final SdkField<String> NETWORK_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NetworkName").getter(getter(DvbNitSettings::networkName)).setter(setter(Builder::networkName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkName").build()).build();

    private static final SdkField<Integer> NIT_INTERVAL_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("NitInterval").getter(getter(DvbNitSettings::nitInterval)).setter(setter(Builder::nitInterval))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nitInterval").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NETWORK_ID_FIELD,
            NETWORK_NAME_FIELD, NIT_INTERVAL_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer networkId;

    private final String networkName;

    private final Integer nitInterval;

    private DvbNitSettings(BuilderImpl builder) {
        this.networkId = builder.networkId;
        this.networkName = builder.networkName;
        this.nitInterval = builder.nitInterval;
    }

    /**
     * The numeric value placed in the Network Information Table (NIT).
     * 
     * @return The numeric value placed in the Network Information Table (NIT).
     */
    public final Integer networkId() {
        return networkId;
    }

    /**
     * The network name text placed in the network_name_descriptor inside the Network Information Table. Maximum length
     * is 256 characters.
     * 
     * @return The network name text placed in the network_name_descriptor inside the Network Information Table. Maximum
     *         length is 256 characters.
     */
    public final String networkName() {
        return networkName;
    }

    /**
     * The number of milliseconds between instances of this table in the output transport stream.
     * 
     * @return The number of milliseconds between instances of this table in the output transport stream.
     */
    public final Integer nitInterval() {
        return nitInterval;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(networkId());
        hashCode = 31 * hashCode + Objects.hashCode(networkName());
        hashCode = 31 * hashCode + Objects.hashCode(nitInterval());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DvbNitSettings)) {
            return false;
        }
        DvbNitSettings other = (DvbNitSettings) obj;
        return Objects.equals(networkId(), other.networkId()) && Objects.equals(networkName(), other.networkName())
                && Objects.equals(nitInterval(), other.nitInterval());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DvbNitSettings").add("NetworkId", networkId()).add("NetworkName", networkName())
                .add("NitInterval", nitInterval()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NetworkId":
            return Optional.ofNullable(clazz.cast(networkId()));
        case "NetworkName":
            return Optional.ofNullable(clazz.cast(networkName()));
        case "NitInterval":
            return Optional.ofNullable(clazz.cast(nitInterval()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DvbNitSettings, T> g) {
        return obj -> g.apply((DvbNitSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DvbNitSettings> {
        /**
         * The numeric value placed in the Network Information Table (NIT).
         * 
         * @param networkId
         *        The numeric value placed in the Network Information Table (NIT).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkId(Integer networkId);

        /**
         * The network name text placed in the network_name_descriptor inside the Network Information Table. Maximum
         * length is 256 characters.
         * 
         * @param networkName
         *        The network name text placed in the network_name_descriptor inside the Network Information Table.
         *        Maximum length is 256 characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkName(String networkName);

        /**
         * The number of milliseconds between instances of this table in the output transport stream.
         * 
         * @param nitInterval
         *        The number of milliseconds between instances of this table in the output transport stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nitInterval(Integer nitInterval);
    }

    static final class BuilderImpl implements Builder {
        private Integer networkId;

        private String networkName;

        private Integer nitInterval;

        private BuilderImpl() {
        }

        private BuilderImpl(DvbNitSettings model) {
            networkId(model.networkId);
            networkName(model.networkName);
            nitInterval(model.nitInterval);
        }

        public final Integer getNetworkId() {
            return networkId;
        }

        @Override
        public final Builder networkId(Integer networkId) {
            this.networkId = networkId;
            return this;
        }

        public final void setNetworkId(Integer networkId) {
            this.networkId = networkId;
        }

        public final String getNetworkName() {
            return networkName;
        }

        @Override
        public final Builder networkName(String networkName) {
            this.networkName = networkName;
            return this;
        }

        public final void setNetworkName(String networkName) {
            this.networkName = networkName;
        }

        public final Integer getNitInterval() {
            return nitInterval;
        }

        @Override
        public final Builder nitInterval(Integer nitInterval) {
            this.nitInterval = nitInterval;
            return this;
        }

        public final void setNitInterval(Integer nitInterval) {
            this.nitInterval = nitInterval;
        }

        @Override
        public DvbNitSettings build() {
            return new DvbNitSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
