/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;

/**
 * Use this setting for interlaced outputs, when your output frame rate is half of your input frame rate. In this
 * situation, choose Optimized interlacing (INTERLACED_OPTIMIZE) to create a better quality interlaced output. In this
 * case, each progressive frame from the input corresponds to an interlaced field in the output. Keep the default value,
 * Basic interlacing (INTERLACED), for all other output frame rates. With basic interlacing, MediaConvert performs any
 * frame rate conversion first and then interlaces the frames. When you choose Optimized interlacing and you set your
 * output frame rate to a value that isn't suitable for optimized interlacing, MediaConvert automatically falls back to
 * basic interlacing. Required settings: To use optimized interlacing, you must set Telecine (telecine) to None (NONE)
 * or Soft (SOFT). You can't use optimized interlacing for hard telecine outputs. You must also set Interlace mode
 * (interlaceMode) to a value other than Progressive (PROGRESSIVE).
 */
@Generated("software.amazon.awssdk:codegen")
public enum H265ScanTypeConversionMode {
    INTERLACED("INTERLACED"),

    INTERLACED_OPTIMIZE("INTERLACED_OPTIMIZE"),

    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private H265ScanTypeConversionMode(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return H265ScanTypeConversionMode corresponding to the value
     */
    public static H265ScanTypeConversionMode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(H265ScanTypeConversionMode.values()).filter(e -> e.toString().equals(value)).findFirst()
                .orElse(UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link H265ScanTypeConversionMode}s
     */
    public static Set<H265ScanTypeConversionMode> knownValues() {
        return Stream.of(values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}
