/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListPresetsResponse extends MediaConvertResponse implements
        ToCopyableBuilder<ListPresetsResponse.Builder, ListPresetsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListPresetsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<Preset>> PRESETS_FIELD = SdkField
            .<List<Preset>> builder(MarshallingType.LIST)
            .memberName("Presets")
            .getter(getter(ListPresetsResponse::presets))
            .setter(setter(Builder::presets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("presets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Preset> builder(MarshallingType.SDK_POJO)
                                            .constructor(Preset::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            PRESETS_FIELD));

    private final String nextToken;

    private final List<Preset> presets;

    private ListPresetsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.presets = builder.presets;
    }

    /**
     * Use this string to request the next batch of presets.
     * 
     * @return Use this string to request the next batch of presets.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * Returns true if the Presets property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasPresets() {
        return presets != null && !(presets instanceof SdkAutoConstructList);
    }

    /**
     * List of presets
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPresets()} to see if a value was sent in this field.
     * </p>
     * 
     * @return List of presets
     */
    public final List<Preset> presets() {
        return presets;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasPresets() ? presets() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPresetsResponse)) {
            return false;
        }
        ListPresetsResponse other = (ListPresetsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasPresets() == other.hasPresets()
                && Objects.equals(presets(), other.presets());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListPresetsResponse").add("NextToken", nextToken())
                .add("Presets", hasPresets() ? presets() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "Presets":
            return Optional.ofNullable(clazz.cast(presets()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListPresetsResponse, T> g) {
        return obj -> g.apply((ListPresetsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaConvertResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListPresetsResponse> {
        /**
         * Use this string to request the next batch of presets.
         * 
         * @param nextToken
         *        Use this string to request the next batch of presets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * List of presets
         * 
         * @param presets
         *        List of presets
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder presets(Collection<Preset> presets);

        /**
         * List of presets
         * 
         * @param presets
         *        List of presets
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder presets(Preset... presets);

        /**
         * List of presets This is a convenience that creates an instance of the {@link List<Preset>.Builder} avoiding
         * the need to create one manually via {@link List<Preset>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Preset>.Builder#build()} is called immediately and its
         * result is passed to {@link #presets(List<Preset>)}.
         * 
         * @param presets
         *        a consumer that will call methods on {@link List<Preset>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #presets(List<Preset>)
         */
        Builder presets(Consumer<Preset.Builder>... presets);
    }

    static final class BuilderImpl extends MediaConvertResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<Preset> presets = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListPresetsResponse model) {
            super(model);
            nextToken(model.nextToken);
            presets(model.presets);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final List<Preset.Builder> getPresets() {
            List<Preset.Builder> result = ___listOfPresetCopier.copyToBuilder(this.presets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder presets(Collection<Preset> presets) {
            this.presets = ___listOfPresetCopier.copy(presets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder presets(Preset... presets) {
            presets(Arrays.asList(presets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder presets(Consumer<Preset.Builder>... presets) {
            presets(Stream.of(presets).map(c -> Preset.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPresets(Collection<Preset.BuilderImpl> presets) {
            this.presets = ___listOfPresetCopier.copyFromBuilder(presets);
        }

        @Override
        public ListPresetsResponse build() {
            return new ListPresetsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
