/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;

/**
 * When set to VIDEO_AND_FIXED_INTERVALS, audio EBP markers will be added to partitions 3 and 4. The interval between
 * these additional markers will be fixed, and will be slightly shorter than the video EBP marker interval. When set to
 * VIDEO_INTERVAL, these additional markers will not be inserted. Only applicable when EBP segmentation markers are is
 * selected (segmentationMarkers is EBP or EBP_LEGACY).
 */
@Generated("software.amazon.awssdk:codegen")
public enum M2tsEbpAudioInterval {
    VIDEO_AND_FIXED_INTERVALS("VIDEO_AND_FIXED_INTERVALS"),

    VIDEO_INTERVAL("VIDEO_INTERVAL"),

    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private M2tsEbpAudioInterval(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return M2tsEbpAudioInterval corresponding to the value
     */
    public static M2tsEbpAudioInterval fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(M2tsEbpAudioInterval.values()).filter(e -> e.toString().equals(value)).findFirst()
                .orElse(UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link M2tsEbpAudioInterval}s
     */
    public static Set<M2tsEbpAudioInterval> knownValues() {
        return Stream.of(values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}
