/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;

/**
 * Optional. Choose Include (INCLUDE) to have MediaConvert mark up your DASH manifest with <Accessibility> elements for
 * embedded 608 captions. This markup isn't generally required, but some video players require it to discover and play
 * embedded 608 captions. Keep the default value, Exclude (EXCLUDE), to leave these elements out. When you enable this
 * setting, this is the markup that MediaConvert includes in your manifest: <Accessibility
 * schemeIdUri="urn:scte:dash:cc:cea-608:2015" value="CC1=eng"/>
 */
@Generated("software.amazon.awssdk:codegen")
public enum MpdAccessibilityCaptionHints {
    INCLUDE("INCLUDE"),

    EXCLUDE("EXCLUDE"),

    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private MpdAccessibilityCaptionHints(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return MpdAccessibilityCaptionHints corresponding to the value
     */
    public static MpdAccessibilityCaptionHints fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(MpdAccessibilityCaptionHints.values()).filter(e -> e.toString().equals(value)).findFirst()
                .orElse(UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link MpdAccessibilityCaptionHints}s
     */
    public static Set<MpdAccessibilityCaptionHints> knownValues() {
        return Stream.of(values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}
