/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;

/**
 * Choose the method that you want MediaConvert to use when increasing or decreasing the frame rate. We recommend using
 * drop duplicate (DUPLICATE_DROP) for numerically simple conversions, such as 60 fps to 30 fps. For numerically complex
 * conversions, you can use interpolate (INTERPOLATE) to avoid stutter. This results in a smooth picture, but might
 * introduce undesirable video artifacts. For complex frame rate conversions, especially if your source video has
 * already been converted from its original cadence, use FrameFormer (FRAMEFORMER) to do motion-compensated
 * interpolation. FrameFormer chooses the best conversion method frame by frame. Note that using FrameFormer increases
 * the transcoding time and incurs a significant add-on cost.
 */
@Generated("software.amazon.awssdk:codegen")
public enum Mpeg2FramerateConversionAlgorithm {
    DUPLICATE_DROP("DUPLICATE_DROP"),

    INTERPOLATE("INTERPOLATE"),

    FRAMEFORMER("FRAMEFORMER"),

    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private Mpeg2FramerateConversionAlgorithm(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return Mpeg2FramerateConversionAlgorithm corresponding to the value
     */
    public static Mpeg2FramerateConversionAlgorithm fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(Mpeg2FramerateConversionAlgorithm.values()).filter(e -> e.toString().equals(value)).findFirst()
                .orElse(UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link Mpeg2FramerateConversionAlgorithm}s
     */
    public static Set<Mpeg2FramerateConversionAlgorithm> knownValues() {
        return Stream.of(values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}
