/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;

/**
 * Choose the type of Nielsen watermarks that you want in your outputs. When you choose NAES 2 and NW (NAES2_AND_NW),
 * you must provide a value for the setting SID (sourceId). When you choose CBET (CBET), you must provide a value for
 * the setting CSID (cbetSourceId). When you choose NAES 2, NW, and CBET (NAES2_AND_NW_AND_CBET), you must provide
 * values for both of these settings.
 */
@Generated("software.amazon.awssdk:codegen")
public enum NielsenActiveWatermarkProcessType {
    NAES2_AND_NW("NAES2_AND_NW"),

    CBET("CBET"),

    NAES2_AND_NW_AND_CBET("NAES2_AND_NW_AND_CBET"),

    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private NielsenActiveWatermarkProcessType(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return NielsenActiveWatermarkProcessType corresponding to the value
     */
    public static NielsenActiveWatermarkProcessType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(NielsenActiveWatermarkProcessType.values()).filter(e -> e.toString().equals(value)).findFirst()
                .orElse(UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link NielsenActiveWatermarkProcessType}s
     */
    public static Set<NielsenActiveWatermarkProcessType> knownValues() {
        return Stream.of(values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}
