/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Contains details about the output groups specified in the job settings.
 */
@Generated("software.amazon.awssdk:codegen")
public final class OutputGroupDetail implements SdkPojo, Serializable,
        ToCopyableBuilder<OutputGroupDetail.Builder, OutputGroupDetail> {
    private static final SdkField<List<OutputDetail>> OUTPUT_DETAILS_FIELD = SdkField
            .<List<OutputDetail>> builder(MarshallingType.LIST)
            .memberName("OutputDetails")
            .getter(getter(OutputGroupDetail::outputDetails))
            .setter(setter(Builder::outputDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputDetails").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<OutputDetail> builder(MarshallingType.SDK_POJO)
                                            .constructor(OutputDetail::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OUTPUT_DETAILS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<OutputDetail> outputDetails;

    private OutputGroupDetail(BuilderImpl builder) {
        this.outputDetails = builder.outputDetails;
    }

    /**
     * Returns true if the OutputDetails property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasOutputDetails() {
        return outputDetails != null && !(outputDetails instanceof SdkAutoConstructList);
    }

    /**
     * Details about the output
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasOutputDetails()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Details about the output
     */
    public final List<OutputDetail> outputDetails() {
        return outputDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasOutputDetails() ? outputDetails() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OutputGroupDetail)) {
            return false;
        }
        OutputGroupDetail other = (OutputGroupDetail) obj;
        return hasOutputDetails() == other.hasOutputDetails() && Objects.equals(outputDetails(), other.outputDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OutputGroupDetail").add("OutputDetails", hasOutputDetails() ? outputDetails() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OutputDetails":
            return Optional.ofNullable(clazz.cast(outputDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OutputGroupDetail, T> g) {
        return obj -> g.apply((OutputGroupDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OutputGroupDetail> {
        /**
         * Details about the output
         * 
         * @param outputDetails
         *        Details about the output
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputDetails(Collection<OutputDetail> outputDetails);

        /**
         * Details about the output
         * 
         * @param outputDetails
         *        Details about the output
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputDetails(OutputDetail... outputDetails);

        /**
         * Details about the output This is a convenience that creates an instance of the {@link List
         * <OutputDetail>.Builder} avoiding the need to create one manually via {@link List<OutputDetail>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<OutputDetail>.Builder#build()} is called immediately and its
         * result is passed to {@link #outputDetails(List<OutputDetail>)}.
         * 
         * @param outputDetails
         *        a consumer that will call methods on {@link List<OutputDetail>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputDetails(List<OutputDetail>)
         */
        Builder outputDetails(Consumer<OutputDetail.Builder>... outputDetails);
    }

    static final class BuilderImpl implements Builder {
        private List<OutputDetail> outputDetails = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(OutputGroupDetail model) {
            outputDetails(model.outputDetails);
        }

        public final List<OutputDetail.Builder> getOutputDetails() {
            List<OutputDetail.Builder> result = ___listOfOutputDetailCopier.copyToBuilder(this.outputDetails);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder outputDetails(Collection<OutputDetail> outputDetails) {
            this.outputDetails = ___listOfOutputDetailCopier.copy(outputDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputDetails(OutputDetail... outputDetails) {
            outputDetails(Arrays.asList(outputDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputDetails(Consumer<OutputDetail.Builder>... outputDetails) {
            outputDetails(Stream.of(outputDetails).map(c -> OutputDetail.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setOutputDetails(Collection<OutputDetail.BuilderImpl> outputDetails) {
            this.outputDetails = ___listOfOutputDetailCopier.copyFromBuilder(outputDetails);
        }

        @Override
        public OutputGroupDetail build() {
            return new OutputGroupDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
