/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Settings for burning the output timecode and specified prefix into the output.
 */
@Generated("software.amazon.awssdk:codegen")
public final class TimecodeBurnin implements SdkPojo, Serializable, ToCopyableBuilder<TimecodeBurnin.Builder, TimecodeBurnin> {
    private static final SdkField<Integer> FONT_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("FontSize").getter(getter(TimecodeBurnin::fontSize)).setter(setter(Builder::fontSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fontSize").build()).build();

    private static final SdkField<String> POSITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Position").getter(getter(TimecodeBurnin::positionAsString)).setter(setter(Builder::position))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("position").build()).build();

    private static final SdkField<String> PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Prefix")
            .getter(getter(TimecodeBurnin::prefix)).setter(setter(Builder::prefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("prefix").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FONT_SIZE_FIELD,
            POSITION_FIELD, PREFIX_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer fontSize;

    private final String position;

    private final String prefix;

    private TimecodeBurnin(BuilderImpl builder) {
        this.fontSize = builder.fontSize;
        this.position = builder.position;
        this.prefix = builder.prefix;
    }

    /**
     * Use Font Size (FontSize) to set the font size of any burned-in timecode. Valid values are 10, 16, 32, 48.
     * 
     * @return Use Font Size (FontSize) to set the font size of any burned-in timecode. Valid values are 10, 16, 32, 48.
     */
    public final Integer fontSize() {
        return fontSize;
    }

    /**
     * Use Position (Position) under under Timecode burn-in (TimecodeBurnIn) to specify the location the burned-in
     * timecode on output video.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #position} will
     * return {@link TimecodeBurninPosition#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #positionAsString}.
     * </p>
     * 
     * @return Use Position (Position) under under Timecode burn-in (TimecodeBurnIn) to specify the location the
     *         burned-in timecode on output video.
     * @see TimecodeBurninPosition
     */
    public final TimecodeBurninPosition position() {
        return TimecodeBurninPosition.fromValue(position);
    }

    /**
     * Use Position (Position) under under Timecode burn-in (TimecodeBurnIn) to specify the location the burned-in
     * timecode on output video.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #position} will
     * return {@link TimecodeBurninPosition#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #positionAsString}.
     * </p>
     * 
     * @return Use Position (Position) under under Timecode burn-in (TimecodeBurnIn) to specify the location the
     *         burned-in timecode on output video.
     * @see TimecodeBurninPosition
     */
    public final String positionAsString() {
        return position;
    }

    /**
     * Use Prefix (Prefix) to place ASCII characters before any burned-in timecode. For example, a prefix of "EZ-" will
     * result in the timecode "EZ-00:00:00:00". Provide either the characters themselves or the ASCII code equivalents.
     * The supported range of characters is 0x20 through 0x7e. This includes letters, numbers, and all special
     * characters represented on a standard English keyboard.
     * 
     * @return Use Prefix (Prefix) to place ASCII characters before any burned-in timecode. For example, a prefix of
     *         "EZ-" will result in the timecode "EZ-00:00:00:00". Provide either the characters themselves or the ASCII
     *         code equivalents. The supported range of characters is 0x20 through 0x7e. This includes letters, numbers,
     *         and all special characters represented on a standard English keyboard.
     */
    public final String prefix() {
        return prefix;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fontSize());
        hashCode = 31 * hashCode + Objects.hashCode(positionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(prefix());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TimecodeBurnin)) {
            return false;
        }
        TimecodeBurnin other = (TimecodeBurnin) obj;
        return Objects.equals(fontSize(), other.fontSize()) && Objects.equals(positionAsString(), other.positionAsString())
                && Objects.equals(prefix(), other.prefix());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TimecodeBurnin").add("FontSize", fontSize()).add("Position", positionAsString())
                .add("Prefix", prefix()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FontSize":
            return Optional.ofNullable(clazz.cast(fontSize()));
        case "Position":
            return Optional.ofNullable(clazz.cast(positionAsString()));
        case "Prefix":
            return Optional.ofNullable(clazz.cast(prefix()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TimecodeBurnin, T> g) {
        return obj -> g.apply((TimecodeBurnin) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TimecodeBurnin> {
        /**
         * Use Font Size (FontSize) to set the font size of any burned-in timecode. Valid values are 10, 16, 32, 48.
         * 
         * @param fontSize
         *        Use Font Size (FontSize) to set the font size of any burned-in timecode. Valid values are 10, 16, 32,
         *        48.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fontSize(Integer fontSize);

        /**
         * Use Position (Position) under under Timecode burn-in (TimecodeBurnIn) to specify the location the burned-in
         * timecode on output video.
         * 
         * @param position
         *        Use Position (Position) under under Timecode burn-in (TimecodeBurnIn) to specify the location the
         *        burned-in timecode on output video.
         * @see TimecodeBurninPosition
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TimecodeBurninPosition
         */
        Builder position(String position);

        /**
         * Use Position (Position) under under Timecode burn-in (TimecodeBurnIn) to specify the location the burned-in
         * timecode on output video.
         * 
         * @param position
         *        Use Position (Position) under under Timecode burn-in (TimecodeBurnIn) to specify the location the
         *        burned-in timecode on output video.
         * @see TimecodeBurninPosition
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TimecodeBurninPosition
         */
        Builder position(TimecodeBurninPosition position);

        /**
         * Use Prefix (Prefix) to place ASCII characters before any burned-in timecode. For example, a prefix of "EZ-"
         * will result in the timecode "EZ-00:00:00:00". Provide either the characters themselves or the ASCII code
         * equivalents. The supported range of characters is 0x20 through 0x7e. This includes letters, numbers, and all
         * special characters represented on a standard English keyboard.
         * 
         * @param prefix
         *        Use Prefix (Prefix) to place ASCII characters before any burned-in timecode. For example, a prefix of
         *        "EZ-" will result in the timecode "EZ-00:00:00:00". Provide either the characters themselves or the
         *        ASCII code equivalents. The supported range of characters is 0x20 through 0x7e. This includes letters,
         *        numbers, and all special characters represented on a standard English keyboard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prefix(String prefix);
    }

    static final class BuilderImpl implements Builder {
        private Integer fontSize;

        private String position;

        private String prefix;

        private BuilderImpl() {
        }

        private BuilderImpl(TimecodeBurnin model) {
            fontSize(model.fontSize);
            position(model.position);
            prefix(model.prefix);
        }

        public final Integer getFontSize() {
            return fontSize;
        }

        @Override
        public final Builder fontSize(Integer fontSize) {
            this.fontSize = fontSize;
            return this;
        }

        public final void setFontSize(Integer fontSize) {
            this.fontSize = fontSize;
        }

        public final String getPosition() {
            return position;
        }

        @Override
        public final Builder position(String position) {
            this.position = position;
            return this;
        }

        @Override
        public final Builder position(TimecodeBurninPosition position) {
            this.position(position == null ? null : position.toString());
            return this;
        }

        public final void setPosition(String position) {
            this.position = position;
        }

        public final String getPrefix() {
            return prefix;
        }

        @Override
        public final Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public final void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        @Override
        public TimecodeBurnin build() {
            return new TimecodeBurnin(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
