/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Enable Timed metadata insertion (TimedMetadataInsertion) to include ID3 tags in any HLS outputs. To include timed
 * metadata, you must enable it here, enable it in each output container, and specify tags and timecodes in ID3
 * insertion (Id3Insertion) objects.
 */
@Generated("software.amazon.awssdk:codegen")
public final class TimedMetadataInsertion implements SdkPojo, Serializable,
        ToCopyableBuilder<TimedMetadataInsertion.Builder, TimedMetadataInsertion> {
    private static final SdkField<List<Id3Insertion>> ID3_INSERTIONS_FIELD = SdkField
            .<List<Id3Insertion>> builder(MarshallingType.LIST)
            .memberName("Id3Insertions")
            .getter(getter(TimedMetadataInsertion::id3Insertions))
            .setter(setter(Builder::id3Insertions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id3Insertions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Id3Insertion> builder(MarshallingType.SDK_POJO)
                                            .constructor(Id3Insertion::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID3_INSERTIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<Id3Insertion> id3Insertions;

    private TimedMetadataInsertion(BuilderImpl builder) {
        this.id3Insertions = builder.id3Insertions;
    }

    /**
     * Returns true if the Id3Insertions property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasId3Insertions() {
        return id3Insertions != null && !(id3Insertions instanceof SdkAutoConstructList);
    }

    /**
     * Id3Insertions contains the array of Id3Insertion instances.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasId3Insertions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Id3Insertions contains the array of Id3Insertion instances.
     */
    public final List<Id3Insertion> id3Insertions() {
        return id3Insertions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasId3Insertions() ? id3Insertions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TimedMetadataInsertion)) {
            return false;
        }
        TimedMetadataInsertion other = (TimedMetadataInsertion) obj;
        return hasId3Insertions() == other.hasId3Insertions() && Objects.equals(id3Insertions(), other.id3Insertions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TimedMetadataInsertion").add("Id3Insertions", hasId3Insertions() ? id3Insertions() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id3Insertions":
            return Optional.ofNullable(clazz.cast(id3Insertions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TimedMetadataInsertion, T> g) {
        return obj -> g.apply((TimedMetadataInsertion) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TimedMetadataInsertion> {
        /**
         * Id3Insertions contains the array of Id3Insertion instances.
         * 
         * @param id3Insertions
         *        Id3Insertions contains the array of Id3Insertion instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id3Insertions(Collection<Id3Insertion> id3Insertions);

        /**
         * Id3Insertions contains the array of Id3Insertion instances.
         * 
         * @param id3Insertions
         *        Id3Insertions contains the array of Id3Insertion instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id3Insertions(Id3Insertion... id3Insertions);

        /**
         * Id3Insertions contains the array of Id3Insertion instances. This is a convenience that creates an instance of
         * the {@link List<Id3Insertion>.Builder} avoiding the need to create one manually via {@link List
         * <Id3Insertion>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Id3Insertion>.Builder#build()} is called immediately and its
         * result is passed to {@link #id3Insertions(List<Id3Insertion>)}.
         * 
         * @param id3Insertions
         *        a consumer that will call methods on {@link List<Id3Insertion>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #id3Insertions(List<Id3Insertion>)
         */
        Builder id3Insertions(Consumer<Id3Insertion.Builder>... id3Insertions);
    }

    static final class BuilderImpl implements Builder {
        private List<Id3Insertion> id3Insertions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TimedMetadataInsertion model) {
            id3Insertions(model.id3Insertions);
        }

        public final List<Id3Insertion.Builder> getId3Insertions() {
            List<Id3Insertion.Builder> result = ___listOfId3InsertionCopier.copyToBuilder(this.id3Insertions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder id3Insertions(Collection<Id3Insertion> id3Insertions) {
            this.id3Insertions = ___listOfId3InsertionCopier.copy(id3Insertions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder id3Insertions(Id3Insertion... id3Insertions) {
            id3Insertions(Arrays.asList(id3Insertions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder id3Insertions(Consumer<Id3Insertion.Builder>... id3Insertions) {
            id3Insertions(Stream.of(id3Insertions).map(c -> Id3Insertion.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setId3Insertions(Collection<Id3Insertion.BuilderImpl> id3Insertions) {
            this.id3Insertions = ___listOfId3InsertionCopier.copyFromBuilder(id3Insertions);
        }

        @Override
        public TimedMetadataInsertion build() {
            return new TimedMetadataInsertion(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
